/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.AccountLogger;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.AttributeCardinality;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.AttributeInfo;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.AttributeServerType;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.FileGenUtil;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.PreAuthKey;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ShareInfoData;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.ldap.LdapEntrySearchFilter;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.fb.FbCli;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.util.SoapCLI;
import com.zimbra.cs.wiki.WikiUtil;
import com.zimbra.cs.zclient.ZMailboxUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.spy.memcached.HashAlgorithm;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvUtil
implements SoapHttpTransport.HttpDebugListener {
    private static final String ERR_VIA_SOAP_ONLY = "can only be used with SOAP";
    private static final String ERR_VIA_LDAP_ONLY = "can only be used with  \"zmprov -l/--ldap\"";
    private static final String ERR_INVALID_ARG_EV = "arg -e is invalid unless -v is also specified";
    private boolean mInteractive = false;
    private boolean mVerbose = false;
    private SoapDebugLevel mDebug = SoapDebugLevel.none;
    private boolean mUseLdap = LC.zimbra_zmprov_default_to_ldap.booleanValue();
    private boolean mUseLdapMaster = false;
    private String mAccount = null;
    private String mPassword = null;
    private ZAuthToken mAuthToken = null;
    private String mServer = LC.zimbra_zmprov_default_soap_server.value();
    private int mPort = LC.zimbra_admin_service_port.intValue();
    private Command mCommand;
    private Map<String, Command> mCommandIndex;
    private Provisioning mProv;
    private BufferedReader mReader;
    private long mSendStart;

    public void setDebug(SoapDebugLevel debug) {
        this.mDebug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setUseLdap(boolean useLdap, boolean useMaster) {
        this.mUseLdap = useLdap;
        this.mUseLdapMaster = useMaster;
    }

    public void setAccount(String account) {
        this.mAccount = account;
        this.mUseLdap = false;
    }

    public void setPassword(String password) {
        this.mPassword = password;
        this.mUseLdap = false;
    }

    public void setAuthToken(ZAuthToken zat) {
        this.mAuthToken = zat;
        this.mUseLdap = false;
    }

    public void setServer(String server) {
        int i = server.indexOf(":");
        if (i == -1) {
            this.mServer = server;
        } else {
            this.mServer = server.substring(0, i);
            this.mPort = Integer.parseInt(server.substring(i + 1));
        }
        this.mUseLdap = false;
    }

    public boolean useLdap() {
        return this.mUseLdap;
    }

    private void usage() {
        this.usage(null);
    }

    private void usage(Command.Via violatedVia) {
        if (this.mCommand != null) {
            if (violatedVia == null) {
                System.out.printf("usage:  %s(%s) %s\n", this.mCommand.getName(), this.mCommand.getAlias(), this.mCommand.getHelp());
                CommandHelp extraHelp = this.mCommand.getExtraHelp();
                if (extraHelp != null) {
                    extraHelp.printHelp();
                }
            } else if (violatedVia == Command.Via.ldap) {
                System.out.printf("%s %s\n", this.mCommand.getName(), ERR_VIA_LDAP_ONLY);
            } else {
                System.out.printf("%s %s\n", this.mCommand.getName(), ERR_VIA_SOAP_ONLY);
            }
        }
        if (this.mInteractive) {
            return;
        }
        System.out.println("");
        System.out.println("zmprov [args] [cmd] [cmd-args ...]");
        System.out.println("");
        System.out.println("  -h/--help                             display usage");
        System.out.println("  -f/--file                             use file as input stream");
        System.out.println("  -s/--server   {host}[:{port}]         server hostname and optional port");
        System.out.println("  -l/--ldap                             provision via LDAP instead of SOAP");
        System.out.println("  -L/--logpropertyfile                  log4j property file, valid only with -l");
        System.out.println("  -a/--account  {name}                  account name to auth as");
        System.out.println("  -p/--password {pass}                  password for account");
        System.out.println("  -P/--passfile {file}                  read password from file");
        System.out.println("  -z/--zadmin                           use zimbra admin name/password from localconfig for admin/password");
        System.out.println("  -y/--authtoken {authtoken}            " + SoapCLI.OPT_AUTHTOKEN.getDescription());
        System.out.println("  -Y/--authtokenfile {authtoken file}   " + SoapCLI.OPT_AUTHTOKENFILE.getDescription());
        System.out.println("  -v/--verbose                          verbose mode (dumps full exception stack trace)");
        System.out.println("  -d/--debug                            debug mode (dumps SOAP messages)");
        System.out.println("  -m/--master                           use LDAP master (only valid with -l)");
        System.out.println("");
        this.doHelp(null);
        System.exit(1);
    }

    private void addCommand(Command command) {
        String name = command.getName().toLowerCase();
        if (this.mCommandIndex.get(name) != null) {
            throw new RuntimeException("duplicate command: " + name);
        }
        String alias = command.getAlias().toLowerCase();
        if (this.mCommandIndex.get(alias) != null) {
            throw new RuntimeException("duplicate command: " + alias);
        }
        this.mCommandIndex.put(name, command);
        this.mCommandIndex.put(alias, command);
    }

    private void initCommands() {
        this.mCommandIndex = new HashMap<String, Command>();
        for (Command c : Command.values()) {
            this.addCommand(c);
        }
    }

    private Command lookupCommand(String command) {
        return this.mCommandIndex.get(command.toLowerCase());
    }

    private boolean forceLdapButDontRequireUseLdapOption(Command command) {
        return command == Command.HELP || command == Command.DESCRIBE;
    }

    private ProvUtil() {
        this.initCommands();
    }

    public void initProvisioning() throws ServiceException {
        if (this.mUseLdap) {
            this.mProv = Provisioning.getInstance();
            if (this.mUseLdapMaster) {
                ZimbraLdapContext.forceMasterURL();
            }
        } else {
            SoapProvisioning sp = new SoapProvisioning();
            sp.soapSetURI(LC.zimbra_admin_service_scheme.value() + this.mServer + ":" + this.mPort + "/service/admin/soap/");
            if (this.mDebug != SoapDebugLevel.none) {
                sp.soapSetHttpTransportDebugListener(this);
            }
            if (this.mAccount != null && this.mPassword != null) {
                sp.soapAdminAuthenticate(this.mAccount, this.mPassword);
            } else if (this.mAuthToken != null) {
                sp.soapAdminAuthenticate(this.mAuthToken);
            } else {
                sp.soapZimbraAdminAuthenticate();
            }
            this.mProv = sp;
        }
    }

    private Command.Via violateVia(Command cmd) {
        Command.Via via = cmd.getVia();
        if (via == null) {
            return null;
        }
        if (via == Command.Via.ldap && !(this.mProv instanceof LdapProvisioning)) {
            return Command.Via.ldap;
        }
        if (via == Command.Via.soap && !(this.mProv instanceof SoapProvisioning)) {
            return Command.Via.soap;
        }
        return null;
    }

    private boolean execute(String[] args) throws ServiceException, ArgException, IOException {
        this.mCommand = this.lookupCommand(args[0]);
        if (this.mCommand == null) {
            return false;
        }
        Command.Via violatedVia = this.violateVia(this.mCommand);
        if (violatedVia != null) {
            this.usage(violatedVia);
            return true;
        }
        if (!this.mCommand.checkArgsLength(args)) {
            this.usage();
            return true;
        }
        if (this.mCommand.needsSchemaExtension()) {
            this.loadLdapSchemaExtensionAttrs();
        }
        switch (this.mCommand) {
            case ADD_ACCOUNT_ALIAS: {
                this.mProv.addAlias(this.lookupAccount(args[1]), args[2]);
                break;
            }
            case ADD_ACCOUNT_LOGGER: {
                AccountLoggerOptions alo = this.parseAccountLoggerOptions(args);
                if (!this.mCommand.checkArgsLength(alo.args)) {
                    this.usage();
                    return true;
                }
                this.doAddAccountLogger(alo);
                break;
            }
            case AUTO_COMPLETE_GAL: {
                this.doAutoCompleteGal(args);
                break;
            }
            case COPY_COS: {
                System.out.println(this.mProv.copyCos(this.lookupCos(args[1]).getId(), args[2]).getId());
                break;
            }
            case COUNT_ACCOUNT: {
                this.doCountAccount(args);
                break;
            }
            case CREATE_ACCOUNT: {
                System.out.println(this.mProv.createAccount(args[1], args[2].equals("") ? null : args[2], this.getMap(args, 3)).getId());
                break;
            }
            case CREATE_ALIAS_DOMAIN: {
                System.out.println(this.doCreateAliasDomain(args[1], args[2], this.getMap(args, 3)).getId());
                break;
            }
            case CREATE_COS: {
                System.out.println(this.mProv.createCos(args[1], this.getMap(args, 2)).getId());
                break;
            }
            case CREATE_DOMAIN: {
                System.out.println(this.mProv.createDomain(args[1], this.getMap(args, 2)).getId());
                break;
            }
            case CREATE_IDENTITY: {
                this.mProv.createIdentity(this.lookupAccount(args[1]), args[2], this.getMap(args, 3));
                break;
            }
            case CREATE_SIGNATURE: {
                System.out.println(this.mProv.createSignature(this.lookupAccount(args[1]), args[2], this.getMap(args, 3)).getId());
                break;
            }
            case CREATE_DATA_SOURCE: {
                System.out.println(this.mProv.createDataSource(this.lookupAccount(args[1]), DataSource.Type.fromString(args[2]), args[3], this.getMap(args, 4)).getId());
                break;
            }
            case CREATE_SERVER: {
                System.out.println(this.mProv.createServer(args[1], this.getMap(args, 2)).getId());
                break;
            }
            case CREATE_XMPP_COMPONENT: {
                this.doCreateXMPPComponent(args);
                break;
            }
            case DESCRIBE: {
                this.doDescribe(args);
                break;
            }
            case EXIT: {
                System.exit(0);
                break;
            }
            case FLUSH_CACHE: {
                this.doFlushCache(args);
                break;
            }
            case GENERATE_DOMAIN_PRE_AUTH_KEY: {
                this.doGenerateDomainPreAuthKey(args);
                break;
            }
            case GENERATE_DOMAIN_PRE_AUTH: {
                this.doGenerateDomainPreAuth(args);
                break;
            }
            case GET_ACCOUNT: {
                this.doGetAccount(args);
                break;
            }
            case GET_ACCOUNT_MEMBERSHIP: {
                this.doGetAccountMembership(args);
                break;
            }
            case GET_IDENTITIES: {
                this.doGetAccountIdentities(args);
                break;
            }
            case GET_SIGNATURES: {
                this.doGetAccountSignatures(args);
                break;
            }
            case GET_DATA_SOURCES: {
                this.doGetAccountDataSources(args);
                break;
            }
            case GET_ACCOUNT_LOGGERS: {
                AccountLoggerOptions alo = this.parseAccountLoggerOptions(args);
                if (!this.mCommand.checkArgsLength(alo.args)) {
                    this.usage();
                    return true;
                }
                this.doGetAccountLoggers(alo);
                break;
            }
            case GET_ALL_ACCOUNT_LOGGERS: {
                AccountLoggerOptions alo = this.parseAccountLoggerOptions(args);
                if (!this.mCommand.checkArgsLength(alo.args)) {
                    this.usage();
                    return true;
                }
                this.doGetAllAccountLoggers(alo);
                break;
            }
            case GET_ALL_ACCOUNTS: {
                this.doGetAllAccounts(args);
                break;
            }
            case GET_ALL_ADMIN_ACCOUNTS: {
                this.doGetAllAdminAccounts(args);
                break;
            }
            case GET_ALL_CONFIG: {
                this.dumpAttrs(this.mProv.getConfig().getAttrs(), this.getArgNameSet(args, 1));
                break;
            }
            case GET_ALL_COS: {
                this.doGetAllCos(args);
                break;
            }
            case GET_ALL_DOMAINS: {
                this.doGetAllDomains(args);
                break;
            }
            case GET_ALL_FREEBUSY_PROVIDERS: {
                FbCli fbcli = new FbCli();
                for (FbCli.FbProvider fbprov : fbcli.getAllFreeBusyProviders()) {
                    System.out.println(fbprov.toString());
                }
                break;
            }
            case GET_ALL_RIGHTS: {
                this.doGetAllRights(args);
                break;
            }
            case GET_ALL_SERVERS: {
                this.doGetAllServers(args);
                break;
            }
            case GET_CONFIG: {
                this.doGetConfig(args);
                break;
            }
            case GET_COS: {
                this.dumpCos(this.lookupCos(args[1]), this.getArgNameSet(args, 2));
                break;
            }
            case GET_DISTRIBUTION_LIST_MEMBERSHIP: {
                this.doGetDistributionListMembership(args);
                break;
            }
            case GET_DOMAIN: {
                this.doGetDomain(args);
                break;
            }
            case GET_DOMAIN_INFO: {
                this.doGetDomainInfo(args);
                break;
            }
            case GET_FREEBUSY_QUEUE_INFO: {
                FbCli fbcli = new FbCli();
                String name = null;
                if (args.length > 1) {
                    name = args[1];
                }
                for (FbCli.FbQueue fbqueue : fbcli.getFreeBusyQueueInfo(name)) {
                    System.out.println(fbqueue.toString());
                }
                break;
            }
            case GET_RIGHT: {
                this.dumpRight(this.lookupRight(args[1]));
                break;
            }
            case GET_RIGHTS_DOC: {
                this.doGetRightsDoc(args);
                break;
            }
            case GET_SERVER: {
                this.doGetServer(args);
                break;
            }
            case GET_XMPP_COMPONENT: {
                this.doGetXMPPComponent(args);
                break;
            }
            case CHECK_RIGHT: {
                this.doCheckRight(args);
                break;
            }
            case GET_ALL_EFFECTIVE_RIGHTS: {
                this.doGetAllEffectiveRights(args);
                break;
            }
            case GET_EFFECTIVE_RIGHTS: {
                this.doGetEffectiveRights(args);
                break;
            }
            case GET_CREATE_OBJECT_ATTRS: {
                this.doGetCreateObjectAttrs(args);
                break;
            }
            case GET_GRANTS: {
                this.doGetGrants(args);
                break;
            }
            case GRANT_RIGHT: {
                this.doGrantRight(args);
                break;
            }
            case REVOKE_RIGHT: {
                this.doRevokeRight(args);
                break;
            }
            case HELP: {
                this.doHelp(args);
                break;
            }
            case MODIFY_ACCOUNT: {
                this.mProv.modifyAttrs(this.lookupAccount(args[1]), this.getMap(args, 2), true);
                break;
            }
            case MODIFY_DATA_SOURCE: {
                Account account = this.lookupAccount(args[1]);
                this.mProv.modifyDataSource(account, this.lookupDataSourceId(account, args[2]), this.getMap(args, 3));
                break;
            }
            case MODIFY_IDENTITY: {
                this.mProv.modifyIdentity(this.lookupAccount(args[1]), args[2], this.getMap(args, 3));
                break;
            }
            case MODIFY_SIGNATURE: {
                Account account = this.lookupAccount(args[1]);
                this.mProv.modifySignature(account, this.lookupSignatureId(account, args[2]), this.getMap(args, 3));
                break;
            }
            case MODIFY_COS: {
                this.mProv.modifyAttrs(this.lookupCos(args[1]), this.getMap(args, 2), true);
                break;
            }
            case MODIFY_CONFIG: {
                this.mProv.modifyAttrs(this.mProv.getConfig(), this.getMap(args, 1), true);
                break;
            }
            case MODIFY_DOMAIN: {
                this.mProv.modifyAttrs(this.lookupDomain(args[1]), this.getMap(args, 2), true);
                break;
            }
            case MODIFY_SERVER: {
                this.mProv.modifyAttrs(this.lookupServer(args[1]), this.getMap(args, 2), true);
                break;
            }
            case DELETE_ACCOUNT: {
                this.doDeleteAccount(args);
                break;
            }
            case DELETE_COS: {
                this.mProv.deleteCos(this.lookupCos(args[1]).getId());
                break;
            }
            case DELETE_DOMAIN: {
                this.mProv.deleteDomain(this.lookupDomain(args[1]).getId());
                break;
            }
            case DELETE_IDENTITY: {
                this.mProv.deleteIdentity(this.lookupAccount(args[1]), args[2]);
                break;
            }
            case DELETE_SIGNATURE: {
                Account account = this.lookupAccount(args[1]);
                this.mProv.deleteSignature(account, this.lookupSignatureId(account, args[2]));
                break;
            }
            case DELETE_DATA_SOURCE: {
                Account account = this.lookupAccount(args[1]);
                this.mProv.deleteDataSource(account, this.lookupDataSourceId(account, args[2]));
                break;
            }
            case DELETE_SERVER: {
                this.mProv.deleteServer(this.lookupServer(args[1]).getId());
                break;
            }
            case DELETE_XMPP_COMPONENT: {
                this.mProv.deleteXMPPComponent(this.lookupXMPPComponent(args[1]));
                break;
            }
            case PUSH_FREEBUSY: {
                FbCli fbcli = new FbCli();
                HashSet<String> accounts = new HashSet<String>();
                Collections.addAll(accounts, args);
                accounts.remove(args[0]);
                for (String acct : accounts) {
                    if (this.mProv.getAccountByName(acct) != null) continue;
                    throw AccountServiceException.NO_SUCH_ACCOUNT(acct);
                }
                fbcli.pushFreeBusyForAccounts(accounts);
                break;
            }
            case PUSH_FREEBUSY_DOMAIN: {
                FbCli fbcli = new FbCli();
                this.lookupDomain(args[1]);
                fbcli.pushFreeBusyForDomain(args[1]);
                break;
            }
            case PURGE_ACCOUNT_CALENDAR_CACHE: {
                this.doPurgeAccountCalendarCache(args);
                break;
            }
            case REMOVE_ACCOUNT_ALIAS: {
                Account acct = this.lookupAccount(args[1], false);
                this.mProv.removeAlias(acct, args[2]);
                if (acct != null) break;
                throw AccountServiceException.NO_SUCH_ACCOUNT(args[1]);
            }
            case REMOVE_ACCOUNT_LOGGER: {
                AccountLoggerOptions alo = this.parseAccountLoggerOptions(args);
                if (!this.mCommand.checkArgsLength(alo.args)) {
                    this.usage();
                    return true;
                }
                this.doRemoveAccountLogger(alo);
                break;
            }
            case RENAME_ACCOUNT: {
                this.mProv.renameAccount(this.lookupAccount(args[1]).getId(), args[2]);
                break;
            }
            case RENAME_COS: {
                this.mProv.renameCos(this.lookupCos(args[1]).getId(), args[2]);
                break;
            }
            case RENAME_DOMAIN: {
                this.doRenameDomain(args);
                break;
            }
            case SET_ACCOUNT_COS: {
                this.mProv.setCOS(this.lookupAccount(args[1]), this.lookupCos(args[2]));
                break;
            }
            case SEARCH_ACCOUNTS: {
                this.doSearchAccounts(args);
                break;
            }
            case SEARCH_GAL: {
                this.doSearchGal(args);
                break;
            }
            case SYNC_GAL: {
                this.doSyncGal(args);
                break;
            }
            case SET_PASSWORD: {
                this.mProv.setPassword(this.lookupAccount(args[1]), args[2]);
                break;
            }
            case CHECK_PASSWORD_STRENGTH: {
                this.mProv.checkPasswordStrength(this.lookupAccount(args[1]), args[2]);
                System.out.println("Password passed strength check.");
                break;
            }
            case CREATE_DISTRIBUTION_LIST: {
                System.out.println(this.mProv.createDistributionList(args[1], this.getMap(args, 2)).getId());
                break;
            }
            case CREATE_DISTRIBUTION_LISTS_BULK: {
                this.doCreateDistributionListsBulk(args);
                break;
            }
            case GET_ALL_DISTRIBUTION_LISTS: {
                this.doGetAllDistributionLists(args);
                break;
            }
            case GET_DISTRIBUTION_LIST: {
                this.dumpDistributionList(this.lookupDistributionList(args[1]), this.getArgNameSet(args, 2));
                break;
            }
            case GET_ALL_XMPP_COMPONENTS: {
                this.doGetAllXMPPComponents();
                break;
            }
            case MODIFY_DISTRIBUTION_LIST: {
                this.mProv.modifyAttrs(this.lookupDistributionList(args[1]), this.getMap(args, 2), true);
                break;
            }
            case DELETE_DISTRIBUTION_LIST: {
                this.mProv.deleteDistributionList(this.lookupDistributionList(args[1]).getId());
                break;
            }
            case ADD_DISTRIBUTION_LIST_MEMBER: {
                String[] members = new String[args.length - 2];
                System.arraycopy(args, 2, members, 0, args.length - 2);
                this.mProv.addMembers(this.lookupDistributionList(args[1]), members);
                break;
            }
            case REMOVE_DISTRIBUTION_LIST_MEMBER: {
                String[] members = new String[args.length - 2];
                System.arraycopy(args, 2, members, 0, args.length - 2);
                this.mProv.removeMembers(this.lookupDistributionList(args[1]), members);
                break;
            }
            case CREATE_BULK_ACCOUNTS: {
                this.doCreateAccountsBulk(args);
                break;
            }
            case ADD_DISTRIBUTION_LIST_ALIAS: {
                this.mProv.addAlias(this.lookupDistributionList(args[1]), args[2]);
                break;
            }
            case REMOVE_DISTRIBUTION_LIST_ALIAS: {
                DistributionList dl = this.lookupDistributionList(args[1], false);
                this.mProv.removeAlias(dl, args[2]);
                if (dl != null) break;
                throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(args[1]);
            }
            case RENAME_DISTRIBUTION_LIST: {
                this.mProv.renameDistributionList(this.lookupDistributionList(args[1]).getId(), args[2]);
                break;
            }
            case CREATE_CALENDAR_RESOURCE: {
                System.out.println(this.mProv.createCalendarResource(args[1], args[2].equals("") ? null : args[2], this.getMap(args, 3)).getId());
                break;
            }
            case DELETE_CALENDAR_RESOURCE: {
                this.mProv.deleteCalendarResource(this.lookupCalendarResource(args[1]).getId());
                break;
            }
            case MODIFY_CALENDAR_RESOURCE: {
                this.mProv.modifyAttrs(this.lookupCalendarResource(args[1]), this.getMap(args, 2), true);
                break;
            }
            case RENAME_CALENDAR_RESOURCE: {
                this.mProv.renameCalendarResource(this.lookupCalendarResource(args[1]).getId(), args[2]);
                break;
            }
            case GET_CALENDAR_RESOURCE: {
                this.dumpCalendarResource(this.lookupCalendarResource(args[1]), true, this.getArgNameSet(args, 2));
                break;
            }
            case GET_ALL_CALENDAR_RESOURCES: {
                this.doGetAllCalendarResources(args);
                break;
            }
            case SEARCH_CALENDAR_RESOURCES: {
                this.doSearchCalendarResources(args);
                break;
            }
            case PUBLISH_DISTRIBUTION_LIST_SHARE_INFO: {
                this.doPublishDistributionListShareInfo(args);
                break;
            }
            case GET_PUBLISHED_DISTRIBUTION_LIST_SHARE_INFO: {
                this.doGetPublishedDistributionListShareInfo(args);
                break;
            }
            case GET_SHARE_INFO: {
                this.doGetShareInfo(args);
                break;
            }
            case INIT_NOTEBOOK: {
                this.initNotebook(args);
                break;
            }
            case INIT_DOMAIN_NOTEBOOK: {
                this.initDomainNotebook(args);
                break;
            }
            case IMPORT_NOTEBOOK: {
                this.importNotebook(args);
                break;
            }
            case UPDATE_TEMPLATES: {
                this.updateTemplates(args);
                break;
            }
            case GET_QUOTA_USAGE: {
                this.doGetQuotaUsage(args);
                break;
            }
            case GET_MAILBOX_INFO: {
                this.doGetMailboxInfo(args);
                break;
            }
            case REINDEX_MAILBOX: {
                this.doReIndexMailbox(args);
                break;
            }
            case RECALCULATE_MAILBOX_COUNTS: {
                this.doRecalculateMailboxCounts(args);
                break;
            }
            case SELECT_MAILBOX: {
                if (!(this.mProv instanceof SoapProvisioning)) {
                    this.throwSoapOnly();
                }
                ZMailboxUtil util = new ZMailboxUtil();
                util.setVerbose(this.mVerbose);
                util.setDebug(this.mDebug != SoapDebugLevel.none);
                boolean smInteractive = this.mInteractive && args.length < 3;
                util.setInteractive(smInteractive);
                util.selectMailbox(args[1], (SoapProvisioning)this.mProv);
                if (smInteractive) {
                    util.interactive(this.mReader);
                    break;
                }
                if (args.length > 2) {
                    String[] newArgs = new String[args.length - 2];
                    System.arraycopy(args, 2, newArgs, 0, newArgs.length);
                    util.execute(newArgs);
                    break;
                }
                throw ZClientException.CLIENT_ERROR("command only valid in interactive mode or with arguments", null);
            }
            case GET_ALL_MTA_AUTH_URLS: {
                this.doGetAllMtaAuthURLs(args);
                break;
            }
            case GET_ALL_REVERSE_PROXY_URLS: {
                this.doGetAllReverseProxyURLs(args);
                break;
            }
            case GET_ALL_REVERSE_PROXY_BACKENDS: {
                this.doGetAllReverseProxyBackends(args);
                break;
            }
            case GET_ALL_MEMCACHED_SERVERS: {
                this.doGetAllMemcachedServers(args);
                break;
            }
            case RELOAD_MEMCACHED_CLIENT_CONFIG: {
                this.doReloadMemcachedClientConfig(args);
                break;
            }
            case GET_MEMCACHED_CLIENT_CONFIG: {
                this.doGetMemcachedClientConfig(args);
                break;
            }
            case GET_AUTH_TOKEN_INFO: {
                this.doGetAuthTokenInfo(args);
                break;
            }
            case SOAP: {
                SoapProvisioning sp = new SoapProvisioning();
                sp.soapSetURI("https://localhost:" + this.mPort + "/service/admin/soap/");
                sp.soapZimbraAdminAuthenticate();
                this.mProv = sp;
                break;
            }
            case LDAP: {
                this.mProv = Provisioning.getInstance();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void doGetDomain(String[] args) throws ServiceException {
        String arg;
        int i;
        boolean applyDefault = true;
        for (i = 1; i < args.length && (arg = args[i]).equals("-e"); ++i) {
            applyDefault = false;
        }
        if (i >= args.length) {
            this.usage();
            return;
        }
        this.dumpDomain(this.lookupDomain(args[i], this.mProv, applyDefault), applyDefault, this.getArgNameSet(args, i + 1));
    }

    private void doGetDomainInfo(String[] args) throws ServiceException {
        String key;
        Provisioning.DomainBy by;
        SoapProvisioning sp;
        Domain domain;
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        if ((domain = (sp = (SoapProvisioning)this.mProv).getDomainInfo(by = Provisioning.DomainBy.fromString(args[1]), key = args[2])) == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(key);
        }
        this.dumpDomain(domain, this.getArgNameSet(args, 3));
    }

    private void doRenameDomain(String[] args) throws ServiceException {
        if (!(this.mProv instanceof LdapProvisioning)) {
            this.throwLdapOnly();
        }
        LdapProvisioning lp = (LdapProvisioning)this.mProv;
        Domain domain = this.lookupDomain(args[1]);
        lp.renameDomain(domain.getId(), args[2]);
        ProvUtil.printOutput("domain " + args[1] + " renamed to " + args[2]);
    }

    private void doGetQuotaUsage(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        List<SoapProvisioning.QuotaUsage> result = sp.getQuotaUsage(args[1]);
        for (SoapProvisioning.QuotaUsage u : result) {
            System.out.printf("%s %d %d\n", u.getName(), u.getLimit(), u.getUsed());
        }
    }

    private void doGetMailboxInfo(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        Account acct = this.lookupAccount(args[1]);
        SoapProvisioning.MailboxInfo info = sp.getMailbox(acct);
        System.out.printf("mailboxId: %s\nquotaUsed: %d\n", info.getMailboxId(), info.getUsed());
    }

    private void doReIndexMailbox(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        Account acct = this.lookupAccount(args[1]);
        SoapProvisioning.ReIndexBy by = null;
        String[] values = null;
        if (args.length > 3) {
            try {
                by = SoapProvisioning.ReIndexBy.valueOf(args[3]);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("invalid reindex-by", null);
            }
            if (args.length > 4) {
                values = new String[args.length - 4];
                System.arraycopy(args, 4, values, 0, args.length - 4);
            } else {
                throw ServiceException.INVALID_REQUEST("missing reindex-by values", null);
            }
        }
        SoapProvisioning.ReIndexInfo info = sp.reIndex(acct, args[2], by, values);
        SoapProvisioning.ReIndexInfo.Progress progress = info.getProgress();
        System.out.printf("status: %s\n", info.getStatus());
        if (progress != null) {
            System.out.printf("progress: numSucceeded=%d, numFailed=%d, numRemaining=%d\n", progress.getNumSucceeded(), progress.getNumFailed(), progress.getNumRemaining());
        }
    }

    private void doRecalculateMailboxCounts(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        Account acct = this.lookupAccount(args[1]);
        long quotaUsed = sp.recalculateMailboxCounts(acct);
        System.out.printf("account: " + acct.getName() + "\nquotaUsed: " + quotaUsed + "\n", new Object[0]);
    }

    private AccountLoggerOptions parseAccountLoggerOptions(String[] args) throws ServiceException {
        AccountLoggerOptions alo = new AccountLoggerOptions();
        if (args.length > 1 && (args[1].equals("-s") || args[1].equals("--server"))) {
            if (args.length == 2) {
                throw ServiceException.FAILURE("Server name not specified.", null);
            }
            alo.server = args[2];
            int numArgs = args.length - 2;
            alo.args = new String[numArgs];
            alo.args[0] = args[0];
            for (int i = 1; i < numArgs; ++i) {
                alo.args[i] = args[i + 2];
            }
        } else {
            alo.args = args;
        }
        return alo;
    }

    private void doAddAccountLogger(AccountLoggerOptions alo) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        Account acct = this.lookupAccount(alo.args[1]);
        sp.addAccountLogger(acct, alo.args[2], alo.args[3], alo.server);
    }

    private void doGetAccountLoggers(AccountLoggerOptions alo) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        Account acct = this.lookupAccount(alo.args[1]);
        for (AccountLogger accountLogger : sp.getAccountLoggers(acct, alo.server)) {
            System.out.printf("%s=%s\n", new Object[]{accountLogger.getCategory(), accountLogger.getLevel()});
        }
    }

    private void doGetAllAccountLoggers(AccountLoggerOptions alo) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        Map<String, List<AccountLogger>> allLoggers = sp.getAllAccountLoggers(alo.server);
        for (String accountName : allLoggers.keySet()) {
            System.out.printf("# name %s\n", accountName);
            for (AccountLogger logger : allLoggers.get(accountName)) {
                System.out.printf("%s=%s\n", new Object[]{logger.getCategory(), logger.getLevel()});
            }
        }
    }

    private void doRemoveAccountLogger(AccountLoggerOptions alo) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        Account acct = null;
        String category = null;
        if (alo.args.length == 2) {
            String arg = alo.args[1];
            if (arg.startsWith("zimbra.") || arg.startsWith("com.zimbra")) {
                category = arg;
            } else {
                acct = this.lookupAccount(alo.args[1]);
            }
        }
        if (alo.args.length == 3) {
            acct = this.lookupAccount(alo.args[1]);
            category = alo.args[2];
        }
        sp.removeAccountLoggers(acct, category, alo.server);
    }

    private void doCreateAccountsBulk(String[] args) throws ServiceException {
        if (args.length < 3) {
            this.usage();
        } else {
            String domain = args[1];
            String password = "test123";
            String nameMask = args[2];
            int numAccounts = Integer.parseInt(args[3]);
            for (int ix = 0; ix < numAccounts; ++ix) {
                String name = nameMask + Integer.toString(ix) + "@" + domain;
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                String displayName = nameMask + " N. " + Integer.toString(ix);
                StringUtil.addToMultiMap(attrs, "displayName", displayName);
                Account account = this.mProv.createAccount(name, password, attrs);
                System.out.println(account.getId());
            }
        }
    }

    private Domain doCreateAliasDomain(String aliasDomain, String localDoamin, Map<String, Object> attrs) throws ServiceException {
        Domain local = this.lookupDomain(localDoamin);
        String localType = local.getAttr("zimbraDomainType");
        if (!"local".equals(localType)) {
            throw ServiceException.INVALID_REQUEST("target domain must be a local domain", null);
        }
        attrs.put("zimbraDomainType", "alias");
        attrs.put("zimbraDomainAliasTargetId", local.getId());
        return this.mProv.createDomain(aliasDomain, attrs);
    }

    private void doGetAccount(String[] args) throws ServiceException {
        boolean applyDefault = true;
        int acctPos = 1;
        if (args[1].equals("-e")) {
            if (args.length > 1) {
                applyDefault = false;
                acctPos = 2;
            } else {
                this.usage();
                return;
            }
        }
        this.dumpAccount(this.lookupAccount(args[acctPos], true, applyDefault), applyDefault, this.getArgNameSet(args, acctPos + 1));
    }

    private void doGetAccountMembership(String[] args) throws ServiceException {
        String key = null;
        boolean idsOnly = false;
        if (args.length > 2) {
            idsOnly = args[1].equals("-i");
            key = args[2];
        } else {
            key = args[1];
        }
        Account account = this.lookupAccount(key);
        if (idsOnly) {
            Set<String> lists = this.mProv.getDistributionLists(account);
            for (String id : lists) {
                System.out.println(id);
            }
        } else {
            HashMap<String, String> via = new HashMap<String, String>();
            List<DistributionList> lists = this.mProv.getDistributionLists(account, false, via);
            for (DistributionList dl : lists) {
                String viaDl = via.get(dl.getName());
                if (viaDl != null) {
                    System.out.println(dl.getName() + " (via " + viaDl + ")");
                    continue;
                }
                System.out.println(dl.getName());
            }
        }
    }

    private boolean parsePlusMinus(String s) throws ServiceException {
        if (s.equals("-")) {
            return false;
        }
        if (s.equals("+")) {
            return true;
        }
        throw ServiceException.INVALID_REQUEST("invalid arg for the add/remove", null);
    }

    private void doPublishDistributionListShareInfo(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        boolean isAdd = this.parsePlusMinus(args[1]);
        String key = args[2];
        DistributionList dl = this.lookupDistributionList(key);
        ShareInfoArgs siArgs = this.parsePublishShareInfo(isAdd, args);
        this.mProv.publishShareInfo(dl, siArgs.mAction, siArgs.mOwnerAcct, siArgs.mFolderPathOrId);
    }

    private void doGetPublishedDistributionListShareInfo(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        String key = args[1];
        DistributionList dl = this.lookupDistributionList(key);
        Account owner = null;
        if (args.length == 3) {
            owner = this.lookupAccount(args[2]);
        }
        ShareInfoVisitor.printHeadings();
        this.mProv.getPublishedShareInfo(dl, owner, new ShareInfoVisitor());
    }

    private ShareInfoArgs parsePublishShareInfo(boolean isAdd, String[] args) throws ServiceException {
        int idx = 3;
        String owner = args[idx++];
        Account ownerAcct = this.lookupAccount(owner);
        String folderPathOrId = null;
        if (args.length == 5) {
            folderPathOrId = args[idx++];
        }
        Provisioning.PublishShareInfoAction action = isAdd ? Provisioning.PublishShareInfoAction.add : Provisioning.PublishShareInfoAction.remove;
        return new ShareInfoArgs(action, ownerAcct, folderPathOrId);
    }

    private void doGetShareInfo(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        Account owner = this.lookupAccount(args[1]);
        ShareInfoVisitor.printHeadings();
        this.mProv.getShareInfo(owner, new ShareInfoVisitor());
    }

    private void doDeleteAccount(String[] args) throws ServiceException {
        String key = args[1];
        Account acct = this.lookupAccount(key);
        if (!(key.equalsIgnoreCase(acct.getId()) || key.equalsIgnoreCase(acct.getName()) || acct.getName().equalsIgnoreCase(key + "@" + acct.getDomainName()))) {
            throw ServiceException.INVALID_REQUEST("argument to deleteAccount must be an account id or the account's primary name", null);
        }
        this.mProv.deleteAccount(acct.getId());
    }

    private void doGetAccountIdentities(String[] args) throws ServiceException {
        Account account = this.lookupAccount(args[1]);
        Set<String> argNameSet = this.getArgNameSet(args, 2);
        for (Identity identity : this.mProv.getAllIdentities(account)) {
            this.dumpIdentity(identity, argNameSet);
        }
    }

    private void doGetAccountSignatures(String[] args) throws ServiceException {
        Account account = this.lookupAccount(args[1]);
        Set<String> argNameSet = this.getArgNameSet(args, 2);
        for (Signature signature : this.mProv.getAllSignatures(account)) {
            this.dumpSignature(signature, argNameSet);
        }
    }

    private void dumpDataSource(DataSource dataSource, Set<String> argNameSet) throws ServiceException {
        System.out.println("# name " + dataSource.getName());
        System.out.println("# type " + (Object)((Object)dataSource.getType()));
        Map<String, Object> attrs = dataSource.getAttrs();
        this.dumpAttrs(attrs, argNameSet);
        System.out.println();
    }

    private void doGetAccountDataSources(String[] args) throws ServiceException {
        Account account = this.lookupAccount(args[1]);
        Set<String> attrNameSet = this.getArgNameSet(args, 2);
        for (DataSource dataSource : this.mProv.getAllDataSources(account)) {
            this.dumpDataSource(dataSource, attrNameSet);
        }
    }

    private void doGetDistributionListMembership(String[] args) throws ServiceException {
        String key = args[1];
        DistributionList dist = this.lookupDistributionList(key);
        HashMap<String, String> via = new HashMap<String, String>();
        List<DistributionList> lists = this.mProv.getDistributionLists(dist, false, via);
        for (DistributionList dl : lists) {
            String viaDl = via.get(dl.getName());
            if (viaDl != null) {
                System.out.println(dl.getName() + " (via " + viaDl + ")");
                continue;
            }
            System.out.println(dl.getName());
        }
    }

    private void doGetConfig(String[] args) throws ServiceException {
        String key = args[1];
        String[] value = this.mProv.getConfig().getMultiAttr(key);
        if (value != null && value.length != 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(key, value);
            this.dumpAttrs(map, null);
        }
    }

    private void doGetAllAccounts(LdapProvisioning ldapProv, Domain domain, Server server, final boolean verbose, final boolean applyDefault, final Set<String> attrNames) throws ServiceException {
        NamedEntry.Visitor visitor = new NamedEntry.Visitor(){

            public void visit(NamedEntry entry) throws ServiceException {
                if (verbose) {
                    ProvUtil.this.dumpAccount((Account)entry, applyDefault, attrNames);
                } else {
                    System.out.println(entry.getName());
                }
            }
        };
        if (verbose && applyDefault) {
            ldapProv.getAllAccounts(domain, server, visitor);
        } else {
            ldapProv.getAllAccountsNoDefaults(domain, server, visitor);
        }
    }

    private void doGetAllAccounts(String[] args) throws ServiceException {
        if (!(this.mProv instanceof LdapProvisioning)) {
            this.throwLdapOnly();
        }
        LdapProvisioning ldapProv = (LdapProvisioning)this.mProv;
        boolean verbose = false;
        boolean applyDefault = true;
        String d = null;
        String s = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-e")) {
                applyDefault = false;
                continue;
            }
            if (arg.equals("-s")) {
                if (++i < args.length) {
                    if (s == null) {
                        s = args[i];
                        continue;
                    }
                    System.out.println("invalid arg: " + args[i] + ", already specified -s with " + s);
                    this.usage();
                    return;
                }
                this.usage();
                return;
            }
            if (d == null) {
                d = arg;
                continue;
            }
            System.out.println("invalid arg: " + arg + ", already specified domain: " + d);
            this.usage();
            return;
        }
        if (!applyDefault && !verbose) {
            System.out.println(ERR_INVALID_ARG_EV);
            this.usage();
            return;
        }
        Server server = null;
        if (s != null) {
            server = this.lookupServer(s);
        }
        if (d == null) {
            List<Domain> domains = ldapProv.getAllDomains();
            for (Domain domain : domains) {
                this.doGetAllAccounts(ldapProv, domain, server, verbose, applyDefault, null);
            }
        } else {
            Domain domain = this.lookupDomain(d, ldapProv);
            this.doGetAllAccounts(ldapProv, domain, server, verbose, applyDefault, null);
        }
    }

    private void doSearchAccounts(String[] args) throws ServiceException, ArgException {
        List<NamedEntry> accounts;
        boolean verbose = false;
        int i = 1;
        if (args[i].equals("-v")) {
            verbose = true;
            if (args.length < ++i - 1) {
                this.usage();
                return;
            }
        }
        if (args.length < i + 1) {
            this.usage();
            return;
        }
        String query = args[i];
        query = LdapEntrySearchFilter.toLdapIDNFilter(query);
        Map<String, Object> attrs = this.getMap(args, i + 1);
        String limitStr = (String)attrs.get("limit");
        int limit = limitStr == null ? Integer.MAX_VALUE : Integer.parseInt(limitStr);
        String offsetStr = (String)attrs.get("offset");
        int offset = offsetStr == null ? 0 : Integer.parseInt(offsetStr);
        String sortBy = (String)attrs.get("sortBy");
        String sortAscending = (String)attrs.get("sortAscending");
        boolean isSortAscending = sortAscending != null ? "1".equalsIgnoreCase(sortAscending) : true;
        String[] attrsToGet = null;
        String typesStr = (String)attrs.get("types");
        int flags = 15;
        if (typesStr != null) {
            flags = Provisioning.searchAccountStringToMask(typesStr);
        }
        String domainStr = (String)attrs.get("domain");
        Provisioning prov = Provisioning.getInstance();
        if (domainStr != null) {
            Domain d = this.lookupDomain(domainStr, prov);
            accounts = prov.searchAccounts(d, query, attrsToGet, sortBy, isSortAscending, flags);
        } else {
            accounts = prov.searchAccounts(query, attrsToGet, sortBy, isSortAscending, flags);
        }
        for (int j = offset; j < offset + limit && j < accounts.size(); ++j) {
            NamedEntry account = accounts.get(j);
            if (verbose) {
                if (account instanceof Account) {
                    this.dumpAccount((Account)account, true, null);
                    continue;
                }
                if (account instanceof Alias) {
                    this.dumpAlias((Alias)account);
                    continue;
                }
                if (account instanceof DistributionList) {
                    this.dumpDistributionList((DistributionList)account, null);
                    continue;
                }
                if (!(account instanceof Domain)) continue;
                this.dumpDomain((Domain)account, null);
                continue;
            }
            System.out.println(account.getName());
        }
    }

    private void doSearchGal(String[] args) throws ServiceException, ArgException {
        boolean verbose = false;
        int i = 1;
        if (args.length < i + 1) {
            this.usage();
            return;
        }
        if (args[i].equals("-v")) {
            verbose = true;
            if (args.length < ++i - 1) {
                this.usage();
                return;
            }
        }
        if (args.length < i + 2) {
            this.usage();
            return;
        }
        String domain = args[i];
        String query = args[i + 1];
        Map<String, Object> attrs = this.getMap(args, i + 2);
        String limitStr = (String)attrs.get("limit");
        int limit = limitStr == null ? Integer.MAX_VALUE : Integer.parseInt(limitStr);
        String offsetStr = (String)attrs.get("offset");
        int offset = offsetStr == null ? 0 : Integer.parseInt(offsetStr);
        String sortBy = (String)attrs.get("sortBy");
        Domain d = this.lookupDomain(domain);
        Provisioning.SearchGalResult result = this.mProv instanceof SoapProvisioning ? ((SoapProvisioning)this.mProv).searchGal(d, query, Provisioning.GAL_SEARCH_TYPE.ALL, null, limit, offset, sortBy) : this.mProv.searchGal(d, query, Provisioning.GAL_SEARCH_TYPE.ALL, null);
        for (GalContact contact : result.getMatches()) {
            this.dumpContact(contact);
        }
    }

    private void doAutoCompleteGal(String[] args) throws ServiceException {
        String domain = args[1];
        String query = args[2];
        Domain d = this.lookupDomain(domain);
        Provisioning.SearchGalResult result = this.mProv.autoCompleteGal(d, query, Provisioning.GAL_SEARCH_TYPE.ALL, 100);
        for (GalContact contact : result.getMatches()) {
            this.dumpContact(contact);
        }
    }

    private void doCountAccount(String[] args) throws ServiceException {
        String domain = args[1];
        Domain d = this.lookupDomain(domain);
        Provisioning.CountAccountResult result = this.mProv.countAccount(d);
        String formatHeading = "%-20s %-40s %s\n";
        String format = "%-20s %-40s %d\n";
        System.out.printf(formatHeading, "cos name", "cos id", "# of accounts");
        System.out.printf(formatHeading, "--------------------", "----------------------------------------", "--------------------");
        for (Provisioning.CountAccountResult.CountAccountByCos c : result.getCountAccountByCos()) {
            System.out.printf(format, c.getCosName(), c.getCosId(), c.getCount());
        }
        System.out.println();
    }

    private void doSyncGal(String[] args) throws ServiceException {
        String domain = args[1];
        String token = args.length == 3 ? args[2] : "";
        Domain d = this.lookupDomain(domain);
        Provisioning.SearchGalResult result = this.mProv.searchGal(d, "", Provisioning.GAL_SEARCH_TYPE.ALL, token);
        if (result.getToken() != null) {
            System.out.println("# token = " + result.getToken() + "\n");
        }
        for (GalContact contact : result.getMatches()) {
            this.dumpContact(contact);
        }
    }

    private void doGetAllAdminAccounts(String[] args) throws ServiceException {
        List<Account> accounts;
        int i;
        boolean verbose = false;
        boolean applyDefault = true;
        for (i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (!arg.equals("-e")) break;
            applyDefault = false;
        }
        if (!applyDefault && !verbose) {
            System.out.println(ERR_INVALID_ARG_EV);
            this.usage();
            return;
        }
        if (this.mProv instanceof SoapProvisioning) {
            SoapProvisioning soapProv = (SoapProvisioning)this.mProv;
            accounts = soapProv.getAllAdminAccounts(applyDefault);
        } else {
            accounts = this.mProv.getAllAdminAccounts();
        }
        Set<String> attrNames = this.getArgNameSet(args, i);
        for (Account account : accounts) {
            if (verbose) {
                this.dumpAccount(account, applyDefault, attrNames);
                continue;
            }
            System.out.println(account.getName());
        }
    }

    private void doGetAllCos(String[] args) throws ServiceException {
        boolean verbose = args.length > 1 && args[1].equals("-v");
        Set<String> attrNames = this.getArgNameSet(args, verbose ? 2 : 1);
        List<Cos> allcos = this.mProv.getAllCos();
        for (Cos cos : allcos) {
            if (verbose) {
                this.dumpCos(cos, attrNames);
                continue;
            }
            System.out.println(cos.getName());
        }
    }

    private void dumpCos(Cos cos, Set<String> attrNames) throws ServiceException {
        System.out.println("# name " + cos.getName());
        Map<String, Object> attrs = cos.getAttrs();
        this.dumpAttrs(attrs, attrNames);
        System.out.println();
    }

    private void doGetAllDomains(String[] args) throws ServiceException {
        List<Domain> domains;
        int i;
        boolean verbose = false;
        boolean applyDefault = true;
        for (i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (!arg.equals("-e")) break;
            applyDefault = false;
        }
        if (!applyDefault && !verbose) {
            System.out.println(ERR_INVALID_ARG_EV);
            this.usage();
            return;
        }
        Set<String> attrNames = this.getArgNameSet(args, i);
        if (this.mProv instanceof SoapProvisioning) {
            SoapProvisioning soapProv = (SoapProvisioning)this.mProv;
            domains = soapProv.getAllDomains(applyDefault);
        } else {
            domains = this.mProv.getAllDomains();
        }
        for (Domain domain : domains) {
            if (verbose) {
                this.dumpDomain(domain, attrNames);
                continue;
            }
            System.out.println(domain.getName());
        }
    }

    private void dumpDomain(Domain domain, Set<String> attrNames) throws ServiceException {
        this.dumpDomain(domain, true, attrNames);
    }

    private void dumpDomain(Domain domain, boolean expandConfig, Set<String> attrNames) throws ServiceException {
        System.out.println("# name " + domain.getName());
        Map<String, Object> attrs = domain.getAttrs(expandConfig);
        this.dumpAttrs(attrs, attrNames);
        System.out.println();
    }

    private void dumpDistributionList(DistributionList dl, Set<String> attrNames) throws ServiceException {
        String[] members = dl.getAllMembers();
        int count = members == null ? 0 : members.length;
        System.out.println("# distributionList " + dl.getName() + " memberCount=" + count);
        Map<String, Object> attrs = dl.getAttrs();
        this.dumpAttrs(attrs, attrNames);
    }

    private void dumpAlias(Alias alias) throws ServiceException {
        System.out.println("# alias " + alias.getName());
        Map<String, Object> attrs = alias.getAttrs();
        this.dumpAttrs(attrs, null);
    }

    private void doGetAllRights(String[] args) throws ServiceException {
        boolean verbose = false;
        String targetType = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (targetType == null) {
                targetType = arg;
                continue;
            }
            System.out.println("invalid arg: " + arg + ", already specified target type: " + targetType);
            this.usage();
            return;
        }
        List<Right> allRights = this.mProv.getAllRights(targetType, false);
        for (Right right : allRights) {
            if (verbose) {
                this.dumpRight(right);
                continue;
            }
            System.out.println(right.getName());
        }
    }

    private void dumpRight(Right right) throws ServiceException {
        String indent = "    ";
        String indent2 = "        ";
        System.out.println();
        System.out.println("------------------------------");
        System.out.println(right.getName());
        System.out.println(indent + "   description: " + right.getDesc());
        System.out.println(indent + "    right type: " + right.getRightType().name());
        String targetType = right.getTargetTypeStr();
        System.out.println(indent + "target type(s): " + (targetType == null ? "" : targetType));
        if (right.isAttrRight()) {
            AttrRight attrRight = (AttrRight)right;
            System.out.println();
            System.out.println(indent + "attributes:");
            if (attrRight.allAttrs()) {
                System.out.println(indent2 + "all attributes");
            } else {
                for (String attrName : attrRight.getAttrs()) {
                    System.out.println(indent2 + attrName);
                }
            }
        } else if (right.isComboRight()) {
            ComboRight comboRight = (ComboRight)right;
            System.out.println();
            System.out.println(indent + "rights:");
            for (Right r : comboRight.getRights()) {
                System.out.println(indent2 + r.getName());
            }
        }
        System.out.println();
    }

    private void doGetRightsDoc(String[] args) throws ServiceException {
        String[] packages;
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        StringBuilder argsDump = new StringBuilder();
        if (args.length > 1) {
            packages = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                packages[i - 1] = args[i];
                argsDump.append(" " + args[i]);
            }
        } else {
            packages = new String[]{"com.zimbra.cs.service.admin", "com.zimbra.bp", "com.zimbra.cert", "com.zimbra.cs.network", "com.zimbra.cs.network.license.service", "com.zimbra.cs.service.backup", "com.zimbra.cs.service.hsm", "com.zimbra.xmbxsearch"};
        }
        System.out.println("#");
        System.out.println("#  Generated by: zmprov grd" + argsDump);
        System.out.println("#");
        System.out.println("#  Date: " + DateFormat.getDateInstance(1).format(new Date()));
        System.out.println("# ");
        System.out.println("#  Pacakges:");
        for (String pkg : packages) {
            System.out.println("#       " + pkg);
        }
        System.out.println("# ");
        System.out.println("\n");
        Map<String, List<Provisioning.RightsDoc>> allDocs = this.mProv.getRightsDoc(packages);
        for (Map.Entry<String, List<Provisioning.RightsDoc>> docs : allDocs.entrySet()) {
            System.out.println("========================================");
            System.out.println("Package: " + docs.getKey());
            System.out.println("========================================");
            System.out.println();
            for (Provisioning.RightsDoc doc : docs.getValue()) {
                System.out.println("------------------------------");
                System.out.println(doc.getCmd() + "\n");
                System.out.println("    Related rights:");
                for (String r : doc.getRights()) {
                    System.out.println("        " + r);
                }
                System.out.println();
                System.out.println("    Notes:");
                for (String n : doc.getNotes()) {
                    System.out.println(FileGenUtil.wrapComments(StringUtil.escapeHtml(n), 70, "        ") + "\n");
                }
                System.out.println();
            }
        }
    }

    private void doGetAllServers(String[] args) throws ServiceException {
        List<Server> servers;
        boolean verbose = false;
        boolean applyDefault = true;
        String service = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-e")) {
                applyDefault = false;
                continue;
            }
            if (service == null) {
                service = arg;
                continue;
            }
            System.out.println("invalid arg: " + arg + ", already specified service: " + service);
            this.usage();
            return;
        }
        if (!applyDefault && !verbose) {
            System.out.println(ERR_INVALID_ARG_EV);
            this.usage();
            return;
        }
        if (this.mProv instanceof SoapProvisioning) {
            SoapProvisioning soapProv = (SoapProvisioning)this.mProv;
            servers = soapProv.getAllServers(service, applyDefault);
        } else {
            servers = this.mProv.getAllServers(service);
        }
        for (Server server : servers) {
            if (verbose) {
                this.dumpServer(server, applyDefault, null);
                continue;
            }
            System.out.println(server.getName());
        }
    }

    private void dumpServer(Server server, Set<String> attrNames) throws ServiceException {
        this.dumpServer(server, true, attrNames);
    }

    private void dumpServer(Server server, boolean expandConfig, Set<String> attrNames) throws ServiceException {
        System.out.println("# name " + server.getName());
        Map<String, Object> attrs = server.getAttrs(expandConfig);
        this.dumpAttrs(attrs, attrNames);
        System.out.println();
    }

    private void dumpXMPPComponent(XMPPComponent comp, Set<String> attrNames) {
        System.out.println("# name " + comp.getName());
        Map<String, Object> attrs = comp.getAttrs();
        this.dumpAttrs(attrs, attrNames);
        System.out.println();
    }

    private void doGetAllXMPPComponents() throws ServiceException {
        List<XMPPComponent> components = this.mProv.getAllXMPPComponents();
        for (XMPPComponent comp : components) {
            this.dumpXMPPComponent(comp, null);
        }
    }

    private void dumpAccount(Account account, boolean expandCos, Set<String> attrNames) throws ServiceException {
        System.out.println("# name " + account.getName());
        Map<String, Object> attrs = account.getAttrs(expandCos);
        this.dumpAttrs(attrs, attrNames);
        System.out.println();
    }

    private void dumpCalendarResource(CalendarResource resource, boolean expandCos, Set<String> attrNames) throws ServiceException {
        System.out.println("# name " + resource.getName());
        Map<String, Object> attrs = resource.getAttrs(expandCos);
        this.dumpAttrs(attrs, attrNames);
        System.out.println();
    }

    private void dumpContact(GalContact contact) throws ServiceException {
        System.out.println("# name " + contact.getId());
        Map<String, Object> attrs = contact.getAttrs();
        this.dumpAttrs(attrs, null);
        System.out.println();
    }

    private void dumpIdentity(Identity identity, Set<String> attrNameSet) throws ServiceException {
        System.out.println("# name " + identity.getName());
        Map<String, Object> attrs = identity.getAttrs();
        this.dumpAttrs(attrs, attrNameSet);
        System.out.println();
    }

    private void dumpSignature(Signature signature, Set<String> attrNameSet) throws ServiceException {
        System.out.println("# name " + signature.getName());
        Map<String, Object> attrs = signature.getAttrs();
        this.dumpAttrs(attrs, attrNameSet);
        System.out.println();
    }

    private void dumpAttrs(Map<String, Object> attrsIn, Set<String> specificAttrs) {
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(attrsIn);
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            String name = entry.getKey();
            if (specificAttrs != null && !specificAttrs.contains(name.toLowerCase())) continue;
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] sv;
                for (String aSv : sv = (String[])value) {
                    if (aSv.length() <= 0) continue;
                    ProvUtil.printOutput(name + ": " + aSv);
                }
                continue;
            }
            if (!(value instanceof String) || ((String)value).length() <= 0) continue;
            ProvUtil.printOutput(name + ": " + value);
        }
    }

    private void doCreateDistributionListsBulk(String[] args) throws ServiceException {
        if (args.length < 3) {
            this.usage();
        } else {
            String domain = args[1];
            String nameMask = args[2];
            int numAccounts = Integer.parseInt(args[3]);
            for (int ix = 0; ix < numAccounts; ++ix) {
                String name = nameMask + Integer.toString(ix) + "@" + domain;
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                String displayName = nameMask + " N. " + Integer.toString(ix);
                StringUtil.addToMultiMap(attrs, "displayName", displayName);
                DistributionList dl = this.mProv.createDistributionList(name, attrs);
                System.out.println(dl.getId());
            }
        }
    }

    private void doGetAllDistributionLists(String[] args) throws ServiceException {
        String d;
        String string = d = args.length == 2 ? args[1] : null;
        if (d == null) {
            List<Domain> domains = this.mProv.getAllDomains();
            for (Domain domain : domains) {
                List dls = this.mProv.getAllDistributionLists(domain);
                for (DistributionList dl : dls) {
                    System.out.println(dl.getName());
                }
            }
        } else {
            Domain domain = this.lookupDomain(d);
            List dls = this.mProv.getAllDistributionLists(domain);
            for (DistributionList dl : dls) {
                System.out.println(dl.getName());
            }
        }
    }

    private void doGetAllCalendarResources(String[] args) throws ServiceException {
        boolean verbose = false;
        boolean applyDefault = true;
        String d = null;
        String s = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-e")) {
                applyDefault = false;
                continue;
            }
            if (arg.equals("-s")) {
                if (++i < args.length) {
                    if (s == null) {
                        s = args[i];
                        continue;
                    }
                    System.out.println("invalid arg: " + args[i] + ", already specified -s with " + s);
                    this.usage();
                    return;
                }
                this.usage();
                return;
            }
            if (d == null) {
                d = arg;
                continue;
            }
            System.out.println("invalid arg: " + arg + ", already specified domain: " + d);
            this.usage();
            return;
        }
        if (!applyDefault && !verbose) {
            System.out.println(ERR_INVALID_ARG_EV);
            this.usage();
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        Server server = null;
        if (s != null) {
            server = this.lookupServer(s);
        }
        if (d == null) {
            List<Domain> domains = prov.getAllDomains();
            for (Domain domain : domains) {
                this.doGetAllCalendarResources(prov, domain, server, verbose, applyDefault);
            }
        } else {
            Domain domain = this.lookupDomain(d, prov);
            this.doGetAllCalendarResources(prov, domain, server, verbose, applyDefault);
        }
    }

    private void doGetAllCalendarResources(Provisioning prov, Domain domain, Server server, final boolean verbose, final boolean applyDefault) throws ServiceException {
        NamedEntry.Visitor visitor = new NamedEntry.Visitor(){

            public void visit(NamedEntry entry) throws ServiceException {
                if (verbose) {
                    ProvUtil.this.dumpCalendarResource((CalendarResource)entry, applyDefault, null);
                } else {
                    System.out.println(entry.getName());
                }
            }
        };
        prov.getAllCalendarResources(domain, server, visitor);
    }

    private void doSearchCalendarResources(String[] args) throws ServiceException {
        if (!(this.mProv instanceof LdapProvisioning)) {
            this.throwLdapOnly();
        }
        boolean verbose = false;
        int i = 1;
        if (args.length < i + 1) {
            this.usage();
            return;
        }
        if (args[i].equals("-v")) {
            verbose = true;
            ++i;
        }
        if (args.length < i + 1) {
            this.usage();
            return;
        }
        Domain d = this.lookupDomain(args[i++]);
        if ((args.length - i) % 3 != 0) {
            this.usage();
            return;
        }
        EntrySearchFilter.Multi multi = new EntrySearchFilter.Multi(false, EntrySearchFilter.AndOr.and);
        while (i < args.length) {
            String attr = args[i++];
            String op = args[i++];
            String value = args[i++];
            try {
                EntrySearchFilter.Single single = new EntrySearchFilter.Single(false, attr, op, value);
                multi.add(single);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ProvUtil.printError("Bad search op in: " + attr + " " + op + " '" + value + "'");
                illegalArgumentException.printStackTrace();
                this.usage();
                return;
            }
        }
        EntrySearchFilter filter = new EntrySearchFilter(multi);
        List<NamedEntry> resources = this.mProv.searchCalendarResources(d, filter, null, null, true);
        for (CalendarResource calendarResource : resources) {
            if (verbose) {
                this.dumpCalendarResource(calendarResource, true, null);
                continue;
            }
            System.out.println(calendarResource.getName());
        }
    }

    private void initNotebook(String[] args) throws ServiceException {
        if (args.length > 2) {
            this.usage();
            return;
        }
        String username = null;
        if (args.length == 2) {
            username = args[1];
        }
        WikiUtil wu = WikiUtil.getInstance(this.mProv);
        wu.initDefaultWiki(username);
    }

    private void initDomainNotebook(String[] args) throws ServiceException {
        if (args.length < 2 || args.length > 3) {
            this.usage();
            return;
        }
        String domain = null;
        String username = null;
        domain = args[1];
        if (args.length == 3) {
            username = args[2];
        }
        if (this.mProv.get(Provisioning.AccountBy.name, username) == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(username);
        }
        WikiUtil wu = WikiUtil.getInstance(this.mProv);
        wu.initDomainWiki(domain, username);
    }

    private void importNotebook(String[] args) throws ServiceException, IOException {
        if (args.length != 4) {
            this.usage();
            return;
        }
        WikiUtil wu = WikiUtil.getInstance(this.mProv);
        wu.startImport(args[1], args[3], new File(args[2]));
    }

    private void updateTemplates(String[] args) throws ServiceException, IOException {
        if (args.length != 2 && args.length != 4) {
            this.usage();
            return;
        }
        String dir = args[1];
        Server server = null;
        if (args.length == 4 && args[1].equals("-h")) {
            server = this.mProv.get(Provisioning.ServerBy.name, args[2]);
            if (server == null) {
                throw AccountServiceException.NO_SUCH_SERVER(args[2]);
            }
            dir = args[3];
        }
        WikiUtil wu = WikiUtil.getInstance(this.mProv);
        wu.updateTemplates(server, new File(dir));
    }

    private Account lookupAccount(String key, boolean mustFind, boolean applyDefault) throws ServiceException {
        Account a;
        if (applyDefault || this.mProv instanceof LdapProvisioning) {
            a = this.mProv.getAccount(key);
        } else {
            SoapProvisioning soapProv = (SoapProvisioning)this.mProv;
            a = soapProv.getAccount(key, applyDefault);
        }
        if (mustFind && a == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(key);
        }
        return a;
    }

    private Account lookupAccount(String key) throws ServiceException {
        return this.lookupAccount(key, true, true);
    }

    private Account lookupAccount(String key, boolean mustFind) throws ServiceException {
        return this.lookupAccount(key, mustFind, true);
    }

    private CalendarResource lookupCalendarResource(String key) throws ServiceException {
        CalendarResource res = this.mProv.get(ProvUtil.guessCalendarResourceBy(key), key);
        if (res == null) {
            throw AccountServiceException.NO_SUCH_CALENDAR_RESOURCE(key);
        }
        return res;
    }

    private Domain lookupDomain(String key) throws ServiceException {
        return this.lookupDomain(key, this.mProv);
    }

    private Domain lookupDomain(String key, Provisioning prov) throws ServiceException {
        return this.lookupDomain(key, prov, true);
    }

    private Domain lookupDomain(String key, Provisioning prov, boolean applyDefault) throws ServiceException {
        Domain d;
        if (prov instanceof SoapProvisioning) {
            SoapProvisioning soapProv = (SoapProvisioning)prov;
            d = soapProv.get(ProvUtil.guessDomainBy(key), key, applyDefault);
        } else {
            d = prov.get(ProvUtil.guessDomainBy(key), key);
        }
        if (d == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(key);
        }
        return d;
    }

    private Cos lookupCos(String key) throws ServiceException {
        Cos c = this.mProv.get(ProvUtil.guessCosBy(key), key);
        if (c == null) {
            throw AccountServiceException.NO_SUCH_COS(key);
        }
        return c;
    }

    private Right lookupRight(String rightName) throws ServiceException {
        return this.mProv.getRight(rightName, false);
    }

    private Server lookupServer(String key) throws ServiceException {
        return this.lookupServer(key, true);
    }

    private Server lookupServer(String key, boolean applyDefault) throws ServiceException {
        Server s;
        if (this.mProv instanceof SoapProvisioning) {
            SoapProvisioning soapProv = (SoapProvisioning)this.mProv;
            s = soapProv.get(ProvUtil.guessServerBy(key), key, applyDefault);
        } else {
            s = this.mProv.get(ProvUtil.guessServerBy(key), key);
        }
        if (s == null) {
            throw AccountServiceException.NO_SUCH_SERVER(key);
        }
        return s;
    }

    private String lookupDataSourceId(Account account, String key) throws ServiceException {
        if (Provisioning.isUUID(key)) {
            return key;
        }
        DataSource ds = this.mProv.get(account, Provisioning.DataSourceBy.name, key);
        if (ds == null) {
            throw AccountServiceException.NO_SUCH_DATA_SOURCE(key);
        }
        return ds.getId();
    }

    private String lookupSignatureId(Account account, String key) throws ServiceException {
        Signature sig = this.mProv.get(account, ProvUtil.guessSignatureBy(key), key);
        if (sig == null) {
            throw AccountServiceException.NO_SUCH_SIGNATURE(key);
        }
        return sig.getId();
    }

    private DistributionList lookupDistributionList(String key, boolean mustFind) throws ServiceException {
        DistributionList dl = this.mProv.get(ProvUtil.guessDistributionListBy(key), key);
        if (mustFind && dl == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(key);
        }
        return dl;
    }

    private DistributionList lookupDistributionList(String key) throws ServiceException {
        return this.lookupDistributionList(key, true);
    }

    private String getAllFreebusyProviders(String[] args) throws ServiceException {
        return "";
    }

    private XMPPComponent lookupXMPPComponent(String value) throws ServiceException {
        if (Provisioning.isUUID(value)) {
            return this.mProv.get(Provisioning.XMPPComponentBy.id, value);
        }
        return this.mProv.get(Provisioning.XMPPComponentBy.name, value);
    }

    public static Provisioning.AccountBy guessAccountBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.AccountBy.id;
        }
        return Provisioning.AccountBy.name;
    }

    public static Provisioning.CosBy guessCosBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.CosBy.id;
        }
        return Provisioning.CosBy.name;
    }

    public static Provisioning.DomainBy guessDomainBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.DomainBy.id;
        }
        return Provisioning.DomainBy.name;
    }

    public static Provisioning.ServerBy guessServerBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.ServerBy.id;
        }
        return Provisioning.ServerBy.name;
    }

    public static Provisioning.CalendarResourceBy guessCalendarResourceBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.CalendarResourceBy.id;
        }
        return Provisioning.CalendarResourceBy.name;
    }

    public static Provisioning.DistributionListBy guessDistributionListBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.DistributionListBy.id;
        }
        return Provisioning.DistributionListBy.name;
    }

    public static Provisioning.SignatureBy guessSignatureBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.SignatureBy.id;
        }
        return Provisioning.SignatureBy.name;
    }

    public static Provisioning.TargetBy guessTargetBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.TargetBy.id;
        }
        return Provisioning.TargetBy.name;
    }

    public static Provisioning.GranteeBy guessGranteeBy(String value) {
        if (Provisioning.isUUID(value)) {
            return Provisioning.GranteeBy.id;
        }
        return Provisioning.GranteeBy.name;
    }

    private Map<String, Object> getMap(String[] args, int offset) throws ArgException {
        try {
            return StringUtil.keyValueArrayToMultiMap(args, offset);
        }
        catch (IllegalArgumentException iae) {
            throw new ArgException("not enough arguments");
        }
    }

    private Set<String> getArgNameSet(String[] args, int offset) {
        if (offset >= args.length) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = offset; i < args.length; ++i) {
            result.add(args[i].toLowerCase());
        }
        return result;
    }

    private void interactive(BufferedReader in) throws IOException {
        this.mReader = in;
        this.mInteractive = true;
        while (true) {
            String[] args;
            System.out.print("prov> ");
            String line = StringUtil.readLine(in);
            if (line == null) break;
            if (this.mVerbose) {
                System.out.println(line);
            }
            if ((args = StringUtil.parseLine(line)).length == 0) continue;
            try {
                if (this.execute(args)) continue;
                System.out.println("Unknown command. Type: 'help commands' for a list");
            }
            catch (ServiceException e) {
                Throwable cause = e.getCause();
                String errText = "ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")");
                ProvUtil.printError(errText);
                if (!this.mVerbose) continue;
                e.printStackTrace(System.err);
            }
            catch (ArgException e) {
                this.usage();
            }
        }
    }

    private static void printError(String text) {
        PrintStream ps = System.err;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)ps, "UTF-8"));
            writer.write(text + "\n");
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            ps.println(text);
        }
        catch (IOException e) {
            ps.println(text);
        }
    }

    private static void printOutput(String text) {
        PrintStream ps = System.out;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)ps, "UTF-8"));
            writer.write(text + "\n");
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            ps.println(text);
        }
        catch (IOException e) {
            ps.println(text);
        }
    }

    public static void main(String[] args) throws IOException, ParseException, ServiceException {
        block30: {
            CliUtil.toolSetup();
            SoapTransport.setDefaultUserAgent("zmprov", BuildInfo.VERSION);
            ProvUtil pu = new ProvUtil();
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("h", "help", false, "display usage");
            options.addOption("f", "file", true, "use file as input stream");
            options.addOption("s", "server", true, "host[:port] of server to connect to");
            options.addOption("l", "ldap", false, "provision via LDAP");
            options.addOption("L", "logpropertyfile", true, "log4j property file");
            options.addOption("a", "account", true, "account name (not used with --ldap)");
            options.addOption("p", "password", true, "password for account");
            options.addOption("P", "passfile", true, "filename with password in it");
            options.addOption("z", "zadmin", false, "use zimbra admin name/password from localconfig for account/password");
            options.addOption("v", "verbose", false, "verbose mode");
            options.addOption("d", "debug", false, "debug mode (SOAP request and response payload)");
            options.addOption("D", "debughigh", false, "debug mode (SOAP req/resp payload and http headers)");
            options.addOption("m", "master", false, "use LDAP master (has to be used with --ldap)");
            options.addOption(SoapCLI.OPT_AUTHTOKEN);
            options.addOption(SoapCLI.OPT_AUTHTOKENFILE);
            CommandLine cl = null;
            boolean err = false;
            try {
                cl = parser.parse(options, args, true);
            }
            catch (ParseException pe) {
                ProvUtil.printError("error: " + pe.getMessage());
                err = true;
            }
            if (err || cl.hasOption('h')) {
                pu.usage();
            }
            if (cl.hasOption('l') && cl.hasOption('s')) {
                ProvUtil.printError("error: cannot specify both -l and -s at the same time");
                System.exit(2);
            }
            pu.setVerbose(cl.hasOption('v'));
            if (cl.hasOption('l')) {
                pu.setUseLdap(true, cl.hasOption('m'));
            }
            if (cl.hasOption('L')) {
                if (cl.hasOption('l')) {
                    ZimbraLog.toolSetupLog4j("INFO", cl.getOptionValue('L'));
                } else {
                    ProvUtil.printError("error: cannot specify -L when -l is not specified");
                    System.exit(2);
                }
            }
            if (cl.hasOption('z')) {
                pu.setAccount(LC.zimbra_ldap_user.value());
                pu.setPassword(LC.zimbra_ldap_password.value());
            }
            if (cl.hasOption("y") && cl.hasOption("Y")) {
                ProvUtil.printError("error: cannot specify y when Y is specified");
                System.exit(2);
            }
            if (cl.hasOption("y")) {
                ZAuthToken zat = ZAuthToken.fromJSONString(cl.getOptionValue("y"));
                pu.setAuthToken(zat);
            }
            if (cl.hasOption("Y")) {
                String authToken = StringUtil.readSingleLineFromFile(cl.getOptionValue("Y"));
                ZAuthToken zat = ZAuthToken.fromJSONString(authToken);
                pu.setAuthToken(zat);
            }
            if (cl.hasOption('s')) {
                pu.setServer(cl.getOptionValue('s'));
            }
            if (cl.hasOption('a')) {
                pu.setAccount(cl.getOptionValue('a'));
            }
            if (cl.hasOption('p')) {
                pu.setPassword(cl.getOptionValue('p'));
            }
            if (cl.hasOption('P')) {
                pu.setPassword(StringUtil.readSingleLineFromFile(cl.getOptionValue('P')));
            }
            if (cl.hasOption('d') && cl.hasOption('D')) {
                ProvUtil.printError("error: cannot specify both -d and -D at the same time");
                System.exit(2);
            }
            if (cl.hasOption('D')) {
                pu.setDebug(SoapDebugLevel.high);
            } else if (cl.hasOption('d')) {
                pu.setDebug(SoapDebugLevel.normal);
            }
            if (!pu.useLdap() && cl.hasOption('m')) {
                ProvUtil.printError("error: cannot specify -m when -l is not specified");
                System.exit(2);
            }
            args = cl.getArgs();
            try {
                if (args.length < 1) {
                    pu.initProvisioning();
                    InputStream is = cl.hasOption('f') ? new FileInputStream(cl.getOptionValue('f')) : System.in;
                    pu.interactive(new BufferedReader(new InputStreamReader(is, "UTF-8")));
                    break block30;
                }
                Command cmd = pu.lookupCommand(args[0]);
                if (cmd == null) {
                    pu.usage();
                }
                if (pu.forceLdapButDontRequireUseLdapOption(cmd)) {
                    pu.setUseLdap(true, false);
                }
                pu.initProvisioning();
                try {
                    if (!pu.execute(args)) {
                        pu.usage();
                    }
                }
                catch (ArgException e) {
                    pu.usage();
                }
            }
            catch (ServiceException e) {
                Throwable cause = e.getCause();
                String errText = "ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")");
                ProvUtil.printError(errText);
                if (pu.mVerbose) {
                    e.printStackTrace(System.err);
                }
                System.exit(2);
            }
        }
    }

    static String formatLine(int width) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            sb.append("-");
        }
        return sb.toString();
    }

    private String formatAllEntryTypes() {
        StringBuilder sb = new StringBuilder();
        for (AttributeClass ac : AttributeClass.values()) {
            if (!ac.isProvisionable()) continue;
            sb.append(ac.name() + ",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String formatAllFields() {
        StringBuilder sb = new StringBuilder();
        for (DescribeArgs.Field field : DescribeArgs.Field.values()) {
            sb.append(String.format("    %-12.12s : %s", field.name(), field.getDesc()) + "\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void descAttrsUsage(Exception e) {
        System.out.println(e.getMessage() + "\n");
        System.out.printf("usage:  %s(%s) %s\n", this.mCommand.getName(), this.mCommand.getAlias(), this.mCommand.getHelp());
        System.out.println();
        System.out.println("Valid entry types: " + this.formatAllEntryTypes() + "\n");
        System.out.println("Examples:");
        System.out.println("zmprov desc");
        System.out.println("    print attribute name of all attributes\n");
        System.out.println("zmprov desc -v");
        System.out.println("    print attribute name and description of all attributes\n");
        System.out.println("zmprov desc account");
        System.out.println("    print attribute name of all account attributes\n");
        System.out.println("zmprov desc -ni -v account");
        System.out.println("    print attribute name and description of all non-inherited account attributes, ");
        System.out.println("    that is, attributes that are on account but not on cos\n");
        System.out.println("zmprov desc -ni domain");
        System.out.println("    print attribute name of all non-inherited domain attributes, ");
        System.out.println("    that is, attributes that are on domain but not on global config\n");
        System.out.println("zmprov desc -a zimbraId");
        System.out.println("    print attribute name, description, and all properties of attribute zimbraId\n");
        System.out.println("zmprov desc account -a zimbraId");
        System.out.println("    error: can only specify either an entry type or a specific attribute\n");
        this.usage();
    }

    private DescribeArgs parseDescribeArgs(String[] args) throws ServiceException {
        DescribeArgs descArgs = new DescribeArgs();
        for (int i = 1; i < args.length; ++i) {
            if ("-v".equals(args[i])) {
                if (descArgs.mAttr != null) {
                    throw ServiceException.INVALID_REQUEST("cannot specify -v when -a is specified", null);
                }
                descArgs.mVerbose = true;
                continue;
            }
            if (args[i].startsWith("-ni")) {
                if (descArgs.mAttr != null) {
                    throw ServiceException.INVALID_REQUEST("cannot specify -ni when -a is specified", null);
                }
                descArgs.mNonInheritedOnly = true;
                continue;
            }
            if (args[i].startsWith("-only")) {
                if (descArgs.mAttr != null) {
                    throw ServiceException.INVALID_REQUEST("cannot specify -only when -a is specified", null);
                }
                descArgs.mOnThisObjectTypeOnly = true;
                continue;
            }
            if (args[i].startsWith("-a")) {
                if (descArgs.mAttrClass != null) {
                    throw ServiceException.INVALID_REQUEST("cannot specify -a when entry type is specified", null);
                }
                if (descArgs.mAttr != null) {
                    throw ServiceException.INVALID_REQUEST("attribute is already specified as " + descArgs.mAttr, null);
                }
                if (args.length <= i + 1) {
                    throw ServiceException.INVALID_REQUEST("not enough number of args", null);
                }
                descArgs.mAttr = args[++i];
                continue;
            }
            if (descArgs.mAttr != null) {
                throw ServiceException.INVALID_REQUEST("too many args", null);
            }
            if (descArgs.mAttrClass != null) {
                throw ServiceException.INVALID_REQUEST("entry type is already specified as " + (Object)((Object)descArgs.mAttrClass), null);
            }
            AttributeClass ac = AttributeClass.fromString(args[i]);
            if (ac == null || !ac.isProvisionable()) {
                throw ServiceException.INVALID_REQUEST("invalid entry type " + ac.name(), null);
            }
            descArgs.mAttrClass = ac;
        }
        if ((descArgs.mNonInheritedOnly || descArgs.mOnThisObjectTypeOnly) && descArgs.mAttrClass == null) {
            throw ServiceException.INVALID_REQUEST("-ni -only must be specified with an entry type", null);
        }
        return descArgs;
    }

    private void doDescribe(String[] args) throws ServiceException {
        AttributeInfo ai;
        DescribeArgs descArgs = null;
        try {
            descArgs = this.parseDescribeArgs(args);
        }
        catch (ServiceException e) {
            this.descAttrsUsage(e);
            return;
        }
        catch (NumberFormatException e) {
            this.descAttrsUsage(e);
            return;
        }
        TreeSet<Object> attrs = null;
        String specificAttr = null;
        AttributeManager am = AttributeManager.getInstance();
        if (descArgs.mAttr != null) {
            specificAttr = descArgs.mAttr;
        } else if (descArgs.mAttrClass != null) {
            attrs = new TreeSet<String>(am.getAllAttrsInClass(descArgs.mAttrClass));
            if (descArgs.mNonInheritedOnly) {
                HashSet<String> inheritFrom = null;
                Set<Object> netAttrs = null;
                switch (descArgs.mAttrClass) {
                    case account: {
                        netAttrs = new HashSet<Object>(attrs);
                        inheritFrom = new HashSet<String>(am.getAllAttrsInClass(AttributeClass.cos));
                        netAttrs = SetUtil.subtract(netAttrs, inheritFrom);
                        inheritFrom = new HashSet<String>(am.getAllAttrsInClass(AttributeClass.domain));
                        netAttrs = SetUtil.subtract(netAttrs, inheritFrom);
                        break;
                    }
                    case domain: 
                    case server: {
                        netAttrs = new HashSet<Object>(attrs);
                        inheritFrom = new HashSet<String>(am.getAllAttrsInClass(AttributeClass.globalConfig));
                        netAttrs = SetUtil.subtract(netAttrs, inheritFrom);
                    }
                }
                if (netAttrs != null) {
                    attrs = new TreeSet<Object>(netAttrs);
                }
            }
            if (descArgs.mOnThisObjectTypeOnly) {
                TreeSet<String> netAttrs = new TreeSet<String>();
                for (String attr : attrs) {
                    ai = am.getAttributeInfo(attr);
                    if (ai == null) continue;
                    Set<AttributeClass> requiredIn = ai.getRequiredIn();
                    Set<AttributeClass> optionalIn = ai.getOptionalIn();
                    if (requiredIn != null && requiredIn.size() != 1 || optionalIn != null && optionalIn.size() != 1) continue;
                    netAttrs.add(attr);
                }
                attrs = netAttrs;
            }
        } else {
            attrs = new TreeSet();
            for (AttributeClass ac : AttributeClass.values()) {
                attrs.addAll(am.getAllAttrsInClass(ac));
            }
        }
        if (specificAttr != null) {
            AttributeInfo ai2 = am.getAttributeInfo(specificAttr);
            if (ai2 == null) {
                System.out.println("no attribute info for " + specificAttr);
            } else {
                System.out.println(ai2.getName());
                String desc = ai2.getDescription();
                System.out.println(FileGenUtil.wrapComments(desc == null ? "" : desc, 70, "    "));
                System.out.println();
                for (DescribeArgs.Field f : DescribeArgs.Field.values()) {
                    System.out.format("    %15s : %s\n", f.name(), DescribeArgs.Field.print(f, ai2));
                }
            }
            System.out.println();
        } else {
            String indent = "    ";
            for (String attr : attrs) {
                ai = am.getAttributeInfo(attr);
                if (ai == null) {
                    System.out.println(attr + " (no attribute info)");
                    continue;
                }
                String attrName = ai.getName();
                System.out.println(attrName);
                if (!descArgs.mVerbose) continue;
                String desc = ai.getDescription();
                System.out.println(FileGenUtil.wrapComments(desc == null ? "" : desc, 70, "    ") + "\n");
            }
        }
    }

    private void doFlushCache(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        Provisioning.CacheEntry[] entries = null;
        if (args.length > 2) {
            entries = new Provisioning.CacheEntry[args.length - 2];
            for (int i = 2; i < args.length; ++i) {
                Provisioning.CacheEntryBy entryBy = Provisioning.isUUID(args[i]) ? Provisioning.CacheEntryBy.id : Provisioning.CacheEntryBy.name;
                entries[i - 2] = new Provisioning.CacheEntry(entryBy, args[i]);
            }
        }
        SoapProvisioning sp = (SoapProvisioning)this.mProv;
        sp.flushCache(args[1], entries);
    }

    private void doGenerateDomainPreAuthKey(String[] args) throws ServiceException {
        String key = null;
        boolean force = false;
        if (args.length == 3) {
            if (!args[1].equals("-f")) {
                this.usage();
                return;
            }
            force = true;
            key = args[2];
        } else {
            key = args[1];
        }
        Domain domain = this.lookupDomain(key);
        String curPreAuthKey = domain.getAttr("zimbraPreAuthKey");
        if (curPreAuthKey != null && !force) {
            throw ServiceException.INVALID_REQUEST("pre auth key exists for domain " + key + ", use command -f option to force overwriting the existing key", null);
        }
        String preAuthKey = PreAuthKey.generateRandomPreAuthKey();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPreAuthKey", preAuthKey);
        this.mProv.modifyAttrs(domain, attrs);
        System.out.printf("preAuthKey: %s\n", preAuthKey);
        if (curPreAuthKey != null) {
            System.out.printf("previous preAuthKey: %s\n", curPreAuthKey);
        }
    }

    private void doGenerateDomainPreAuth(String[] args) throws ServiceException {
        String key = args[1];
        Domain domain = this.lookupDomain(key);
        String preAuthKey = domain.getAttr("zimbraPreAuthKey", null);
        if (preAuthKey == null) {
            throw ServiceException.INVALID_REQUEST("domain not configured for preauth", null);
        }
        String name = args[2];
        String by = args[3];
        long timestamp = Long.parseLong(args[4]);
        if (timestamp == 0L) {
            timestamp = System.currentTimeMillis();
        }
        long expires = Long.parseLong(args[5]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", name);
        params.put("by", by);
        params.put("timestamp", timestamp + "");
        params.put("expires", expires + "");
        if (args.length == 7) {
            params.put("admin", args[6]);
        }
        System.out.printf("account: %s\nby: %s\ntimestamp: %s\nexpires: %s\npreauth: %s\n", name, by, timestamp, expires, PreAuthKey.computePreAuth(params, preAuthKey));
    }

    private void doGetAllMtaAuthURLs(String[] args) throws ServiceException {
        List<Server> servers = this.mProv.getAllServers();
        for (Server server : servers) {
            boolean isTarget = server.getBooleanAttr("zimbraMtaAuthTarget", false);
            if (!isTarget) continue;
            System.out.print(URLUtil.getAdminURL(server) + " ");
        }
        System.out.println();
    }

    private void doGetAllReverseProxyURLs(String[] args) throws ServiceException {
        String REVERSE_PROXY_PROTO = "";
        int REVERSE_PROXY_PORT = 7072;
        String REVERSE_PROXY_PATH = "/service/extension/nginx-lookup";
        List<Server> servers = this.mProv.getAllServers();
        for (Server server : servers) {
            boolean isTarget = server.getBooleanAttr("zimbraReverseProxyLookupTarget", false);
            if (!isTarget) continue;
            String serviceName = server.getAttr("zimbraServiceHostname", "");
            System.out.print(REVERSE_PROXY_PROTO + serviceName + ":" + REVERSE_PROXY_PORT + REVERSE_PROXY_PATH + " ");
        }
        System.out.println();
    }

    private void doGetAllReverseProxyBackends(String[] args) throws ServiceException {
        List<Server> servers = this.mProv.getAllServers();
        boolean atLeastOne = false;
        for (Server server : servers) {
            boolean isPlain;
            String mode;
            boolean isTarget = server.getBooleanAttr("zimbraReverseProxyLookupTarget", false);
            if (!isTarget || (mode = server.getAttr("zimbraMailMode", null)) == null) continue;
            Provisioning.MailMode mailMode = Provisioning.MailMode.fromString(mode);
            boolean bl = isPlain = mailMode == Provisioning.MailMode.http || mailMode == Provisioning.MailMode.mixed || mailMode == Provisioning.MailMode.both;
            if (!isPlain) continue;
            int backendPort = server.getIntAttr("zimbraMailPort", 0);
            String serviceName = server.getAttr("zimbraServiceHostname", "");
            System.out.println("    server " + serviceName + ":" + backendPort + ";");
            atLeastOne = true;
        }
        if (!atLeastOne) {
            System.out.println("    server localhost:8080;");
        }
    }

    private void doGetAllMemcachedServers(String[] args) throws ServiceException {
        List<Server> servers = this.mProv.getAllServers("memcached");
        for (Server server : servers) {
            System.out.print(server.getAttr("zimbraServiceHostname", "") + ":" + server.getAttr("zimbraMemcachedBindPort", "") + " ");
        }
        System.out.println();
    }

    private List<Pair<String, Integer>> getMailboxServersFromArgs(String[] args) throws ServiceException {
        ArrayList<Pair<String, Integer>> entries = new ArrayList<Pair<String, Integer>>();
        if (args.length == 2 && "all".equalsIgnoreCase(args[1])) {
            List<Server> servers = this.mProv.getAllServers("mailbox");
            for (Server svr : servers) {
                String host = svr.getAttr("zimbraServiceHostname");
                int port = (int)svr.getLongAttr("zimbraAdminPort", this.mPort);
                Pair<String, Integer> entry = new Pair<String, Integer>(host, port);
                entries.add(entry);
            }
        } else {
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (this.mServer.equalsIgnoreCase(arg)) {
                    entries.add(new Pair<String, Integer>(this.mServer, this.mPort));
                    continue;
                }
                Server svr = this.mProv.getServerByServiceHostname(arg);
                if (svr == null) {
                    throw AccountServiceException.NO_SUCH_SERVER(arg);
                }
                int port = (int)svr.getLongAttr("zimbraAdminPort", this.mPort);
                entries.add(new Pair<String, Integer>(arg, port));
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReloadMemcachedClientConfig(String[] args) throws ServiceException {
        List<Pair<String, Integer>> servers = this.getMailboxServersFromArgs(args);
        for (Pair<String, Integer> server : servers) {
            Object var10_10;
            String hostname = server.getFirst();
            int port = server.getSecond();
            if (this.mVerbose) {
                System.out.print("Updating " + hostname + " ... ");
            }
            boolean success = false;
            try {
                try {
                    SoapProvisioning sp = new SoapProvisioning();
                    sp.soapSetURI(LC.zimbra_admin_service_scheme.value() + hostname + ":" + port + "/service/admin/soap/");
                    if (this.mDebug != SoapDebugLevel.none) {
                        sp.soapSetHttpTransportDebugListener(this);
                    }
                    if (this.mAccount != null && this.mPassword != null) {
                        sp.soapAdminAuthenticate(this.mAccount, this.mPassword);
                    } else if (this.mAuthToken != null) {
                        sp.soapAdminAuthenticate(this.mAuthToken);
                    } else {
                        sp.soapZimbraAdminAuthenticate();
                    }
                    sp.reloadMemcachedClientConfig();
                    success = true;
                }
                catch (ServiceException e) {
                    if (this.mVerbose) {
                        System.out.println("fail");
                        e.printStackTrace(System.out);
                    } else {
                        System.out.println("Error updating " + hostname + ": " + e.getMessage());
                    }
                    var10_10 = null;
                    if (!this.mVerbose || !success) continue;
                    System.out.println("ok");
                    continue;
                }
                var10_10 = null;
                if (!this.mVerbose || !success) continue;
                System.out.println("ok");
            }
            catch (Throwable throwable) {
                var10_10 = null;
                if (this.mVerbose && success) {
                    System.out.println("ok");
                }
                throw throwable;
            }
        }
    }

    private void doGetMemcachedClientConfig(String[] args) throws ServiceException {
        List<Pair<String, Integer>> servers = this.getMailboxServersFromArgs(args);
        int longestHostname = 0;
        for (Pair<String, Integer> server : servers) {
            String hostname = server.getFirst();
            longestHostname = Math.max(longestHostname, hostname.length());
        }
        String hostnameFormat = String.format("%%-%ds", longestHostname);
        boolean consistent = true;
        String prevConf = null;
        for (Pair<String, Integer> server : servers) {
            String hostname = server.getFirst();
            int port = server.getSecond();
            try {
                String serverList;
                SoapProvisioning sp = new SoapProvisioning();
                sp.soapSetURI(LC.zimbra_admin_service_scheme.value() + hostname + ":" + port + "/service/admin/soap/");
                if (this.mDebug != SoapDebugLevel.none) {
                    sp.soapSetHttpTransportDebugListener(this);
                }
                if (this.mAccount != null && this.mPassword != null) {
                    sp.soapAdminAuthenticate(this.mAccount, this.mPassword);
                } else if (this.mAuthToken != null) {
                    sp.soapAdminAuthenticate(this.mAuthToken);
                } else {
                    sp.soapZimbraAdminAuthenticate();
                }
                SoapProvisioning.MemcachedClientConfig config = sp.getMemcachedClientConfig();
                String string = serverList = config.serverList != null ? config.serverList : "none";
                if (this.mVerbose) {
                    System.out.printf(hostnameFormat + " => serverList=[%s], hashAlgo=%s, binaryProto=%s, expiry=%ds, timeout=%dms\n", hostname, serverList, config.hashAlgorithm, config.binaryProtocol, config.defaultExpirySeconds, config.defaultTimeoutMillis);
                } else if (config.serverList != null) {
                    if (HashAlgorithm.KETAMA_HASH.toString().equals(config.hashAlgorithm)) {
                        System.out.printf(hostnameFormat + " => %s\n", hostname, serverList);
                    } else {
                        System.out.printf(hostnameFormat + " => %s (%S)\n", hostname, serverList, config.hashAlgorithm);
                    }
                } else {
                    System.out.printf(hostnameFormat + " => none\n", hostname);
                }
                String listAndAlgo = serverList + "/" + config.hashAlgorithm;
                if (prevConf == null) {
                    prevConf = listAndAlgo;
                    continue;
                }
                if (prevConf.equals(listAndAlgo)) continue;
                consistent = false;
            }
            catch (ServiceException e) {
                System.out.printf(hostnameFormat + " => ERROR: unable to get configuration\n", hostname);
                if (!this.mVerbose) continue;
                e.printStackTrace(System.out);
            }
        }
        if (!consistent) {
            System.out.println("Inconsistency detected!");
        }
    }

    private void doGetServer(String[] args) throws ServiceException {
        String arg;
        int i;
        boolean applyDefault = true;
        for (i = 1; i < args.length && (arg = args[i]).equals("-e"); ++i) {
            applyDefault = false;
        }
        if (i >= args.length) {
            this.usage();
            return;
        }
        this.dumpServer(this.lookupServer(args[i], applyDefault), applyDefault, this.getArgNameSet(args, i + 1));
    }

    private void doPurgeAccountCalendarCache(String[] args) throws ServiceException {
        if (!(this.mProv instanceof SoapProvisioning)) {
            this.throwSoapOnly();
        }
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                Account acct = this.lookupAccount(args[i], true);
                this.mProv.purgeAccountCalendarCache(acct.getId());
            }
        }
    }

    private void doCreateXMPPComponent(String[] args) throws ServiceException, ArgException {
        Map<String, Object> map = this.getMap(args, 7);
        map.put("zimbraXMPPComponentClassName", args[4]);
        map.put("zimbraXMPPComponentCategory", args[5]);
        map.put("zimbraXMPPComponentType", args[6]);
        Domain d = this.lookupDomain(args[2]);
        String routableName = args[1] + "." + d.getName();
        System.out.println(this.mProv.createXMPPComponent(routableName, this.lookupDomain(args[2]), this.lookupServer(args[3]), map));
    }

    private void doGetXMPPComponent(String[] args) throws ServiceException {
        this.dumpXMPPComponent(this.lookupXMPPComponent(args[1]), this.getArgNameSet(args, 2));
    }

    private void getRightArgsTarget(RightArgs ra) throws ServiceException, ArgException {
        if (ra.mCurPos >= ra.mArgs.length) {
            throw new ArgException("not enough number of arguments");
        }
        ra.mTargetType = ra.mArgs[ra.mCurPos++];
        TargetType tt = TargetType.fromCode(ra.mTargetType);
        if (tt.needsTargetIdentity()) {
            if (ra.mCurPos >= ra.mArgs.length) {
                throw new ArgException("not enough number of arguments");
            }
            ra.mTargetIdOrName = ra.mArgs[ra.mCurPos++];
        } else {
            ra.mTargetIdOrName = null;
        }
    }

    private void getRightArgsGrantee(RightArgs ra, boolean needGranteeType) throws ServiceException, ArgException {
        if (ra.mCurPos >= ra.mArgs.length) {
            throw new ArgException("not enough number of arguments");
        }
        ra.mGranteeType = needGranteeType ? ra.mArgs[ra.mCurPos++] : null;
        if (ra.mCurPos >= ra.mArgs.length) {
            throw new ArgException("not enough number of arguments");
        }
        ra.mGranteeIdOrName = ra.mArgs[ra.mCurPos++];
    }

    private void getRightArgsRight(RightArgs ra) throws ServiceException, ArgException {
        if (ra.mCurPos >= ra.mArgs.length) {
            throw new ArgException("not enough number of arguments");
        }
        ra.mRight = ra.mArgs[ra.mCurPos++];
        ra.mRightModifier = RightModifier.fromChar(ra.mRight.charAt(0));
        if (ra.mRightModifier != null) {
            ra.mRight = ra.mRight.substring(1);
        }
    }

    private void getRightArgs(RightArgs ra, boolean needGranteeType) throws ServiceException, ArgException {
        this.getRightArgsTarget(ra);
        this.getRightArgsGrantee(ra, needGranteeType);
        this.getRightArgsRight(ra);
    }

    private void doCheckRight(String[] args) throws ServiceException, ArgException {
        RightArgs ra = new RightArgs(args);
        this.getRightArgs(ra, false);
        Map<String, Object> attrs = this.getMap(args, ra.mCurPos);
        Provisioning.TargetBy targetBy = ra.mTargetIdOrName == null ? null : ProvUtil.guessTargetBy(ra.mTargetIdOrName);
        Provisioning.GranteeBy granteeBy = ProvUtil.guessGranteeBy(ra.mGranteeIdOrName);
        AccessManager.ViaGrant via = new AccessManager.ViaGrant();
        boolean allow = this.mProv.checkRight(ra.mTargetType, targetBy, ra.mTargetIdOrName, granteeBy, ra.mGranteeIdOrName, ra.mRight, attrs, via);
        System.out.println(allow ? "ALLOWED" : "DENIED");
        if (via.available()) {
            System.out.println("Via:");
            System.out.println("    target type  : " + via.getTargetType());
            System.out.println("    target       : " + via.getTargetName());
            System.out.println("    grantee type : " + via.getGranteeType());
            System.out.println("    grantee      : " + via.getGranteeName());
            System.out.println("    right        : " + (via.isNegativeGrant() ? "DENY " : "") + via.getRight());
            System.out.println();
        }
    }

    private void doGetAllEffectiveRights(String[] args) throws ServiceException, ArgException {
        RightArgs ra = new RightArgs(args);
        if (this.mProv instanceof LdapProvisioning) {
            this.getRightArgsGrantee(ra, true);
        } else if (ra.mCurPos < args.length) {
            this.getRightArgsGrantee(ra, true);
        }
        boolean expandSetAttrs = false;
        boolean expandGetAttrs = false;
        for (int i = ra.mCurPos; i < args.length; ++i) {
            if ("expandSetAttrs".equals(args[i])) {
                expandSetAttrs = true;
                continue;
            }
            if ("expandGetAttrs".equals(args[i])) {
                expandGetAttrs = true;
                continue;
            }
            throw new ArgException("unrecognized arg: " + args[i]);
        }
        Provisioning.GranteeBy granteeBy = ra.mGranteeIdOrName == null ? null : ProvUtil.guessGranteeBy(ra.mGranteeIdOrName);
        RightCommand.AllEffectiveRights allEffRights = this.mProv.getAllEffectiveRights(ra.mGranteeType, granteeBy, ra.mGranteeIdOrName, expandSetAttrs, expandGetAttrs);
        System.out.println(allEffRights.granteeType() + " " + allEffRights.granteeName() + "(" + allEffRights.granteeId() + ")" + " has the following rights:");
        for (Map.Entry<TargetType, RightCommand.RightsByTargetType> rightsByTargetType : allEffRights.rightsByTargetType().entrySet()) {
            RightCommand.RightsByTargetType rbtt = rightsByTargetType.getValue();
            if (rbtt.hasNoRight()) continue;
            this.dumpRightsByTargetType(rightsByTargetType.getKey(), rbtt, expandSetAttrs, expandGetAttrs);
        }
    }

    private void dumpRightsByTargetType(TargetType targetType, RightCommand.RightsByTargetType rbtt, boolean expandSetAttrs, boolean expandGetAttrs) {
        System.out.println("------------------------------------------------------------------");
        System.out.println("Target type: " + targetType.getCode());
        System.out.println("------------------------------------------------------------------");
        RightCommand.EffectiveRights er = rbtt.all();
        if (er != null) {
            System.out.println("On all " + targetType.getPrettyName() + " entries");
            this.dumpEffectiveRight(er, expandSetAttrs, expandGetAttrs);
        }
        if (rbtt instanceof RightCommand.DomainedRightsByTargetType) {
            RightCommand.DomainedRightsByTargetType domainedRights = (RightCommand.DomainedRightsByTargetType)rbtt;
            for (RightCommand.RightAggregation rightsByDomains : domainedRights.domains()) {
                this.dumpRightAggregation(targetType, rightsByDomains, true, expandSetAttrs, expandGetAttrs);
            }
        }
        for (RightCommand.RightAggregation rightsByEntries : rbtt.entries()) {
            this.dumpRightAggregation(targetType, rightsByEntries, false, expandSetAttrs, expandGetAttrs);
        }
    }

    private void dumpRightAggregation(TargetType targetType, RightCommand.RightAggregation rightAggr, boolean domainScope, boolean expandSetAttrs, boolean expandGetAttrs) {
        Set<String> entries = rightAggr.entries();
        RightCommand.EffectiveRights er = rightAggr.effectiveRights();
        for (String entry : entries) {
            if (domainScope) {
                System.out.println("On " + targetType.getCode() + " entries in domain " + entry);
                continue;
            }
            System.out.println("On " + targetType.getCode() + " " + entry);
        }
        this.dumpEffectiveRight(er, expandSetAttrs, expandGetAttrs);
    }

    private void doGetEffectiveRights(String[] args) throws ServiceException, ArgException {
        RightArgs ra = new RightArgs(args);
        this.getRightArgsTarget(ra);
        if (this.mProv instanceof LdapProvisioning) {
            this.getRightArgsGrantee(ra, false);
        } else if (ra.mCurPos < args.length) {
            this.getRightArgsGrantee(ra, false);
        }
        boolean expandSetAttrs = false;
        boolean expandGetAttrs = false;
        for (int i = ra.mCurPos; i < args.length; ++i) {
            if ("expandSetAttrs".equals(args[i])) {
                expandSetAttrs = true;
                continue;
            }
            if ("expandGetAttrs".equals(args[i])) {
                expandGetAttrs = true;
                continue;
            }
            throw new ArgException("unrecognized arg: " + args[i]);
        }
        Provisioning.TargetBy targetBy = ra.mTargetIdOrName == null ? null : ProvUtil.guessTargetBy(ra.mTargetIdOrName);
        Provisioning.GranteeBy granteeBy = ra.mGranteeIdOrName == null ? null : ProvUtil.guessGranteeBy(ra.mGranteeIdOrName);
        RightCommand.EffectiveRights effRights = this.mProv.getEffectiveRights(ra.mTargetType, targetBy, ra.mTargetIdOrName, granteeBy, ra.mGranteeIdOrName, expandSetAttrs, expandGetAttrs);
        System.out.println("Account " + effRights.granteeName() + " has the following rights on target " + effRights.targetType() + " " + effRights.targetName());
        this.dumpEffectiveRight(effRights, expandSetAttrs, expandGetAttrs);
    }

    private void dumpEffectiveRight(RightCommand.EffectiveRights effRights, boolean expandSetAttrs, boolean expandGetAttrs) {
        List<String> presetRights = effRights.presetRights();
        if (presetRights != null && presetRights.size() > 0) {
            System.out.println("================");
            System.out.println("Preset rights");
            System.out.println("================");
            for (String r : presetRights) {
                System.out.println("    " + r);
            }
        }
        this.displayAttrs("set", expandSetAttrs, effRights.canSetAllAttrs(), effRights.canSetAttrs());
        this.displayAttrs("get", expandGetAttrs, effRights.canGetAllAttrs(), effRights.canGetAttrs());
        System.out.println();
        System.out.println();
    }

    private void displayAttrs(String op, boolean expandAll, boolean allAttrs, SortedMap<String, RightCommand.EffectiveAttr> attrs) {
        if (!allAttrs && attrs.size() == 0) {
            return;
        }
        String format = "    %-50s %-30s\n";
        System.out.println();
        System.out.println("=========================");
        System.out.println(op + " attributes rights");
        System.out.println("=========================");
        if (allAttrs) {
            System.out.println("Can " + op + " all attributes");
        }
        if (!allAttrs || expandAll) {
            System.out.println("Can " + op + " the following attributes");
            System.out.println("--------------------------------");
            System.out.printf(format, "attribute", "default");
            System.out.printf(format, "----------------------------------------", "--------------------");
            for (RightCommand.EffectiveAttr ea : attrs.values()) {
                boolean first = true;
                if (ea.getDefault().isEmpty()) {
                    System.out.printf(format, ea.getAttrName(), "");
                    continue;
                }
                for (String v : ea.getDefault()) {
                    if (first) {
                        System.out.printf(format, ea.getAttrName(), v);
                        first = false;
                        continue;
                    }
                    System.out.printf(format, "", v);
                }
            }
        }
    }

    private void doGetCreateObjectAttrs(String[] args) throws ServiceException, ArgException {
        String targetType = args[1];
        Provisioning.DomainBy domainBy = null;
        String domain = null;
        if (!args[2].equals("null")) {
            domainBy = ProvUtil.guessDomainBy(args[2]);
            domain = args[2];
        }
        Provisioning.CosBy cosBy = null;
        String cos = null;
        if (!args[3].equals("null")) {
            cosBy = ProvUtil.guessCosBy(args[3]);
            cos = args[3];
        }
        Provisioning.GranteeBy granteeBy = null;
        String grantee = null;
        if (this.mProv instanceof LdapProvisioning) {
            granteeBy = ProvUtil.guessGranteeBy(args[4]);
            grantee = args[4];
        }
        RightCommand.EffectiveRights effRights = this.mProv.getCreateObjectAttrs(targetType, domainBy, domain, cosBy, cos, granteeBy, grantee);
        this.displayAttrs("set", true, effRights.canSetAllAttrs(), effRights.canSetAttrs());
    }

    private void doGetGrants(String[] args) throws ServiceException, ArgException {
        RightArgs ra = new RightArgs(args);
        boolean granteeIncludeGroupsGranteeBelongs = true;
        while (ra.hasNext()) {
            String arg = ra.getNextArg();
            if ("-t".equals(arg)) {
                this.getRightArgsTarget(ra);
                continue;
            }
            if (!"-g".equals(arg)) continue;
            this.getRightArgsGrantee(ra, true);
            if (!ra.hasNext()) continue;
            String includeGroups = ra.getNextArg();
            if ("1".equals(includeGroups)) {
                granteeIncludeGroupsGranteeBelongs = true;
                continue;
            }
            if ("0".equals(includeGroups)) {
                granteeIncludeGroupsGranteeBelongs = false;
                continue;
            }
            throw ServiceException.INVALID_REQUEST("invalid value for the include group flag, must be 0 or 1", null);
        }
        Provisioning.TargetBy targetBy = ra.mTargetIdOrName == null ? null : ProvUtil.guessTargetBy(ra.mTargetIdOrName);
        Provisioning.GranteeBy granteeBy = ra.mGranteeIdOrName == null ? null : ProvUtil.guessGranteeBy(ra.mGranteeIdOrName);
        RightCommand.Grants grants = this.mProv.getGrants(ra.mTargetType, targetBy, ra.mTargetIdOrName, ra.mGranteeType, granteeBy, ra.mGranteeIdOrName, granteeIncludeGroupsGranteeBelongs);
        String format = "%-12.12s %-36.36s %-30.30s %-12.12s %-36.36s %-30.30s %s\n";
        System.out.printf(format, "target type", "target id", "target name", "grantee type", "grantee id", "grantee name", "right");
        System.out.printf(format, "------------", "------------------------------------", "------------------------------", "------------", "------------------------------------", "------------------------------", "--------------------");
        for (RightCommand.ACE ace : grants.getACEs()) {
            RightModifier rightModifier = ace.rightModifier();
            String rm = rightModifier == null ? "" : String.valueOf(rightModifier.getModifier());
            System.out.printf(format, ace.targetType(), ace.targetId(), ace.targetName(), ace.granteeType(), ace.granteeId(), ace.granteeName(), rm + ace.right());
        }
        System.out.println();
    }

    private void doGrantRight(String[] args) throws ServiceException, ArgException {
        RightArgs ra = new RightArgs(args);
        this.getRightArgs(ra, true);
        Provisioning.TargetBy targetBy = ra.mTargetIdOrName == null ? null : ProvUtil.guessTargetBy(ra.mTargetIdOrName);
        Provisioning.GranteeBy granteeBy = ProvUtil.guessGranteeBy(ra.mGranteeIdOrName);
        this.mProv.grantRight(ra.mTargetType, targetBy, ra.mTargetIdOrName, ra.mGranteeType, granteeBy, ra.mGranteeIdOrName, ra.mRight, ra.mRightModifier);
    }

    private void doRevokeRight(String[] args) throws ServiceException, ArgException {
        RightArgs ra = new RightArgs(args);
        this.getRightArgs(ra, true);
        Provisioning.TargetBy targetBy = ra.mTargetIdOrName == null ? null : ProvUtil.guessTargetBy(ra.mTargetIdOrName);
        Provisioning.GranteeBy granteeBy = ProvUtil.guessGranteeBy(ra.mGranteeIdOrName);
        this.mProv.revokeRight(ra.mTargetType, targetBy, ra.mTargetIdOrName, ra.mGranteeType, granteeBy, ra.mGranteeIdOrName, ra.mRight, ra.mRightModifier);
    }

    private void doGetAuthTokenInfo(String[] args) throws ServiceException {
        String authToken = args[1];
        try {
            Map attrs = AuthToken.getInfo(authToken);
            ArrayList keys = new ArrayList(attrs.keySet());
            Collections.sort(keys);
            for (Object k : keys) {
                String key = k.toString();
                String value = attrs.get(k).toString();
                if ("exp".equals(key)) {
                    long exp = Long.parseLong(value);
                    System.out.format("%s: %s (%s)\n", key, value, DateUtil.toRFC822Date(new Date(exp)));
                    continue;
                }
                System.out.format("%s: %s\n", key, value);
            }
        }
        catch (AuthTokenException e) {
            System.out.println("Unable to parse auth token: " + e.getMessage());
        }
        System.out.println();
    }

    private void doHelp(String[] args) {
        Category cat = null;
        if (args != null && args.length >= 2) {
            String s = args[1].toUpperCase();
            try {
                cat = Category.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                for (Category c : Category.values()) {
                    if (!c.name().startsWith(s)) continue;
                    cat = c;
                    break;
                }
            }
        }
        if (args == null || args.length == 1 || cat == null) {
            System.out.println(" zmprov is used for provisioning. Try:");
            System.out.println("");
            for (Enum enum_ : Category.values()) {
                System.out.printf("     zmprov help %-15s %s\n", enum_.name().toLowerCase(), ((Category)enum_).getDescription());
            }
        }
        if (cat != null) {
            System.out.println("");
            for (Enum enum_ : Command.values()) {
                if (!((Command)enum_).hasHelp() || cat != Category.COMMANDS && cat != ((Command)enum_).getCategory()) continue;
                Command.Via via = ((Command)enum_).getVia();
                System.out.printf("  %s(%s) %s\n", ((Command)enum_).getName(), ((Command)enum_).getAlias(), ((Command)enum_).getHelp());
                if (via == Command.Via.ldap) {
                    System.out.printf("    -- NOTE: %s can only be used with \"zmprov -l/--ldap\"\n", ((Command)enum_).getName());
                }
                System.out.printf("\n", new Object[0]);
            }
            Category.help(cat);
        }
        System.out.println();
    }

    @Override
    public void receiveSoapMessage(PostMethod postMethod, Element envelope) {
        System.out.printf("======== SOAP RECEIVE =========\n", new Object[0]);
        if (this.mDebug == SoapDebugLevel.high) {
            Header[] headers;
            for (Header header : headers = postMethod.getResponseHeaders()) {
                System.out.println(header.toString().trim());
            }
            System.out.println();
        }
        long end = System.currentTimeMillis();
        System.out.println(envelope.prettyPrint());
        System.out.printf("=============================== (%d msecs)\n", end - this.mSendStart);
    }

    @Override
    public void sendSoapMessage(PostMethod postMethod, Element envelope) {
        System.out.println("========== SOAP SEND ==========");
        if (this.mDebug == SoapDebugLevel.high) {
            Header[] headers;
            for (Header header : headers = postMethod.getRequestHeaders()) {
                System.out.println(header.toString().trim());
            }
            System.out.println();
        }
        this.mSendStart = System.currentTimeMillis();
        System.out.println(envelope.prettyPrint());
        System.out.println("===============================");
    }

    void throwSoapOnly() throws ServiceException {
        throw ServiceException.INVALID_REQUEST(ERR_VIA_SOAP_ONLY, null);
    }

    void throwLdapOnly() throws ServiceException {
        throw ServiceException.INVALID_REQUEST(ERR_VIA_LDAP_ONLY, null);
    }

    private void loadLdapSchemaExtensionAttrs() {
        if (this.mProv instanceof LdapProvisioning) {
            AttributeManager.loadLdapSchemaExtensionAttrs((LdapProvisioning)this.mProv);
        }
    }

    private static class RightArgs {
        String mTargetType;
        String mTargetIdOrName;
        String mGranteeType;
        String mGranteeIdOrName;
        String mRight;
        RightModifier mRightModifier;
        String[] mArgs;
        int mCurPos = 1;

        RightArgs(String[] args) {
            this.mArgs = args;
            this.mCurPos = 1;
        }

        String getNextArg() throws ServiceException {
            if (this.hasNext()) {
                return this.mArgs[this.mCurPos++];
            }
            throw ServiceException.INVALID_REQUEST("not enough number of arguments", null);
        }

        boolean hasNext() {
            return this.mCurPos < this.mArgs.length;
        }
    }

    private static class DescribeArgs {
        boolean mNonInheritedOnly;
        boolean mOnThisObjectTypeOnly;
        AttributeClass mAttrClass;
        boolean mVerbose;
        String mAttr;

        private DescribeArgs() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Field {
            type("attribute type"),
            value("value for enum or regex attributes"),
            callback("class name of AttributeCallback object to invoke on changes to attribute."),
            immutable("whether this attribute can be modified directly"),
            cardinality("single or multi"),
            requiredIn("comma-seperated list containing classes in which this attribute is required"),
            optionalIn("comma-seperated list containing classes in which this attribute can appear"),
            flags("attribute flags"),
            defaults("default value on global config or default COS(for new install) and all upgraded COS's"),
            min("min value for integers and durations. defaults to Integer.MIN_VALUE"),
            max("max value for integers and durations, max length for strings/email, defaults to Integer.MAX_VALUE"),
            id("leaf OID of the attribute"),
            requiresRestart("server(s) need be to restarted after changing this attribute"),
            since("version since which the attribute had been introduced"),
            deprecatedSince("version since which the attribute had been deprecaed");

            String mDesc;

            private Field(String desc) {
                this.mDesc = desc;
            }

            String getDesc() {
                return this.mDesc;
            }

            static Field fromString(String s) throws ServiceException {
                try {
                    return Field.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    throw ServiceException.INVALID_REQUEST("unknown field: " + s, e);
                }
            }

            static String formatDefaults(AttributeInfo ai) {
                StringBuilder sb = new StringBuilder();
                for (String d : ai.getDefaultCosValues()) {
                    sb.append(d + ",");
                }
                for (String d : ai.getGlobalConfigValues()) {
                    sb.append(d + ",");
                }
                return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
            }

            static String formatRequiredIn(AttributeInfo ai) {
                Set<AttributeClass> requiredIn = ai.getRequiredIn();
                if (requiredIn == null) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                for (AttributeClass ac : requiredIn) {
                    sb.append(ac.name() + ",");
                }
                return sb.substring(0, sb.length() - 1);
            }

            static String formatOptionalIn(AttributeInfo ai) {
                Set<AttributeClass> optionalIn = ai.getOptionalIn();
                if (optionalIn == null) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                for (AttributeClass ac : optionalIn) {
                    sb.append(ac.name() + ",");
                }
                return sb.substring(0, sb.length() - 1);
            }

            static String formatFlags(AttributeInfo ai) {
                StringBuilder sb = new StringBuilder();
                for (AttributeFlag f : AttributeFlag.values()) {
                    if (!ai.hasFlag(f)) continue;
                    sb.append(f.name() + ",");
                }
                return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
            }

            static String formatRequiresRestart(AttributeInfo ai) {
                StringBuilder sb = new StringBuilder();
                List<AttributeServerType> requiresRetstart = ai.getRequiresRestart();
                if (requiresRetstart != null) {
                    for (AttributeServerType ast : requiresRetstart) {
                        sb.append(ast.name() + ",");
                    }
                }
                return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
            }

            static String print(Field field, AttributeInfo ai) {
                String out = null;
                switch (field) {
                    case type: {
                        out = ai.getType().getName();
                        break;
                    }
                    case value: {
                        out = ai.getValue();
                        break;
                    }
                    case callback: {
                        AttributeCallback acb = ai.getCallback();
                        if (acb == null) break;
                        out = acb.getClass().getSimpleName();
                        break;
                    }
                    case immutable: {
                        out = Boolean.toString(ai.isImmutable());
                        break;
                    }
                    case cardinality: {
                        AttributeCardinality card = ai.getCardinality();
                        if (card == null) break;
                        out = card.name();
                        break;
                    }
                    case requiredIn: {
                        out = Field.formatRequiredIn(ai);
                        break;
                    }
                    case optionalIn: {
                        out = Field.formatOptionalIn(ai);
                        break;
                    }
                    case flags: {
                        out = Field.formatFlags(ai);
                        break;
                    }
                    case defaults: {
                        out = Field.formatDefaults(ai);
                        break;
                    }
                    case min: {
                        long min = ai.getMin();
                        if (min == Long.MIN_VALUE || min == Integer.MIN_VALUE) break;
                        out = Long.toString(min);
                        break;
                    }
                    case max: {
                        long max = ai.getMax();
                        if (max == Long.MAX_VALUE || max == Integer.MAX_VALUE) break;
                        out = Long.toString(max);
                        break;
                    }
                    case id: {
                        int id = ai.getId();
                        if (id == -1) break;
                        out = Integer.toString(ai.getId());
                        break;
                    }
                    case requiresRestart: {
                        out = Field.formatRequiresRestart(ai);
                        break;
                    }
                    case since: {
                        BuildInfo.Version since = ai.getSince();
                        if (since == null) break;
                        out = since.toString();
                        break;
                    }
                    case deprecatedSince: {
                        BuildInfo.Version depreSince = ai.getDeprecatedSince();
                        if (depreSince == null) break;
                        out = depreSince.toString();
                    }
                }
                if (out == null) {
                    out = "";
                }
                return out;
            }
        }
    }

    class ArgException
    extends Exception {
        ArgException(String msg) {
            super(msg);
        }
    }

    private static class ShareInfoVisitor
    implements Provisioning.PublishedShareInfoVisitor {
        private static final String mFormat = "%-36.36s %-15.15s %-15.15s %-5.5s %-20.20s %-10.10s %-10.10s %-5.5s %-5.5s %-36.36s %-15.15s %-15.15s\n";

        private ShareInfoVisitor() {
        }

        private static void printHeadings() {
            System.out.printf(mFormat, "owner id", "owner email", "owner display", "fid", "folder path", "view", "rights", "mid", "gt", "grantee id", "grantee name", "grantee display");
            System.out.printf(mFormat, "------------------------------------", "---------------", "---------------", "-----", "--------------------", "----------", "----------", "-----", "-----", "------------------------------------", "---------------", "---------------");
        }

        public void visit(ShareInfoData shareInfoData) throws ServiceException {
            System.out.printf(mFormat, shareInfoData.getOwnerAcctId(), shareInfoData.getOwnerAcctEmail(), shareInfoData.getOwnerAcctDisplayName(), String.valueOf(shareInfoData.getFolderId()), shareInfoData.getFolderPath(), shareInfoData.getFolderDefaultView(), shareInfoData.getRights(), shareInfoData.getMountpointId_zmprov_only(), shareInfoData.getGranteeType(), shareInfoData.getGranteeId(), shareInfoData.getGranteeName(), shareInfoData.getGranteeDisplayName());
        }
    }

    private static class ShareInfoArgs {
        Provisioning.PublishShareInfoAction mAction;
        Account mOwnerAcct;
        String mFolderPathOrId;

        ShareInfoArgs(Provisioning.PublishShareInfoAction action, Account ownerAcct, String folderPathOrId) {
            this.mAction = action;
            this.mOwnerAcct = ownerAcct;
            this.mFolderPathOrId = folderPathOrId;
        }
    }

    private class AccountLoggerOptions {
        String server;
        String[] args;

        private AccountLoggerOptions() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        ADD_ACCOUNT_ALIAS("addAccountAlias", "aaa", "{name@domain|id} {alias@domain}", Category.ACCOUNT, 2, 2),
        ADD_ACCOUNT_LOGGER("addAccountLogger", "aal", "[-s/--server hostname] {name@domain|id} {logging-category} {debug|info|warn|error}", Category.LOG, 3, 5),
        ADD_DISTRIBUTION_LIST_ALIAS("addDistributionListAlias", "adla", "{list@domain|id} {alias@domain}", Category.LIST, 2, 2),
        ADD_DISTRIBUTION_LIST_MEMBER("addDistributionListMember", "adlm", "{list@domain|id} {member@domain}+", Category.LIST, 2, Integer.MAX_VALUE),
        AUTO_COMPLETE_GAL("autoCompleteGal", "acg", "{domain} {name}", Category.SEARCH, 2, 2),
        CHECK_PASSWORD_STRENGTH("checkPasswordStrength", "cps", "{name@domain|id} {password}", Category.ACCOUNT, 2, 2),
        CHECK_RIGHT("checkRight", "ckr", "{target-type} [{target-id|target-name}] {grantee-id|grantee-name} {right}", Category.RIGHT, 3, 4, null, new RightCommandHelp()),
        COPY_COS("copyCos", "cpc", "{src-cos-name|id} {dest-cos-name}", Category.COS, 2, 2),
        COUNT_ACCOUNT("countAccount", "cta", "{domain|id}", Category.DOMAIN, 1, 1),
        CREATE_ACCOUNT("createAccount", "ca", "{name@domain} {password} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 2, Integer.MAX_VALUE),
        CREATE_ALIAS_DOMAIN("createAliasDomain", "cad", "{alias-domain-name} {local-domain-name|id} [attr1 value1 [attr2 value2...]]", Category.DOMAIN, 2, Integer.MAX_VALUE),
        CREATE_BULK_ACCOUNTS("createBulkAccounts", "cabulk"),
        CREATE_CALENDAR_RESOURCE("createCalendarResource", "ccr", "{name@domain} {password} [attr1 value1 [attr2 value2...]]", Category.CALENDAR, 2, Integer.MAX_VALUE),
        CREATE_COS("createCos", "cc", "{name} [attr1 value1 [attr2 value2...]]", Category.COS, 1, Integer.MAX_VALUE),
        CREATE_DATA_SOURCE("createDataSource", "cds", "{name@domain} {ds-type} {ds-name} zimbraDataSourceEnabled {TRUE|FALSE} zimbraDataSourceFolderId {folder-id} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 3, Integer.MAX_VALUE),
        CREATE_DISTRIBUTION_LIST("createDistributionList", "cdl", "{list@domain}", Category.LIST, 1, Integer.MAX_VALUE),
        CREATE_DISTRIBUTION_LISTS_BULK("createDistributionListsBulk", "cdlbulk"),
        CREATE_DOMAIN("createDomain", "cd", "{domain} [attr1 value1 [attr2 value2...]]", Category.DOMAIN, 1, Integer.MAX_VALUE),
        CREATE_SERVER("createServer", "cs", "{name} [attr1 value1 [attr2 value2...]]", Category.SERVER, 1, Integer.MAX_VALUE),
        CREATE_IDENTITY("createIdentity", "cid", "{name@domain} {identity-name} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 2, Integer.MAX_VALUE),
        CREATE_SIGNATURE("createSignature", "csig", "{name@domain} {signature-name} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 2, Integer.MAX_VALUE),
        CREATE_XMPP_COMPONENT("createXMPPComponent", "cxc", "{short-name} {domain}  {server} {classname} {category} {type} [attr value1 [attr2 value2...]]", Category.CONFIG, 6, Integer.MAX_VALUE),
        DELETE_ACCOUNT("deleteAccount", "da", "{name@domain|id}", Category.ACCOUNT, 1, 1),
        DELETE_CALENDAR_RESOURCE("deleteCalendarResource", "dcr", "{name@domain|id}", Category.CALENDAR, 1, 1),
        DELETE_COS("deleteCos", "dc", "{name|id}", Category.COS, 1, 1),
        DELETE_DATA_SOURCE("deleteDataSource", "dds", "{name@domain|id} {ds-name|ds-id}", Category.ACCOUNT, 2, 2),
        DELETE_DISTRIBUTION_LIST("deleteDistributionList", "ddl", "{list@domain|id}", Category.LIST, 1, 1),
        DELETE_DOMAIN("deleteDomain", "dd", "{domain|id}", Category.DOMAIN, 1, 1),
        DELETE_IDENTITY("deleteIdentity", "did", "{name@domain|id} {identity-name}", Category.ACCOUNT, 2, 2),
        DELETE_SIGNATURE("deleteSignature", "dsig", "{name@domain|id} {signature-name}", Category.ACCOUNT, 2, 2),
        DELETE_SERVER("deleteServer", "ds", "{name|id}", Category.SERVER, 1, 1),
        DELETE_XMPP_COMPONENT("deleteXMPPComponent", "dxc", "{xmpp-component-name}", Category.CONFIG, 1, 1),
        DESCRIBE("describe", "desc", "[[-v] [-ni] [{entry-type}]] | [-a {attribute-name}]", Category.MISC, 0, Integer.MAX_VALUE, null, null, true),
        EXIT("exit", "quit", "", Category.MISC, 0, 0),
        FLUSH_CACHE("flushCache", "fc", "{skin|locale|license|account|config|cos|domain|group|server|zimlet|<extension-cache-type>} [name1|id1 [name2|id2...]]", Category.MISC, 1, Integer.MAX_VALUE),
        GENERATE_DOMAIN_PRE_AUTH("generateDomainPreAuth", "gdpa", "{domain|id} {name|id|foreignPrincipal} {by} {timestamp|0} {expires|0}", Category.MISC, 5, 6),
        GENERATE_DOMAIN_PRE_AUTH_KEY("generateDomainPreAuthKey", "gdpak", "[-f] {domain|id}", Category.MISC, 1, 2),
        GET_ACCOUNT("getAccount", "ga", "[-e] {name@domain|id} [attr1 [attr2...]]", Category.ACCOUNT, 1, Integer.MAX_VALUE),
        GET_DATA_SOURCES("getDataSources", "gds", "{name@domain|id} [arg1 [arg2...]]", Category.ACCOUNT, 1, Integer.MAX_VALUE),
        GET_IDENTITIES("getIdentities", "gid", "{name@domain|id} [arg1 [arg...]]", Category.ACCOUNT, 1, Integer.MAX_VALUE),
        GET_SIGNATURES("getSignatures", "gsig", "{name@domain|id} [arg1 [arg...]]", Category.ACCOUNT, 1, Integer.MAX_VALUE),
        GET_ACCOUNT_MEMBERSHIP("getAccountMembership", "gam", "{name@domain|id}", Category.ACCOUNT, 1, 2),
        GET_ALL_ACCOUNTS("getAllAccounts", "gaa", "[-v] [-e] [-s server] [{domain}]", Category.ACCOUNT, 0, 5),
        GET_ACCOUNT_LOGGERS("getAccountLoggers", "gal", "[-s/--server hostname] {name@domain|id}", Category.LOG, 1, 3),
        GET_ALL_ACCOUNT_LOGGERS("getAllAccountLoggers", "gaal", "[-s/--server hostname]", Category.LOG, 0, 2),
        GET_ALL_ADMIN_ACCOUNTS("getAllAdminAccounts", "gaaa", "[-v] [-e] [attr1 [attr2...]]", Category.ACCOUNT, 0, Integer.MAX_VALUE),
        GET_ALL_CALENDAR_RESOURCES("getAllCalendarResources", "gacr", "[-v] [-e] [-s server] [{domain}]", Category.CALENDAR, 0, 5),
        GET_ALL_CONFIG("getAllConfig", "gacf", "[attr1 [attr2...]]", Category.CONFIG, 0, Integer.MAX_VALUE),
        GET_ALL_COS("getAllCos", "gac", "[-v]", Category.COS, 0, 1),
        GET_ALL_DISTRIBUTION_LISTS("getAllDistributionLists", "gadl", "[{domain}]", Category.LIST, 0, 1),
        GET_ALL_DOMAINS("getAllDomains", "gad", "[-v] [-e] [attr1 [attr2...]]", Category.DOMAIN, 0, Integer.MAX_VALUE),
        GET_ALL_EFFECTIVE_RIGHTS("getAllEffectiveRights", "gaer", "{grantee-type} {grantee-id|grantee-name} [expandSetAttrs] [expandGetAttrs]", Category.RIGHT, 2, 4),
        GET_ALL_FREEBUSY_PROVIDERS("getAllFbp", "gafbp", "[-v]", Category.FREEBUSY, 0, 1),
        GET_ALL_RIGHTS("getAllRights", "gar", "[-v] [{target-type}]", Category.RIGHT, 0, 2),
        GET_ALL_SERVERS("getAllServers", "gas", "[-v] [-e] [service]", Category.SERVER, 0, 3),
        GET_ALL_XMPP_COMPONENTS("getAllXMPPComponents", "gaxcs", "", Category.CONFIG, 0, 0),
        GET_AUTH_TOKEN_INFO("getAuthTokenInfo", "gati", "{auth-token}", Category.MISC, 1, 1),
        GET_CALENDAR_RESOURCE("getCalendarResource", "gcr", "{name@domain|id} [attr1 [attr2...]]", Category.CALENDAR, 1, Integer.MAX_VALUE),
        GET_CONFIG("getConfig", "gcf", "{name}", Category.CONFIG, 1, 1),
        GET_COS("getCos", "gc", "{name|id} [attr1 [attr2...]]", Category.COS, 1, Integer.MAX_VALUE),
        GET_DISTRIBUTION_LIST("getDistributionList", "gdl", "{list@domain|id} [attr1 [attr2...]]", Category.LIST, 1, Integer.MAX_VALUE),
        GET_DISTRIBUTION_LIST_MEMBERSHIP("getDistributionListMembership", "gdlm", "{name@domain|id}", Category.LIST, 1, 1),
        GET_DOMAIN("getDomain", "gd", "[-e] {domain|id} [attr1 [attr2...]]", Category.DOMAIN, 1, Integer.MAX_VALUE),
        GET_DOMAIN_INFO("getDomainInfo", "gdi", "name|id|virtualHostname {value} [attr1 [attr2...]]", Category.DOMAIN, 2, Integer.MAX_VALUE),
        GET_EFFECTIVE_RIGHTS("getEffectiveRights", "ger", "{target-type} [{target-id|target-name}] {grantee-id|grantee-name} [expandSetAttrs] [expandGetAttrs]", Category.RIGHT, 1, 5, null, new RightCommandHelp()),
        GET_CREATE_OBJECT_ATTRS("getCreateObjectAttrs", "gcoa", "{target-type} {domain-id|domain-name} {cos-id|cos-name} {grantee-id|grantee-name}", Category.RIGHT, 3, 4),
        GET_FREEBUSY_QUEUE_INFO("getFreebusyQueueInfo", "gfbqi", "[{provider-name}]", Category.FREEBUSY, 0, 1),
        GET_GRANTS("getGrants", "gg", "[-t {target-type} [{target-id|target-name}]] [-g {grantee-type} {grantee-id|grantee-name} [{0|1 (whether to include grants granted to groups the grantee belongs)}]]", Category.RIGHT, 2, 7, null, new RightCommandHelp()),
        GET_MAILBOX_INFO("getMailboxInfo", "gmi", "{account}", Category.MAILBOX, 1, 1),
        GET_PUBLISHED_DISTRIBUTION_LIST_SHARE_INFO("getPublishedDistributionListShareInfo", "gpdlsi", "{dl-name|dl-id} [{owner-name|owner-id}]", Category.SHARE, 1, 2),
        GET_QUOTA_USAGE("getQuotaUsage", "gqu", "{server}", Category.MAILBOX, 1, 1),
        GET_RIGHT("getRight", "gr", "[-e] {name|id} [attr1 [attr2...]]", Category.RIGHT, 1, Integer.MAX_VALUE),
        GET_RIGHTS_DOC("getRightsDoc", "grd", "[java packages]", Category.RIGHT, 0, Integer.MAX_VALUE),
        GET_SERVER("getServer", "gs", "[-e] {name|id} [attr1 [attr2...]]", Category.SERVER, 1, Integer.MAX_VALUE),
        GET_SHARE_INFO("getShareInfo", "gsi", "{owner-name|owner-id}", Category.SHARE, 1, 1),
        GET_XMPP_COMPONENT("getXMPPComponent", "gxc", "{name|id} [attr1 [attr2...]]", Category.CONFIG, 1, Integer.MAX_VALUE),
        GRANT_RIGHT("grantRight", "grr", "{target-type} [{target-id|target-name}] {grantee-type} {grantee-id|grantee-name} {[-]right}", Category.RIGHT, 4, 5, null, new RightCommandHelp()),
        HELP("help", "?", "commands", Category.MISC, 0, 1),
        IMPORT_NOTEBOOK("importNotebook", "impn", "{name@domain} {directory} {folder}", Category.NOTEBOOK),
        INIT_NOTEBOOK("initNotebook", "in", "[{name@domain}]", Category.NOTEBOOK),
        INIT_DOMAIN_NOTEBOOK("initDomainNotebook", "idn", "{domain} [{name@domain}]", Category.NOTEBOOK),
        LDAP(".ldap", ".l"),
        MODIFY_ACCOUNT("modifyAccount", "ma", "{name@domain|id} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 3, Integer.MAX_VALUE),
        MODIFY_CALENDAR_RESOURCE("modifyCalendarResource", "mcr", "{name@domain|id} [attr1 value1 [attr2 value2...]]", Category.CALENDAR, 3, Integer.MAX_VALUE),
        MODIFY_CONFIG("modifyConfig", "mcf", "attr1 value1 [attr2 value2...]", Category.CONFIG, 2, Integer.MAX_VALUE),
        MODIFY_COS("modifyCos", "mc", "{name|id} [attr1 value1 [attr2 value2...]]", Category.COS, 3, Integer.MAX_VALUE),
        MODIFY_DATA_SOURCE("modifyDataSource", "mds", "{name@domain|id} {ds-name|ds-id} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 4, Integer.MAX_VALUE),
        MODIFY_DISTRIBUTION_LIST("modifyDistributionList", "mdl", "{list@domain|id} attr1 value1 [attr2 value2...]", Category.LIST, 3, Integer.MAX_VALUE),
        MODIFY_DOMAIN("modifyDomain", "md", "{domain|id} [attr1 value1 [attr2 value2...]]", Category.DOMAIN, 3, Integer.MAX_VALUE),
        MODIFY_IDENTITY("modifyIdentity", "mid", "{name@domain|id} {identity-name} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 4, Integer.MAX_VALUE),
        MODIFY_SIGNATURE("modifySignature", "msig", "{name@domain|id} {signature-name|signature-id} [attr1 value1 [attr2 value2...]]", Category.ACCOUNT, 4, Integer.MAX_VALUE),
        MODIFY_SERVER("modifyServer", "ms", "{name|id} [attr1 value1 [attr2 value2...]]", Category.SERVER, 3, Integer.MAX_VALUE),
        MODIFY_XMPP_COMPONENT("modifyXMPPComponent", "mxc", "{name@domain} [attr1 value1 [attr value2...]]", Category.CONFIG, 3, Integer.MAX_VALUE),
        PUBLISH_DISTRIBUTION_LIST_SHARE_INFO("publishDistribtionListShareInfo", "pdlsi", "{+|-} {dl-name@domain|id} {owner-name|owner-id} [{folder-path|folder-id}]", Category.SHARE, 3, 4),
        PUSH_FREEBUSY("pushFreebusy", "pfb", "[account-id ...]", Category.FREEBUSY, 1, Integer.MAX_VALUE),
        PUSH_FREEBUSY_DOMAIN("pushFreebusyDomain", "pfbd", "{domain}", Category.FREEBUSY, 1, 1),
        PURGE_ACCOUNT_CALENDAR_CACHE("purgeAccountCalendarCache", "pacc", "{name@domain|id} [...]", Category.CALENDAR, 1, Integer.MAX_VALUE),
        RECALCULATE_MAILBOX_COUNTS("recalculateMailboxCounts", "rmc", "{name@domain|id}", Category.MAILBOX, 1, 1),
        REMOVE_ACCOUNT_ALIAS("removeAccountAlias", "raa", "{name@domain|id} {alias@domain}", Category.ACCOUNT, 2, 2),
        REMOVE_ACCOUNT_LOGGER("removeAccountLogger", "ral", "[-s/--server hostname] [{name@domain|id}] [{logging-category}]", Category.LOG, 0, 4),
        REMOVE_DISTRIBUTION_LIST_ALIAS("removeDistributionListAlias", "rdla", "{list@domain|id} {alias@domain}", Category.LIST, 2, 2),
        REMOVE_DISTRIBUTION_LIST_MEMBER("removeDistributionListMember", "rdlm", "{list@domain|id} {member@domain}", Category.LIST, 2, Integer.MAX_VALUE),
        RENAME_ACCOUNT("renameAccount", "ra", "{name@domain|id} {newName@domain}", Category.ACCOUNT, 2, 2),
        RENAME_CALENDAR_RESOURCE("renameCalendarResource", "rcr", "{name@domain|id} {newName@domain}", Category.CALENDAR, 2, 2),
        RENAME_COS("renameCos", "rc", "{name|id} {newName}", Category.COS, 2, 2),
        RENAME_DISTRIBUTION_LIST("renameDistributionList", "rdl", "{list@domain|id} {newName@domain}", Category.LIST, 2, 2),
        RENAME_DOMAIN("renameDomain", "rd", "{domain|id} {newDomain}", Category.DOMAIN, 2, 2, Via.ldap),
        REINDEX_MAILBOX("reIndexMailbox", "rim", "{name@domain|id} {start|status|cancel} [{types|ids} {type or id} [type or id...]]", Category.MAILBOX, 2, Integer.MAX_VALUE),
        REVOKE_RIGHT("revokeRight", "rvr", "{target-type} [{target-id|target-name}] {grantee-type} {grantee-id|grantee-name} {[-]right}", Category.RIGHT, 4, 5, null, new RightCommandHelp()),
        SEARCH_ACCOUNTS("searchAccounts", "sa", "[-v] {ldap-query} [limit {limit}] [offset {offset}] [sortBy {attr}] [sortAscending 0|1*] [domain {domain}]", Category.SEARCH, 1, Integer.MAX_VALUE),
        SEARCH_CALENDAR_RESOURCES("searchCalendarResources", "scr", "[-v] domain attr op value [attr op value...]", Category.SEARCH),
        SEARCH_GAL("searchGal", "sg", "{domain} {name} [limit {limit}] [offset {offset}] [sortBy {attr}]", Category.SEARCH, 2, Integer.MAX_VALUE),
        SELECT_MAILBOX("selectMailbox", "sm", "{account-name} [{zmmailbox commands}]", Category.MAILBOX, 1, Integer.MAX_VALUE),
        SET_ACCOUNT_COS("setAccountCos", "sac", "{name@domain|id} {cos-name|cos-id}", Category.ACCOUNT, 2, 2),
        SET_PASSWORD("setPassword", "sp", "{name@domain|id} {password}", Category.ACCOUNT, 2, 2),
        GET_ALL_MTA_AUTH_URLS("getAllMtaAuthURLs", "gamau", "", Category.SERVER, 0, 0),
        GET_ALL_REVERSE_PROXY_URLS("getAllReverseProxyURLs", "garpu", "", Category.SERVER, 0, 0),
        GET_ALL_REVERSE_PROXY_BACKENDS("getAllReverseProxyBackends", "garpb", "", Category.SERVER, 0, 0),
        GET_ALL_MEMCACHED_SERVERS("getAllMemcachedServers", "gamcs", "", Category.SERVER, 0, 0),
        RELOAD_MEMCACHED_CLIENT_CONFIG("reloadMemcachedClientConfig", "rmcc", "all | mailbox-server [...]", Category.MISC, 1, Integer.MAX_VALUE, Via.soap),
        GET_MEMCACHED_CLIENT_CONFIG("getMemcachedClientConfig", "gmcc", "all | mailbox-server [...]", Category.MISC, 1, Integer.MAX_VALUE, Via.soap),
        SOAP(".soap", ".s"),
        SYNC_GAL("syncGal", "syg", "{domain} [{token}]", Category.MISC, 1, 2),
        UPDATE_TEMPLATES("updateTemplates", "ut", "[-h host] {template-directory}", Category.NOTEBOOK, 1, 3);

        private String mName;
        private String mAlias;
        private String mHelp;
        private CommandHelp mExtraHelp;
        private Category mCat;
        private int mMinArgLength = 0;
        private int mMaxArgLength = Integer.MAX_VALUE;
        private Via mVia;
        private boolean mNeedsSchemaExtension = false;

        public String getName() {
            return this.mName;
        }

        public String getAlias() {
            return this.mAlias;
        }

        public String getHelp() {
            return this.mHelp;
        }

        public CommandHelp getExtraHelp() {
            return this.mExtraHelp;
        }

        public Category getCategory() {
            return this.mCat;
        }

        public boolean hasHelp() {
            return this.mHelp != null;
        }

        public boolean checkArgsLength(String[] args) {
            int len = args == null ? 0 : args.length - 1;
            return len >= this.mMinArgLength && len <= this.mMaxArgLength;
        }

        public Via getVia() {
            return this.mVia;
        }

        public boolean needsSchemaExtension() {
            return this.mNeedsSchemaExtension || this.mCat == Category.RIGHT;
        }

        private Command(String name, String alias) {
            this.mName = name;
            this.mAlias = alias;
        }

        private Command(String name, String alias, String help, Category cat) {
            this.mName = name;
            this.mAlias = alias;
            this.mHelp = help;
            this.mCat = cat;
        }

        private Command(String name, String alias, String help, Category cat, int minArgLength, int maxArgLength) {
            this.mName = name;
            this.mAlias = alias;
            this.mHelp = help;
            this.mCat = cat;
            this.mMinArgLength = minArgLength;
            this.mMaxArgLength = maxArgLength;
        }

        private Command(String name, String alias, String help, Category cat, int minArgLength, int maxArgLength, Via via) {
            this.mName = name;
            this.mAlias = alias;
            this.mHelp = help;
            this.mCat = cat;
            this.mMinArgLength = minArgLength;
            this.mMaxArgLength = maxArgLength;
            this.mVia = via;
        }

        private Command(String name, String alias, String help, Category cat, int minArgLength, int maxArgLength, Via via, CommandHelp extraHelp) {
            this.mName = name;
            this.mAlias = alias;
            this.mHelp = help;
            this.mCat = cat;
            this.mMinArgLength = minArgLength;
            this.mMaxArgLength = maxArgLength;
            this.mVia = via;
            this.mExtraHelp = extraHelp;
        }

        private Command(String name, String alias, String help, Category cat, int minArgLength, int maxArgLength, Via via, CommandHelp extraHelp, boolean needsSchemaExtension) {
            this(name, alias, help, cat, minArgLength, maxArgLength, via, extraHelp);
            this.mNeedsSchemaExtension = needsSchemaExtension;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Via {
            soap,
            ldap;

        }
    }

    static class RightCommandHelp
    implements CommandHelp {
        RightCommandHelp() {
        }

        public void printHelp() {
            Category.helpRIGHTCommand();
        }
    }

    static interface CommandHelp {
        public void printHelp();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        ACCOUNT("help on account-related commands"),
        CALENDAR("help on calendar resource-related commands"),
        COMMANDS("help on all commands"),
        CONFIG("help on config-related commands"),
        COS("help on COS-related commands"),
        DOMAIN("help on domain-related commands"),
        FREEBUSY("help on free/busy-related commands"),
        LIST("help on distribution list-related commands"),
        LOG("help on logging commands"),
        MISC("help on misc commands"),
        MAILBOX("help on mailbox-related commands"),
        NOTEBOOK("help on notebook-related commands"),
        RIGHT("help on right-related commands"),
        SEARCH("help on search-related commands"),
        SERVER("help on server-related commands"),
        SHARE("help on share related commands");

        String mDesc;

        public String getDescription() {
            return this.mDesc;
        }

        private Category(String desc) {
            this.mDesc = desc;
        }

        static void help(Category cat) {
            if (cat == CALENDAR) {
                Category.helpCALENDAR();
            } else if (cat == RIGHT) {
                Category.helpRIGHT();
            } else if (cat == LOG) {
                Category.helpLOG();
            }
        }

        static void helpCALENDAR() {
            System.out.println("");
            StringBuilder sb = new StringBuilder();
            EntrySearchFilter.Operator[] vals = EntrySearchFilter.Operator.values();
            for (int i = 0; i < vals.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(vals[i].toString());
            }
            System.out.println("    op = " + sb.toString());
        }

        static void helpRIGHT() {
            Category.helpRIGHTCommon();
            Category.helpRIGHTRights(true);
        }

        static void helpRIGHTCommand() {
            Category.helpRIGHTCommon();
            Category.helpRIGHTRights(false);
        }

        static void helpRIGHTRights(boolean printRights) {
            System.out.println();
            System.out.println("    {right}: if right is prefixed with a '-', it means negative right, i.e., specifically deny");
            if (printRights) {
                try {
                    for (AdminRight r : RightManager.getInstance().getAllAdminRights().values()) {
                        System.out.println("        " + r.getName());
                    }
                }
                catch (ServiceException e) {
                    System.out.println("cannot get RightManager instance: " + e.getMessage());
                }
            } else {
                System.out.println("             for complete list of rights, do \"zmprov [-l] gar\"");
            }
            System.out.println();
        }

        static void helpRIGHTCommon() {
            System.out.println();
            StringBuilder tt = new StringBuilder();
            StringBuilder ttNeedsTargetIdentity = new StringBuilder();
            TargetType[] tts = TargetType.values();
            for (int i = 0; i < tts.length; ++i) {
                if (i > 0) {
                    tt.append(", ");
                }
                tt.append(tts[i].getCode());
                if (!tts[i].needsTargetIdentity()) continue;
                ttNeedsTargetIdentity.append(tts[i].getCode() + " ");
            }
            System.out.println("    {target-type} = " + tt.toString());
            System.out.println();
            System.out.println("    {target-id|target-name} is required if target-type is: " + ttNeedsTargetIdentity + ",");
            System.out.println("        otherwise {target-id|target-name} should not be specified");
            System.out.println();
            StringBuilder gt = new StringBuilder();
            GranteeType[] gts = GranteeType.values();
            for (int i = 0; i < gts.length; ++i) {
                if (!gts[i].allowedForAdminRights()) continue;
                if (i > 0) {
                    gt.append(", ");
                }
                gt.append(gts[i].getCode());
            }
            System.out.println("    {grantee-type} = " + gt.toString());
        }

        static void helpLOG() {
            System.out.println("    Log categories:");
            int maxNameLength = 0;
            for (String name : ZimbraLog.CATEGORY_DESCRIPTIONS.keySet()) {
                if (name.length() <= maxNameLength) continue;
                maxNameLength = name.length();
            }
            for (String name : ZimbraLog.CATEGORY_DESCRIPTIONS.keySet()) {
                System.out.print("        " + name);
                for (int i = 0; i < maxNameLength - name.length(); ++i) {
                    System.out.print(" ");
                }
                System.out.format(" - %s\n", ZimbraLog.CATEGORY_DESCRIPTIONS.get(name));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SoapDebugLevel {
        none,
        normal,
        high;

    }
}

