/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreAuthKey {
    public static final int KEY_SIZE_BYTES = 32;

    public static String generateRandomPreAuthKey() throws ServiceException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] key = new byte[32];
            random.nextBytes(key);
            return new String(Hex.encodeHex((byte[])key));
        }
        catch (NoSuchAlgorithmException e) {
            throw ServiceException.FAILURE("unable to initialize SecureRandom", e);
        }
    }

    public static String computePreAuth(Map<String, String> params, String key) {
        TreeSet<String> names = new TreeSet<String>(params.keySet());
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(params.get(name));
        }
        return PreAuthKey.getHmac(sb.toString(), key.getBytes());
    }

    private static String getHmac(String data, byte[] key) {
        try {
            ByteKey bk = new ByteKey(key);
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(bk);
            return new String(Hex.encodeHex((byte[])mac.doFinal(data.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("fatal error", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("fatal error", e);
        }
    }

    public static void main(String[] args) throws ServiceException {
        long now = System.currentTimeMillis();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", "user1");
        params.put("by", "name");
        params.put("timestamp", "1176399950434");
        params.put("expires", "0");
        String key = "9d8ad87fd726ba7d5fecf3d705621024b31cedb142310ec965f9263568fa0f27";
        System.out.printf("key=%s preAuth=%s\n", key, PreAuthKey.computePreAuth(params, key));
    }

    static class ByteKey
    implements SecretKey {
        private byte[] mKey;

        ByteKey(byte[] key) {
            this.mKey = (byte[])key.clone();
        }

        public byte[] getEncoded() {
            return this.mKey;
        }

        public String getAlgorithm() {
            return "HmacSHA1";
        }

        public String getFormat() {
            return "RAW";
        }
    }
}

