/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.stats.Counter;
import com.zimbra.cs.account.NamedEntry;
import java.util.List;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedEntryCache<E extends NamedEntry> {
    private LRUMap mNameCache;
    private LRUMap mIdCache;
    private long mRefreshTTL;
    private Counter mHitRate = new Counter();

    public NamedEntryCache(int maxItems, long refreshTTL) {
        this.mNameCache = new LRUMap(maxItems);
        this.mIdCache = new LRUMap(maxItems);
        this.mRefreshTTL = refreshTTL;
    }

    public synchronized void clear() {
        this.mNameCache.clear();
        this.mIdCache.clear();
    }

    public synchronized void remove(String name, String id) {
        this.mNameCache.remove((Object)name);
        this.mIdCache.remove((Object)id);
    }

    public synchronized void remove(E entry) {
        if (entry != null) {
            this.mNameCache.remove((Object)((NamedEntry)entry).getName());
            this.mIdCache.remove((Object)((NamedEntry)entry).getId());
        }
    }

    public synchronized void put(E entry) {
        if (entry != null) {
            CacheEntry<E> cacheEntry = new CacheEntry<E>(entry, this.mRefreshTTL);
            this.mNameCache.put((Object)((NamedEntry)entry).getName(), cacheEntry);
            this.mIdCache.put((Object)((NamedEntry)entry).getId(), cacheEntry);
        }
    }

    public synchronized void put(List<E> entries, boolean clear) {
        if (entries != null) {
            if (clear) {
                this.clear();
            }
            for (NamedEntry e : entries) {
                this.put(e);
            }
        }
    }

    private E get(String key, LRUMap cache) {
        CacheEntry ce = (CacheEntry)cache.get((Object)key);
        if (ce != null) {
            if (this.mRefreshTTL != 0L && ce.isStale()) {
                this.remove(ce.mEntry);
                this.mHitRate.increment(0L);
                return null;
            }
            this.mHitRate.increment(100L);
            return ce.mEntry;
        }
        this.mHitRate.increment(0L);
        return null;
    }

    public synchronized E getById(String key) {
        return this.get(key, this.mIdCache);
    }

    public synchronized E getByName(String key) {
        return this.get(key.toLowerCase(), this.mNameCache);
    }

    public synchronized int getSize() {
        return this.mIdCache.size();
    }

    public synchronized double getHitRate() {
        return this.mHitRate.getAverage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheEntry<E extends NamedEntry> {
        long mLifetime;
        E mEntry;

        CacheEntry(E entry, long expires) {
            this.mEntry = entry;
            this.mLifetime = System.currentTimeMillis() + expires;
        }

        boolean isStale() {
            return this.mLifetime < System.currentTimeMillis();
        }
    }
}

