/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedEntry
extends Entry
implements Comparable {
    protected String mName;
    protected String mId;

    protected NamedEntry(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov) {
        super(attrs, defaults, prov);
        this.mName = name;
        this.mId = id;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof NamedEntry)) {
            return 0;
        }
        NamedEntry other = (NamedEntry)obj;
        return this.getName().compareTo(other.getName());
    }

    @Override
    public synchronized String toString() {
        return String.format("[%s %s]", this.getClass().getName(), this.getName());
    }

    public static interface CheckRight {
        public boolean allow(NamedEntry var1) throws ServiceException;
    }

    public static interface Visitor {
        public void visit(NamedEntry var1) throws ServiceException;
    }
}

