/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailTarget
extends NamedEntry {
    protected String mDomain;
    protected String mUnicodeDomain;
    protected String mUnicodeName;

    public MailTarget(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov) {
        super(name, id, attrs, defaults, prov);
        int index = name.indexOf(64);
        if (index != -1) {
            String local = name.substring(0, index);
            this.mDomain = name.substring(index + 1);
            this.mUnicodeDomain = IDNUtil.toUnicodeDomainName(this.mDomain);
            this.mUnicodeName = local + "@" + this.mUnicodeDomain;
        } else {
            this.mUnicodeName = name;
        }
    }

    public String getDomainName() {
        return this.mDomain;
    }

    public String getUnicodeDomainName() {
        return this.mUnicodeDomain;
    }

    public String getUnicodeName() {
        return this.mUnicodeName;
    }
}

