/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeManager;
import gnu.inet.encoding.IDNA;
import gnu.inet.encoding.IDNAException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class IDNUtil {
    public static final String ACE_PREFIX = "xn--";
    private static Pattern S_DOMAIN = Pattern.compile("(.+)(@)([^>]*)(.*)");

    public static String toAsciiDomainName(String name) {
        return ZimbraIDN.convertToASCII(name);
    }

    public static String toUnicodeDomainName(String name) {
        return ZimbraIDN.convertToUnicode(name);
    }

    public static String toAsciiEmail(String emailAddress) throws ServiceException {
        String[] parts = emailAddress.split("@");
        if (parts.length != 2) {
            throw ServiceException.INVALID_REQUEST("must be valid email address: " + emailAddress, null);
        }
        String localPart = parts[0];
        String domain = parts[1];
        emailAddress = localPart + "@" + IDNUtil.toAsciiDomainName(domain);
        return emailAddress;
    }

    public static String toUnicodeEmail(String emailAddress) throws ServiceException {
        String[] parts = emailAddress.split("@");
        if (parts.length != 2) {
            throw ServiceException.INVALID_REQUEST("must be valid email address: " + emailAddress, null);
        }
        String localPart = parts[0];
        String domain = parts[1];
        emailAddress = localPart + "@" + IDNUtil.toUnicodeDomainName(domain);
        return emailAddress;
    }

    public static String toAscii(String name, AttributeManager.IDNType idnType) {
        switch (idnType) {
            case email: {
                return IDNUtil.toAscii(name);
            }
            case emailp: {
                return IDNUtil.toAsciiWithPersonalPart(name);
            }
            case cs_emailp: {
                String[] names = name.split(",");
                StringBuilder out = new StringBuilder();
                boolean first = true;
                for (String n : names) {
                    if (first) {
                        first = false;
                    } else {
                        out.append(", ");
                    }
                    out.append(IDNUtil.toAsciiWithPersonalPart(n.trim()));
                }
                return out.toString();
            }
        }
        return name;
    }

    private static String toAsciiWithPersonalPart(String name) {
        String asciiName = name;
        Matcher m = S_DOMAIN.matcher(name);
        if (m.matches() && m.groupCount() == 4) {
            String domain = m.group(3);
            String asciiDomain = IDNUtil.toAsciiDomainName(domain);
            asciiName = m.group(1) + m.group(2) + asciiDomain + m.group(4);
        }
        try {
            InternetAddress ia = new InternetAddress(asciiName);
            String personal = ia.getPersonal();
            if (personal != null) {
                ia = new InternetAddress(ia.getAddress(), personal, "utf-8");
            }
            return ia.toString();
        }
        catch (UnsupportedEncodingException e) {
            ZimbraLog.account.info((Object)("cannot convert to ascii, returning original addr: [" + name + "]"), e);
        }
        catch (AddressException e) {
            ZimbraLog.account.info((Object)("cannot convert to ascii, returning original addr: [" + name + "]"), e);
        }
        return name;
    }

    public static String toAscii(String name) {
        if (name == null) {
            return null;
        }
        try {
            if (name.contains("@")) {
                return IDNUtil.toAsciiEmail(name);
            }
            return IDNUtil.toAsciiDomainName(name);
        }
        catch (ServiceException e) {
            return name;
        }
    }

    public static String toUnicode(String name, AttributeManager.IDNType idnType) {
        switch (idnType) {
            case email: {
                return IDNUtil.toUnicode(name);
            }
            case emailp: {
                return IDNUtil.toUnicodeWithPersonalPart(name);
            }
            case cs_emailp: {
                String[] names = name.split(",");
                StringBuilder out = new StringBuilder();
                boolean first = true;
                for (String n : names) {
                    if (first) {
                        first = false;
                    } else {
                        out.append(", ");
                    }
                    out.append(IDNUtil.toUnicodeWithPersonalPart(n.trim()));
                }
                return out.toString();
            }
        }
        return name;
    }

    private static String toUnicodeWithPersonalPart(String name) {
        try {
            InternetAddress ia = new InternetAddress(name, true);
            String addr = ia.getAddress();
            String unicodeAddr = IDNUtil.toUnicode(addr);
            try {
                ia = new InternetAddress(unicodeAddr, ia.getPersonal(), "utf-8");
                return ia.toUnicodeString();
            }
            catch (UnsupportedEncodingException e) {
                ZimbraLog.account.info((Object)("cannot convert to unicode, returning original addr: [" + name + "]"), e);
            }
        }
        catch (AddressException e) {
            ZimbraLog.account.info((Object)("cannot convert to unicode, returning original addr: [" + name + "]"), e);
        }
        return name;
    }

    public static String toUnicode(String name) {
        if (name == null) {
            return null;
        }
        try {
            if (name.contains("@")) {
                return IDNUtil.toUnicodeEmail(name);
            }
            return IDNUtil.toUnicodeDomainName(name);
        }
        catch (ServiceException e) {
            return name;
        }
    }

    private static void regexTest(String input) {
        System.out.print(input + " ==> ");
        Matcher m = S_DOMAIN.matcher(input);
        if (m.matches()) {
            int groupsMatched = m.groupCount();
            for (int i = 1; i <= groupsMatched; ++i) {
                System.out.print("[" + i + " " + m.group(i) + "]");
            }
            System.out.println();
        } else {
            System.out.println("don't match");
        }
    }

    public static void main(String[] args) {
        IDNUtil.regexTest("test.com");
        IDNUtil.regexTest("@test.com");
        IDNUtil.regexTest("@test.com>aaa");
        IDNUtil.regexTest("user@test.com>aaa");
        IDNUtil.regexTest("foo bar <user@test.com>");
        IDNUtil.regexTest("foo bar <user@test.com");
    }

    private static class GnuIDN
    extends ZimbraIDN {
        private boolean mAllowUnassigned;
        private boolean mUseSTD3ASCIIRules;

        private GnuIDN(boolean allowUnassigned, boolean useSTD3ASCIIRules) {
            this.mAllowUnassigned = allowUnassigned;
            this.mUseSTD3ASCIIRules = useSTD3ASCIIRules;
        }

        String toASCII(String input) throws ServiceException {
            try {
                StringBuffer o = new StringBuffer();
                StringBuffer h = new StringBuffer();
                for (int i = 0; i < input.length(); ++i) {
                    char c = input.charAt(i);
                    if (c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61') {
                        o.append(IDNA.toASCII((String)h.toString(), (boolean)this.mAllowUnassigned, (boolean)this.mUseSTD3ASCIIRules));
                        o.append('.');
                        h = new StringBuffer();
                        continue;
                    }
                    h.append(c);
                }
                o.append(IDNA.toASCII((String)h.toString(), (boolean)this.mAllowUnassigned, (boolean)this.mUseSTD3ASCIIRules));
                return o.toString();
            }
            catch (IDNAException e) {
                throw ServiceException.FAILURE("cannot convert to ASCII", e);
            }
        }

        String toUnicode(String input) {
            StringBuffer o = new StringBuffer();
            StringBuffer h = new StringBuffer();
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61') {
                    o.append(IDNA.toUnicode((String)h.toString(), (boolean)this.mAllowUnassigned, (boolean)this.mUseSTD3ASCIIRules));
                    o.append(c);
                    h = new StringBuffer();
                    continue;
                }
                h.append(c);
            }
            o.append(IDNA.toUnicode((String)h.toString(), (boolean)this.mAllowUnassigned, (boolean)this.mUseSTD3ASCIIRules));
            return o.toString();
        }
    }

    private static class JavaIDN
    extends ZimbraIDN {
        private int mFlags;
        private Method mMethodToASCII;
        private Method mMethodToUnicode;
        private int ALLOW_UNASSIGNED;
        private int USE_STD3_ASCII_RULES;

        private static JavaIDN getInstance(boolean allowUnassigned, boolean useSTD3ASCIIRules) {
            try {
                return new JavaIDN(allowUnassigned, useSTD3ASCIIRules);
            }
            catch (ServiceException serviceException) {
                return null;
            }
        }

        private JavaIDN(boolean allowUnassigned, boolean useSTD3ASCIIRules) throws ServiceException {
            try {
                Class<?> cls = Class.forName("java.net.IDN");
                this.mMethodToASCII = cls.getMethod("toASCII", String.class, Integer.TYPE);
                this.mMethodToUnicode = cls.getMethod("toUnicode", String.class, Integer.TYPE);
                Field fieldAllowUnassigned = cls.getField("ALLOW_UNASSIGNED");
                Field fieldUseSTD3ASCIIRules = cls.getField("USE_STD3_ASCII_RULES");
                if (this.mMethodToASCII == null || this.mMethodToUnicode == null || fieldAllowUnassigned == null || fieldUseSTD3ASCIIRules == null) {
                    throw ServiceException.FAILURE("JavaIDN not supported", null);
                }
                this.ALLOW_UNASSIGNED = fieldAllowUnassigned.getInt(null);
                this.USE_STD3_ASCII_RULES = fieldUseSTD3ASCIIRules.getInt(null);
                this.mFlags = 0;
                if (allowUnassigned) {
                    this.mFlags |= this.ALLOW_UNASSIGNED;
                }
                if (useSTD3ASCIIRules) {
                    this.mFlags |= this.USE_STD3_ASCII_RULES;
                }
                return;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw ServiceException.FAILURE("JavaIDN not supported", null);
        }

        String toASCII(String input) throws ServiceException {
            try {
                return (String)this.mMethodToASCII.invoke(null, input, this.mFlags);
            }
            catch (IllegalAccessException e) {
                throw ServiceException.FAILURE("cannot convert to ASCII", e);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.FAILURE("cannot convert to ASCII", e);
            }
            catch (InvocationTargetException e) {
                throw ServiceException.FAILURE("cannot convert to ASCII", e);
            }
        }

        String toUnicode(String input) throws ServiceException {
            try {
                return (String)this.mMethodToUnicode.invoke(null, input, this.mFlags);
            }
            catch (IllegalAccessException e) {
                throw ServiceException.FAILURE("cannot convert to Unicode", e);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.FAILURE("cannot convert to Unicode", e);
            }
            catch (InvocationTargetException e) {
                throw ServiceException.FAILURE("cannot convert to Unicode", e);
            }
        }
    }

    private static abstract class ZimbraIDN {
        private static final boolean sAllowUnassigned = true;
        private static final boolean sUseSTD3ASCIIRules = false;
        private static final ZimbraIDN INSTANCE = ZimbraIDN.getInstance();

        private ZimbraIDN() {
        }

        private static ZimbraIDN getInstance() {
            ZimbraIDN instance = JavaIDN.getInstance(true, false);
            if (instance == null) {
                instance = new GnuIDN(true, false);
            }
            return instance;
        }

        abstract String toASCII(String var1) throws ServiceException;

        abstract String toUnicode(String var1) throws ServiceException;

        private static String convertToASCII(String input) {
            try {
                return INSTANCE.toASCII(input);
            }
            catch (ServiceException e) {
                ZimbraLog.account.info((Object)("domain [" + input + "] cannot be converted to ASCII"), e);
                return input;
            }
        }

        private static String convertToUnicode(String input) {
            try {
                return INSTANCE.toUnicode(input);
            }
            catch (ServiceException e) {
                ZimbraLog.account.info((Object)("domain [" + input + "] cannot be converted to Unicode"), e);
                return input;
            }
        }
    }
}

