/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalContact
implements Comparable {
    private Map<String, Object> mAttrs;
    private String mId;
    private String mSortField;

    public GalContact(String dn, Map<String, Object> attrs) {
        this.mId = dn;
        this.mAttrs = attrs;
    }

    public String getId() {
        return this.mId;
    }

    public Map<String, Object> getAttrs() {
        return this.mAttrs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LdapGalContact: { ");
        sb.append("id=" + this.mId);
        sb.append("}");
        return sb.toString();
    }

    public String getSingleAttr(String name) {
        Object val = this.mAttrs.get(name);
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof String[]) {
            return ((String[])val)[0];
        }
        return null;
    }

    private String getSortField() {
        if (this.mSortField != null) {
            return this.mSortField;
        }
        this.mSortField = this.getSingleAttr("fullName");
        if (this.mSortField != null) {
            return this.mSortField;
        }
        String first = this.getSingleAttr("firstName");
        String last = this.getSingleAttr("lastName");
        if (first != null || last != null) {
            StringBuilder sb = new StringBuilder();
            if (first != null) {
                sb.append(first);
            }
            if (last != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(last);
            }
            this.mSortField = sb.toString();
        } else {
            this.mSortField = this.getSingleAttr("email");
            if (this.mSortField == null) {
                this.mSortField = "";
            }
        }
        return this.mSortField;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof GalContact)) {
            return 0;
        }
        GalContact other = (GalContact)obj;
        return this.getSortField().compareTo(other.getSortField());
    }

    public static interface Visitor {
        public void visit(GalContact var1) throws ServiceException;
    }
}

