/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EntrySearchFilter {
    private static Set<String> sIndexedAttrs = new HashSet<String>();
    private Term mTerm;

    public EntrySearchFilter(Term term) {
        this.mTerm = term;
    }

    public void andWith(EntrySearchFilter other) {
        Multi m;
        Term otherTerm = other.mTerm;
        if (this.mTerm instanceof Multi && (m = (Multi)this.mTerm).isAnd()) {
            m.add(otherTerm);
            return;
        }
        Multi multi = new Multi(false, AndOr.and);
        multi.add(this.mTerm);
        multi.add(otherTerm);
        this.mTerm = multi;
    }

    public void orWith(EntrySearchFilter other) {
        Multi m;
        Term otherTerm = other.mTerm;
        if (this.mTerm instanceof Multi && !(m = (Multi)this.mTerm).isAnd()) {
            m.add(otherTerm);
            return;
        }
        Multi multi = new Multi(false, AndOr.or);
        multi.add(this.mTerm);
        multi.add(otherTerm);
        this.mTerm = multi;
    }

    public void traverse(Visitor visitor) {
        this.mTerm.visit(visitor);
    }

    public boolean usesIndex() {
        return EntrySearchFilter.possiblyUsesIndex(this.mTerm);
    }

    private static boolean possiblyUsesIndex(Term term) {
        boolean result;
        if (term instanceof Single) {
            Single single = (Single)term;
            result = sIndexedAttrs.contains(single.getLhs().toLowerCase());
        } else {
            assert (term instanceof Multi);
            Multi multi = (Multi)term;
            boolean anding = multi.isAnd();
            List<Term> terms = multi.getTerms();
            if (anding) {
                result = false;
                for (Term t : terms) {
                    if (!EntrySearchFilter.possiblyUsesIndex(t)) continue;
                    result = true;
                    break;
                }
            } else {
                result = true;
                for (Term t : terms) {
                    if (EntrySearchFilter.possiblyUsesIndex(t)) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    static {
        sIndexedAttrs.add("objectClass".toLowerCase());
        sIndexedAttrs.add("zimbraForeignPrincipal".toLowerCase());
        sIndexedAttrs.add("zimbraId".toLowerCase());
        sIndexedAttrs.add("zimbraMailCatchAllAddress".toLowerCase());
        sIndexedAttrs.add("zimbraMailDeliveryAddress".toLowerCase());
        sIndexedAttrs.add("zimbraMailForwardingAddress".toLowerCase());
        sIndexedAttrs.add("zimbraMailAlias".toLowerCase());
        sIndexedAttrs.add("zimbraDomainName".toLowerCase());
        sIndexedAttrs.add("uid".toLowerCase());
        sIndexedAttrs.add("mail".toLowerCase());
        sIndexedAttrs.add("cn".toLowerCase());
        sIndexedAttrs.add("sn".toLowerCase());
        sIndexedAttrs.add("gn".toLowerCase());
        sIndexedAttrs.add("displayName".toLowerCase());
        sIndexedAttrs.add("zimbraCalResSite".toLowerCase());
        sIndexedAttrs.add("zimbraCalResBuilding".toLowerCase());
        sIndexedAttrs.add("zimbraCalResFloor".toLowerCase());
        sIndexedAttrs.add("zimbraCalResRoom".toLowerCase());
        sIndexedAttrs.add("zimbraCalResCapacity".toLowerCase());
    }

    public static class Single
    extends Term {
        private String mLhs;
        private Operator mOp;
        private String mRhs;

        public Single(boolean negation, String lhs, String op, String rhs) throws IllegalArgumentException {
            this(negation, lhs, Operator.valueOf(op), rhs);
        }

        public Single(boolean negation, String lhs, Operator op, String rhs) {
            this.setNegation(negation);
            this.mLhs = lhs;
            this.mOp = op;
            this.mRhs = rhs;
        }

        public String getLhs() {
            return this.mLhs;
        }

        public Operator getOperator() {
            return this.mOp;
        }

        public String getRhs() {
            return this.mRhs;
        }

        protected void visit(Visitor visitor) {
            visitor.visitSingle(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Multi
    extends Term {
        private AndOr mAndOr;
        private List<Term> mTerms;

        public Multi(boolean negation, AndOr andOr) {
            this.setNegation(negation);
            this.mAndOr = andOr;
            this.mTerms = new ArrayList<Term>();
        }

        public Multi(boolean negation, AndOr andOr, Term ... terms) {
            this(negation, andOr);
            for (Term t : terms) {
                this.add(t);
            }
        }

        public List<Term> getTerms() {
            return this.mTerms;
        }

        public boolean isAnd() {
            return AndOr.and.equals((Object)this.mAndOr);
        }

        public void add(Term t) {
            this.mTerms.add(t);
        }

        @Override
        protected void visit(Visitor visitor) {
            visitor.enterMulti(this);
            for (Term t : this.mTerms) {
                t.visit(visitor);
            }
            visitor.leaveMulti(this);
        }
    }

    public static abstract class Term {
        private boolean mNegation;

        public boolean isNegation() {
            return this.mNegation;
        }

        public void setNegation(boolean negation) {
            this.mNegation = negation;
        }

        protected abstract void visit(Visitor var1);
    }

    public static interface Visitor {
        public void visitSingle(Single var1);

        public void enterMulti(Multi var1);

        public void leaveMulti(Multi var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        eq,
        has,
        startswith,
        endswith,
        ge,
        le,
        gt,
        lt;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AndOr {
        and,
        or;

    }
}

