/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.AttributeInfo;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entry
implements ToZJSONObject {
    private Map<String, Object> mAttrs;
    private Map<String, Object> mDefaults;
    private Map<String, Object> mSecondaryDefaults;
    private Map<String, Object> mData;
    private Map<String, Set<String>> mMultiAttrSetCache;
    private Locale mLocale;
    private Provisioning mProvisioning;
    private AttributeManager mAttrMgr;
    protected static String[] sEmptyMulti = new String[0];
    static Pattern regex = Pattern.compile("^/(.*)/(i)?$");

    protected Entry(Map<String, Object> attrs, Map<String, Object> defaults, Provisioning provisioning) {
        this.mProvisioning = provisioning;
        this.mAttrs = attrs;
        this.mDefaults = defaults;
        this.setAttributeManager();
    }

    protected Entry(Map<String, Object> attrs, Map<String, Object> defaults, Map<String, Object> secondaryDefaults, Provisioning provisioning) {
        this.mProvisioning = provisioning;
        this.mAttrs = attrs;
        this.mDefaults = defaults;
        this.mSecondaryDefaults = secondaryDefaults;
        this.setAttributeManager();
    }

    private void setAttributeManager() {
        try {
            this.mAttrMgr = AttributeManager.getInstance();
        }
        catch (ServiceException se) {
            ZimbraLog.account.warn((Object)"failed to get AttributeManager instance", se);
        }
    }

    private AttributeManager getAttributeManager() {
        return this.mAttrMgr;
    }

    public Provisioning getProvisioning() {
        return this.mProvisioning;
    }

    public String getLabel() {
        return "unknown";
    }

    public synchronized void setAttrs(Map<String, Object> attrs, Map<String, Object> defaults, Map<String, Object> secondaryDefaults) {
        this.mAttrs = attrs;
        this.mDefaults = defaults;
        this.mSecondaryDefaults = secondaryDefaults;
        this.resetData();
    }

    public synchronized void setAttrs(Map<String, Object> attrs) {
        this.mAttrs = attrs;
        this.resetData();
    }

    public synchronized void setDefaults(Map<String, Object> defaults) {
        this.mDefaults = defaults;
        this.resetData();
    }

    public synchronized void setDefaults(Map<String, Object> defaults, Map<String, Object> secondaryDefaults) {
        this.mDefaults = defaults;
        this.mSecondaryDefaults = secondaryDefaults;
        this.resetData();
    }

    public synchronized void setSecondaryDefaults(Map<String, Object> secondaryDefaults) {
        this.mSecondaryDefaults = secondaryDefaults;
        this.resetData();
    }

    protected synchronized void resetData() {
        if (this.mMultiAttrSetCache != null) {
            this.mMultiAttrSetCache.clear();
        }
        if (this.mData != null) {
            this.mData.clear();
        }
        this.mLocale = null;
    }

    private Object getObject(String name, boolean applyDefaults) {
        Object v = this.mAttrs.get(name);
        if (v != null) {
            return v;
        }
        v = this.getValueByRealAttrName(name, this.mAttrs);
        if (v != null) {
            return v;
        }
        if (!applyDefaults) {
            return null;
        }
        return this.getAttrDefault(name);
    }

    public Object getAttrDefault(String name) {
        Object v;
        if (this.mDefaults != null) {
            v = this.mDefaults.get(name);
            if (v != null) {
                return v;
            }
            v = this.getValueByRealAttrName(name, this.mDefaults);
            if (v != null) {
                return v;
            }
        }
        if (this.mSecondaryDefaults != null) {
            v = this.mSecondaryDefaults.get(name);
            if (v != null) {
                return v;
            }
            v = this.getValueByRealAttrName(name, this.mSecondaryDefaults);
            if (v != null) {
                return v;
            }
        }
        return null;
    }

    private Object getValueByRealAttrName(String attrName, Map<String, Object> map) {
        AttributeInfo ai;
        AttributeManager attrMgr = this.getAttributeManager();
        if (attrMgr != null && (ai = attrMgr.getAttributeInfo(attrName)) != null) {
            return map.get(ai.getName());
        }
        return null;
    }

    private Map<String, Object> toUnicode(Map<String, Object> attrs) {
        AttributeManager attrMgr = this.getAttributeManager();
        HashSet<String> keySet = new HashSet<String>(attrs.keySet());
        for (String key : keySet) {
            AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, key);
            if (!idnType.isEmailOrIDN()) continue;
            Object value = attrs.get(key);
            if (value instanceof String[]) {
                String[] sv = (String[])value;
                for (int i = 0; i < sv.length; ++i) {
                    sv[i] = IDNUtil.toUnicode(sv[i], idnType);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            attrs.put(key, IDNUtil.toUnicode((String)value, idnType));
        }
        return attrs;
    }

    public String getAttr(String name) {
        return this.getAttr(name, true);
    }

    public String getAttr(String name, boolean applyDefaults) {
        Object v = this.getObject(name, applyDefaults);
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof String[]) {
            String[] a = (String[])v;
            return a.length > 0 ? a[0] : null;
        }
        return null;
    }

    public String getAttr(String name, String defaultValue) {
        String v = this.getAttr(name);
        return v == null ? defaultValue : v;
    }

    protected Map<String, Object> getRawAttrs() {
        return this.mAttrs;
    }

    public Map<String, Object> getAttrs() {
        return this.getAttrs(true);
    }

    public Map<String, Object> getUnicodeAttrs() {
        Map<String, Object> attrs = this.getAttrs(true);
        return this.toUnicode(attrs);
    }

    public Map<String, Object> getAttrs(boolean applyDefaults) {
        if (applyDefaults && (this.mDefaults != null || this.mSecondaryDefaults != null)) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            if (this.mSecondaryDefaults != null) {
                attrs.putAll(this.mSecondaryDefaults);
            }
            if (this.mDefaults != null) {
                attrs.putAll(this.mDefaults);
            }
            attrs.putAll(this.mAttrs);
            return attrs;
        }
        return this.mAttrs;
    }

    public Map<String, Object> getUnicodeAttrs(boolean applyDefaults) {
        Map<String, Object> attrs = this.getAttrs(applyDefaults);
        return this.toUnicode(attrs);
    }

    public boolean getBooleanAttr(String name, boolean defaultValue) {
        String v = this.getAttr(name);
        return v == null ? defaultValue : "TRUE".equals(v);
    }

    public Date getGeneralizedTimeAttr(String name, Date defaultValue) {
        String v = this.getAttr(name);
        if (v == null) {
            return defaultValue;
        }
        Date d = DateUtil.parseGeneralizedTime(v);
        return d == null ? defaultValue : d;
    }

    public int getIntAttr(String name, int defaultValue) {
        String v = this.getAttr(name);
        try {
            return v == null ? defaultValue : Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() throws ServiceException {
        Entry entry = this;
        synchronized (entry) {
            if (this.mLocale != null) {
                return this.mLocale;
            }
        }
        Locale lc = Provisioning.getInstance().getLocale(this);
        Entry entry2 = this;
        synchronized (entry2) {
            this.mLocale = lc;
            return this.mLocale;
        }
    }

    public long getLongAttr(String name, long defaultValue) {
        String v = this.getAttr(name);
        try {
            return v == null ? defaultValue : Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String[] getMultiAttr(String name) {
        return this.getMultiAttr(name, true);
    }

    public String[] getUnicodeMultiAttr(String name) {
        String[] values = this.getMultiAttr(name, true);
        AttributeManager attrMgr = this.getAttributeManager();
        AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, name);
        if (idnType.isEmailOrIDN() && values != null) {
            String[] unicodeValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                unicodeValues[i] = IDNUtil.toUnicode(values[i], idnType);
            }
            return unicodeValues;
        }
        return values;
    }

    public String[] getMultiAttr(String name, boolean applyDefaults) {
        Object v = this.getObject(name, applyDefaults);
        if (v instanceof String) {
            return new String[]{(String)v};
        }
        if (v instanceof String[]) {
            return (String[])v;
        }
        return sEmptyMulti;
    }

    public Set<String> getMultiAttrSet(String name) {
        Set<String> result;
        if (this.mMultiAttrSetCache == null) {
            this.mMultiAttrSetCache = new HashMap<String, Set<String>>();
        }
        if ((result = this.mMultiAttrSetCache.get(name)) == null) {
            result = new HashSet<String>(Arrays.asList(this.getMultiAttr(name)));
            this.mMultiAttrSetCache.put(name, result);
        }
        return result;
    }

    public long getTimeInterval(String name, long defaultValue) {
        return DateUtil.getTimeInterval(this.getAttr(name), defaultValue);
    }

    public long getTimeIntervalSecs(String name, long defaultValue) {
        return DateUtil.getTimeIntervalSecs(this.getAttr(name), defaultValue);
    }

    public synchronized void setCachedData(String key, Object value) {
        if (this.mData == null) {
            this.mData = new HashMap<String, Object>();
        }
        this.mData.put(key, value);
    }

    public synchronized Object getCachedData(String key) {
        if (this.mData == null) {
            return null;
        }
        return this.mData.get(key);
    }

    protected void getDefaults(AttributeFlag flag, Map<String, Object> defaults) throws ServiceException {
        defaults.clear();
        Set<String> attrs = AttributeManager.getInstance().getAttrsWithFlag(flag);
        for (String a : attrs) {
            Object obj = this.getObject(a, true);
            if (obj == null) continue;
            defaults.put(a, obj);
        }
    }

    public synchronized String toString() {
        return String.format("[%s]", this.getClass().getName());
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        return this.toZJSONObject(null, true);
    }

    public ZJSONObject toZJSONObject(String filter, boolean applyDefaults) throws JSONException {
        Map<String, Object> attrs = this.getAttrs(applyDefaults);
        if (this instanceof NamedEntry) {
            NamedEntry ne = (NamedEntry)this;
            attrs.put("id", ne.getId());
            attrs.put("name", ne.getName());
        }
        Pattern pattern = null;
        if (filter != null) {
            Matcher rm = regex.matcher(filter);
            if (rm.matches()) {
                pattern = Pattern.compile(rm.group(1), "i".equals(rm.group(2)) ? 2 : 0);
            } else {
                filter = filter.toLowerCase();
            }
        }
        ZJSONObject zj = new ZJSONObject();
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            if (pattern == null ? filter != null && !entry.getKey().toLowerCase().contains(filter) : !pattern.matcher(entry.getKey()).find()) continue;
            Object o = entry.getValue();
            if (o instanceof String) {
                zj.put(entry.getKey(), (String)o);
                continue;
            }
            if (!(o instanceof String[])) continue;
            zj.put(entry.getKey(), (String[])o);
        }
        return zj;
    }

    public String dump() throws JSONException {
        return this.dump(null, true);
    }

    public String dump(String filter) throws JSONException {
        return this.dump(filter, true);
    }

    public String dump(String filter, boolean applyDefaults) throws JSONException {
        return this.toZJSONObject(filter, applyDefaults).toString();
    }
}

