/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.stats.Counter;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import org.apache.commons.collections.map.LRUMap;

public class DomainCache {
    private LRUMap mNameCache;
    private LRUMap mIdCache;
    private LRUMap mVirtualHostnameCache;
    private LRUMap mKrb5RealmCache;
    private long mRefreshTTL;
    private Counter mHitRate = new Counter();
    private NonExistingCache mNonExistingCache;

    public DomainCache(int maxItems, long refreshTTL, int maxItemsNonExisting, long refreshTTLNonExisting) {
        this.mNameCache = new LRUMap(maxItems);
        this.mIdCache = new LRUMap(maxItems);
        this.mVirtualHostnameCache = new LRUMap(maxItems);
        this.mKrb5RealmCache = new LRUMap(maxItems);
        this.mRefreshTTL = refreshTTL;
        this.mNonExistingCache = new NonExistingCache(maxItemsNonExisting, refreshTTLNonExisting);
    }

    public synchronized void clear() {
        this.mNameCache.clear();
        this.mIdCache.clear();
        this.mVirtualHostnameCache.clear();
        this.mKrb5RealmCache.clear();
        this.mNonExistingCache.clear();
    }

    public synchronized void remove(Domain entry) {
        if (entry != null) {
            String[] vhost;
            this.mNameCache.remove((Object)entry.getName());
            this.mIdCache.remove((Object)entry.getId());
            for (String vh : vhost = entry.getMultiAttr("zimbraVirtualHostname")) {
                this.mVirtualHostnameCache.remove((Object)vh.toLowerCase());
            }
            String krb5Realm = entry.getAttr("zimbraAuthKerberos5Realm");
            if (krb5Realm != null) {
                this.mKrb5RealmCache.remove((Object)krb5Realm);
            }
        }
    }

    public synchronized void removeNonExisting(Provisioning.DomainBy domainBy, String key) {
        this.mNonExistingCache.remove(domainBy, key);
    }

    public synchronized void put(Provisioning.DomainBy domainBy, String key, Domain entry) {
        if (entry != null) {
            String[] vhost;
            this.mNonExistingCache.clean(domainBy, key, entry);
            CacheEntry cacheEntry = new CacheEntry(entry, this.mRefreshTTL);
            this.mNameCache.put((Object)entry.getName(), (Object)cacheEntry);
            this.mIdCache.put((Object)entry.getId(), (Object)cacheEntry);
            for (String vh : vhost = entry.getMultiAttr("zimbraVirtualHostname")) {
                this.mVirtualHostnameCache.put((Object)vh.toLowerCase(), (Object)cacheEntry);
            }
            String krb5Realm = entry.getAttr("zimbraAuthKerberos5Realm");
            if (krb5Realm != null) {
                this.mKrb5RealmCache.put((Object)krb5Realm, (Object)cacheEntry);
            }
        } else {
            this.mNonExistingCache.put(domainBy, key);
        }
    }

    private Domain get(String key, LRUMap cache) {
        CacheEntry ce = (CacheEntry)cache.get((Object)key);
        if (ce != null) {
            if (this.mRefreshTTL != 0L && ce.isStale()) {
                this.remove(ce.mEntry);
                this.mHitRate.increment(0L);
                return null;
            }
            this.mHitRate.increment(100L);
            return ce.mEntry;
        }
        this.mHitRate.increment(0L);
        return null;
    }

    public synchronized Domain getById(String key) {
        NonExistingDomain d = this.mNonExistingCache.get(Provisioning.DomainBy.id, key);
        if (d == null) {
            return this.get(key, this.mIdCache);
        }
        return d;
    }

    public synchronized Domain getByName(String key) {
        NonExistingDomain d = this.mNonExistingCache.get(Provisioning.DomainBy.name, key);
        if (d == null) {
            return this.get(key.toLowerCase(), this.mNameCache);
        }
        return d;
    }

    public synchronized Domain getByVirtualHostname(String key) {
        NonExistingDomain d = this.mNonExistingCache.get(Provisioning.DomainBy.virtualHostname, key);
        if (d == null) {
            return this.get(key.toLowerCase(), this.mVirtualHostnameCache);
        }
        return d;
    }

    public synchronized Domain getByKrb5Realm(String key) {
        NonExistingDomain d = this.mNonExistingCache.get(Provisioning.DomainBy.virtualHostname, key);
        if (d == null) {
            return this.get(key.toLowerCase(), this.mKrb5RealmCache);
        }
        return d;
    }

    public synchronized int getSize() {
        return this.mIdCache.size();
    }

    public synchronized double getHitRate() {
        return this.mHitRate.getAverage();
    }

    class NonExistingCache {
        private LRUMap mNENameCache;
        private LRUMap mNEIdCache;
        private LRUMap mNEVirtualHostnameCache;
        private LRUMap mNEKrb5RealmCache;
        private long mNERefreshTTL;
        private boolean mEnabled = true;

        private NonExistingCache(int maxItems, long refreshTTL) {
            this.mNENameCache = new LRUMap(maxItems);
            this.mNEIdCache = new LRUMap(maxItems);
            this.mNEVirtualHostnameCache = new LRUMap(maxItems);
            this.mNEKrb5RealmCache = new LRUMap(maxItems);
            this.mNERefreshTTL = refreshTTL;
        }

        private void put(Provisioning.DomainBy domainBy, String key) {
            if (!this.mEnabled) {
                return;
            }
            NonExistingDomain nonExistingDomain = new NonExistingDomain();
            switch (domainBy) {
                case name: {
                    this.mNENameCache.put((Object)key, (Object)nonExistingDomain);
                    break;
                }
                case id: {
                    this.mNEIdCache.put((Object)key, (Object)nonExistingDomain);
                    break;
                }
                case virtualHostname: {
                    this.mNEVirtualHostnameCache.put((Object)key, (Object)nonExistingDomain);
                    break;
                }
                case krb5Realm: {
                    this.mNEKrb5RealmCache.put((Object)key, (Object)nonExistingDomain);
                }
            }
        }

        private NonExistingDomain get(Provisioning.DomainBy domainBy, String key) {
            if (!this.mEnabled) {
                return null;
            }
            switch (domainBy) {
                case name: {
                    return (NonExistingDomain)this.mNENameCache.get((Object)key);
                }
                case id: {
                    return (NonExistingDomain)this.mNEIdCache.get((Object)key);
                }
                case virtualHostname: {
                    return (NonExistingDomain)this.mNEVirtualHostnameCache.get((Object)key);
                }
                case krb5Realm: {
                    return (NonExistingDomain)this.mNEKrb5RealmCache.get((Object)key);
                }
            }
            return null;
        }

        private void remove(Provisioning.DomainBy domainBy, String key) {
            if (!this.mEnabled) {
                return;
            }
            switch (domainBy) {
                case name: {
                    this.mNENameCache.remove((Object)key);
                    break;
                }
                case id: {
                    this.mNEIdCache.remove((Object)key);
                    break;
                }
                case virtualHostname: {
                    this.mNEVirtualHostnameCache.remove((Object)key);
                    break;
                }
                case krb5Realm: {
                    this.mNEKrb5RealmCache.remove((Object)key);
                }
            }
        }

        private void clean(Provisioning.DomainBy domainBy, String key, Domain entry) {
            String[] vhost;
            this.mNENameCache.remove((Object)entry.getName());
            this.mNEIdCache.remove((Object)entry.getId());
            for (String vh : vhost = entry.getMultiAttr("zimbraVirtualHostname")) {
                this.mNEVirtualHostnameCache.remove((Object)vh.toLowerCase());
            }
            String krb5Realm = entry.getAttr("zimbraAuthKerberos5Realm");
            if (krb5Realm != null) {
                this.mNEKrb5RealmCache.remove((Object)krb5Realm);
            }
        }

        void clear() {
            this.mNENameCache.clear();
            this.mNEIdCache.clear();
            this.mNEVirtualHostnameCache.clear();
            this.mNEKrb5RealmCache.clear();
        }
    }

    public static class NonExistingDomain
    extends Domain {
        private NonExistingDomain() {
            super(null, null, null, null, null);
        }
    }

    static class CacheEntry {
        long mLifetime;
        Domain mEntry;

        CacheEntry(Domain entry, long expires) {
            this.mEntry = entry;
            this.mLifetime = System.currentTimeMillis() + expires;
        }

        boolean isStale() {
            return this.mLifetime < System.currentTimeMillis();
        }
    }
}

