/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.Right;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainAccessManager
extends AccessManager {
    @Override
    public boolean isDomainAdminOnly(AuthToken at) {
        return at.isDomainAdmin() && !at.isAdmin();
    }

    @Override
    public boolean canAccessAccount(AuthToken at, Account target, boolean asAdmin) throws ServiceException {
        if (!at.isZimbraUser()) {
            return false;
        }
        this.checkDomainStatus(target);
        if (asAdmin && at.isAdmin()) {
            return true;
        }
        if (this.isParentOf(at, target)) {
            return true;
        }
        if (!asAdmin || !at.isDomainAdmin()) {
            return false;
        }
        if (target.getBooleanAttr("zimbraIsAdminAccount", false)) {
            return false;
        }
        Provisioning prov = Provisioning.getInstance();
        return this.getDomain(at).getId().equals(prov.getDomain(target).getId());
    }

    @Override
    public boolean canAccessAccount(AuthToken at, Account target) throws ServiceException {
        return this.canAccessAccount(at, target, true);
    }

    @Override
    public boolean canAccessAccount(Account credentials, Account target, boolean asAdmin) throws ServiceException {
        if (credentials == null) {
            return false;
        }
        this.checkDomainStatus(target);
        if (asAdmin && credentials.getBooleanAttr("zimbraIsAdminAccount", false)) {
            return true;
        }
        if (this.isParentOf(credentials, target)) {
            return true;
        }
        if (!asAdmin) {
            return false;
        }
        if (target.getBooleanAttr("zimbraIsAdminAccount", false)) {
            return false;
        }
        if (target.getDomainName() != null && target.getDomainName().equals(credentials.getDomainName())) {
            return credentials.getBooleanAttr("zimbraIsDomainAdminAccount", false);
        }
        return false;
    }

    @Override
    public boolean canAccessAccount(Account credentials, Account target) throws ServiceException {
        return this.canAccessAccount(credentials, target, true);
    }

    private boolean canAccessDomainInternal(AuthToken at, String domainName) throws ServiceException {
        if (at.isAdmin()) {
            return true;
        }
        if (!at.isDomainAdmin()) {
            return false;
        }
        return this.getDomain(at).getName().equalsIgnoreCase(domainName);
    }

    @Override
    public boolean canAccessDomain(AuthToken at, String domainName) throws ServiceException {
        if (!at.isZimbraUser()) {
            return false;
        }
        this.checkDomainStatus(domainName);
        return this.canAccessDomainInternal(at, domainName);
    }

    @Override
    public boolean canAccessDomain(AuthToken at, Domain domain) throws ServiceException {
        if (!at.isZimbraUser()) {
            return false;
        }
        this.checkDomainStatus(domain);
        return this.canAccessDomainInternal(at, domain.getName());
    }

    @Override
    public boolean canAccessCos(AuthToken at, Cos cos) throws ServiceException {
        if (!at.isZimbraUser()) {
            return false;
        }
        if (at.isAdmin()) {
            return true;
        }
        if (!at.isDomainAdmin()) {
            return false;
        }
        String cosId = cos.getId();
        Domain domain = this.getDomain(at);
        Set<String> allowedCoses = domain.getMultiAttrSet("zimbraDomainCOSMaxAccounts");
        for (String c : allowedCoses) {
            String id;
            String[] parts = c.split(":");
            if (parts.length != 2 || !(id = parts[0]).equals(cosId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAccessEmail(AuthToken at, String email) throws ServiceException {
        String[] parts = EmailUtil.getLocalPartAndDomain(email);
        if (parts == null) {
            throw ServiceException.INVALID_REQUEST("must be valid email address: " + email, null);
        }
        Account targetAcct = Provisioning.getInstance().get(Provisioning.AccountBy.name, email, at);
        if (targetAcct != null && this.isParentOf(at, targetAcct)) {
            return true;
        }
        return this.canAccessDomain(at, parts[1]);
    }

    @Override
    public boolean canModifyMailQuota(AuthToken at, Account targetAccount, long mailQuota) throws ServiceException {
        if (!this.canAccessAccount(at, targetAccount)) {
            return false;
        }
        return DomainAccessManager.canSetMailQuota(at, targetAccount, mailQuota);
    }

    public static boolean canSetMailQuota(AuthToken at, Account targetAccount, long quota) throws ServiceException {
        if (at.isAdmin()) {
            return true;
        }
        Account adminAccount = Provisioning.getInstance().get(Provisioning.AccountBy.id, at.getAccountId(), at);
        if (adminAccount == null) {
            return false;
        }
        long maxQuota = adminAccount.getLongAttr("zimbraDomainAdminMaxMailQuota", -1L);
        if (maxQuota == 0L) {
            return true;
        }
        if (maxQuota == -1L || quota == 0L || quota > maxQuota) {
            ZimbraLog.account.warn(String.format("invalid attempt to change quota: admin(%s) account(%s) quota(%d) max(%d)", adminAccount.getName(), targetAccount.getName(), quota, maxQuota));
            return false;
        }
        return true;
    }

    @Override
    public boolean canDo(AuthToken grantee, Entry target, Right rightNeeded, boolean asAdmin) {
        return false;
    }

    @Override
    public boolean canDo(Account grantee, Entry target, Right rightNeeded, boolean asAdmin) {
        return false;
    }

    @Override
    public boolean canDo(String grantee, Entry target, Right rightNeeded, boolean asAdmin) {
        return false;
    }

    @Override
    public boolean canGetAttrs(Account grantee, Entry target, Set<String> attrs, boolean asAdmin) throws ServiceException {
        return false;
    }

    @Override
    public boolean canGetAttrs(AuthToken grantee, Entry target, Set<String> attrs, boolean asAdmin) throws ServiceException {
        return false;
    }

    @Override
    public boolean canSetAttrs(Account grantee, Entry target, Set<String> attrs, boolean asAdmin) throws ServiceException {
        return false;
    }

    @Override
    public boolean canSetAttrs(AuthToken grantee, Entry target, Set<String> attrs, boolean asAdmin) throws ServiceException {
        return false;
    }

    @Override
    public boolean canSetAttrs(Account grantee, Entry target, Map<String, Object> attrs, boolean asAdmin) throws ServiceException {
        return false;
    }

    @Override
    public boolean canSetAttrs(AuthToken grantee, Entry target, Map<String, Object> attrs, boolean asAdmin) throws ServiceException {
        return false;
    }
}

