/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ZAttrDomain;
import com.zimbra.cs.account.ZAttrProvisioning;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends ZAttrDomain {
    private String mUnicodeName;
    private Map<String, Object> mAccountDefaults = new HashMap<String, Object>();

    public Domain(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov) {
        super(name, id, attrs, defaults, prov);
        this.mUnicodeName = name == null ? name : IDNUtil.toUnicodeDomainName(name);
    }

    public void modify(Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    public void deleteDomain(String zimbraId) throws ServiceException {
        this.getProvisioning().deleteDomain(this.getId());
    }

    public List getAllAccounts() throws ServiceException {
        return this.getProvisioning().getAllAccounts(this);
    }

    public void getAllAccounts(NamedEntry.Visitor visitor) throws ServiceException {
        this.getProvisioning().getAllAccounts(this, visitor);
    }

    public void getAllAccounts(Server s, NamedEntry.Visitor visitor) throws ServiceException {
        this.getProvisioning().getAllAccounts(this, s, visitor);
    }

    public List getAllCalendarResources() throws ServiceException {
        return this.getProvisioning().getAllCalendarResources(this);
    }

    public void getAllCalendarResources(NamedEntry.Visitor visitor) throws ServiceException {
        this.getProvisioning().getAllCalendarResources(this, visitor);
    }

    public void getAllCalendarResources(Server s, NamedEntry.Visitor visitor) throws ServiceException {
        this.getProvisioning().getAllCalendarResources(this, s, visitor);
    }

    public List getAllDistributionLists() throws ServiceException {
        return this.getProvisioning().getAllDistributionLists(this);
    }

    public List<NamedEntry> searchAccounts(String query, String[] returnAttrs, String sortAttr, boolean sortAscending, int flags) throws ServiceException {
        return this.getProvisioning().searchAccounts(this, query, returnAttrs, sortAttr, sortAscending, flags);
    }

    public List searchCalendarResources(EntrySearchFilter filter, String[] returnAttrs, String sortAttr, boolean sortAscending) throws ServiceException {
        return this.getProvisioning().searchCalendarResources(this, filter, returnAttrs, sortAttr, sortAscending);
    }

    public Provisioning.SearchGalResult searchGal(String query, Provisioning.GAL_SEARCH_TYPE type, String token) throws ServiceException {
        return this.getProvisioning().searchGal(this, query, type, token);
    }

    public Provisioning.SearchGalResult searchGal(String query, Provisioning.GAL_SEARCH_TYPE type, String token, GalContact.Visitor visitor) throws ServiceException {
        return this.getProvisioning().searchGal(this, query, type, token, visitor);
    }

    public Provisioning.SearchGalResult searchGal(String query, Provisioning.GAL_SEARCH_TYPE type, Provisioning.GalMode mode, String token) throws ServiceException {
        return this.getProvisioning().searchGal(this, query, type, mode, token);
    }

    @Override
    protected void resetData() {
        super.resetData();
        try {
            this.getDefaults(AttributeFlag.accountCosDomainInherited, this.mAccountDefaults);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public Map<String, Object> getAccountDefaults() {
        return this.mAccountDefaults;
    }

    public String getUnicodeName() {
        return this.mUnicodeName;
    }

    public boolean isSuspended() {
        boolean suspended;
        ZAttrProvisioning.DomainStatus status = this.getDomainStatus();
        boolean bl = suspended = status != null && status.isSuspended();
        if (suspended) {
            ZimbraLog.account.warn("domain " + this.mName + " is " + "suspended");
        }
        return suspended;
    }

    public boolean isShutdown() {
        boolean shutdown;
        ZAttrProvisioning.DomainStatus status = this.getDomainStatus();
        boolean bl = shutdown = status != null && status.isShutdown();
        if (shutdown) {
            ZimbraLog.account.warn("domain " + this.mName + " is " + "shutdown");
        }
        return shutdown;
    }

    public boolean beingRenamed() {
        String renameInfo = this.getAttr("zimbraDomainRenameInfo");
        return !StringUtil.isNullOrEmpty(renameInfo);
    }
}

