/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttrDistributionList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionList
extends ZAttrDistributionList {
    boolean mIsAclGroup;

    public DistributionList(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, prov);
    }

    public void modify(Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    public void deleteDistributionList() throws ServiceException {
        this.getProvisioning().deleteDistributionList(this.getId());
    }

    public void addAlias(String alias) throws ServiceException {
        this.getProvisioning().addAlias(this, alias);
    }

    public void removeAlias(String alias) throws ServiceException {
        this.getProvisioning().removeAlias(this, alias);
    }

    public void renameDistributionList(String newName) throws ServiceException {
        this.getProvisioning().renameDistributionList(this.getId(), newName);
    }

    public void addMembers(String[] members) throws ServiceException {
        this.getProvisioning().addMembers(this, members);
    }

    public void removeMembers(String[] member) throws ServiceException {
        this.getProvisioning().removeMembers(this, member);
    }

    public String[] getAllMembers() throws ServiceException {
        if (this.mIsAclGroup) {
            throw ServiceException.FAILURE("internal error", null);
        }
        return this.getMultiAttr("zimbraMailForwardingAddress");
    }

    public Set<String> getAllMembersSet() throws ServiceException {
        if (this.mIsAclGroup) {
            throw ServiceException.FAILURE("internal error", null);
        }
        return this.getMultiAttrSet("zimbraMailForwardingAddress");
    }

    public String[] getAliases() throws ServiceException {
        if (this.mIsAclGroup) {
            throw ServiceException.FAILURE("internal error", null);
        }
        return this.getMultiAttr("zimbraMailAlias");
    }

    @Override
    protected void resetData() {
        super.resetData();
        if (this.mIsAclGroup) {
            this.trimForAclGroup();
        }
    }

    private void trimForAclGroup() {
        Map<String, Object> attrs = this.getAttrs(false);
        attrs.remove("zimbraMailAlias");
        attrs.remove("zimbraMailForwardingAddress");
    }

    public boolean isAclGroup() {
        return this.mIsAclGroup;
    }

    public void turnToAclGroup() {
        this.mIsAclGroup = true;
        this.trimForAclGroup();
    }
}

