/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.datasource.SyncState;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountProperty;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.DataSourceManager;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSource
extends AccountProperty {
    private static final int SALT_SIZE_BYTES = 16;
    private static final int AES_PAD_SIZE = 16;
    private static final byte[] VERSION = new byte[]{1};
    private static final String SIMPLE_CLASS_NAME = StringUtil.getSimpleClassName(DataSource.class.getName());
    public static final String CT_CLEARTEXT = "cleartext";
    public static final String CT_SSL = "ssl";
    private Type mType;

    public DataSource(Account acct, Type type, String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(acct, name, id, attrs, null, prov);
        this.mType = type;
    }

    public Type getType() {
        return this.mType;
    }

    public boolean isManaged() {
        return DataSourceManager.isManaged(this);
    }

    public boolean isEnabled() {
        return this.getBooleanAttr("zimbraDataSourceEnabled", false);
    }

    public ConnectionType getConnectionType() {
        String value = this.getAttr("zimbraDataSourceConnectionType");
        ConnectionType connectionType = null;
        if (value != null) {
            try {
                connectionType = ConnectionType.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                ZimbraLog.mailbox.warn("Illegal connection type: " + value);
            }
        }
        return connectionType;
    }

    public boolean isSslEnabled() {
        return this.getConnectionType() == ConnectionType.ssl;
    }

    public int getFolderId() {
        return this.getIntAttr("zimbraDataSourceFolderId", -1);
    }

    public String getHost() {
        return this.getAttr("zimbraDataSourceHost");
    }

    public String getUsername() {
        return this.getAttr("zimbraDataSourceUsername");
    }

    public String getDomain() {
        return this.getAttr("zimbraDataSourceDomain", null);
    }

    public Integer getPort() {
        if (this.getAttr("zimbraDataSourcePort") == null) {
            return null;
        }
        return this.getIntAttr("zimbraDataSourcePort", -1);
    }

    public String getDecryptedPassword() throws ServiceException {
        String data = this.getAttr("zimbraDataSourcePassword");
        return data == null ? null : DataSource.decryptData(this.getId(), data);
    }

    public long getPollingInterval() throws ServiceException {
        long safeguard;
        long interval;
        String val = this.getAttr("zimbraDataSourcePollingInterval");
        Provisioning prov = Provisioning.getInstance();
        Account account = this.getAccount(prov);
        if (val != null) {
            interval = this.getTimeInterval("zimbraDataSourcePollingInterval", 0L);
        } else {
            this.migratePollingIntervalIfNecessary(prov, account);
            switch (this.getType()) {
                case pop3: {
                    interval = account.getDataSourcePop3PollingInterval();
                    break;
                }
                case imap: {
                    interval = account.getDataSourceImapPollingInterval();
                    break;
                }
                case rss: {
                    interval = account.getDataSourceRssPollingInterval();
                    break;
                }
                case caldav: {
                    interval = account.getDataSourceCaldavPollingInterval();
                    break;
                }
                case yab: {
                    interval = account.getDataSourceYabPollingInterval();
                    break;
                }
                case cal: {
                    interval = account.getDataSourceCalendarPollingInterval();
                    break;
                }
                case gal: {
                    interval = account.getDataSourceGalPollingInterval();
                    break;
                }
                default: {
                    return 0L;
                }
            }
        }
        if (interval < 0L) {
            return 0L;
        }
        long min = account.getDataSourceMinPollingInterval();
        if (min < (safeguard = 10000L)) {
            min = safeguard;
        }
        if (0L < interval && interval < min) {
            interval = min;
        }
        return interval;
    }

    private void migratePollingIntervalIfNecessary(Provisioning prov, Account account) throws ServiceException {
        Cos cos;
        String oldInterval = account.getAttr("zimbraDataSourcePollingInterval", false);
        if (!StringUtil.isNullOrEmpty(oldInterval)) {
            ZimbraLog.datasource.info("Migrating account POP3 and IMAP polling intervals to %s.", oldInterval);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraDataSourcePollingInterval", "");
            attrs.put("zimbraDataSourcePop3PollingInterval", oldInterval);
            attrs.put("zimbraDataSourceImapPollingInterval", oldInterval);
            prov.modifyAttrs((Entry)account, attrs, true, false);
        }
        if (!StringUtil.isNullOrEmpty(oldInterval = (cos = account.getCOS()).getAttr("zimbraDataSourcePollingInterval", false))) {
            ZimbraLog.datasource.info("Migrating COS POP3 and IMAP polling intervals to %s.", oldInterval);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraDataSourcePollingInterval", "");
            attrs.put("zimbraDataSourcePop3PollingInterval", oldInterval);
            attrs.put("zimbraDataSourceImapPollingInterval", oldInterval);
            prov.modifyAttrs((Entry)cos, attrs, true, false);
        }
    }

    public boolean isScheduled() throws ServiceException {
        return this.getPollingInterval() > 0L;
    }

    public boolean leaveOnServer() {
        return this.getBooleanAttr("zimbraDataSourceLeaveOnServer", true);
    }

    public String getEmailAddress() {
        return this.getAttr("zimbraDataSourceEmailAddress");
    }

    public boolean useAddressForForwardReply() {
        return this.getBooleanAttr("zimbraDataSourceUseAddressForForwardReply", false);
    }

    public String getDefaultSignature() {
        return this.getAttr("zimbraPrefDefaultSignatureId");
    }

    public String getFromDisplay() {
        return this.getAttr("zimbraPrefFromDisplay");
    }

    public String getFromAddress() {
        return this.getAttr("zimbraPrefFromAddress");
    }

    public String getReplyToAddress() {
        return this.getAttr("zimbraPrefReplyToAddress");
    }

    public String getReplyToDisplay() {
        return this.getAttr("zimbraPrefReplyToDisplay");
    }

    public boolean isDebugTraceEnabled() {
        return this.getBooleanAttr("zimbraDataSourceEnableTrace", false);
    }

    public String mapRemoteToLocalPath(String remotePath) {
        return null;
    }

    public String mapLocalToRemotePath(String localPath) {
        return null;
    }

    public boolean ignoreRemotePath(String remotePath) {
        return false;
    }

    public boolean isSyncInboxOnly() {
        return false;
    }

    public boolean isSyncEnabled(String localPath) {
        return true;
    }

    public boolean isSaveToSent() {
        return true;
    }

    public boolean isOffline() {
        return false;
    }

    public boolean checkPendingMessages() throws ServiceException {
        return false;
    }

    public long getSyncFrequency() {
        return 0L;
    }

    public boolean hasSyncState(int folderId) {
        return false;
    }

    public SyncState getSyncState(int folderId) {
        return null;
    }

    public SyncState removeSyncState(int folderId) {
        return null;
    }

    public void putSyncState(int folderId, SyncState state) {
    }

    public void clearSyncState(int folderId) {
    }

    public void reportError(int itemId, String error, Exception e) {
    }

    private static byte[] randomSalt() {
        SecureRandom random = new SecureRandom();
        byte[] pad = new byte[16];
        random.nextBytes(pad);
        return pad;
    }

    private static Cipher getCipher(String dataSourceId, byte[] salt, boolean encrypt2) throws GeneralSecurityException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(salt);
        md5.update(dataSourceId.getBytes("utf-8"));
        byte[] key = md5.digest();
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(encrypt2 ? 1 : 2, skeySpec);
        return cipher;
    }

    public static String encryptData(String dataSourceId, String data) throws ServiceException {
        try {
            byte[] salt = DataSource.randomSalt();
            Cipher cipher = DataSource.getCipher(dataSourceId, salt, true);
            byte[] dataBytes = cipher.doFinal(data.getBytes("utf-8"));
            byte[] toEncode = new byte[VERSION.length + salt.length + dataBytes.length];
            System.arraycopy(VERSION, 0, toEncode, 0, VERSION.length);
            System.arraycopy(salt, 0, toEncode, VERSION.length, salt.length);
            System.arraycopy(dataBytes, 0, toEncode, VERSION.length + salt.length, dataBytes.length);
            return new String(Base64.encodeBase64((byte[])toEncode));
        }
        catch (UnsupportedEncodingException e) {
            throw ServiceException.FAILURE("caught unsupport encoding exception", e);
        }
        catch (GeneralSecurityException e) {
            throw ServiceException.FAILURE("caught security exception", e);
        }
    }

    public static String decryptData(String dataSourceId, String data) throws ServiceException {
        try {
            byte[] encoded = Base64.decodeBase64((byte[])data.getBytes());
            if (encoded.length < VERSION.length + 16 + 16) {
                throw ServiceException.FAILURE("invalid encoded size: " + encoded.length, null);
            }
            byte[] version = new byte[VERSION.length];
            byte[] salt = new byte[16];
            System.arraycopy(encoded, 0, version, 0, VERSION.length);
            if (!Arrays.equals(version, VERSION)) {
                throw ServiceException.FAILURE("unsupported version", null);
            }
            System.arraycopy(encoded, VERSION.length, salt, 0, 16);
            Cipher cipher = DataSource.getCipher(dataSourceId, salt, false);
            return new String(cipher.doFinal(encoded, VERSION.length + 16, encoded.length - 16 - VERSION.length), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw ServiceException.FAILURE("caught unsupport encoding exception", e);
        }
        catch (GeneralSecurityException e) {
            throw ServiceException.FAILURE("caught security exception", e);
        }
    }

    @Override
    public String toString() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("id=" + this.getId());
        parts.add("type=" + (Object)((Object)this.getType()));
        parts.add("isEnabled=" + this.isEnabled());
        if (this.getName() != null) {
            parts.add("name=" + this.getName());
        }
        if (this.getHost() != null) {
            parts.add("host=" + this.getHost());
        }
        if (this.getPort() != null) {
            parts.add("port=" + this.getPort());
        }
        if (this.getConnectionType() != null) {
            parts.add("connectionType=" + this.getConnectionType().name());
        }
        if (this.getUsername() != null) {
            parts.add("username=" + this.getUsername());
        }
        parts.add("folderId=" + this.getFolderId());
        return String.format("%s: { %s }", SIMPLE_CLASS_NAME, StringUtil.join(", ", parts));
    }

    public static void main(String[] args) throws ServiceException {
        String dataSourceId = UUID.randomUUID().toString();
        String enc = DataSource.encryptData(dataSourceId, "helloworld");
        System.out.println(enc);
        System.out.println(DataSource.decryptData(dataSourceId, enc));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DataImport {
        public void test() throws ServiceException;

        public void importData(List<Integer> var1, boolean var2) throws ServiceException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        cleartext,
        ssl,
        tls,
        tls_if_available;


        public static ConnectionType fromString(String s) throws ServiceException {
            try {
                return ConnectionType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("invalid type: " + s + ", valid values: " + Arrays.asList(Type.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        pop3,
        imap,
        caldav,
        yab,
        rss,
        cal,
        gal,
        xsync;


        public static Type fromString(String s) throws ServiceException {
            try {
                return Type.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("invalid type: " + s + ", valid values: " + Arrays.asList(Type.values()), e);
            }
        }
    }
}

