/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttrCos;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cos
extends ZAttrCos {
    private Map<String, Object> mAccountDefaults = new HashMap<String, Object>();

    public Cos(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, prov);
        this.resetData();
    }

    public void modify(Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    public Cos copyCos(String destCosName) throws ServiceException {
        return this.getProvisioning().copyCos(this.getId(), destCosName);
    }

    public void renameCos(String newName) throws ServiceException {
        this.getProvisioning().renameCos(this.getId(), newName);
    }

    public void deleteCos() throws ServiceException {
        this.getProvisioning().deleteCos(this.getId());
    }

    @Override
    protected void resetData() {
        super.resetData();
        try {
            this.getDefaults(AttributeFlag.accountInherited, this.mAccountDefaults);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public Map<String, Object> getAccountDefaults() {
        return this.mAccountDefaults;
    }

    public boolean isDefaultCos() {
        return this.getName().equals("default");
    }
}

