/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttrConfig;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
extends ZAttrConfig {
    private Map<String, Object> mDomainDefaults = new HashMap<String, Object>();
    private Map<String, Object> mServerDefaults = new HashMap<String, Object>();

    public Config(Map<String, Object> attrs, Provisioning provisioning) {
        super(attrs, provisioning);
        this.resetData();
    }

    @Override
    public String getLabel() {
        return "globalconfig";
    }

    public void modify(Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    public void resetData() {
        super.resetData();
        try {
            this.getDefaults(AttributeFlag.domainInherited, this.mDomainDefaults);
            this.getDefaults(AttributeFlag.serverInherited, this.mServerDefaults);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public Map<String, Object> getDomainDefaults() {
        return this.mDomainDefaults;
    }

    public Map<String, Object> getServerDefaults() {
        return this.mServerDefaults;
    }
}

