/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import java.util.HashMap;
import java.util.Map;

public abstract class CacheExtension {
    private static Map<String, CacheExtension> mHandlers;

    public static synchronized void register(String cacheType, CacheExtension handler) {
        if (mHandlers == null) {
            mHandlers = new HashMap<String, CacheExtension>();
        } else {
            CacheExtension obj = mHandlers.get(cacheType);
            if (obj != null) {
                ZimbraLog.account.warn("cache type " + cacheType + " is already registered, " + "registering of " + obj.getClass().getCanonicalName() + " is ignored");
                return;
            }
            Provisioning.CacheEntryType cet = null;
            try {
                cet = Provisioning.CacheEntryType.fromString(cacheType);
            }
            catch (ServiceException e) {
                // empty catch block
            }
            if (cet != null) {
                ZimbraLog.account.warn("cache type " + cacheType + " is one of the internal cache type, " + "registering of " + obj.getClass().getCanonicalName() + " is ignored");
                return;
            }
        }
        mHandlers.put(cacheType, handler);
    }

    public static synchronized CacheExtension getHandler(String cacheType) {
        if (mHandlers == null) {
            return null;
        }
        return mHandlers.get(cacheType);
    }

    public abstract void flushCache() throws ServiceException;
}

