/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import java.security.SecureRandom;
import java.util.HashMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class AuthTokenKey {
    public static final int KEY_SIZE_BYTES = 32;
    private byte[] mKey;
    private long mVersion;
    private long mCreated;
    private static HashMap<String, AuthTokenKey> mCache = new HashMap();
    private static AuthTokenKey sLatestKey;

    public byte[] getKey() {
        return this.mKey;
    }

    public long getVersion() {
        return this.mVersion;
    }

    public long getCreated() {
        return this.mCreated;
    }

    void setKey(byte[] key) {
        this.mKey = key;
    }

    AuthTokenKey(long version, byte[] key) throws ServiceException {
        this.mVersion = version;
        this.mCreated = System.currentTimeMillis();
        if (key != null) {
            this.mKey = key;
        } else {
            SecureRandom random = new SecureRandom();
            this.mKey = new byte[32];
            random.nextBytes(this.mKey);
        }
    }

    private AuthTokenKey(String k) throws ServiceException {
        String[] parts = k.split(":");
        if (parts.length != 3) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key", null);
        }
        String ver = parts[0];
        String created = parts[1];
        String data = parts[2];
        try {
            this.mVersion = Long.parseLong(ver);
        }
        catch (NumberFormatException e) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key version", e);
        }
        try {
            this.mCreated = Long.parseLong(created);
        }
        catch (NumberFormatException e) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key created data", e);
        }
        try {
            this.mKey = Hex.decodeHex((char[])data.toCharArray());
        }
        catch (DecoderException e) {
            throw ServiceException.INVALID_REQUEST("invalid auth token key data", e);
        }
    }

    public String getEncoded() {
        return this.mVersion + ":" + this.mCreated + ":" + new String(Hex.encodeHex((byte[])this.mKey));
    }

    public static AuthTokenKey getVersion(String version) throws ServiceException {
        AuthTokenKey key = mCache.get(version);
        if (key == null) {
            AuthTokenKey.refresh(false);
        }
        if ((key = mCache.get(version)) == null) {
            AuthTokenKey.refresh(true);
        }
        key = mCache.get(version);
        return key;
    }

    private static synchronized void refresh(boolean reload) throws ServiceException {
        String[] keys;
        Provisioning prov = Provisioning.getInstance();
        Config config = prov.getConfig();
        if (reload) {
            prov.reload(config);
        }
        if ((keys = config.getMultiAttr("zimbraAuthTokenKey")).length == 0) {
            prov.reload(config);
            keys = config.getMultiAttr("zimbraAuthTokenKey");
        }
        if (keys.length == 0) {
            AuthTokenKey key = new AuthTokenKey(0L, null);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraAuthTokenKey", key.getEncoded());
            Provisioning.getInstance().modifyAttrs(config, attrs);
            keys = config.getMultiAttr("zimbraAuthTokenKey");
        }
        for (int i = 0; i < keys.length; ++i) {
            AuthTokenKey key = mCache.get(keys[i]);
            if (key != null) continue;
            key = new AuthTokenKey(keys[i]);
            mCache.put(keys[i], key);
            mCache.put(Long.toString(key.mVersion), key);
            if (sLatestKey != null && AuthTokenKey.sLatestKey.mVersion >= key.mVersion) continue;
            sLatestKey = key;
        }
    }

    static synchronized AuthTokenKey getCurrentKey() throws ServiceException {
        if (sLatestKey == null) {
            AuthTokenKey.refresh(false);
        }
        return sLatestKey;
    }
}

