/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.ZimbraAuthToken;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;

public abstract class AuthToken {
    public static final long DEFAULT_AUTH_LIFETIME = 43200L;

    public static String generateDigest(String a, String b) {
        if (a == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(a);
        buf.append(":");
        if (b != null) {
            buf.append(b);
        }
        return ByteUtil.getDigest(buf.toString().getBytes());
    }

    public static boolean isAnyAdmin(AuthToken authToken) {
        return authToken.isAdmin() || authToken.isDomainAdmin() || authToken.isDelegatedAdmin();
    }

    public abstract String toString();

    public abstract String getAccountId();

    public abstract String getAdminAccountId();

    public abstract long getExpires();

    public int getValidityValue() {
        return -1;
    }

    public abstract boolean isExpired();

    public abstract boolean isAdmin();

    public abstract boolean isDomainAdmin();

    public abstract boolean isDelegatedAdmin();

    public abstract boolean isZimbraUser();

    public abstract String getExternalUserEmail();

    public abstract String getDigest();

    public abstract String getCrumb() throws AuthTokenException;

    public boolean isDelegatedAuth() {
        return this.getAdminAccountId() != null && !this.getAdminAccountId().equals("");
    }

    public String getAccessKey() {
        return null;
    }

    public void setProxyAuthToken(String encoded) {
    }

    public String getProxyAuthToken() {
        return null;
    }

    public void resetProxyAuthToken() {
    }

    public abstract void encode(HttpClient var1, HttpMethod var2, boolean var3, String var4) throws ServiceException;

    public abstract void encode(HttpState var1, boolean var2, String var3) throws ServiceException;

    public abstract void encode(HttpServletResponse var1, boolean var2, boolean var3) throws ServiceException;

    public abstract void encodeAuthResp(Element var1, boolean var2) throws ServiceException;

    public abstract ZAuthToken toZAuthToken() throws ServiceException;

    public abstract String getEncoded() throws AuthTokenException;

    public static AuthToken getAuthToken(String encoded) throws AuthTokenException {
        return ZimbraAuthToken.getAuthToken(encoded);
    }

    public static AuthToken getAuthToken(String acctId, String externalEmail, String pass, String digest, long expires) {
        return new ZimbraAuthToken(acctId, externalEmail, pass, digest, expires);
    }

    public static AuthToken getZimbraAdminAuthToken() throws ServiceException {
        return ZimbraAuthToken.getZimbraAdminAuthToken();
    }

    public static Map getInfo(String encoded) throws AuthTokenException {
        return ZimbraAuthToken.getInfo(encoded);
    }
}

