/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.AttributeCardinality;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.AttributeInfo;
import com.zimbra.cs.account.AttributeOrder;
import com.zimbra.cs.account.AttributeServerType;
import com.zimbra.cs.account.AttributeType;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.FileGenUtil;
import com.zimbra.cs.account.callback.IDNCallback;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import com.zimbra.cs.util.BuildInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeManager {
    private static final String E_ATTRS = "attrs";
    private static final String E_OBJECTCLASSES = "objectclasses";
    private static final String A_GROUP = "group";
    private static final String A_GROUP_ID = "groupid";
    private static final String E_ATTR = "attr";
    private static final String A_NAME = "name";
    private static final String A_IMMUTABLE = "immutable";
    private static final String A_TYPE = "type";
    private static final String A_ORDER = "order";
    private static final String A_VALUE = "value";
    static final String A_MAX = "max";
    static final String A_MIN = "min";
    private static final String A_CALLBACK = "callback";
    private static final String A_ID = "id";
    private static final String A_PARENT_OID = "parentOid";
    private static final String A_CARDINALITY = "cardinality";
    private static final String A_REQUIRED_IN = "requiredIn";
    private static final String A_OPTIONAL_IN = "optionalIn";
    private static final String A_FLAGS = "flags";
    private static final String A_DEPRECATED_SINCE = "deprecatedSince";
    private static final String A_SINCE = "since";
    private static final String A_REQUIRES_RESTART = "requiresRestart";
    private static final String E_OBJECTCLASS = "objectclass";
    private static final String E_SUP = "sup";
    private static final String E_COMMENT = "comment";
    private static final String E_DESCRIPTION = "desc";
    private static final String E_DEPRECATE_DESC = "deprecateDesc";
    private static final String E_GLOBAL_CONFIG_VALUE = "globalConfigValue";
    private static final String E_GLOBAL_CONFIG_VALUE_UPGRADE = "globalConfigValueUpgrade";
    private static final String E_DEFAULT_COS_VALUE = "defaultCOSValue";
    private static final String E_DEFAULT_COS_VALUE_UPGRADE = "defaultCOSValueUpgrade";
    private static final String ML_CONT_PREFIX = "  ";
    private static AttributeManager mInstance;
    private Map<String, AttributeInfo> mAttrs = new HashMap<String, AttributeInfo>();
    private Map<String, ObjectClassInfo> mOCs = new HashMap<String, ObjectClassInfo>();
    private Map<AttributeClass, Set<String>> mClassToAttrsMap = new HashMap<AttributeClass, Set<String>>();
    private Map<AttributeClass, Set<String>> mClassToLowerCaseAttrsMap = new HashMap<AttributeClass, Set<String>>();
    private Map<AttributeClass, Set<String>> mClassToAllAttrsMap = new HashMap<AttributeClass, Set<String>>();
    private boolean mLdapSchemaExtensionInited = false;
    private AttributeCallback mIDNCallback = new IDNCallback();
    private static Map<Integer, String> mGroupMap;
    private static Map<Integer, String> mOCGroupMap;
    private List<String> mErrors = new LinkedList<String>();
    private Map<AttributeFlag, Set<String>> mFlagToAttrsMap = new HashMap<AttributeFlag, Set<String>>();
    private static Log mLog;
    private static Options mOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeManager getInstance() throws ServiceException {
        Class<AttributeManager> clazz = AttributeManager.class;
        synchronized (AttributeManager.class) {
            if (mInstance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mInstance;
            }
            String dir = LC.zimbra_attrs_directory.value();
            mInstance = new AttributeManager(dir);
            if (mInstance.hasErrors()) {
                throw ServiceException.FAILURE(mInstance.getErrors(), null);
            }
            mInstance.computeClassToAllAttrsMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private AttributeManager(String dir) throws ServiceException {
        File[] files;
        this.initFlagsToAttrsMap();
        this.initClassToAttrsMap();
        File fdir = new File(dir);
        if (!fdir.exists()) {
            throw ServiceException.FAILURE("attrs directory does not exists: " + dir, null);
        }
        if (!fdir.isDirectory()) {
            throw ServiceException.FAILURE("attrs directory is not a directory: " + dir, null);
        }
        for (File file : files = fdir.listFiles()) {
            if (!file.getPath().endsWith(".xml")) {
                ZimbraLog.misc.warn("while loading attrs, ignoring not .xml file: " + file);
                continue;
            }
            if (!file.isFile()) {
                ZimbraLog.misc.warn("while loading attrs, ignored non-file: " + file);
            }
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read(file);
                Element root = doc.getRootElement();
                if (root.getName().equals(E_ATTRS)) {
                    this.loadAttrs(file);
                    continue;
                }
                if (root.getName().equals(E_OBJECTCLASSES)) {
                    this.loadObjectClasses(file);
                    continue;
                }
                ZimbraLog.misc.warn("while loading attrs, ignored unknown file: " + file);
            }
            catch (DocumentException de) {
                throw ServiceException.FAILURE("error loading attrs file: " + file, de);
            }
        }
    }

    private boolean hasErrors() {
        return this.mErrors.size() > 0;
    }

    private String getErrors() {
        StringBuilder result = new StringBuilder();
        for (String error : this.mErrors) {
            result.append(error).append("\n");
        }
        return result.toString();
    }

    private void error(String attrName, File file, String error) {
        if (attrName != null) {
            this.mErrors.add("attr " + attrName + " in file " + file + ": " + error);
        } else {
            this.mErrors.add("file " + file + ": " + error);
        }
    }

    private void loadAttrs(File file) throws DocumentException {
        String groupIdStr;
        SAXReader reader = new SAXReader();
        Document doc = reader.read(file);
        Element root = doc.getRootElement();
        if (!root.getName().equals(E_ATTRS)) {
            this.error(null, file, "root tag is not attrs");
            return;
        }
        String group = root.attributeValue(A_GROUP);
        if (group == null ^ (groupIdStr = root.attributeValue(A_GROUP_ID)) == null) {
            this.error(null, file, "group and groupid both have to be both specified");
        }
        int groupId = -1;
        if (group != null) {
            try {
                groupId = Integer.valueOf(groupIdStr);
            }
            catch (NumberFormatException nfe) {
                this.error(null, file, "groupid is not a number: " + groupIdStr);
            }
        }
        if (groupId == 2) {
            this.error(null, file, "groupid is not valid (used by ZimbraObjectClass)");
        } else if (groupId > 0) {
            if (mGroupMap.containsKey(groupId)) {
                this.error(null, file, "duplicate group id: " + groupId);
            } else if (mGroupMap.containsValue(group)) {
                this.error(null, file, "duplicate group: " + group);
            } else {
                mGroupMap.put(groupId, group);
            }
        }
        Iterator iter = root.elementIterator();
        block12: while (iter.hasNext()) {
            Element eattr = (Element)iter.next();
            if (!eattr.getName().equals(E_ATTR)) {
                this.error(null, file, "unknown element: " + eattr.getName());
                continue;
            }
            AttributeCallback callback = null;
            AttributeType type = null;
            AttributeOrder order = null;
            String value = null;
            String min = null;
            String max = null;
            boolean immutable = false;
            int id = -1;
            String parentOid = null;
            AttributeCardinality cardinality = null;
            Set<AttributeClass> requiredIn = null;
            Set<AttributeClass> optionalIn = null;
            Set<AttributeFlag> flags = null;
            String canonicalName = null;
            String name = eattr.attributeValue(A_NAME);
            if (name == null) {
                this.error(null, file, "no name specified");
                continue;
            }
            canonicalName = name.toLowerCase();
            List<AttributeServerType> requiresRestart = null;
            BuildInfo.Version deprecatedSinceVer = null;
            BuildInfo.Version sinceVer = null;
            Iterator attrIter = eattr.attributeIterator();
            while (attrIter.hasNext()) {
                Attribute attr = (Attribute)attrIter.next();
                String aname = attr.getName();
                if (aname.equals(A_NAME)) continue;
                if (aname.equals(A_CALLBACK)) {
                    callback = AttributeManager.loadCallback(attr.getValue());
                    continue;
                }
                if (aname.equals(A_IMMUTABLE)) {
                    immutable = "1".equals(attr.getValue());
                    continue;
                }
                if (aname.equals(A_MAX)) {
                    max = attr.getValue();
                    continue;
                }
                if (aname.equals(A_MIN)) {
                    min = attr.getValue();
                    continue;
                }
                if (aname.equals(A_TYPE)) {
                    type = AttributeType.getType(attr.getValue());
                    if (type != null) continue;
                    this.error(name, file, "unknown <attr> type: " + attr.getValue());
                    continue block12;
                }
                if (aname.equals(A_VALUE)) {
                    value = attr.getValue();
                    continue;
                }
                if (aname.equals(A_PARENT_OID)) {
                    parentOid = attr.getValue();
                    if (parentOid.matches("^\\d+(\\.\\d+)+")) continue;
                    this.error(name, file, "invalid parent OID " + parentOid + ": must be an OID");
                    continue;
                }
                if (aname.equals(A_ID)) {
                    try {
                        id = Integer.parseInt(attr.getValue());
                        if (id >= 0) continue;
                        this.error(name, file, "invalid id " + id + ": must be positive");
                    }
                    catch (NumberFormatException nfe) {
                        this.error(name, file, aname + " is not a number: " + attr.getValue());
                    }
                    continue;
                }
                if (aname.equals(A_CARDINALITY)) {
                    try {
                        cardinality = AttributeCardinality.valueOf(attr.getValue());
                    }
                    catch (IllegalArgumentException iae) {
                        this.error(name, file, aname + " is not valid: " + attr.getValue());
                    }
                    continue;
                }
                if (aname.equals(A_REQUIRED_IN)) {
                    requiredIn = this.parseClasses(name, file, attr.getValue());
                    continue;
                }
                if (aname.equals(A_OPTIONAL_IN)) {
                    optionalIn = this.parseClasses(name, file, attr.getValue());
                    continue;
                }
                if (aname.equals(A_FLAGS)) {
                    flags = this.parseFlags(name, file, attr.getValue());
                    continue;
                }
                if (aname.equals(A_ORDER)) {
                    try {
                        order = AttributeOrder.valueOf(attr.getValue());
                    }
                    catch (IllegalArgumentException iae) {
                        this.error(name, file, aname + " is not valid: " + attr.getValue());
                    }
                    continue;
                }
                if (aname.equals(A_REQUIRES_RESTART)) {
                    requiresRestart = this.parseRequiresRestart(name, file, attr.getValue());
                    continue;
                }
                if (aname.equals(A_DEPRECATED_SINCE)) {
                    String depreSince = attr.getValue();
                    if (depreSince == null) continue;
                    try {
                        deprecatedSinceVer = new BuildInfo.Version(depreSince);
                    }
                    catch (ServiceException e) {
                        this.error(name, file, aname + " is not valid: " + attr.getValue() + " (" + e.getMessage() + ")");
                    }
                    continue;
                }
                if (aname.equals(A_SINCE)) {
                    String since = attr.getValue();
                    if (since == null) continue;
                    try {
                        sinceVer = new BuildInfo.Version(since);
                    }
                    catch (ServiceException e) {
                        this.error(name, file, aname + " is not valid: " + attr.getValue() + " (" + e.getMessage() + ")");
                    }
                    continue;
                }
                this.error(name, file, "unknown <attr> attr: " + aname);
            }
            LinkedList<String> globalConfigValues = new LinkedList<String>();
            LinkedList<String> globalConfigValuesUpgrade = null;
            LinkedList<String> defaultCOSValues = new LinkedList<String>();
            LinkedList<String> defaultCOSValuesUpgrade = null;
            String description = null;
            String deprecateDesc = null;
            Iterator elemIter = eattr.elementIterator();
            while (elemIter.hasNext()) {
                Element elem = (Element)elemIter.next();
                if (elem.getName().equals(E_GLOBAL_CONFIG_VALUE)) {
                    globalConfigValues.add(elem.getText());
                    continue;
                }
                if (elem.getName().equals(E_GLOBAL_CONFIG_VALUE_UPGRADE)) {
                    if (globalConfigValuesUpgrade == null) {
                        globalConfigValuesUpgrade = new LinkedList<String>();
                    }
                    globalConfigValuesUpgrade.add(elem.getText());
                    continue;
                }
                if (elem.getName().equals(E_DEFAULT_COS_VALUE)) {
                    defaultCOSValues.add(elem.getText());
                    continue;
                }
                if (elem.getName().equals(E_DEFAULT_COS_VALUE_UPGRADE)) {
                    if (defaultCOSValuesUpgrade == null) {
                        defaultCOSValuesUpgrade = new LinkedList<String>();
                    }
                    defaultCOSValuesUpgrade.add(elem.getText());
                    continue;
                }
                if (elem.getName().equals(E_DESCRIPTION)) {
                    if (description != null) {
                        this.error(name, file, "more than one desc");
                    }
                    description = elem.getText();
                    continue;
                }
                if (elem.getName().equals(E_DEPRECATE_DESC)) {
                    if (deprecateDesc != null) {
                        this.error(name, file, "more than one deprecateDesc");
                    }
                    deprecateDesc = elem.getText();
                    continue;
                }
                this.error(name, file, "unknown element: " + elem.getName());
            }
            if (deprecatedSinceVer != null && deprecateDesc == null) {
                this.error(name, file, "missing attr deprecatedSince");
            } else if (deprecatedSinceVer == null && deprecateDesc != null) {
                this.error(name, file, "missing element deprecateDesc");
            }
            if (deprecatedSinceVer != null) {
                String deprecateInfo = "Deprecated since: " + deprecatedSinceVer.toString() + ".  " + deprecateDesc;
                description = description == null ? deprecateInfo : deprecateInfo + ".  Orig desc: " + description;
            }
            if (sinceVer == null && id >= 525) {
                this.error(name, file, "missing since (required after(inclusive) oid 710)");
            }
            if (id > 0 && cardinality == null) {
                this.error(name, file, "cardinality not specified");
            }
            if (id > 0 && optionalIn != null && optionalIn.isEmpty() && requiredIn != null && requiredIn.isEmpty()) {
                this.error(name, file, "atleast one of requiredIn or optionalIn must be specified");
            }
            this.checkFlag(name, file, flags, AttributeFlag.accountInherited, AttributeClass.account, AttributeClass.cos, null, requiredIn, optionalIn);
            this.checkFlag(name, file, flags, AttributeFlag.accountCosDomainInherited, AttributeClass.account, AttributeClass.cos, AttributeClass.domain, requiredIn, optionalIn);
            this.checkFlag(name, file, flags, AttributeFlag.domainInherited, AttributeClass.domain, AttributeClass.globalConfig, null, requiredIn, optionalIn);
            this.checkFlag(name, file, flags, AttributeFlag.serverInherited, AttributeClass.server, AttributeClass.globalConfig, null, requiredIn, optionalIn);
            if (cardinality == AttributeCardinality.single) {
                if (globalConfigValues.size() > 1) {
                    this.error(name, file, "more than one global config value specified for cardinality " + (Object)((Object)AttributeCardinality.single));
                }
                if (defaultCOSValues.size() > 1) {
                    this.error(name, file, "more than one default COS value specified for cardinality " + (Object)((Object)AttributeCardinality.single));
                }
            }
            AttributeInfo info = new AttributeInfo(name, id, parentOid, groupId, callback, type, order, value, immutable, min, max, cardinality, requiredIn, optionalIn, flags, globalConfigValues, defaultCOSValues, globalConfigValuesUpgrade, defaultCOSValuesUpgrade, description, requiresRestart, sinceVer, deprecatedSinceVer);
            if (this.mAttrs.get(canonicalName) != null) {
                this.error(name, file, "duplicate definiton");
            }
            this.mAttrs.put(canonicalName, info);
            if (flags != null) {
                for (AttributeFlag flag : flags) {
                    this.mFlagToAttrsMap.get((Object)flag).add(name);
                    if (flag != AttributeFlag.accountCosDomainInherited) continue;
                    this.mFlagToAttrsMap.get((Object)AttributeFlag.accountInherited).add(name);
                }
            }
            if (requiredIn == null && optionalIn == null) continue;
            if (requiredIn != null) {
                for (AttributeClass klass : requiredIn) {
                    this.mClassToAttrsMap.get((Object)klass).add(name);
                    this.mClassToLowerCaseAttrsMap.get((Object)klass).add(name.toLowerCase());
                }
            }
            if (optionalIn == null) continue;
            for (AttributeClass klass : optionalIn) {
                this.mClassToAttrsMap.get((Object)klass).add(name);
                this.mClassToLowerCaseAttrsMap.get((Object)klass).add(name.toLowerCase());
            }
        }
    }

    private void loadObjectClasses(File file) throws DocumentException {
        String groupIdStr;
        SAXReader reader = new SAXReader();
        Document doc = reader.read(file);
        Element root = doc.getRootElement();
        if (!root.getName().equals(E_OBJECTCLASSES)) {
            this.error(null, file, "root tag is not objectclasses");
            return;
        }
        String group = root.attributeValue(A_GROUP);
        if (group == null ^ (groupIdStr = root.attributeValue(A_GROUP_ID)) == null) {
            this.error(null, file, "group and groupid both have to be both specified");
        }
        int groupId = -1;
        if (group != null) {
            try {
                groupId = Integer.valueOf(groupIdStr);
            }
            catch (NumberFormatException nfe) {
                this.error(null, file, "groupid is not a number: " + groupIdStr);
            }
        }
        if (groupId == 1) {
            this.error(null, file, "groupid is not valid (used by ZimbraAttrType)");
        } else if (groupId > 0) {
            if (mOCGroupMap.containsKey(groupId)) {
                this.error(null, file, "duplicate group id: " + groupId);
            } else if (mOCGroupMap.containsValue(group)) {
                this.error(null, file, "duplicate group: " + group);
            } else {
                mOCGroupMap.put(groupId, group);
            }
        }
        Iterator iter = root.elementIterator();
        while (iter.hasNext()) {
            AttributeClass attrClass;
            Element eattr = (Element)iter.next();
            if (!eattr.getName().equals(E_OBJECTCLASS)) {
                this.error(null, file, "unknown element: " + eattr.getName());
                continue;
            }
            int id = -1;
            ObjectClassType type = null;
            String canonicalName = null;
            String name = eattr.attributeValue(A_NAME);
            if (name == null) {
                this.error(null, file, "no name specified");
                continue;
            }
            canonicalName = name.toLowerCase();
            Iterator attrIter = eattr.attributeIterator();
            while (attrIter.hasNext()) {
                Attribute attr = (Attribute)attrIter.next();
                String aname = attr.getName();
                if (aname.equals(A_NAME)) continue;
                if (aname.equals(A_TYPE)) {
                    type = ObjectClassType.valueOf(attr.getValue());
                    continue;
                }
                if (aname.equals(A_ID)) {
                    try {
                        id = Integer.parseInt(attr.getValue());
                        if (id >= 0) continue;
                        this.error(name, file, "invalid id " + id + ": must be positive");
                    }
                    catch (NumberFormatException nfe) {
                        this.error(name, file, aname + " is not a number: " + attr.getValue());
                    }
                    continue;
                }
                this.error(name, file, "unknown <attr> attr: " + aname);
            }
            LinkedList<String> superOCs = new LinkedList<String>();
            String description = null;
            ArrayList<String> comment = null;
            Iterator elemIter = eattr.elementIterator();
            while (elemIter.hasNext()) {
                Element elem = (Element)elemIter.next();
                if (elem.getName().equals(E_SUP)) {
                    superOCs.add(elem.getText());
                    continue;
                }
                if (elem.getName().equals(E_DESCRIPTION)) {
                    if (description != null) {
                        this.error(name, file, "more than one desc");
                    }
                    description = elem.getText();
                    continue;
                }
                if (elem.getName().equals(E_COMMENT)) {
                    String[] lines;
                    if (comment != null) {
                        this.error(name, file, "more than one comment");
                    }
                    comment = new ArrayList<String>();
                    for (String line : lines = elem.getText().trim().split("\\n")) {
                        comment.add(line.trim());
                    }
                    continue;
                }
                this.error(name, file, "unknown element: " + elem.getName());
            }
            if (id <= 0) {
                this.error(name, file, "id not specified");
            }
            if (type == null) {
                this.error(name, file, "type not specified");
            }
            if (description == null) {
                this.error(name, file, "desc not specified");
            }
            if (superOCs.isEmpty()) {
                this.error(name, file, "sup not specified");
            }
            if ((attrClass = AttributeClass.getAttributeClass(name)) == null) {
                this.error(name, file, "unknown class in AttributeClass: " + name);
            }
            ObjectClassInfo info = new ObjectClassInfo(attrClass, name, id, groupId, type, superOCs, description, comment);
            if (this.mOCs.get(canonicalName) != null) {
                this.error(name, file, "duplicate objectclass definiton");
            }
            this.mOCs.put(canonicalName, info);
        }
    }

    private Set<AttributeClass> parseClasses(String attrName, File file, String value) {
        String[] cnames;
        HashSet<AttributeClass> result = new HashSet<AttributeClass>();
        for (String cname : cnames = value.split(",")) {
            try {
                AttributeClass ac = AttributeClass.valueOf(cname);
                if (result.contains((Object)ac)) {
                    this.error(attrName, file, "duplicate class: " + cname);
                }
                result.add(ac);
            }
            catch (IllegalArgumentException iae) {
                this.error(attrName, file, "invalid class: " + cname);
            }
        }
        return result;
    }

    private Set<AttributeFlag> parseFlags(String attrName, File file, String value) {
        String[] flags;
        HashSet<AttributeFlag> result = new HashSet<AttributeFlag>();
        for (String flag : flags = value.split(",")) {
            try {
                AttributeFlag ac = AttributeFlag.valueOf(flag);
                if (result.contains((Object)ac)) {
                    this.error(attrName, file, "duplicate flag: " + flag);
                }
                result.add(ac);
            }
            catch (IllegalArgumentException iae) {
                this.error(attrName, file, "invalid flag: " + flag);
            }
        }
        return result;
    }

    private void checkFlag(String attrName, File file, Set<AttributeFlag> flags, AttributeFlag flag, AttributeClass c1, AttributeClass c2, AttributeClass c3, Set<AttributeClass> required, Set<AttributeClass> optional) {
        if (flags != null && flags.contains((Object)flag)) {
            boolean inC3;
            boolean inC2;
            boolean inC1 = optional != null && optional.contains((Object)c1) || required != null && required.contains((Object)c1);
            boolean bl = inC2 = optional != null && optional.contains((Object)c2) || required != null && required.contains((Object)c2);
            boolean bl2 = c3 == null ? true : (inC3 = optional != null && optional.contains((Object)c3) || required != null && required.contains((Object)c3));
            if (!(inC1 && inC2 && inC3)) {
                String classes = (Object)((Object)c1) + " and " + (Object)((Object)c2) + (c3 == null ? "" : " and " + (Object)((Object)c3));
                this.error(attrName, file, "flag " + (Object)((Object)flag) + " requires that attr be in all these classes: " + classes);
            }
        }
    }

    private List<AttributeServerType> parseRequiresRestart(String attrName, File file, String value) {
        String[] serverTypes;
        ArrayList<AttributeServerType> result = new ArrayList<AttributeServerType>();
        for (String server : serverTypes = value.split(",")) {
            try {
                AttributeServerType ast = AttributeServerType.valueOf(server);
                if (result.contains((Object)ast)) {
                    this.error(attrName, file, "duplicate server type: " + server);
                }
                result.add(ast);
            }
            catch (IllegalArgumentException iae) {
                this.error(attrName, file, "invalid server type: " + server);
            }
        }
        return result;
    }

    private void initClassToAttrsMap() {
        for (AttributeClass klass : AttributeClass.values()) {
            this.mClassToAttrsMap.put(klass, new HashSet());
            this.mClassToLowerCaseAttrsMap.put(klass, new HashSet());
        }
    }

    private void computeClassToAllAttrsMap() {
        block11: for (AttributeClass klass : this.mClassToAttrsMap.keySet()) {
            switch (klass) {
                case account: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.mailRecipient), this.mClassToAttrsMap.get((Object)AttributeClass.account));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case calendarResource: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.mailRecipient), this.mClassToAttrsMap.get((Object)AttributeClass.account));
                    attrs = SetUtil.union(attrs, this.mClassToAttrsMap.get((Object)AttributeClass.calendarResource));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case distributionList: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.mailRecipient), this.mClassToAttrsMap.get((Object)AttributeClass.distributionList));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case imapDataSource: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.dataSource), this.mClassToAttrsMap.get((Object)AttributeClass.imapDataSource));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case pop3DataSource: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.dataSource), this.mClassToAttrsMap.get((Object)AttributeClass.pop3DataSource));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case rssDataSource: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.dataSource), this.mClassToAttrsMap.get((Object)AttributeClass.rssDataSource));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case liveDataSource: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.dataSource), this.mClassToAttrsMap.get((Object)AttributeClass.liveDataSource));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case galDataSource: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.dataSource), this.mClassToAttrsMap.get((Object)AttributeClass.galDataSource));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
                case domain: {
                    Set<String> attrs = SetUtil.union(new HashSet(), this.mClassToAttrsMap.get((Object)AttributeClass.mailRecipient), this.mClassToAttrsMap.get((Object)AttributeClass.domain));
                    this.mClassToAllAttrsMap.put(klass, attrs);
                    continue block11;
                }
            }
            this.mClassToAllAttrsMap.put(klass, this.mClassToAttrsMap.get((Object)klass));
        }
    }

    private void initFlagsToAttrsMap() {
        for (AttributeFlag flag : AttributeFlag.values()) {
            this.mFlagToAttrsMap.put(flag, new HashSet());
        }
    }

    public boolean isAccountInherited(String attr) {
        return this.mFlagToAttrsMap.get((Object)AttributeFlag.accountInherited).contains(attr);
    }

    public boolean isAccountCosDomainInherited(String attr) {
        return this.mFlagToAttrsMap.get((Object)AttributeFlag.accountCosDomainInherited).contains(attr);
    }

    public boolean isDomainInherited(String attr) {
        return this.mFlagToAttrsMap.get((Object)AttributeFlag.domainInherited).contains(attr);
    }

    public boolean isServerInherited(String attr) {
        return this.mFlagToAttrsMap.get((Object)AttributeFlag.serverInherited).contains(attr);
    }

    public boolean isDomainAdminModifiable(String attr, AttributeClass klass) throws ServiceException {
        if (!this.mClassToAllAttrsMap.get((Object)klass).contains(attr)) {
            throw AccountServiceException.INVALID_ATTR_NAME("unknown attribute on " + klass.name() + ": " + attr, null);
        }
        return this.mFlagToAttrsMap.get((Object)AttributeFlag.domainAdminModifiable).contains(attr);
    }

    public void makeDomainAdminModifiable(String attr) {
        this.mFlagToAttrsMap.get((Object)AttributeFlag.domainAdminModifiable).add(attr);
    }

    public static IDNType idnType(AttributeManager am, String attr) {
        if (am == null) {
            return IDNType.none;
        }
        return am.idnType(attr);
    }

    private IDNType idnType(String attr) {
        AttributeInfo ai = this.mAttrs.get(attr.toLowerCase());
        if (ai != null) {
            AttributeType at = ai.getType();
            if (at == AttributeType.TYPE_EMAIL) {
                return IDNType.email;
            }
            if (at == AttributeType.TYPE_EMAILP) {
                return IDNType.emailp;
            }
            if (at == AttributeType.TYPE_CS_EMAILP) {
                return IDNType.cs_emailp;
            }
            if (this.mFlagToAttrsMap.get((Object)AttributeFlag.idn).contains(attr)) {
                return IDNType.idn;
            }
        }
        return IDNType.none;
    }

    public boolean inVersion(String attr, String version) throws ServiceException {
        AttributeInfo ai = this.mAttrs.get(attr.toLowerCase());
        if (ai != null) {
            BuildInfo.Version since = ai.getSince();
            if (since == null) {
                return true;
            }
            return since.compare(version) <= 0;
        }
        throw AccountServiceException.INVALID_ATTR_NAME("unknown attribute: " + attr, null);
    }

    public AttributeType getAttributeType(String attr) throws ServiceException {
        AttributeInfo ai = this.mAttrs.get(attr.toLowerCase());
        if (ai != null) {
            return ai.getType();
        }
        throw AccountServiceException.INVALID_ATTR_NAME("unknown attribute: " + attr, null);
    }

    private boolean hasFlag(AttributeFlag flag, String attr) {
        return this.mFlagToAttrsMap.get((Object)flag).contains(attr);
    }

    public Set<String> getAttrsWithFlag(AttributeFlag flag) {
        return this.mFlagToAttrsMap.get((Object)flag);
    }

    public Set<String> getAttrsInClass(AttributeClass klass) {
        return this.mClassToAttrsMap.get((Object)klass);
    }

    public Set<String> getAllAttrsInClass(AttributeClass klass) {
        return this.mClassToAllAttrsMap.get((Object)klass);
    }

    public Set<String> getLowerCaseAttrsInClass(AttributeClass klass) {
        return this.mClassToLowerCaseAttrsMap.get((Object)klass);
    }

    public Set<String> getImmutableAttrs() {
        HashSet<String> immutable = new HashSet<String>();
        for (AttributeInfo info : this.mAttrs.values()) {
            if (info == null || !info.isImmutable()) continue;
            immutable.add(info.getName());
        }
        return immutable;
    }

    public Set<String> getImmutableAttrsInClass(AttributeClass klass) {
        HashSet<String> immutable = new HashSet<String>();
        for (String attr : this.mClassToAttrsMap.get((Object)klass)) {
            AttributeInfo info = this.mAttrs.get(attr.toLowerCase());
            if (info != null) {
                if (!info.isImmutable()) continue;
                immutable.add(attr);
                continue;
            }
            ZimbraLog.misc.warn("getImmutableAttrsInClass: no attribute info for: " + attr);
        }
        return immutable;
    }

    private static AttributeCallback loadCallback(String clazz) {
        AttributeCallback cb = null;
        if (clazz == null) {
            return null;
        }
        if (clazz.indexOf(46) == -1) {
            clazz = "com.zimbra.cs.account.callback." + clazz;
        }
        try {
            cb = (AttributeCallback)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            ZimbraLog.misc.warn((Object)"loadCallback caught exception", e);
        }
        return cb;
    }

    public void preModify(Map<String, ? extends Object> attrs, Entry entry, Map context, boolean isCreate, boolean checkImmutable) throws ServiceException {
        this.preModify(attrs, entry, context, isCreate, checkImmutable, true);
    }

    public void preModify(Map<String, ? extends Object> attrs, Entry entry, Map context, boolean isCreate, boolean checkImmutable, boolean allowCallback) throws ServiceException {
        String[] keys = attrs.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            AttributeInfo info;
            String name = keys[i];
            if (name.length() == 0) {
                throw AccountServiceException.INVALID_ATTR_NAME("empty attr name found", null);
            }
            Object value = attrs.get(name);
            if (name.charAt(0) == '-' || name.charAt(0) == '+') {
                name = name.substring(1);
            }
            if ((info = this.mAttrs.get(name.toLowerCase())) != null) {
                if (this.idnType(name).isEmailOrIDN()) {
                    this.mIDNCallback.preModify(context, name, value, attrs, entry, isCreate);
                    value = attrs.get(name);
                }
                info.checkValue(value, checkImmutable);
                if (!allowCallback || info.getCallback() == null) continue;
                info.getCallback().preModify(context, name, value, attrs, entry, isCreate);
                continue;
            }
            ZimbraLog.misc.warn("checkValue: no attribute info for: " + name);
        }
    }

    public void postModify(Map<String, ? extends Object> attrs, Entry entry, Map context, boolean isCreate) {
        this.postModify(attrs, entry, context, isCreate, true);
    }

    public void postModify(Map<String, ? extends Object> attrs, Entry entry, Map context, boolean isCreate, boolean allowCallback) {
        String[] keys = attrs.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            AttributeInfo info;
            String name = keys[i];
            if (name.charAt(0) == '-' || name.charAt(0) == '+') {
                name = name.substring(1);
            }
            if ((info = this.mAttrs.get(name.toLowerCase())) == null || !allowCallback || info.getCallback() == null) continue;
            try {
                info.getCallback().postModify(context, name, entry, isCreate);
                continue;
            }
            catch (Exception e) {
                ZimbraLog.account.warn((Object)("postModify caught exception: " + e.getMessage()), e);
            }
        }
    }

    private static void usage(String errmsg) {
        if (errmsg != null) {
            mLog.error(errmsg);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("AttributeManager [options] where [options] are one of:", mOptions);
        System.exit(errmsg == null ? 0 : 1);
    }

    private static CommandLine parseArgs(String[] args) {
        StringBuffer gotCL = new StringBuffer("cmdline: ");
        for (int i = 0; i < args.length; ++i) {
            gotCL.append("'").append(args[i]).append("' ");
        }
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(mOptions, args);
        }
        catch (ParseException pe) {
            AttributeManager.usage(pe.getMessage());
        }
        if (cl.hasOption('h')) {
            AttributeManager.usage(null);
        }
        return cl;
    }

    public static void main(String[] args) throws IOException, ServiceException {
        CliUtil.toolSetup();
        CommandLine cl = AttributeManager.parseArgs(args);
        if (!cl.hasOption('a')) {
            AttributeManager.usage("no action specified");
        }
        String actionStr = cl.getOptionValue('a');
        Action action = null;
        try {
            action = Action.valueOf(actionStr);
        }
        catch (IllegalArgumentException iae) {
            AttributeManager.usage("unknown action: " + actionStr);
        }
        AttributeManager am = null;
        if (action != Action.dump && action != Action.listAttrs) {
            if (!cl.hasOption('i')) {
                AttributeManager.usage("no input attribute xml files specified");
            }
            if ((am = new AttributeManager(cl.getOptionValue('i'))).hasErrors()) {
                ZimbraLog.misc.warn(am.getErrors());
                System.exit(1);
            }
        }
        OutputStream os = System.out;
        if (cl.hasOption('o')) {
            os = new FileOutputStream(cl.getOptionValue('o'));
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, "utf8")));
        switch (action) {
            case generateDefaultCOSLdif: {
                am.generateDefaultCOSLdif(pw);
                break;
            }
            case generateGlobalConfigLdif: {
                am.generateGlobalConfigLdif(pw);
                break;
            }
            case generateLdapSchema: {
                if (!cl.hasOption('t')) {
                    AttributeManager.usage("no schema template specified");
                }
                am.generateLdapSchema(pw, cl.getOptionValue('t'));
                break;
            }
            case generateSchemaLdif: {
                am.generateSchemaLdif(pw);
                break;
            }
            case dump: {
                AttributeManager.dumpSchema(pw);
                break;
            }
            case listAttrs: {
                AttributeManager.listAttrs(pw, cl.getOptionValues('c'), cl.getOptionValues('n'), cl.getOptionValues('f'));
                break;
            }
            case generateGetters: {
                am.generateGetters(cl.getOptionValue('c'), cl.getOptionValue('r'));
                break;
            }
            case generateProvisioning: {
                am.generateProvisioningConstants(cl.getOptionValue('r'));
            }
        }
        pw.close();
    }

    private void generateGlobalConfigLdif(PrintWriter pw) {
        pw.println("# DO NOT MODIFY - generated by AttributeManager.");
        pw.println("# LDAP entry that contains initial default Zimbra global config.");
        pw.println("# " + CLOptions.buildVersion());
        String baseDn = CLOptions.getBaseDn("config");
        pw.println("dn: cn=config," + baseDn);
        pw.println("objectclass: organizationalRole");
        pw.println("cn: config");
        pw.println("objectclass: zimbraGlobalConfig");
        LinkedList<String> out = new LinkedList<String>();
        for (AttributeInfo attr : this.mAttrs.values()) {
            List<String> gcv = attr.getGlobalConfigValues();
            if (gcv == null) continue;
            for (String v : gcv) {
                out.add(attr.getName() + ": " + v);
            }
        }
        Object[] outs = out.toArray(new String[0]);
        Arrays.sort(outs);
        for (Object o : outs) {
            pw.println((String)o);
        }
    }

    private void generateDefaultCOSLdif(PrintWriter pw) {
        pw.println("# DO NOT MODIFY - generated by AttributeManager.");
        pw.println("# LDAP entry for the default Zimbra COS.");
        pw.println("# " + CLOptions.buildVersion());
        String baseDn = CLOptions.getBaseDn("cos");
        String cosName = CLOptions.getEntryName("cos", "default");
        String cosId = CLOptions.getEntryId("cos", "e00428a1-0c00-11d9-836a-000d93afea2a");
        pw.println("dn: cn=" + cosName + ",cn=cos," + baseDn);
        pw.println("cn: " + cosName);
        pw.println("objectclass: zimbraCOS");
        pw.println("zimbraId: " + cosId);
        pw.println("description: The " + cosName + " COS");
        LinkedList<String> out = new LinkedList<String>();
        for (AttributeInfo attr : this.mAttrs.values()) {
            List<String> gcv = attr.getDefaultCosValues();
            if (gcv == null) continue;
            for (String v : gcv) {
                out.add(attr.getName() + ": " + v);
            }
        }
        Object[] outs = out.toArray(new String[0]);
        Arrays.sort(outs);
        for (Object o : outs) {
            pw.println((String)o);
        }
    }

    private void buildSchemaBanner(StringBuilder BANNER) {
        BANNER.append("#\n");
        BANNER.append("# Zimbra LDAP Schema\n");
        BANNER.append("#\n");
        BANNER.append("# DO NOT MODIFY - generated by AttributeManager.\n");
        BANNER.append("#\n");
        BANNER.append("# " + CLOptions.buildVersion() + "\n");
        BANNER.append("#\n");
        BANNER.append("# our root OID (http://www.iana.org/assignments/enterprise-numbers)\n");
        BANNER.append("#\n");
        BANNER.append("#  1.3.6.1.4.1.19348\n");
        BANNER.append("#  1.3.6.1.4.1.19348.2      LDAP elements\n");
        BANNER.append("#  1.3.6.1.4.1.19348.2.1    Attribute Types\n");
        BANNER.append("#  1.3.6.1.4.1.19348.2.2    Object Classes\n");
        BANNER.append("#");
    }

    private void buildAttrDef(StringBuilder ATTRIBUTE_DEFINITIONS, AttributeInfo ai) {
        ATTRIBUTE_DEFINITIONS.append("( " + ai.getName() + "\n");
        ATTRIBUTE_DEFINITIONS.append("  NAME ( '" + ai.getName() + "' )\n");
        ATTRIBUTE_DEFINITIONS.append("  DESC '" + ai.getDescription() + "'\n");
        String syntax = null;
        String substr = null;
        String equality = null;
        String ordering = null;
        switch (ai.getType()) {
            case TYPE_BOOLEAN: {
                syntax = "1.3.6.1.4.1.1466.115.121.1.7";
                equality = "booleanMatch";
                break;
            }
            case TYPE_EMAIL: 
            case TYPE_EMAILP: 
            case TYPE_CS_EMAILP: {
                syntax = "1.3.6.1.4.1.1466.115.121.1.26{256}";
                equality = "caseIgnoreIA5Match";
                substr = "caseIgnoreSubstringsMatch";
                break;
            }
            case TYPE_GENTIME: {
                syntax = "1.3.6.1.4.1.1466.115.121.1.24";
                equality = "generalizedTimeMatch";
                ordering = "generalizedTimeOrderingMatch ";
                break;
            }
            case TYPE_ID: {
                syntax = "1.3.6.1.4.1.1466.115.121.1.15{256}";
                equality = "caseIgnoreMatch";
                substr = "caseIgnoreSubstringsMatch";
                break;
            }
            case TYPE_DURATION: {
                syntax = "1.3.6.1.4.1.1466.115.121.1.26{32}";
                equality = "caseIgnoreIA5Match";
                break;
            }
            case TYPE_ENUM: {
                int maxLen = Math.max(32, ai.getEnumValueMaxLength());
                syntax = "1.3.6.1.4.1.1466.115.121.1.15{" + maxLen + "}";
                equality = "caseIgnoreMatch";
                substr = "caseIgnoreSubstringsMatch";
                break;
            }
            case TYPE_INTEGER: 
            case TYPE_PORT: 
            case TYPE_LONG: {
                syntax = "1.3.6.1.4.1.1466.115.121.1.27";
                equality = "integerMatch";
                break;
            }
            case TYPE_STRING: 
            case TYPE_REGEX: {
                String lengthSuffix = "";
                if (ai.getMax() != Long.MAX_VALUE) {
                    lengthSuffix = "{" + ai.getMax() + "}";
                }
                syntax = "1.3.6.1.4.1.1466.115.121.1.15" + lengthSuffix;
                equality = "caseIgnoreMatch";
                substr = "caseIgnoreSubstringsMatch";
                break;
            }
            case TYPE_ASTRING: {
                String lengthSuffix = "";
                if (ai.getMax() != Long.MAX_VALUE) {
                    lengthSuffix = "{" + ai.getMax() + "}";
                }
                syntax = "1.3.6.1.4.1.1466.115.121.1.26" + lengthSuffix;
                equality = "caseIgnoreIA5Match";
                substr = "caseIgnoreSubstringsMatch";
                break;
            }
            case TYPE_OSTRING: {
                String lengthSuffix = "";
                if (ai.getMax() != Long.MAX_VALUE) {
                    lengthSuffix = "{" + ai.getMax() + "}";
                }
                syntax = "1.3.6.1.4.1.1466.115.121.1.40" + lengthSuffix;
                equality = "octetStringMatch";
                break;
            }
            case TYPE_CSTRING: {
                String lengthSuffix = "";
                if (ai.getMax() != Long.MAX_VALUE) {
                    lengthSuffix = "{" + ai.getMax() + "}";
                }
                syntax = "1.3.6.1.4.1.1466.115.121.1.15" + lengthSuffix;
                equality = "caseExactMatch";
                substr = "caseExactSubstringsMatch";
                break;
            }
            case TYPE_PHONE: {
                String lengthSuffix = "";
                if (ai.getMax() != Long.MAX_VALUE) {
                    lengthSuffix = "{" + ai.getMax() + "}";
                }
                syntax = "1.3.6.1.4.1.1466.115.121.1.50" + lengthSuffix;
                equality = "telephoneNumberMatch";
                substr = "telephoneNumberSubstringsMatch";
                break;
            }
            default: {
                throw new RuntimeException("unknown type encountered!");
            }
        }
        ATTRIBUTE_DEFINITIONS.append("  SYNTAX " + syntax + "\n");
        ATTRIBUTE_DEFINITIONS.append("  EQUALITY " + equality);
        if (substr != null) {
            ATTRIBUTE_DEFINITIONS.append("\n  SUBSTR " + substr);
        }
        if (ordering != null) {
            ATTRIBUTE_DEFINITIONS.append("\n  ORDERING " + ordering);
        } else if (ai.getOrder() != null) {
            ATTRIBUTE_DEFINITIONS.append("\n  ORDERING " + (Object)((Object)ai.getOrder()));
        }
        if (ai.getCardinality() == AttributeCardinality.single) {
            ATTRIBUTE_DEFINITIONS.append("\n  SINGLE-VALUE");
        }
        ATTRIBUTE_DEFINITIONS.append(")");
    }

    private void buildZimbraRootOIDs(StringBuilder ZIMBRA_ROOT_OIDS, String prefix) {
        ZIMBRA_ROOT_OIDS.append(prefix + "ZimbraRoot 1.3.6.1.4.1.19348\n");
        ZIMBRA_ROOT_OIDS.append(prefix + "ZimbraLDAP ZimbraRoot:2\n");
    }

    private void buildObjectClassOIDs(StringBuilder OC_GROUP_OIDS, StringBuilder OC_OIDS, String prefix) {
        for (int i : mOCGroupMap.keySet()) {
            OC_GROUP_OIDS.append(prefix + mOCGroupMap.get(i) + " ZimbraLDAP:" + i + "\n");
            List<ObjectClassInfo> list = this.getOCList(i);
            this.sortOCsByOID(list);
            for (ObjectClassInfo oci : list) {
                OC_OIDS.append(prefix + oci.getName() + " " + mOCGroupMap.get(i) + ':' + oci.getId() + "\n");
            }
        }
    }

    private void buildObjectClassDefs(StringBuilder OC_DEFINITIONS, String prefix, boolean blankLineSeperator) {
        for (AttributeClass cls : AttributeClass.values()) {
            String ocName = cls.getOCName();
            String ocCanonicalName = ocName.toLowerCase();
            ObjectClassInfo oci = this.mOCs.get(ocCanonicalName);
            if (oci == null) continue;
            List<String> comment = oci.getComment();
            OC_DEFINITIONS.append("#\n");
            for (String line : comment) {
                if (line.length() > 0) {
                    OC_DEFINITIONS.append("# " + line + "\n");
                    continue;
                }
                OC_DEFINITIONS.append("#\n");
            }
            OC_DEFINITIONS.append("#\n");
            OC_DEFINITIONS.append(prefix + "( " + oci.getName() + "\n");
            OC_DEFINITIONS.append("  NAME '" + oci.getName() + "'\n");
            OC_DEFINITIONS.append("  DESC '" + oci.getDescription() + "'\n");
            OC_DEFINITIONS.append("  SUP ");
            for (String sup : oci.getSuperOCs()) {
                OC_DEFINITIONS.append(sup);
            }
            OC_DEFINITIONS.append(" " + (Object)((Object)oci.getType()) + "\n");
            StringBuilder value = new StringBuilder();
            this.buildObjectClassAttrs(cls, value);
            OC_DEFINITIONS.append((CharSequence)value);
            OC_DEFINITIONS.append(")\n");
            if (!blankLineSeperator) continue;
            OC_DEFINITIONS.append("\n");
        }
    }

    private void buildObjectClassAttrs(AttributeClass cls, StringBuilder value) {
        LinkedList<String> must = new LinkedList<String>();
        LinkedList<String> may = new LinkedList<String>();
        for (AttributeInfo ai : this.mAttrs.values()) {
            if (ai.requiredInClass(cls)) {
                must.add(ai.getName());
            }
            if (!ai.optionalInClass(cls)) continue;
            may.add(ai.getName());
        }
        Collections.sort(must);
        Collections.sort(may);
        if (!must.isEmpty()) {
            value.append("  MUST (\n");
            Iterator mustIter = must.iterator();
            while (true) {
                value.append("    ").append((String)mustIter.next());
                if (!mustIter.hasNext()) break;
                value.append(" $\n");
            }
            value.append("\n  )\n");
        }
        if (!may.isEmpty()) {
            value.append("  MAY (\n");
            Iterator mayIter = may.iterator();
            while (true) {
                value.append("    ").append((String)mayIter.next());
                if (!mayIter.hasNext()) break;
                value.append(" $\n");
            }
            value.append("\n  )\n");
        }
        value.append(ML_CONT_PREFIX);
    }

    private List<AttributeInfo> getAttrList(int groupId) {
        ArrayList<AttributeInfo> list = new ArrayList<AttributeInfo>(this.mAttrs.size());
        for (AttributeInfo ai : this.mAttrs.values()) {
            if (ai.getId() <= -1 || ai.getGroupId() != groupId) continue;
            list.add(ai);
        }
        return list;
    }

    private void sortAttrsByOID(List<AttributeInfo> list) {
        Collections.sort(list, new Comparator<AttributeInfo>(){

            @Override
            public int compare(AttributeInfo a1, AttributeInfo b1) {
                return a1.getId() - b1.getId();
            }
        });
    }

    private void sortAttrsByName(List<AttributeInfo> list) {
        Collections.sort(list, new Comparator<AttributeInfo>(){

            @Override
            public int compare(AttributeInfo a1, AttributeInfo b1) {
                return a1.getName().compareTo(b1.getName());
            }
        });
    }

    private List<ObjectClassInfo> getOCList(int groupId) {
        ArrayList<ObjectClassInfo> list = new ArrayList<ObjectClassInfo>(this.mOCs.size());
        for (ObjectClassInfo oci : this.mOCs.values()) {
            if (oci.getId() <= -1 || oci.getGroupId() != groupId) continue;
            list.add(oci);
        }
        return list;
    }

    private void sortOCsByOID(List<ObjectClassInfo> list) {
        Collections.sort(list, new Comparator<ObjectClassInfo>(){

            @Override
            public int compare(ObjectClassInfo oc1, ObjectClassInfo oc2) {
                return oc1.getId() - oc2.getId();
            }
        });
    }

    private void sortOCsByName(List<ObjectClassInfo> list) {
        Collections.sort(list, new Comparator<ObjectClassInfo>(){

            @Override
            public int compare(ObjectClassInfo oc1, ObjectClassInfo oc2) {
                return oc1.getName().compareTo(oc2.getName());
            }
        });
    }

    private void generateLdapSchema_old(PrintWriter pw, String schemaTemplateFile) throws IOException {
        byte[] templateBytes = ByteUtil.getContent(new File(schemaTemplateFile));
        String templateString = new String(templateBytes, "utf-8");
        StringBuilder GROUP_OIDS = new StringBuilder();
        StringBuilder ATTRIBUTE_OIDS = new StringBuilder();
        StringBuilder ATTRIBUTE_DEFINITIONS = new StringBuilder();
        for (int i : mGroupMap.keySet()) {
            GROUP_OIDS.append("objectIdentifier " + mGroupMap.get(i) + " ZimbraLDAP:" + i + "\n");
            List<AttributeInfo> list = this.getAttrList(i);
            this.sortAttrsByOID(list);
            for (AttributeInfo ai : list) {
                String parentOid = ai.getParentOid();
                if (parentOid == null) {
                    ATTRIBUTE_OIDS.append("objectIdentifier " + ai.getName() + " " + mGroupMap.get(i) + ':' + ai.getId() + "\n");
                    continue;
                }
                ATTRIBUTE_OIDS.append("objectIdentifier " + ai.getName() + " " + parentOid + "." + ai.getId() + "\n");
            }
            this.sortAttrsByName(list);
            for (AttributeInfo ai : list) {
                ATTRIBUTE_DEFINITIONS.append("attributetype ");
                this.buildAttrDef(ATTRIBUTE_DEFINITIONS, ai);
                ATTRIBUTE_DEFINITIONS.append("\n\n");
            }
        }
        HashMap<String, String> templateFillers = new HashMap<String, String>();
        templateFillers.put("SCHEMA_VERSION_INFO", CLOptions.buildVersion());
        templateFillers.put("GROUP_OIDS", GROUP_OIDS.toString());
        templateFillers.put("ATTRIBUTE_OIDS", ATTRIBUTE_OIDS.toString());
        templateFillers.put("ATTRIBUTE_DEFINITIONS", ATTRIBUTE_DEFINITIONS.toString());
        for (AttributeClass cls : AttributeClass.values()) {
            String key = "CLASS_MEMBERS_" + cls.toString().toUpperCase();
            StringBuilder value = new StringBuilder();
            this.buildObjectClassAttrs(cls, value);
            templateFillers.put(key, value.toString());
        }
        pw.print(StringUtil.fillTemplate(templateString, templateFillers));
    }

    private void generateLdapSchema(PrintWriter pw, String schemaTemplateFile) throws IOException {
        byte[] templateBytes = ByteUtil.getContent(new File(schemaTemplateFile));
        String templateString = new String(templateBytes, "utf-8");
        StringBuilder BANNER = new StringBuilder();
        StringBuilder ZIMBRA_ROOT_OIDS = new StringBuilder();
        StringBuilder GROUP_OIDS = new StringBuilder();
        StringBuilder ATTRIBUTE_OIDS = new StringBuilder();
        StringBuilder ATTRIBUTE_DEFINITIONS = new StringBuilder();
        StringBuilder OC_GROUP_OIDS = new StringBuilder();
        StringBuilder OC_OIDS = new StringBuilder();
        StringBuilder OC_DEFINITIONS = new StringBuilder();
        this.buildSchemaBanner(BANNER);
        this.buildZimbraRootOIDs(ZIMBRA_ROOT_OIDS, "objectIdentifier ");
        for (int i : mGroupMap.keySet()) {
            GROUP_OIDS.append("objectIdentifier " + mGroupMap.get(i) + " ZimbraLDAP:" + i + "\n");
            List<AttributeInfo> list = this.getAttrList(i);
            this.sortAttrsByOID(list);
            for (AttributeInfo ai : list) {
                String parentOid = ai.getParentOid();
                if (parentOid == null) {
                    ATTRIBUTE_OIDS.append("objectIdentifier " + ai.getName() + " " + mGroupMap.get(i) + ':' + ai.getId() + "\n");
                    continue;
                }
                ATTRIBUTE_OIDS.append("objectIdentifier " + ai.getName() + " " + parentOid + "." + ai.getId() + "\n");
            }
            this.sortAttrsByName(list);
            for (AttributeInfo ai : list) {
                ATTRIBUTE_DEFINITIONS.append("attributetype ");
                this.buildAttrDef(ATTRIBUTE_DEFINITIONS, ai);
                ATTRIBUTE_DEFINITIONS.append("\n\n");
            }
        }
        this.buildObjectClassOIDs(OC_GROUP_OIDS, OC_OIDS, "objectIdentifier ");
        this.buildObjectClassDefs(OC_DEFINITIONS, "objectclass ", true);
        HashMap<String, String> templateFillers = new HashMap<String, String>();
        templateFillers.put("BANNER", BANNER.toString());
        templateFillers.put("ZIMBRA_ROOT_OIDS", ZIMBRA_ROOT_OIDS.toString());
        templateFillers.put("GROUP_OIDS", GROUP_OIDS.toString());
        templateFillers.put("ATTRIBUTE_OIDS", ATTRIBUTE_OIDS.toString());
        templateFillers.put("OC_GROUP_OIDS", OC_GROUP_OIDS.toString());
        templateFillers.put("OC_OIDS", OC_OIDS.toString());
        templateFillers.put("ATTRIBUTE_DEFINITIONS", ATTRIBUTE_DEFINITIONS.toString());
        templateFillers.put("OC_DEFINITIONS", OC_DEFINITIONS.toString());
        pw.print(StringUtil.fillTemplate(templateString, templateFillers));
    }

    private void generateSchemaLdif(PrintWriter pw) {
        StringBuilder BANNER = new StringBuilder();
        StringBuilder ZIMBRA_ROOT_OIDS = new StringBuilder();
        StringBuilder ATTRIBUTE_GROUP_OIDS = new StringBuilder();
        StringBuilder ATTRIBUTE_OIDS = new StringBuilder();
        StringBuilder ATTRIBUTE_DEFINITIONS = new StringBuilder();
        StringBuilder OC_GROUP_OIDS = new StringBuilder();
        StringBuilder OC_OIDS = new StringBuilder();
        StringBuilder OC_DEFINITIONS = new StringBuilder();
        this.buildSchemaBanner(BANNER);
        this.buildZimbraRootOIDs(ZIMBRA_ROOT_OIDS, "olcObjectIdentifier: ");
        for (int i : mGroupMap.keySet()) {
            ATTRIBUTE_GROUP_OIDS.append("olcObjectIdentifier: " + mGroupMap.get(i) + " ZimbraLDAP:" + i + "\n");
            List<AttributeInfo> list = this.getAttrList(i);
            this.sortAttrsByOID(list);
            for (AttributeInfo ai : list) {
                String parentOid = ai.getParentOid();
                if (parentOid == null) {
                    ATTRIBUTE_OIDS.append("olcObjectIdentifier: " + ai.getName() + " " + mGroupMap.get(i) + ':' + ai.getId() + "\n");
                    continue;
                }
                ATTRIBUTE_OIDS.append("olcObjectIdentifier: " + ai.getName() + " " + parentOid + "." + ai.getId() + "\n");
            }
            this.sortAttrsByName(list);
            ATTRIBUTE_DEFINITIONS.append("olcAttributeTypes: ( 1.2.840.113556.1.2.146\n");
            ATTRIBUTE_DEFINITIONS.append("  NAME ( 'company' )\n");
            ATTRIBUTE_DEFINITIONS.append("  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15{512}\n");
            ATTRIBUTE_DEFINITIONS.append("  EQUALITY caseIgnoreMatch\n");
            ATTRIBUTE_DEFINITIONS.append("  SUBSTR caseIgnoreSubstringsMatch\n");
            ATTRIBUTE_DEFINITIONS.append("  SINGLE-VALUE )\n");
            for (AttributeInfo ai : list) {
                ATTRIBUTE_DEFINITIONS.append("olcAttributeTypes: ");
                this.buildAttrDef(ATTRIBUTE_DEFINITIONS, ai);
                ATTRIBUTE_DEFINITIONS.append("\n");
            }
        }
        this.buildObjectClassOIDs(OC_GROUP_OIDS, OC_OIDS, "olcObjectIdentifier: ");
        this.buildObjectClassDefs(OC_DEFINITIONS, "olcObjectClasses: ", false);
        pw.println(BANNER);
        pw.println("dn: cn=zimbra,cn=schema,cn=config");
        pw.println("objectClass: olcSchemaConfig");
        pw.println("cn: zimbra");
        pw.print(ZIMBRA_ROOT_OIDS);
        pw.print(ATTRIBUTE_GROUP_OIDS);
        pw.print(ATTRIBUTE_OIDS);
        pw.print(OC_GROUP_OIDS);
        pw.print(OC_OIDS);
        pw.print(ATTRIBUTE_DEFINITIONS);
        pw.print(OC_DEFINITIONS);
    }

    private static String sortCSL(String in) {
        Object[] ss = in.split("\\s*,\\s*");
        Arrays.sort(ss);
        StringBuilder sb = new StringBuilder(in.length());
        for (int i = 0; i < ss.length; ++i) {
            sb.append((String)ss[i]);
            if (i >= ss.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static void dumpAttrs(PrintWriter pw, String name, Attributes attrs) throws NamingException {
        NamingEnumeration<? extends javax.naming.directory.Attribute> attrIter = attrs.getAll();
        LinkedList<javax.naming.directory.Attribute> attrsList = new LinkedList<javax.naming.directory.Attribute>();
        while (attrIter.hasMore()) {
            attrsList.add(attrIter.next());
        }
        Collections.sort(attrsList, new Comparator<javax.naming.directory.Attribute>(){

            @Override
            public int compare(javax.naming.directory.Attribute a1, javax.naming.directory.Attribute b1) {
                return a1.getID().compareTo(b1.getID());
            }
        });
        for (javax.naming.directory.Attribute attr : attrsList) {
            NamingEnumeration<?> valIter = attr.getAll();
            LinkedList<String> values = new LinkedList<String>();
            while (valIter.hasMore()) {
                values.add((String)valIter.next());
            }
            Collections.sort(values);
            for (String val : values) {
                pw.println(name + ": " + attr.getID() + ": " + val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSchema(PrintWriter pw) throws ServiceException {
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            DirContext schema = zlc.getSchema();
            NamingEnumeration<NameClassPair> schemaTypeIter = schema.list("");
            while (schemaTypeIter.hasMore()) {
                String schemaType = schemaTypeIter.next().getName();
                NamingEnumeration<NameClassPair> schemaEntryIter = schema.list(schemaType);
                LinkedList<String> schemaEntries = new LinkedList<String>();
                while (schemaEntryIter.hasMore()) {
                    schemaEntries.add(schemaEntryIter.next().getName());
                }
                Collections.sort(schemaEntries);
                for (String schemaEntry : schemaEntries) {
                    DirContext sdc = (DirContext)schema.lookup(schemaType + "/" + schemaEntry);
                    AttributeManager.dumpAttrs(pw, schemaType + ": " + schemaEntry, sdc.getAttributes(""));
                }
            }
            AttributeManager.dumpAttrs(pw, "GlobalConfig", zlc.getAttributes("cn=config,cn=zimbra"));
            AttributeManager.dumpAttrs(pw, "DefaultCOS", zlc.getAttributes("cn=default,cn=cos,cn=zimbra"));
        }
        catch (NamingException ne) {
            try {
                ne.printStackTrace();
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
            ZimbraLdapContext.closeContext(zlc);
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    private static void listAttrs(PrintWriter pw, String[] inClass, String[] notInClass, String[] printFlags) throws ServiceException {
        AttributeManager am = AttributeManager.getInstance();
        if (inClass == null) {
            AttributeManager.usage("no class specified");
        }
        Set attrsInClass = new HashSet();
        for (String c : inClass) {
            AttributeClass ac = AttributeClass.valueOf(c);
            SetUtil.union(attrsInClass, am.getAttrsInClass(ac));
        }
        HashSet attrsNotInClass = new HashSet();
        if (notInClass != null) {
            for (String c : notInClass) {
                AttributeClass ac = AttributeClass.valueOf(c);
                SetUtil.union(attrsNotInClass, am.getAttrsInClass(ac));
            }
        }
        attrsInClass = SetUtil.subtract(attrsInClass, attrsNotInClass);
        ArrayList list = new ArrayList(attrsInClass);
        Collections.sort(list);
        for (String a : list) {
            StringBuffer flags = new StringBuffer();
            if (printFlags != null) {
                for (String f : printFlags) {
                    AttributeFlag af = AttributeFlag.valueOf(f);
                    if (!am.hasFlag(af, a)) continue;
                    if (flags.length() > 0) {
                        flags.append(", ");
                    }
                    flags.append(af.name());
                }
                if (flags.length() > 0) {
                    flags.insert(0, "(").append(")");
                }
            }
            System.out.println(a + " " + flags);
        }
    }

    public AttributeInfo getAttributeInfo(String name) {
        if (name == null) {
            return null;
        }
        return this.mAttrs.get(name.toLowerCase());
    }

    private void generateProvisioningConstants(String javaFile) throws ServiceException, IOException {
        AttributeInfo ai;
        ArrayList<String> list = new ArrayList<String>(this.mAttrs.keySet());
        Collections.sort(list);
        StringBuilder result = new StringBuilder();
        for (String a : list) {
            ai = this.mAttrs.get(a.toLowerCase());
            if (ai == null || ai.getType() != AttributeType.TYPE_ENUM) continue;
            AttributeManager.generateEnum(result, ai);
        }
        for (String a : list) {
            ai = this.mAttrs.get(a.toLowerCase());
            if (ai == null) continue;
            result.append("\n    /**\n");
            if (ai.getDescription() != null) {
                result.append(FileGenUtil.wrapComments(StringUtil.escapeHtml(ai.getDescription()), 70, "     * "));
                result.append("\n");
            }
            if (ai.getSince() != null) {
                result.append("     *\n");
                result.append(String.format("     * @since ZCS %s%n", ai.getSince().toString()));
            }
            result.append("     */\n");
            result.append(String.format("    @ZAttr(id=%d)%n", ai.getId()));
            result.append(String.format("    public static final String A_%s = \"%s\";%n", ai.getName(), ai.getName()));
        }
        FileGenUtil.replaceJavaFile(javaFile, result.toString());
    }

    private static String enumName(AttributeInfo ai) {
        String enumName = ai.getName();
        if (enumName.startsWith("zimbra")) {
            enumName = enumName.substring(6);
        }
        enumName = StringUtil.escapeJavaIdentifier(enumName.substring(0, 1).toUpperCase() + enumName.substring(1));
        return enumName;
    }

    private static void generateEnum(StringBuilder result, AttributeInfo ai) throws ServiceException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String v : ai.getEnumSet()) {
            values.put(v, StringUtil.escapeJavaIdentifier(v));
        }
        String enumName = AttributeManager.enumName(ai);
        result.append(String.format("%n", new Object[0]));
        result.append(String.format("    public static enum %s {%n", enumName));
        Set set = values.entrySet();
        int i = 1;
        for (Map.Entry entry : set) {
            result.append(String.format("        %s(\"%s\")%s%n", entry.getValue(), entry.getKey(), i == set.size() ? ";" : ","));
            ++i;
        }
        result.append(String.format("        private String mValue;%n", new Object[0]));
        result.append(String.format("        private %s(String value) { mValue = value; }%n", enumName));
        result.append(String.format("        public String toString() { return mValue; }%n", new Object[0]));
        result.append(String.format("        public static %s fromString(String s) throws ServiceException {%n", enumName));
        result.append(String.format("            for (%s value : values()) {%n", enumName));
        result.append(String.format("                if (value.mValue.equals(s)) return value;%n", new Object[0]));
        result.append(String.format("             }%n", new Object[0]));
        result.append(String.format("             throw ServiceException.INVALID_REQUEST(\"invalid value: \"+s+\", valid values: \"+ Arrays.asList(values()), null);%n", new Object[0]));
        result.append(String.format("        }%n", new Object[0]));
        for (Map.Entry entry : set) {
            result.append(String.format("        public boolean is%s() { return this == %s;}%n", StringUtil.capitalize((String)entry.getValue()), entry.getValue()));
        }
        result.append(String.format("    }%n", new Object[0]));
    }

    private void generateGetters(String inClass, String javaFile) throws ServiceException, IOException {
        if (inClass == null) {
            AttributeManager.usage("no class specified");
        }
        AttributeClass ac = AttributeClass.valueOf(inClass);
        Set<String> attrsInClass = this.getAttrsInClass(ac);
        if (ac == AttributeClass.account) {
            SetUtil.union(attrsInClass, this.getAttrsInClass(AttributeClass.mailRecipient));
        }
        ArrayList<String> list = new ArrayList<String>(attrsInClass);
        Collections.sort(list);
        StringBuilder result = new StringBuilder();
        block3: for (String a : list) {
            AttributeInfo ai = this.mAttrs.get(a.toLowerCase());
            if (ai == null) continue;
            switch (ai.getType()) {
                case TYPE_GENTIME: 
                case TYPE_DURATION: 
                case TYPE_ENUM: 
                case TYPE_PORT: {
                    AttributeManager.generateGetter(result, ai, false, ac);
                    AttributeManager.generateGetter(result, ai, true, ac);
                    AttributeManager.generateSetters(result, ai, false, SetterType.set);
                    if (ai.getType() == AttributeType.TYPE_GENTIME || ai.getType() == AttributeType.TYPE_ENUM || ai.getType() == AttributeType.TYPE_PORT) {
                        AttributeManager.generateSetters(result, ai, true, SetterType.set);
                    }
                    AttributeManager.generateSetters(result, ai, false, SetterType.unset);
                    continue block3;
                }
            }
            if (ai.getName().equalsIgnoreCase("zimbraLocale")) {
                AttributeManager.generateGetter(result, ai, true, ac);
            } else {
                AttributeManager.generateGetter(result, ai, false, ac);
            }
            AttributeManager.generateSetters(result, ai, false, SetterType.set);
            if (ai.getCardinality() == AttributeCardinality.multi) {
                AttributeManager.generateSetters(result, ai, false, SetterType.add);
                AttributeManager.generateSetters(result, ai, false, SetterType.remove);
            }
            AttributeManager.generateSetters(result, ai, false, SetterType.unset);
        }
        FileGenUtil.replaceJavaFile(javaFile, result.toString());
    }

    private static String defaultValue(AttributeInfo ai, AttributeClass ac) {
        List<String> values;
        switch (ac) {
            case account: 
            case calendarResource: 
            case cos: {
                values = ai.getDefaultCosValues();
                break;
            }
            case domain: {
                if (ai.hasFlag(AttributeFlag.domainInherited)) {
                    values = ai.getGlobalConfigValues();
                    break;
                }
                return null;
            }
            case server: {
                if (ai.hasFlag(AttributeFlag.serverInherited)) {
                    values = ai.getGlobalConfigValues();
                    break;
                }
                return null;
            }
            case globalConfig: {
                values = ai.getGlobalConfigValues();
                break;
            }
            default: {
                return null;
            }
        }
        if (values == null || values.size() == 0) {
            return null;
        }
        if (ai.getCardinality() != AttributeCardinality.multi) {
            return values.get(0);
        }
        StringBuilder result = new StringBuilder();
        result.append("new String[] {");
        boolean first = true;
        for (String v : values) {
            if (!first) {
                result.append(",");
            } else {
                first = false;
            }
            result.append("\"");
            result.append(v.replace("\"", "\\\""));
            result.append("\"");
        }
        result.append("}");
        return result.toString();
    }

    private static void generateGetter(StringBuilder result, AttributeInfo ai, boolean asString, AttributeClass ac) throws ServiceException {
        String javaDocReturns;
        String javaBody;
        String javaType;
        String name = ai.getName();
        AttributeType type = asString ? AttributeType.TYPE_STRING : ai.getType();
        boolean asStringDoc = false;
        String methodName = ai.getName();
        if (methodName.startsWith("zimbra")) {
            methodName = methodName.substring(6);
        }
        methodName = (type == AttributeType.TYPE_BOOLEAN ? "is" : "get") + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        if (asString) {
            methodName = methodName + "AsString";
        }
        String defaultValue = AttributeManager.defaultValue(ai, ac);
        switch (type) {
            case TYPE_BOOLEAN: {
                defaultValue = "TRUE".equalsIgnoreCase(defaultValue) ? "true" : "false";
                javaType = "boolean";
                javaBody = String.format("return getBooleanAttr(Provisioning.A_%s, %s);", name, defaultValue);
                javaDocReturns = String.format(", or %s if unset", defaultValue);
                break;
            }
            case TYPE_INTEGER: {
                if (defaultValue == null) {
                    defaultValue = "-1";
                }
                javaType = "int";
                javaBody = String.format("return getIntAttr(Provisioning.A_%s, %s);", name, defaultValue);
                javaDocReturns = String.format(", or %s if unset", defaultValue);
                break;
            }
            case TYPE_PORT: {
                if (defaultValue == null) {
                    defaultValue = "-1";
                }
                javaType = "int";
                javaBody = String.format("return getIntAttr(Provisioning.A_%s, %s);", name, defaultValue);
                javaDocReturns = String.format(", or %s if unset", defaultValue);
                asStringDoc = true;
                break;
            }
            case TYPE_ENUM: {
                javaType = "ZAttrProvisioning." + AttributeManager.enumName(ai);
                defaultValue = defaultValue != null ? javaType + "." + StringUtil.escapeJavaIdentifier(defaultValue) : "null";
                javaBody = String.format("try { String v = getAttr(Provisioning.A_%s); return v == null ? %s : ZAttrProvisioning.%s.fromString(v); } catch(com.zimbra.common.service.ServiceException e) { return %s; }", name, defaultValue, AttributeManager.enumName(ai), defaultValue);
                javaDocReturns = String.format(", or %s if unset and/or has invalid value", defaultValue);
                break;
            }
            case TYPE_LONG: {
                if (defaultValue == null) {
                    defaultValue = "-1";
                }
                javaType = "long";
                javaBody = String.format("return getLongAttr(Provisioning.A_%s, %sL);", name, defaultValue);
                javaDocReturns = String.format(", or %s if unset", defaultValue);
                break;
            }
            case TYPE_DURATION: {
                String defaultDurationStrValue;
                if (defaultValue != null) {
                    defaultDurationStrValue = " (" + defaultValue + ") ";
                    defaultValue = String.valueOf(DateUtil.getTimeInterval(defaultValue, -1L));
                } else {
                    defaultValue = "-1";
                    defaultDurationStrValue = "";
                }
                javaBody = String.format("return getTimeInterval(Provisioning.A_%s, %sL);", name, defaultValue);
                javaDocReturns = String.format(" in millseconds, or %s%s if unset", defaultValue, defaultDurationStrValue);
                javaType = "long";
                asStringDoc = true;
                break;
            }
            case TYPE_GENTIME: {
                javaType = "Date";
                javaBody = String.format("return getGeneralizedTimeAttr(Provisioning.A_%s, null);", name);
                javaDocReturns = " as Date, null if unset or unable to parse";
                asStringDoc = true;
                break;
            }
            default: {
                if (ai.getCardinality() != AttributeCardinality.multi) {
                    defaultValue = defaultValue != null ? "\"" + defaultValue.replace("\"", "\\\"") + "\"" : "null";
                    javaType = "String";
                    javaBody = String.format("return getAttr(Provisioning.A_%s, %s);", name, defaultValue);
                    javaDocReturns = String.format(", or %s if unset", defaultValue);
                    break;
                }
                javaType = "String[]";
                javaBody = defaultValue == null ? String.format("return getMultiAttr(Provisioning.A_%s);", name) : String.format("String[] value = getMultiAttr(Provisioning.A_%s); return value.length > 0 ? value : %s;", name, defaultValue);
                javaDocReturns = ", or empty array if unset";
            }
        }
        result.append("\n    /**\n");
        if (ai.getDescription() != null) {
            result.append(FileGenUtil.wrapComments(StringUtil.escapeHtml(ai.getDescription()), 70, "     * "));
            result.append("\n");
        }
        if (ai.getType() == AttributeType.TYPE_ENUM) {
            result.append("     *\n");
            result.append(String.format("     * <p>Valid values: %s%n", ai.getEnumSet().toString()));
        }
        if (asStringDoc) {
            result.append("     *\n");
            result.append(String.format("     * <p>Use %sAsString to access value as a string.%n", methodName));
            result.append("     *\n");
            result.append(String.format("     * @see #%sAsString()%n", methodName));
        }
        result.append("     *\n");
        result.append(String.format("     * @return %s%s%n", name, javaDocReturns));
        if (ai.getSince() != null) {
            result.append("     *\n");
            result.append(String.format("     * @since ZCS %s%n", ai.getSince().toString()));
        }
        result.append("     */\n");
        result.append(String.format("    @ZAttr(id=%d)%n", ai.getId()));
        result.append(String.format("    public %s %s() {%n        %s%n    }%n", javaType, methodName, javaBody));
    }

    private static void generateSetters(StringBuilder result, AttributeInfo ai, boolean asString, SetterType setterType) throws ServiceException {
        AttributeManager.generateSetter(result, ai, asString, setterType, true);
        AttributeManager.generateSetter(result, ai, asString, setterType, false);
    }

    private static void generateSetter(StringBuilder result, AttributeInfo ai, boolean asString, SetterType setterType, boolean noMap) throws ServiceException {
        String putParam;
        String javaType;
        String name = ai.getName();
        AttributeType type = asString ? AttributeType.TYPE_STRING : ai.getType();
        String methodName = ai.getName();
        if (methodName.startsWith("zimbra")) {
            methodName = methodName.substring(6);
        }
        methodName = setterType.name() + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        if (asString) {
            methodName = methodName + "AsString";
        }
        switch (type) {
            case TYPE_BOOLEAN: {
                javaType = "boolean";
                putParam = String.format("%s ? Provisioning.TRUE : Provisioning.FALSE", name);
                break;
            }
            case TYPE_INTEGER: 
            case TYPE_PORT: {
                javaType = "int";
                putParam = String.format("Integer.toString(%s)", name);
                break;
            }
            case TYPE_LONG: {
                javaType = "long";
                putParam = String.format("Long.toString(%s)", name);
                break;
            }
            case TYPE_GENTIME: {
                javaType = "Date";
                putParam = String.format("DateUtil.toGeneralizedTime(%s)", name);
                break;
            }
            case TYPE_ENUM: {
                javaType = "ZAttrProvisioning." + AttributeManager.enumName(ai);
                putParam = String.format("%s.toString()", name);
                break;
            }
            default: {
                if (ai.getCardinality() != AttributeCardinality.multi) {
                    javaType = "String";
                    putParam = String.format("%s", name);
                    break;
                }
                javaType = setterType == SetterType.set ? "String[]" : "String";
                putParam = String.format("%s", name);
            }
        }
        String mapType = "Map<String,Object>";
        result.append("\n    /**\n");
        if (ai.getDescription() != null) {
            result.append(FileGenUtil.wrapComments(StringUtil.escapeHtml(ai.getDescription()), 70, "     * "));
            result.append("\n");
        }
        if (ai.getType() == AttributeType.TYPE_ENUM) {
            result.append("     *\n");
            result.append(String.format("     * <p>Valid values: %s%n", ai.getEnumSet().toString()));
        }
        result.append("     *\n");
        String paramDoc = "";
        String body = "";
        switch (setterType) {
            case set: {
                body = String.format("        attrs.put(Provisioning.A_%s, %s);%n", name, putParam);
                paramDoc = String.format("     * @param %s new value%n", name);
                break;
            }
            case add: {
                body = String.format("        StringUtil.addToMultiMap(attrs, \"+\" + Provisioning.A_%s, %s);%n", name, name);
                paramDoc = String.format("     * @param %s new to add to existing values%n", name);
                break;
            }
            case remove: {
                body = String.format("        StringUtil.addToMultiMap(attrs, \"-\" + Provisioning.A_%s, %s);%n", name, name);
                paramDoc = String.format("     * @param %s existing value to remove%n", name);
                break;
            }
            case unset: {
                body = String.format("        attrs.put(Provisioning.A_%s, \"\");%n", name);
                paramDoc = null;
            }
        }
        if (paramDoc != null) {
            result.append(paramDoc);
        }
        if (!noMap) {
            result.append(String.format("     * @param attrs existing map to populate, or null to create a new map%n", new Object[0]));
            result.append("     * @return populated map to pass into Provisioning.modifyAttrs\n");
        } else {
            result.append("     * @throws com.zimbra.common.service.ServiceException if error during update\n");
        }
        if (ai.getSince() != null) {
            result.append("     *\n");
            result.append(String.format("     * @since ZCS %s%n", ai.getSince().toString()));
        }
        result.append("     */\n");
        result.append(String.format("    @ZAttr(id=%d)%n", ai.getId()));
        if (noMap) {
            if (setterType != SetterType.unset) {
                result.append(String.format("    public void %s(%s %s) throws com.zimbra.common.service.ServiceException {%n", methodName, javaType, name));
            } else {
                result.append(String.format("    public void %s() throws com.zimbra.common.service.ServiceException {%n", methodName));
            }
            result.append(String.format("        HashMap<String,Object> attrs = new HashMap<String,Object>();%n", new Object[0]));
            result.append(body);
            result.append(String.format("        getProvisioning().modifyAttrs(this, attrs);%n", new Object[0]));
        } else {
            if (setterType != SetterType.unset) {
                result.append(String.format("    public %s %s(%s %s, %s attrs) {%n", mapType, methodName, javaType, name, mapType));
            } else {
                result.append(String.format("    public %s %s(%s attrs) {%n", mapType, methodName, mapType));
            }
            result.append(String.format("        if (attrs == null) attrs = new HashMap<String,Object>();%n", new Object[0]));
            result.append(body);
            result.append(String.format("        return attrs;%n", new Object[0]));
        }
        result.append(String.format("    }%n", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLdapSchemaExtensionAttrs(LdapProvisioning prov) {
        Class<AttributeManager> clazz = AttributeManager.class;
        synchronized (AttributeManager.class) {
            try {
                AttributeManager theInstance = AttributeManager.getInstance();
                theInstance.getLdapSchemaExtensionAttrs(prov);
                theInstance.computeClassToAllAttrsMap();
            }
            catch (ServiceException e) {
                ZimbraLog.account.warn((Object)"unable to load LDAP schema extensions", e);
            }
            return;
        }
    }

    private void getLdapSchemaExtensionAttrs(LdapProvisioning prov) throws ServiceException {
        if (this.mLdapSchemaExtensionInited) {
            return;
        }
        this.mLdapSchemaExtensionInited = true;
        this.getExtraObjectClassAttrs(prov, AttributeClass.account, "zimbraAccountExtraObjectClass");
        this.getExtraObjectClassAttrs(prov, AttributeClass.calendarResource, "zimbraCalendarResourceExtraObjectClass");
        this.getExtraObjectClassAttrs(prov, AttributeClass.cos, "zimbraCosExtraObjectClass");
        this.getExtraObjectClassAttrs(prov, AttributeClass.domain, "zimbraDomainExtraObjectClass");
        this.getExtraObjectClassAttrs(prov, AttributeClass.server, "zimbraServerExtraObjectClass");
    }

    private void getExtraObjectClassAttrs(LdapProvisioning prov, AttributeClass ac, String extraObjectClassAttr) throws ServiceException {
        Config config = prov.getConfig();
        String[] extraObjectClasses = config.getMultiAttr(extraObjectClassAttr);
        if (extraObjectClasses.length > 0) {
            Set<String> attrsInOCs = this.mClassToAttrsMap.get((Object)AttributeClass.account);
            this.getAttrsInOCs(extraObjectClasses, attrsInOCs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttrsInOCs(String[] ocs, Set<String> attrsInOCs) throws ServiceException {
        ZimbraLdapContext zlc = null;
        try {
            zlc = new ZimbraLdapContext(true);
            DirContext schema = zlc.getSchema();
            for (String oc : ocs) {
                Map<String, Object> attrs = null;
                try {
                    DirContext ocSchema = (DirContext)schema.lookup("ClassDefinition/" + oc);
                    Attributes attributes = ocSchema.getAttributes("");
                    attrs = LdapUtil.getAttrs(attributes);
                }
                catch (NamingException e) {
                    ZimbraLog.account.debug((Object)("unable to load LDAP schema extension for objectclass: " + oc), e);
                }
                if (attrs == null) continue;
                for (Map.Entry attr : attrs.entrySet()) {
                    String attrName = (String)attr.getKey();
                    if ("MAY".compareToIgnoreCase(attrName) != 0 && "MUST".compareToIgnoreCase(attrName) != 0) continue;
                    Object value = attr.getValue();
                    if (value instanceof String) {
                        attrsInOCs.add((String)value);
                        continue;
                    }
                    if (!(value instanceof String[])) continue;
                    for (String v : (String[])value) {
                        attrsInOCs.add(v);
                    }
                }
            }
        }
        catch (NamingException e) {
            try {
                ZimbraLog.account.debug((Object)"unable to load LDAP schema extension", e);
            }
            catch (Throwable throwable) {
                ZimbraLdapContext.closeContext(zlc);
                throw throwable;
            }
            ZimbraLdapContext.closeContext(zlc);
        }
        ZimbraLdapContext.closeContext(zlc);
    }

    static {
        mGroupMap = new HashMap<Integer, String>();
        mOCGroupMap = new HashMap<Integer, String>();
        mLog = LogFactory.getLog(AttributeManager.class);
        mOptions = new Options();
        mOptions.addOption("h", "help", false, "display this  usage info");
        mOptions.addOption("o", "output", true, "output file (default it to generate output to stdout)");
        mOptions.addOption("a", "action", true, "[generateLdapSchema | generateGlobalConfigLdif | generateDefaultCOSLdif | generateSchemaLdif]");
        mOptions.addOption("t", "template", true, "template for LDAP schema");
        mOptions.addOption("r", "regenerateFile", true, "Java file to regenerate");
        Option iopt = new Option("i", "input", true, "attrs definition xml input file (can repeat)");
        iopt.setArgs(-2);
        mOptions.addOption(iopt);
        Option copt = new Option("c", "inclass", true, "list attrs in class  (can repeat)");
        copt.setArgs(-2);
        mOptions.addOption(copt);
        Option nopt = new Option("n", "notinclass", true, "not list attrs in class  (can repeat)");
        nopt.setArgs(-2);
        mOptions.addOption(nopt);
        Option fopt = new Option("f", A_FLAGS, true, "flags to print  (can repeat)");
        fopt.setArgs(-2);
        mOptions.addOption(fopt);
    }

    static class CLOptions {
        CLOptions() {
        }

        private static String get(String key, String defaultValue) {
            String value = System.getProperty(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public static String buildVersion() {
            return CLOptions.get("zimbra.version", "unknown");
        }

        public static String getBaseDn(String entry) {
            return CLOptions.get(entry + ".basedn", "cn=zimbra");
        }

        public static String getEntryName(String entry, String defaultValue) {
            return CLOptions.get(entry + ".name", defaultValue);
        }

        public static String getEntryId(String entry, String defaultValue) {
            return CLOptions.get(entry + ".id", defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SetterType {
        set,
        add,
        unset,
        remove;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        generateLdapSchema,
        generateSchemaLdif,
        generateGlobalConfigLdif,
        generateDefaultCOSLdif,
        dump,
        generateProvisioning,
        generateGetters,
        listAttrs;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IDNType {
        email,
        emailp,
        cs_emailp,
        idn,
        none;


        public boolean isEmailOrIDN() {
            return this != none;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectClassInfo {
        private AttributeClass mAttributeClass;
        private String mName;
        private int mId;
        private int mGroupId;
        private ObjectClassType mType;
        private List<String> mSuperOCs;
        private String mDescription;
        private List<String> mComment;

        ObjectClassInfo(AttributeClass attrClass, String ocName, int id, int groupId, ObjectClassType type, List<String> superOCs, String description, List<String> comment) {
            this.mAttributeClass = attrClass;
            this.mName = ocName;
            this.mId = id;
            this.mGroupId = groupId;
            this.mType = type;
            this.mSuperOCs = superOCs;
            this.mDescription = description;
            this.mComment = comment;
        }

        AttributeClass getAttributeClass() {
            return this.mAttributeClass;
        }

        String getName() {
            return this.mName;
        }

        int getId() {
            return this.mId;
        }

        int getGroupId() {
            return this.mGroupId;
        }

        ObjectClassType getType() {
            return this.mType;
        }

        List<String> getSuperOCs() {
            return this.mSuperOCs;
        }

        String getDescription() {
            return this.mDescription;
        }

        List<String> getComment() {
            return this.mComment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ObjectClassType {
        ABSTRACT,
        AUXILIARY,
        STRUCTURAL;

    }
}

