/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.AttributeCardinality;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.AttributeOrder;
import com.zimbra.cs.account.AttributeServerType;
import com.zimbra.cs.account.AttributeType;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.util.BuildInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeInfo {
    private static Pattern ID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    private static Pattern GENTIME_PATTERN = Pattern.compile("^\\d{14}[zZ]$");
    private static Pattern DURATION_PATTERN = Pattern.compile("^\\d+([hmsd]|ms)?$");
    private String mName;
    private AttributeType mType;
    private AttributeOrder mOrder;
    private HashSet<String> mEnumSet;
    private Pattern mRegex;
    private String mValue;
    private AttributeCallback mCallback;
    private boolean mImmutable;
    private AttributeCardinality mCardinality;
    private Set<AttributeClass> mRequiredInClasses;
    private Set<AttributeClass> mOptionalInClasses;
    private Set<AttributeFlag> mFlags;
    private List<String> mGlobalConfigValues;
    private List<String> mGlobalConfigValuesUpgrade;
    private List<String> mDefaultCOSValues;
    private List<String> mDefaultCOSValuesUpgrade;
    private long mMin = Long.MIN_VALUE;
    private long mMax = Long.MAX_VALUE;
    private String mMinDuration = null;
    private String mMaxDuration = null;
    private int mId;
    private String mParentOid;
    private int mGroupId;
    private String mDescription;
    private List<AttributeServerType> mRequiresRestart;
    private BuildInfo.Version mSince;
    private BuildInfo.Version mDeprecatedSince;

    private static Integer parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long parseLong(String attrName, String propName, String value, long defaultValue) {
        if (!StringUtil.isNullOrEmpty(value)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                ZimbraLog.misc.warn("Invalid value '%s' for property %s of attribute %s.  Defaulting to %d.", value, propName, attrName, defaultValue);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    AttributeInfo(String attrName, int id, String parentId, int groupId, AttributeCallback callback, AttributeType type, AttributeOrder order, String value, boolean immutable, String min, String max, AttributeCardinality cardinality, Set<AttributeClass> requiredIn, Set<AttributeClass> optionalIn, Set<AttributeFlag> flags, List<String> globalConfigValues, List<String> defaultCOSValues, List<String> globalConfigValuesUpgrade, List<String> defaultCOSValuesUpgrade, String description, List<AttributeServerType> requiresRestart, BuildInfo.Version since, BuildInfo.Version deprecatedSince) {
        this.mName = attrName;
        this.mImmutable = immutable;
        this.mCallback = callback;
        this.mType = type;
        this.mOrder = order;
        this.mValue = value;
        this.mId = id;
        this.mParentOid = parentId;
        this.mGroupId = groupId;
        this.mCardinality = cardinality;
        this.mRequiredInClasses = requiredIn;
        this.mOptionalInClasses = optionalIn;
        this.mFlags = flags;
        this.mGlobalConfigValues = globalConfigValues;
        this.mGlobalConfigValuesUpgrade = globalConfigValuesUpgrade;
        this.mDefaultCOSValues = defaultCOSValues;
        this.mDefaultCOSValuesUpgrade = defaultCOSValuesUpgrade;
        this.mDescription = description;
        this.mRequiresRestart = requiresRestart;
        this.mSince = since;
        this.mDeprecatedSince = deprecatedSince;
        this.mMin = AttributeInfo.parseLong(attrName, "min", min, Long.MIN_VALUE);
        this.mMax = AttributeInfo.parseLong(attrName, "max", max, Long.MAX_VALUE);
        switch (this.mType) {
            case TYPE_INTEGER: {
                Integer i;
                this.mMin = Integer.MIN_VALUE;
                this.mMax = Integer.MAX_VALUE;
                if (!StringUtil.isNullOrEmpty(min)) {
                    i = AttributeInfo.parseInt(min);
                    if (i == null) {
                        ZimbraLog.misc.warn("Invalid value '%s' for property %s of attribute %s.  Defaulting to %d.", min, "min", attrName, this.mMin);
                    } else {
                        this.mMin = i.intValue();
                    }
                }
                if (StringUtil.isNullOrEmpty(max)) break;
                i = AttributeInfo.parseInt(max);
                if (i == null) {
                    ZimbraLog.misc.warn("Invalid value '%s' for property %s of attribute %s.  Defaulting to %d.", max, "max", attrName, this.mMax);
                    break;
                }
                this.mMax = i.intValue();
                break;
            }
            case TYPE_LONG: {
                Long l;
                this.mMin = Long.MIN_VALUE;
                this.mMax = Long.MAX_VALUE;
                if (!StringUtil.isNullOrEmpty(min)) {
                    l = AttributeInfo.parseLong(min);
                    if (l == null) {
                        ZimbraLog.misc.warn("Invalid value '%s' for property %s of attribute %s.  Defaulting to %d.", min, "min", attrName, this.mMin);
                    } else {
                        this.mMin = l;
                    }
                }
                if (StringUtil.isNullOrEmpty(max)) break;
                l = AttributeInfo.parseLong(max);
                if (l == null) {
                    ZimbraLog.misc.warn("Invalid value '%s' for property %s of attribute %s.  Defaulting to %d.", max, "max", attrName, this.mMax);
                    break;
                }
                this.mMax = l;
                break;
            }
            case TYPE_ENUM: {
                String[] enums = value.split(",");
                this.mEnumSet = new HashSet(enums.length);
                for (int i = 0; i < enums.length; ++i) {
                    this.mEnumSet.add(enums[i]);
                }
                break;
            }
            case TYPE_REGEX: {
                this.mRegex = Pattern.compile(value);
                break;
            }
            case TYPE_DURATION: {
                this.mMin = 0L;
                this.mMax = Long.MAX_VALUE;
                this.mMinDuration = "0";
                this.mMaxDuration = Long.toString(this.mMax);
                if (!StringUtil.isNullOrEmpty(min)) {
                    this.mMin = DateUtil.getTimeInterval(min, -1L);
                    if (this.mMin < 0L) {
                        this.mMin = 0L;
                        ZimbraLog.misc.warn("Invalid value '%s' for property %s of attribute %s.  Defaulting to 0.", min, "min", attrName);
                    } else {
                        this.mMinDuration = min;
                    }
                }
                if (StringUtil.isNullOrEmpty(max)) break;
                this.mMax = DateUtil.getTimeInterval(max, -1L);
                if (this.mMax < 0L) {
                    this.mMax = Long.MAX_VALUE;
                    ZimbraLog.misc.warn("Invalid value '%s' for property %s of attribute %s.  Defaulting to %d.", max, "max", attrName, this.mMax);
                    break;
                }
                this.mMaxDuration = max;
            }
        }
    }

    public int getEnumValueMaxLength() {
        assert (this.mType == AttributeType.TYPE_ENUM);
        int max = 0;
        for (String s : this.mEnumSet) {
            int l = s.length();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    public void checkValue(Object value, boolean checkImmutable) throws ServiceException {
        if (value == null || value instanceof String) {
            this.checkValue((String)value, checkImmutable);
        } else if (value instanceof String[]) {
            String[] values = (String[])value;
            for (int i = 0; i < values.length; ++i) {
                this.checkValue(values[i], checkImmutable);
            }
        }
    }

    private void checkValue(String value, boolean checkImmutable) throws ServiceException {
        if (checkImmutable && this.mImmutable) {
            throw ServiceException.INVALID_REQUEST(this.mName + " is immutable", null);
        }
        if (value == null || value.equals("")) {
            return;
        }
        switch (this.mType) {
            case TYPE_BOOLEAN: {
                if ("TRUE".equals(value) || "FALSE".equals(value)) {
                    return;
                }
                throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be TRUE or FALSE", null);
            }
            case TYPE_DURATION: {
                if (!DURATION_PATTERN.matcher(value).matches()) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be a valid duration: nnnn[hsmd]", null);
                }
                long l = DateUtil.getTimeInterval(value, 0L);
                if (l < this.mMin) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " is shorter than minimum allowed: " + this.mMinDuration, null);
                }
                if (l > this.mMax) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " is longer than max allowed: " + this.mMaxDuration, null);
                }
                return;
            }
            case TYPE_EMAIL: {
                if ((long)value.length() > this.mMax) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value length(" + value.length() + ") larger than max allowed: " + this.mMax, null);
                }
                AttributeInfo.validEmailAddress(value, false);
                return;
            }
            case TYPE_EMAILP: {
                if ((long)value.length() > this.mMax) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value length(" + value.length() + ") larger than max allowed: " + this.mMax, null);
                }
                AttributeInfo.validEmailAddress(value, true);
                return;
            }
            case TYPE_CS_EMAILP: {
                String[] emails;
                if ((long)value.length() > this.mMax) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value length(" + value.length() + ") larger than max allowed: " + this.mMax, null);
                }
                for (String email : emails = value.split(",")) {
                    AttributeInfo.validEmailAddress(email, true);
                }
                return;
            }
            case TYPE_ENUM: {
                if (this.mEnumSet.contains(value)) {
                    return;
                }
                throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be one of: " + this.mValue, null);
            }
            case TYPE_GENTIME: {
                if (GENTIME_PATTERN.matcher(value).matches()) {
                    return;
                }
                throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be a valid generalized time: yyyyMMddHHmmssZ", null);
            }
            case TYPE_ID: {
                if (!Provisioning.getInstance().idIsUUID()) {
                    return;
                }
                if (ID_PATTERN.matcher(value).matches()) {
                    return;
                }
                throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be a valid id", null);
            }
            case TYPE_INTEGER: {
                try {
                    int v = Integer.parseInt(value);
                    if ((long)v < this.mMin) {
                        throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value(" + v + ") smaller than minimum allowed: " + this.mMin, null);
                    }
                    if ((long)v > this.mMax) {
                        throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value(" + v + ") larger than max allowed: " + this.mMax, null);
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be a valid integer: " + value, e);
                }
            }
            case TYPE_LONG: {
                try {
                    long v = Long.parseLong(value);
                    if (v < this.mMin) {
                        throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value(" + v + ") smaller than minimum allowed: " + this.mMin, null);
                    }
                    if (v > this.mMax) {
                        throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value(" + v + ") larger than max allowed: " + this.mMax, null);
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be a valid long: " + value, e);
                }
            }
            case TYPE_PORT: {
                try {
                    int v = Integer.parseInt(value);
                    if (v >= 0 && v <= 65535) {
                        return;
                    }
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be a valid port: " + value, null);
                }
                catch (NumberFormatException e) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must be a valid port: " + value, null);
                }
            }
            case TYPE_STRING: 
            case TYPE_ASTRING: 
            case TYPE_OSTRING: 
            case TYPE_CSTRING: 
            case TYPE_PHONE: {
                if ((long)value.length() > this.mMax) {
                    throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " value length(" + value.length() + ") larger then max allowed: " + this.mMax, null);
                }
                return;
            }
            case TYPE_REGEX: {
                if (this.mRegex.matcher(value).matches()) {
                    return;
                }
                throw AccountServiceException.INVALID_ATTR_VALUE(this.mName + " must match the regex: " + this.mValue, null);
            }
        }
        ZimbraLog.misc.warn("unknown type(" + (Object)((Object)this.mType) + ") for attribute: " + value);
    }

    public static void validEmailAddress(String addr, boolean personal) throws ServiceException {
        if (addr.indexOf(64) == -1) {
            throw AccountServiceException.INVALID_ATTR_VALUE("must include domain", null);
        }
        try {
            InternetAddress ia = new InternetAddress(addr, true);
            ia.validate();
            if (!personal && ia.getPersonal() != null && !ia.getPersonal().equals("")) {
                throw AccountServiceException.INVALID_ATTR_VALUE("invalid email address", null);
            }
        }
        catch (AddressException e) {
            throw AccountServiceException.INVALID_ATTR_VALUE("invalid email address", e);
        }
    }

    AttributeCallback getCallback() {
        return this.mCallback;
    }

    String getName() {
        return this.mName;
    }

    boolean hasFlag(AttributeFlag flag) {
        if (this.mFlags == null) {
            return false;
        }
        boolean result = this.mFlags.contains((Object)flag);
        return result;
    }

    int getId() {
        return this.mId;
    }

    Set<String> getEnumSet() {
        return this.mEnumSet;
    }

    String getParentOid() {
        return this.mParentOid;
    }

    int getGroupId() {
        return this.mGroupId;
    }

    AttributeType getType() {
        return this.mType;
    }

    AttributeOrder getOrder() {
        return this.mOrder;
    }

    String getDescription() {
        return this.mDescription;
    }

    long getMax() {
        return this.mMax;
    }

    long getMin() {
        return this.mMin;
    }

    boolean requiredInClass(AttributeClass cls) {
        return this.mRequiredInClasses != null && this.mRequiredInClasses.contains((Object)cls);
    }

    boolean optionalInClass(AttributeClass cls) {
        return this.mOptionalInClasses != null && this.mOptionalInClasses.contains((Object)cls);
    }

    Set<AttributeClass> getRequiredIn() {
        return this.mRequiredInClasses;
    }

    Set<AttributeClass> getOptionalIn() {
        return this.mOptionalInClasses;
    }

    public AttributeCardinality getCardinality() {
        return this.mCardinality;
    }

    public List<String> getGlobalConfigValues() {
        return this.mGlobalConfigValues;
    }

    public List<String> getGlobalConfigValuesUpgrade() {
        return this.mGlobalConfigValuesUpgrade;
    }

    public List<String> getDefaultCosValues() {
        return this.mDefaultCOSValues;
    }

    public List<String> getDefaultCosValuesUpgrade() {
        return this.mDefaultCOSValuesUpgrade;
    }

    boolean isImmutable() {
        return this.mImmutable;
    }

    String getValue() {
        return this.mValue;
    }

    public List<AttributeServerType> getRequiresRestart() {
        return this.mRequiresRestart;
    }

    public BuildInfo.Version getSince() {
        return this.mSince;
    }

    public BuildInfo.Version getDeprecatedSince() {
        return this.mDeprecatedSince;
    }
}

