/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AttributeClass {
    mailRecipient("zimbraMailRecipient", false),
    account("zimbraAccount", true),
    alias("zimbraAlias", true),
    distributionList("zimbraDistributionList", true),
    cos("zimbraCOS", true),
    globalConfig("zimbraGlobalConfig", true),
    domain("zimbraDomain", true),
    securityGroup("zimbraSecurityGroup", false),
    server("zimbraServer", true),
    mimeEntry("zimbraMimeEntry", true),
    objectEntry("zimbraObjectEntry", false),
    timeZone("zimbraTimeZone", false),
    zimletEntry("zimbraZimletEntry", true),
    calendarResource("zimbraCalendarResource", true),
    identity("zimbraIdentity", true),
    dataSource("zimbraDataSource", true),
    pop3DataSource("zimbraPop3DataSource", true),
    imapDataSource("zimbraImapDataSource", true),
    rssDataSource("zimbraRssDataSource", true),
    liveDataSource("zimbraLiveDataSource", true),
    galDataSource("zimbraGalDataSource", true),
    signature("zimbraSignature", true),
    xmppComponent("zimbraXMPPComponent", true),
    aclTarget("zimbraAclTarget", true);

    String mOCName;
    boolean mProvisionable;

    private AttributeClass(String ocName, boolean provisionable) {
        this.mOCName = ocName;
        this.mProvisionable = provisionable;
        TM.sOCMap.put(ocName, this);
    }

    public static AttributeClass getAttributeClass(String ocName) {
        return TM.sOCMap.get(ocName);
    }

    public static AttributeClass fromString(String s) throws ServiceException {
        try {
            return AttributeClass.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw ServiceException.PARSE_ERROR("unknown attribute class: " + s, e);
        }
    }

    public String getOCName() {
        return this.mOCName;
    }

    public boolean isProvisionable() {
        return this.mProvisionable;
    }

    private static class TM {
        static Map<String, AttributeClass> sOCMap = new HashMap<String, AttributeClass>();

        private TM() {
        }
    }
}

