/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.account.Entry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeCallback {
    public abstract void preModify(Map var1, String var2, Object var3, Map var4, Entry var5, boolean var6) throws ServiceException;

    public abstract void postModify(Map var1, String var2, Entry var3, boolean var4);

    protected SingleValueMod singleValueMod(String attrName, Object value) throws ServiceException {
        SingleValueMod svm = new SingleValueMod();
        if (value == null) {
            svm.mMod = SingleValueMod.Mod.UNSETTING;
        } else {
            if (!(value instanceof String)) {
                throw ServiceException.INVALID_REQUEST(attrName + " is a single-valued attribute", null);
            }
            String s = (String)value;
            if ("".equals(s)) {
                svm.mMod = SingleValueMod.Mod.UNSETTING;
            } else {
                svm.mMod = SingleValueMod.Mod.SETTING;
                svm.mValue = s;
            }
        }
        return svm;
    }

    protected SingleValueMod singleValueMod(Map attrsToModify, String attrName) throws ServiceException {
        SingleValueMod svm = new SingleValueMod();
        Object v = attrsToModify.get("-" + attrName);
        if (v != null) {
            svm.mMod = SingleValueMod.Mod.UNSETTING;
            return svm;
        }
        Object value = attrsToModify.get(attrName);
        if (value == null) {
            value = attrsToModify.get("+" + attrName);
        }
        if (value == null) {
            svm.mMod = SingleValueMod.Mod.UNSETTING;
        } else {
            String[] ss;
            String s = null;
            if (value instanceof String) {
                s = (String)value;
            } else if (value instanceof String[] && (ss = (String[])value).length == 1) {
                s = ss[0];
            }
            if (s == null) {
                throw ServiceException.INVALID_REQUEST(attrName + " is a single-valued attribute", null);
            }
            if ("".equals(s)) {
                svm.mMod = SingleValueMod.Mod.UNSETTING;
            } else {
                svm.mMod = SingleValueMod.Mod.SETTING;
                svm.mValue = s;
            }
        }
        return svm;
    }

    protected MultiValueMod multiValueMod(Map attrsToModify, String attrName) throws ServiceException {
        MultiValueMod mvm = new MultiValueMod();
        Object v = attrsToModify.get(attrName);
        if (v != null) {
            mvm.mMod = v instanceof String && ((String)v).length() == 0 ? MultiValueMod.Mod.DELETING : MultiValueMod.Mod.REPLACING;
        } else if (attrsToModify.keySet().contains(attrName)) {
            mvm.mMod = MultiValueMod.Mod.DELETING;
        }
        if (v == null && (v = attrsToModify.get("+" + attrName)) != null) {
            mvm.mMod = MultiValueMod.Mod.ADDING;
        }
        if (v == null && (v = attrsToModify.get("-" + attrName)) != null) {
            mvm.mMod = MultiValueMod.Mod.REMOVING;
        }
        if (mvm.mMod != null && mvm.mMod != MultiValueMod.Mod.DELETING) {
            mvm.mValues = this.getMultiValue(v);
        }
        return mvm.mMod == null ? null : mvm;
    }

    protected List<String> getMultiValue(Object value) throws ServiceException {
        ArrayList<String> list = null;
        if (value instanceof String) {
            list = new ArrayList<String>(1);
            list.add((String)value);
        } else if (value instanceof String[]) {
            list = new ArrayList<String>(Arrays.asList((String[])value));
        } else if (value instanceof Collection) {
            list = new ArrayList();
            for (Object o : (Collection)value) {
                list.add(o.toString());
            }
        } else {
            throw ServiceException.INVALID_REQUEST("value not a String or String[]", null);
        }
        return list;
    }

    protected Set<String> getMultiValueSet(Object value) throws ServiceException {
        HashSet<String> values = new HashSet<String>();
        if (value instanceof String) {
            values.add((String)value);
        } else if (value instanceof String[]) {
            for (String s : (String[])value) {
                values.add(s);
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                values.add(o.toString());
            }
        } else {
            throw ServiceException.INVALID_REQUEST("value not a String or String[] or a Collection", null);
        }
        return values;
    }

    protected Set<String> newValuesToBe(MultiValueMod mod, Entry entry, String attrName) {
        Set<String> newValues = null;
        if (entry != null) {
            Set<String> curValues = entry.getMultiAttrSet(attrName);
            if (mod == null) {
                newValues = curValues;
            } else if (mod.adding()) {
                newValues = new HashSet<String>();
                SetUtil.union(newValues, curValues, mod.valuesSet());
            } else {
                newValues = mod.removing() ? SetUtil.subtract(curValues, mod.valuesSet()) : (mod.deleting() ? new HashSet<String>() : mod.valuesSet());
            }
        } else {
            newValues = mod == null ? new HashSet<String>() : mod.valuesSet();
        }
        return newValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MultiValueMod {
        Mod mMod;
        List<String> mValues = new ArrayList<String>();

        protected MultiValueMod() {
        }

        public boolean adding() {
            return this.mMod == Mod.ADDING;
        }

        public boolean removing() {
            return this.mMod == Mod.REMOVING;
        }

        public boolean replacing() {
            return this.mMod == Mod.REPLACING;
        }

        public boolean deleting() {
            return this.mMod == Mod.DELETING;
        }

        public List<String> values() {
            return this.mValues;
        }

        public Set<String> valuesSet() {
            return new HashSet<String>(this.mValues);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Mod {
            ADDING,
            REMOVING,
            REPLACING,
            DELETING;

        }
    }

    protected static class SingleValueMod {
        Mod mMod;
        String mValue;

        protected SingleValueMod() {
        }

        public boolean setting() {
            return this.mMod == Mod.SETTING;
        }

        public boolean unsetting() {
            return this.mMod == Mod.UNSETTING;
        }

        public String value() {
            return this.mValue;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Mod {
            SETTING,
            UNSETTING;

        }
    }
}

