/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.IDNUtil;
import com.zimbra.cs.account.MailTarget;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.TargetType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alias
extends MailTarget {
    private NamedEntry mTarget = null;
    private boolean mIsDangling = false;

    public Alias(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, null, prov);
    }

    public NamedEntry getTarget(Provisioning prov) {
        if (this.mIsDangling) {
            return null;
        }
        if (this.mTarget != null) {
            return this.mTarget;
        }
        try {
            this.mTarget = prov.searchAliasTarget(this, false);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("cannot find target " + this.getId() + " for alias " + this.getName()), e);
        }
        if (this.mTarget == null) {
            this.mIsDangling = true;
        }
        return this.mTarget;
    }

    public String getTargetName(Provisioning prov) throws ServiceException {
        NamedEntry target = this.getTarget(prov);
        if (target == null) {
            return null;
        }
        return target.getName();
    }

    public String getTargetUnicodeName(Provisioning prov) throws ServiceException {
        String targetName = this.getTargetName(prov);
        if (targetName == null) {
            return null;
        }
        return IDNUtil.toUnicodeEmail(targetName);
    }

    public TargetType getTargetType(Provisioning prov) throws ServiceException {
        NamedEntry target = this.getTarget(prov);
        if (target == null) {
            return null;
        }
        if (target instanceof CalendarResource) {
            return TargetType.calresource;
        }
        if (target instanceof Account) {
            return TargetType.account;
        }
        if (target instanceof DistributionList) {
            return TargetType.dl;
        }
        throw ServiceException.FAILURE("invalid target type for alias " + this.getName(), null);
    }

    public boolean isDangling(Provisioning prov) throws ServiceException {
        NamedEntry target = this.getTarget(prov);
        return target == null;
    }
}

