/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.stats.Counter;
import com.zimbra.cs.account.Account;
import org.apache.commons.collections.map.LRUMap;

public class AccountCache {
    private LRUMap mNameCache;
    private LRUMap mIdCache;
    private LRUMap mForeignPrincipalCache;
    private Counter mHitRate = new Counter();
    private long mRefreshTTL;

    public AccountCache(int maxItems, long refreshTTL) {
        this.mNameCache = new LRUMap(maxItems);
        this.mIdCache = new LRUMap(maxItems);
        this.mForeignPrincipalCache = new LRUMap(maxItems);
        this.mRefreshTTL = refreshTTL;
    }

    public synchronized void clear() {
        this.mNameCache.clear();
        this.mIdCache.clear();
        this.mForeignPrincipalCache.clear();
    }

    public synchronized void remove(Account entry) {
        if (entry != null) {
            String[] fps;
            this.mNameCache.remove((Object)entry.getName());
            this.mIdCache.remove((Object)entry.getId());
            for (String fp : fps = entry.getMultiAttr("zimbraForeignPrincipal")) {
                this.mForeignPrincipalCache.remove((Object)fp);
            }
        }
    }

    public synchronized void put(Account entry) {
        if (entry != null) {
            String[] fps;
            CacheEntry cacheEntry = new CacheEntry(entry, this.mRefreshTTL);
            this.mNameCache.put((Object)entry.getName(), (Object)cacheEntry);
            this.mIdCache.put((Object)entry.getId(), (Object)cacheEntry);
            for (String fp : fps = entry.getMultiAttr("zimbraForeignPrincipal")) {
                this.mForeignPrincipalCache.put((Object)fp, (Object)cacheEntry);
            }
        }
    }

    private Account get(String key, LRUMap cache) {
        CacheEntry ce = (CacheEntry)cache.get((Object)key);
        if (ce != null) {
            if (this.mRefreshTTL != 0L && ce.isStale()) {
                this.remove(ce.mEntry);
                this.mHitRate.increment(0L);
                return null;
            }
            this.mHitRate.increment(100L);
            return ce.mEntry;
        }
        this.mHitRate.increment(0L);
        return null;
    }

    public synchronized Account getById(String key) {
        return this.get(key, this.mIdCache);
    }

    public synchronized Account getByName(String key) {
        return this.get(key.toLowerCase(), this.mNameCache);
    }

    public synchronized Account getByForeignPrincipal(String key) {
        return this.get(key, this.mForeignPrincipalCache);
    }

    public synchronized int getSize() {
        return this.mIdCache.size();
    }

    public synchronized double getHitRate() {
        return this.mHitRate.getAverage();
    }

    static class CacheEntry {
        long mLifetime;
        Account mEntry;

        CacheEntry(Account entry, long expires) {
            this.mEntry = entry;
            this.mLifetime = System.currentTimeMillis() + expires;
        }

        boolean isStale() {
            return this.mLifetime < System.currentTimeMillis();
        }
    }
}

