/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.ZAttrAccount;
import com.zimbra.cs.account.auth.AuthContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Account
extends ZAttrAccount {
    public Account(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov) {
        super(name, id, attrs, defaults, prov);
    }

    public void deleteAccount() throws ServiceException {
        this.getProvisioning().deleteAccount(this.getId());
    }

    public void rename(String newName) throws ServiceException {
        this.getProvisioning().renameAccount(this.getId(), newName);
    }

    public void modify(Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    public void addAlias(String alias) throws ServiceException {
        this.getProvisioning().addAlias(this, alias);
    }

    public void removeAlias(String alias) throws ServiceException {
        this.getProvisioning().removeAlias(this, alias);
    }

    public void authAccount(String password, AuthContext.Protocol proto) throws ServiceException {
        this.getProvisioning().authAccount(this, password, proto);
    }

    public void changePassword(String currentPassword, String newPassword) throws ServiceException {
        this.getProvisioning().changePassword(this, currentPassword, newPassword);
    }

    public void checkPasswordStrength(String password) throws ServiceException {
        this.getProvisioning().checkPasswordStrength(this, password);
    }

    public void setPassword(String password) throws ServiceException {
        this.getProvisioning().setPassword(this, password);
    }

    public Provisioning.AclGroups getAclGroups(boolean adminGroupsOnly) throws ServiceException {
        return this.getProvisioning().getAclGroups(this, adminGroupsOnly);
    }

    public boolean inDistributionList(String zimbraId) throws ServiceException {
        return this.getProvisioning().inDistributionList(this, zimbraId);
    }

    public Set<String> getDistributionLists() throws ServiceException {
        return this.getProvisioning().getDistributionLists(this);
    }

    public List<DistributionList> getDistributionLists(boolean directOnly, Map<String, String> via) throws ServiceException {
        return this.getProvisioning().getDistributionLists(this, directOnly, via);
    }

    public void preAuthAccount(String accountName, String accountBy, long timestamp, long expires, String preAuth, Map<String, Object> authCtxt) throws ServiceException {
        this.getProvisioning().preAuthAccount(this, accountName, accountBy, timestamp, expires, preAuth, authCtxt);
    }

    public void preAuthAccount(String accountName, String accountBy, long timestamp, long expires, String preAuth, boolean admin, Map<String, Object> authCtxt) throws ServiceException {
        this.getProvisioning().preAuthAccount(this, accountName, accountBy, timestamp, expires, preAuth, admin, authCtxt);
    }

    public Cos getCOS() throws ServiceException {
        return this.getProvisioning().getCOS(this);
    }

    public DataSource createDataSource(DataSource.Type type, String dataSourceName, Map<String, Object> attrs) throws ServiceException {
        return this.getProvisioning().createDataSource(this, type, dataSourceName, attrs);
    }

    public DataSource createDataSource(DataSource.Type type, String dataSourceName, Map<String, Object> attrs, boolean passwdAlreadyEncrypted) throws ServiceException {
        return this.getProvisioning().createDataSource(this, type, dataSourceName, attrs, passwdAlreadyEncrypted);
    }

    public void modifyDataSource(String dataSourceId, Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifyDataSource(this, dataSourceId, attrs);
    }

    public void deleteDataSource(String dataSourceId) throws ServiceException {
        this.getProvisioning().deleteDataSource(this, dataSourceId);
    }

    public List<DataSource> getAllDataSources() throws ServiceException {
        return this.getProvisioning().getAllDataSources(this);
    }

    public DataSource get(Provisioning.DataSourceBy keyType, String key) throws ServiceException {
        return this.getProvisioning().get(this, keyType, key);
    }

    public DataSource getDataSourceByName(String name) throws ServiceException {
        return this.get(Provisioning.DataSourceBy.name, name);
    }

    public DataSource getDataSourceById(String id) throws ServiceException {
        return this.get(Provisioning.DataSourceBy.id, id);
    }

    public Identity createIdentity(String identityName, Map<String, Object> attrs) throws ServiceException {
        return this.getProvisioning().createIdentity(this, identityName, attrs);
    }

    public void modifyIdentity(String identityName, Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifyIdentity(this, identityName, attrs);
    }

    public void deleteIdentity(String identityName) throws ServiceException {
        this.getProvisioning().deleteIdentity(this, identityName);
    }

    public List<Identity> getAllIdentities() throws ServiceException {
        return this.getProvisioning().getAllIdentities(this);
    }

    public Identity get(Provisioning.IdentityBy keyType, String key) throws ServiceException {
        return this.getProvisioning().get(this, keyType, key);
    }

    public Identity getIdentityByName(String name) throws ServiceException {
        return this.get(Provisioning.IdentityBy.name, name);
    }

    public Identity getIdentityById(String id) throws ServiceException {
        return this.get(Provisioning.IdentityBy.id, id);
    }

    public Identity getDefaultIdentity() throws ServiceException {
        return this.getProvisioning().getDefaultIdentity(this);
    }

    public Signature createSignature(String signatureName, Map<String, Object> attrs) throws ServiceException {
        return this.getProvisioning().createSignature(this, signatureName, attrs);
    }

    public void modifySignature(String signatureId, Map<String, Object> attrs) throws ServiceException {
        this.getProvisioning().modifySignature(this, signatureId, attrs);
    }

    public void deleteSignature(String signatureId) throws ServiceException {
        this.getProvisioning().deleteSignature(this, signatureId);
    }

    public List<Signature> getAllSignatures() throws ServiceException {
        return this.getProvisioning().getAllSignatures(this);
    }

    public Signature get(Provisioning.SignatureBy keyType, String key) throws ServiceException {
        return this.getProvisioning().get(this, keyType, key);
    }

    public Signature getSignatureByName(String key) throws ServiceException {
        return this.get(Provisioning.SignatureBy.name, key);
    }

    public Signature getSignatureById(String key) throws ServiceException {
        return this.get(Provisioning.SignatureBy.id, key);
    }

    public String getAccountStatus(Provisioning prov) {
        String domainStatus = null;
        String accountStatus = this.getAttr("zimbraAccountStatus");
        boolean isAdmin = this.getBooleanAttr("zimbraIsAdminAccount", false);
        boolean isDomainAdmin = this.getBooleanAttr("zimbraIsDomainAdminAccount", false);
        boolean bl = isAdmin = isAdmin && !isDomainAdmin;
        if (isAdmin) {
            return accountStatus;
        }
        if (this.mDomain != null) {
            try {
                Domain domain = prov.getDomain(this);
                if (domain != null) {
                    domainStatus = domain.getDomainStatusAsString();
                }
            }
            catch (ServiceException e) {
                ZimbraLog.account.warn((Object)("unable to get domain for account " + this.getName()), e);
                return accountStatus;
            }
        }
        if (domainStatus == null || domainStatus.equals("active")) {
            return accountStatus;
        }
        if (domainStatus.equals("locked")) {
            if (accountStatus.equals("maintenance") || accountStatus.equals("pending") || accountStatus.equals("closed")) {
                return accountStatus;
            }
            return "locked";
        }
        if (domainStatus.equals("maintenance") || domainStatus.equals("suspended") || domainStatus.equals("shutdown")) {
            if (accountStatus.equals("pending") || accountStatus.equals("closed")) {
                return accountStatus;
            }
            return "maintenance";
        }
        return "closed";
    }

    public boolean isCalendarResource() {
        return this.getAttr("zimbraCalResType") != null;
    }
}

