/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.DomainAccessManager;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AccessManager {
    private static AccessManager sManager;

    public static AccessManager getInstance() {
        if (sManager == null) {
            String className = LC.zimbra_class_accessmanager.value();
            if (className != null && !className.equals("")) {
                try {
                    sManager = (AccessManager)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    ZimbraLog.account.error((Object)("could not instantiate AccessManager interface of class '" + className + "'; defaulting to DomainAccessManager"), e);
                }
            }
            if (sManager == null) {
                sManager = new DomainAccessManager();
            }
        }
        return sManager;
    }

    public abstract boolean isDomainAdminOnly(AuthToken var1);

    public Account getAccount(AuthToken at) throws ServiceException {
        return Provisioning.getInstance().get(Provisioning.AccountBy.id, at.getAccountId(), at);
    }

    protected Account getAdminAccount(AuthToken at) throws ServiceException {
        String adminAcctId = at.getAdminAccountId();
        if (adminAcctId == null) {
            return null;
        }
        return Provisioning.getInstance().get(Provisioning.AccountBy.id, adminAcctId, at);
    }

    public Domain getDomain(AuthToken at) throws ServiceException {
        return Provisioning.getInstance().getDomain(this.getAccount(at));
    }

    public abstract boolean canAccessAccount(AuthToken var1, Account var2, boolean var3) throws ServiceException;

    public abstract boolean canAccessAccount(AuthToken var1, Account var2) throws ServiceException;

    public abstract boolean canAccessAccount(Account var1, Account var2, boolean var3) throws ServiceException;

    public abstract boolean canAccessAccount(Account var1, Account var2) throws ServiceException;

    public abstract boolean canAccessDomain(AuthToken var1, String var2) throws ServiceException;

    public abstract boolean canAccessDomain(AuthToken var1, Domain var2) throws ServiceException;

    public abstract boolean canAccessCos(AuthToken var1, Cos var2) throws ServiceException;

    public abstract boolean canAccessEmail(AuthToken var1, String var2) throws ServiceException;

    public abstract boolean canModifyMailQuota(AuthToken var1, Account var2, long var3) throws ServiceException;

    public boolean allowPrivateAccess(Account authAccount, Account targetAccount, boolean asAdmin) throws ServiceException {
        if (authAccount != null && targetAccount != null) {
            if (authAccount.getId().equalsIgnoreCase(targetAccount.getId())) {
                return true;
            }
            if (this.canAccessAccount(authAccount, targetAccount, asAdmin)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isParentOf(AuthToken at, Account target) throws ServiceException {
        Account acct = this.getAccount(at);
        return this.isParentOf(acct, target);
    }

    protected boolean isParentOf(Account credentials, Account target) {
        String targetId;
        Set<String> childAccts = credentials.getMultiAttrSet("zimbraChildAccount");
        return childAccts.contains(targetId = target.getId());
    }

    protected void checkDomainStatus(Account acct) throws ServiceException {
        Domain domain = Provisioning.getInstance().getDomain(acct);
        this.checkDomainStatus(domain);
    }

    protected void checkDomainStatus(String domainName) throws ServiceException {
        Domain domain = Provisioning.getInstance().get(Provisioning.DomainBy.name, domainName);
        this.checkDomainStatus(domain);
    }

    public void checkDomainStatus(Domain domain) throws ServiceException {
        if (domain != null && (domain.isSuspended() || domain.isShutdown())) {
            throw ServiceException.PERM_DENIED("domain is " + domain.getDomainStatusAsString());
        }
    }

    public abstract boolean canDo(Account var1, Entry var2, Right var3, boolean var4);

    public abstract boolean canDo(AuthToken var1, Entry var2, Right var3, boolean var4);

    public abstract boolean canDo(String var1, Entry var2, Right var3, boolean var4);

    public boolean canDo(Account grantee, Entry target, Right rightNeeded, boolean asAdmin, ViaGrant viaGrant) throws ServiceException {
        return this.canDo(grantee, target, rightNeeded, asAdmin);
    }

    public boolean canDo(AuthToken grantee, Entry target, Right rightNeeded, boolean asAdmin, ViaGrant viaGrant) throws ServiceException {
        return this.canDo(grantee, target, rightNeeded, asAdmin);
    }

    public boolean canDo(String granteeEmail, Entry target, Right rightNeeded, boolean asAdmin, ViaGrant viaGrant) throws ServiceException {
        return this.canDo(granteeEmail, target, rightNeeded, asAdmin);
    }

    public abstract boolean canGetAttrs(Account var1, Entry var2, Set<String> var3, boolean var4) throws ServiceException;

    public abstract boolean canGetAttrs(AuthToken var1, Entry var2, Set<String> var3, boolean var4) throws ServiceException;

    public AttrRightChecker canGetAttrs(Account credentials, Entry target, boolean asAdmin) throws ServiceException {
        throw ServiceException.FAILURE("not supported", null);
    }

    public AttrRightChecker canGetAttrs(AuthToken credentials, Entry target, boolean asAdmin) throws ServiceException {
        throw ServiceException.FAILURE("not supported", null);
    }

    public abstract boolean canSetAttrs(Account var1, Entry var2, Set<String> var3, boolean var4) throws ServiceException;

    public abstract boolean canSetAttrs(AuthToken var1, Entry var2, Set<String> var3, boolean var4) throws ServiceException;

    public abstract boolean canSetAttrs(Account var1, Entry var2, Map<String, Object> var3, boolean var4) throws ServiceException;

    public abstract boolean canSetAttrs(AuthToken var1, Entry var2, Map<String, Object> var3, boolean var4) throws ServiceException;

    public boolean canSetAttrsOnCreate(Account credentials, TargetType targetType, String entryName, Map<String, Object> attrs, boolean asAdmin) throws ServiceException {
        throw ServiceException.FAILURE("not supported", null);
    }

    public boolean canPerform(Account credentials, Entry target, Right rightNeeded, boolean canDelegate, Map<String, Object> attrs, boolean asAdmin, ViaGrant viaGrant) throws ServiceException {
        throw ServiceException.FAILURE("not supported", null);
    }

    public boolean canPerform(AuthToken credentials, Entry target, Right rightNeeded, boolean canDelegate, Map<String, Object> attrs, boolean asAdmin, ViaGrant viaGrant) throws ServiceException {
        throw ServiceException.FAILURE("not supported", null);
    }

    public static interface AttrRightChecker {
        public boolean allowAttr(String var1);
    }

    public static class ViaGrant {
        private ViaGrant mImpl;

        public void setImpl(ViaGrant impl) {
            this.mImpl = impl;
        }

        public String getTargetType() {
            return this.mImpl == null ? null : this.mImpl.getTargetType();
        }

        public String getTargetName() {
            return this.mImpl == null ? null : this.mImpl.getTargetName();
        }

        public String getGranteeType() {
            return this.mImpl == null ? null : this.mImpl.getGranteeType();
        }

        public String getGranteeName() {
            return this.mImpl == null ? null : this.mImpl.getGranteeName();
        }

        public String getRight() {
            return this.mImpl == null ? null : this.mImpl.getRight();
        }

        public boolean isNegativeGrant() {
            return this.mImpl == null ? null : Boolean.valueOf(this.mImpl.isNegativeGrant());
        }

        public boolean available() {
            return this.mImpl != null;
        }
    }
}

