/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util.memcached;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.BEncoding;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.common.util.memcached.BigByteArrayMemcachedMap;
import com.zimbra.common.util.memcached.ByteArraySerializer;
import com.zimbra.common.util.memcached.MemcachedKey;
import com.zimbra.common.util.memcached.MemcachedMap;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.CRC32;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraMemcachedClient {
    public static final int DEFAULT_EXPIRY = -1;
    public static final long DEFAULT_TIMEOUT = -1L;
    private MemcachedClient mMCDClient = null;
    private int mDefaultExpiry = 86400;
    private long mDefaultTimeout = 10000L;
    private String mServerList;
    private String mHashAlgorithm;
    private boolean mBinaryProtocolEnabled;
    private static final int DEFAULT_PORT = 11211;
    private static final int MAX_CHUNK_SIZE = 1047552;
    private static final int MAX_VALUE_SIZE = 0x6400000;
    private static final int CKSUM_LEN = 32768;
    private static final byte BBA_PREFIX_VALUE = 86;
    private static final byte BBA_PREFIX_TOC = 84;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            return this.mMCDClient != null;
        }
    }

    public synchronized String getServerList() {
        return this.mServerList;
    }

    public synchronized String getHashAlgorithm() {
        return this.mHashAlgorithm;
    }

    public synchronized boolean getBinaryProtocolEnabled() {
        return this.mBinaryProtocolEnabled;
    }

    public synchronized int getDefaultExpirySeconds() {
        return this.mDefaultExpiry;
    }

    public synchronized long getDefaultTimeoutMillis() {
        return this.mDefaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String[] servers, boolean useBinaryProtocol, String hashAlgorithm, int defaultExpiry, long defaultTimeout) throws ServiceException {
        HashAlgorithm ha;
        Properties props = System.getProperties();
        props.put("net.spy.log.LoggerImpl", "net.spy.memcached.compat.log.Log4JLogger");
        HashAlgorithm hashAlgo = HashAlgorithm.KETAMA_HASH;
        if (hashAlgorithm != null && hashAlgorithm.length() > 0 && (ha = HashAlgorithm.valueOf((String)hashAlgorithm)) != null) {
            hashAlgo = ha;
        }
        int qLen = 16384;
        int bufSize = 16384;
        MemcachedClient client = null;
        StringBuilder serverList = new StringBuilder();
        if (servers != null && servers.length > 0) {
            TreeSet<String> tset = new TreeSet<String>();
            for (int i = 0; i < servers.length; ++i) {
                tset.add(servers[i].toLowerCase());
            }
            for (String s : tset) {
                if (serverList.length() > 0) {
                    serverList.append(", ");
                }
                serverList.append(s);
            }
            List<InetSocketAddress> serverAddrs = ZimbraMemcachedClient.parseServerList(tset.toArray(new String[0]));
            Object cf = useBinaryProtocol ? new BinaryConnectionFactory(qLen, bufSize, hashAlgo) : new DefaultConnectionFactory(qLen, bufSize, hashAlgo);
            try {
                client = new MemcachedClient((ConnectionFactory)cf, serverAddrs);
                boolean added = client.addObserver((ConnectionObserver)new ConnObserver());
                if (!added) {
                    ZimbraLog.misc.error("Unable to add connection observer to memcached client");
                }
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("Unable to initialize memcached client", e);
            }
        }
        MemcachedClient oldClient = null;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            oldClient = this.mMCDClient;
            this.mMCDClient = client;
            this.mDefaultExpiry = defaultExpiry;
            this.mDefaultTimeout = defaultTimeout;
            this.mServerList = serverList.length() > 0 ? serverList.toString() : null;
            this.mHashAlgorithm = hashAlgo.toString();
            this.mBinaryProtocolEnabled = useBinaryProtocol;
        }
        if (oldClient != null) {
            this.disconnect(oldClient, 30000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(long timeout) {
        MemcachedClient client;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            client = this.mMCDClient;
            this.mMCDClient = null;
            if (timeout == -1L) {
                timeout = this.mDefaultTimeout;
            }
        }
        if (client != null) {
            this.disconnect(client, timeout);
        }
    }

    private void disconnect(MemcachedClient client, long timeout) {
        boolean success;
        boolean drained = client.waitForQueues(timeout, TimeUnit.MILLISECONDS);
        if (!drained) {
            ZimbraLog.misc.warn("Memcached client did not drain queue in " + timeout + "ms");
        }
        if (!(success = client.shutdown(timeout, TimeUnit.MILLISECONDS))) {
            ZimbraLog.misc.warn("Memcached client did not shutdown gracefully in " + timeout + "ms; forcing immediate shutdowb");
            client.shutdown();
        }
    }

    private static List<InetSocketAddress> parseServerList(String[] servers) {
        if (servers != null) {
            ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>(servers.length);
            for (String server : servers) {
                if (server.length() == 0) continue;
                String[] parts = server.split(":");
                if (parts != null) {
                    String host;
                    int port;
                    block8: {
                        port = 11211;
                        if (parts.length == 1) {
                            host = parts[0];
                        } else {
                            if (parts.length == 2) {
                                host = parts[0];
                                try {
                                    port = Integer.parseInt(parts[1]);
                                    break block8;
                                }
                                catch (NumberFormatException e) {
                                    ZimbraLog.misc.warn("Invalid server " + server);
                                    continue;
                                }
                            }
                            ZimbraLog.misc.warn("Invalid server " + server);
                            continue;
                        }
                    }
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    addrs.add(addr);
                    continue;
                }
                ZimbraLog.misc.warn("Invalid server " + server);
            }
            return addrs;
        }
        return new ArrayList<InetSocketAddress>(0);
    }

    public Object get(String key) {
        return this.get(key, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key, long timeout) {
        MemcachedClient client;
        Object value = null;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            client = this.mMCDClient;
            if (timeout == -1L) {
                timeout = this.mDefaultTimeout;
            }
        }
        if (client == null) {
            return null;
        }
        Future future = client.asyncGet(key);
        try {
            value = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            ZimbraLog.misc.warn((Object)("memcached asyncGet timed out after " + timeout + "ms"), e);
            future.cancel(false);
        }
        catch (InterruptedException e) {
            ZimbraLog.misc.warn((Object)"InterruptedException during memcached asyncGet operation", e);
        }
        catch (ExecutionException e) {
            ZimbraLog.misc.warn((Object)"ExecutionException during memcached asyncGet operation", e);
        }
        return value;
    }

    public Map<String, Object> getMulti(Collection<String> keys) {
        return this.getMulti(keys, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMulti(Collection<String> keys, long timeout) {
        MemcachedClient client;
        Map<String, Object> value = null;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            client = this.mMCDClient;
            if (timeout == -1L) {
                timeout = this.mDefaultTimeout;
            }
        }
        if (client != null) {
            Future future = client.asyncGetBulk(keys);
            try {
                value = (Map)future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                ZimbraLog.misc.warn((Object)("memcached asyncGetBulk timed out after " + timeout + "ms"), e);
                future.cancel(false);
            }
            catch (InterruptedException e) {
                ZimbraLog.misc.warn((Object)"InterruptedException during memcached asyncGetBulk operation", e);
            }
            catch (ExecutionException e) {
                ZimbraLog.misc.warn((Object)"ExecutionException during memcached asyncGetBulk operation", e);
            }
        }
        if (value == null) {
            value = new HashMap<String, Object>(keys.size());
        }
        for (String key : keys) {
            if (value.containsKey(key)) continue;
            value.put(key, null);
        }
        return value;
    }

    public boolean put(String key, Object value, boolean waitForAck) {
        return this.put(key, value, -1, -1L, waitForAck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String key, Object value, int expirySec, long timeout, boolean waitForAck) {
        MemcachedClient client;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            client = this.mMCDClient;
            if (expirySec == -1) {
                expirySec = this.mDefaultExpiry;
            }
            if (timeout == -1L) {
                timeout = this.mDefaultTimeout;
            }
        }
        if (client == null) {
            return false;
        }
        Future future = client.set(key, expirySec, value);
        if (waitForAck) {
            Boolean success = null;
            try {
                success = (Boolean)future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                ZimbraLog.misc.warn((Object)("memcached set timed out after " + timeout + "ms"), e);
                future.cancel(false);
            }
            catch (InterruptedException e) {
                ZimbraLog.misc.warn((Object)"InterruptedException during memcached set operation", e);
            }
            catch (ExecutionException e) {
                ZimbraLog.misc.warn((Object)"ExecutionException during memcached set operation", e);
            }
            return success != null && success != false;
        }
        return true;
    }

    public boolean remove(String key, boolean waitForAck) {
        return this.remove(key, -1L, waitForAck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String key, long timeout, boolean waitForAck) {
        MemcachedClient client;
        Boolean success = null;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            client = this.mMCDClient;
            if (timeout == -1L) {
                timeout = this.mDefaultTimeout;
            }
        }
        if (client == null) {
            return false;
        }
        Future future = client.delete(key);
        if (waitForAck) {
            try {
                success = (Boolean)future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                ZimbraLog.misc.warn((Object)("memcached delete timed out after " + timeout + "ms"), e);
                future.cancel(false);
            }
            catch (InterruptedException e) {
                ZimbraLog.misc.warn((Object)"InterruptedException during memcached delete operation", e);
            }
            catch (ExecutionException e) {
                ZimbraLog.misc.warn((Object)"ExecutionException during memcached delete operation", e);
            }
            return success != null && success != false;
        }
        return true;
    }

    public boolean putBigByteArray(String key, byte[] value, boolean waitForAck) {
        return this.putBigByteArray(key, value, -1, -1L, waitForAck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putBigByteArray(String key, byte[] value, int expirySec, long timeout, boolean waitForAck) {
        ByteArray mainValue;
        MemcachedClient client;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            client = this.mMCDClient;
            if (expirySec == -1) {
                expirySec = this.mDefaultExpiry;
            }
            if (timeout == -1L) {
                timeout = this.mDefaultTimeout;
            }
        }
        if (client == null) {
            return false;
        }
        ByteArrayTranscoder bat = new ByteArrayTranscoder();
        if (value.length < 1047552) {
            byte[] prefixed = new byte[value.length + 1];
            System.arraycopy(value, 0, prefixed, 0, value.length);
            prefixed[value.length] = 86;
            mainValue = new ByteArray(prefixed);
        } else {
            byte[] tocBytes;
            ByteArrayChunks chunks;
            try {
                chunks = new ByteArrayChunks(value);
            }
            catch (ServiceException e) {
                ZimbraLog.misc.warn((Object)"Unable to split byte array into chunks", e);
                return false;
            }
            ByteArrayChunksTOC toc = chunks.makeTOC();
            String chunkKeyPrefix = key + ":" + toc.getFingerprint() + ".";
            int numChunks = chunks.getNumChunks();
            for (int i = 0; i < numChunks; ++i) {
                String chunkKey = chunkKeyPrefix + i;
                ByteArray byteArray = chunks.getChunk(i);
                Future future = client.set(chunkKey, expirySec, (Object)byteArray, (Transcoder)bat);
                if (!waitForAck) continue;
                Boolean success = null;
                try {
                    success = (Boolean)future.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    ZimbraLog.misc.warn((Object)("memcached set timed out after " + timeout + "ms"), e);
                    future.cancel(false);
                }
                catch (InterruptedException e) {
                    ZimbraLog.misc.warn((Object)"InterruptedException during memcached set operation", e);
                }
                catch (ExecutionException e) {
                    ZimbraLog.misc.warn((Object)"ExecutionException during memcached set operation", e);
                }
                if (success != null && success.booleanValue()) continue;
                return false;
            }
            try {
                tocBytes = toc.encode().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                ZimbraLog.misc.warn((Object)"Unable to get bytes for BBA table of contents", e);
                return false;
            }
            byte[] prefixed = new byte[tocBytes.length + 1];
            System.arraycopy(tocBytes, 0, prefixed, 0, tocBytes.length);
            prefixed[tocBytes.length] = 84;
            mainValue = new ByteArray(prefixed);
        }
        Future future = client.set(key, expirySec, (Object)mainValue, (Transcoder)bat);
        if (waitForAck) {
            Boolean success = null;
            try {
                success = (Boolean)future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                ZimbraLog.misc.warn((Object)("memcached set timed out after " + timeout + "ms"), e);
                future.cancel(false);
            }
            catch (InterruptedException e) {
                ZimbraLog.misc.warn((Object)"InterruptedException during memcached set operation", e);
            }
            catch (ExecutionException e) {
                ZimbraLog.misc.warn((Object)"ExecutionException during memcached set operation", e);
            }
            return success != null && success != false;
        }
        return true;
    }

    public byte[] getBigByteArray(String key) throws ServiceException {
        return this.getBigByteArray(key, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBigByteArray(String key, long timeout) {
        ByteArrayChunksTOC toc;
        MemcachedClient client;
        ZimbraMemcachedClient zimbraMemcachedClient = this;
        synchronized (zimbraMemcachedClient) {
            client = this.mMCDClient;
            if (timeout == -1L) {
                timeout = this.mDefaultTimeout;
            }
        }
        if (client == null) {
            return null;
        }
        ByteArrayTranscoder bat = new ByteArrayTranscoder();
        ByteArray mainValue = null;
        Future future = client.asyncGet(key, (Transcoder)bat);
        try {
            mainValue = (ByteArray)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            ZimbraLog.misc.warn((Object)("memcached asyncGetBulk timed out after " + timeout + "ms"), e);
            future.cancel(false);
        }
        catch (InterruptedException e) {
            ZimbraLog.misc.warn((Object)"InterruptedException during memcached asyncGetBulk operation", e);
        }
        catch (ExecutionException e) {
            ZimbraLog.misc.warn((Object)"ExecutionException during memcached asyncGetBulk operation", e);
        }
        if (mainValue == null) {
            return null;
        }
        byte[] prefixed = mainValue.getBytes();
        if (prefixed == null || prefixed.length < 2) {
            return null;
        }
        byte[] value = new byte[prefixed.length - 1];
        System.arraycopy(prefixed, 0, value, 0, prefixed.length - 1);
        if (prefixed[prefixed.length - 1] == 86) {
            return value;
        }
        String tocEncoded = null;
        try {
            tocEncoded = new String(value, "utf-8");
            toc = new ByteArrayChunksTOC(tocEncoded);
        }
        catch (UnsupportedEncodingException e) {
            ZimbraLog.misc.warn((Object)"Unable to decode BBA table of contents", e);
            return null;
        }
        catch (ServiceException e) {
            ZimbraLog.misc.warn("Invalid big byte array TOC: " + tocEncoded);
            return null;
        }
        int numChunks = toc.getNumChunks();
        if (numChunks <= 0) {
            ZimbraLog.misc.warn("Big byte array TOC has numChunks=0");
            return null;
        }
        ArrayList<String> chunkKeys = new ArrayList<String>(numChunks);
        for (int i = 0; i < numChunks; ++i) {
            String ck = key + ":" + toc.getFingerprint() + "." + i;
            chunkKeys.add(ck);
        }
        Map vals = null;
        Future futureChunks = client.asyncGetBulk(chunkKeys, (Transcoder)bat);
        try {
            vals = (Map)futureChunks.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            ZimbraLog.misc.warn((Object)("memcached asyncGetBulk timed out after " + timeout + "ms"), e);
            futureChunks.cancel(false);
        }
        catch (InterruptedException e) {
            ZimbraLog.misc.warn((Object)"InterruptedException during memcached asyncGetBulk operation", e);
        }
        catch (ExecutionException e) {
            ZimbraLog.misc.warn((Object)"ExecutionException during memcached asyncGetBulk operation", e);
        }
        if (vals == null) {
            return null;
        }
        ByteArray[] byteArrays = new ByteArray[numChunks];
        int index = 0;
        for (String ck : chunkKeys) {
            ByteArray ba = (ByteArray)vals.get(ck);
            if (ba == null) {
                return null;
            }
            byteArrays[index] = ba;
            ++index;
        }
        byte[] data = null;
        try {
            data = ByteArrayChunks.combine(byteArrays, toc);
        }
        catch (ServiceException e) {
            ZimbraLog.misc.warn((Object)"Unable to reassemble byte array from chunks", e);
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        Test t = new Test();
        t.test();
    }

    public static class Test {
        private static final int KB = 1024;
        private static final int MB = 0x100000;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() throws Exception {
            ZimbraMemcachedClient client = new ZimbraMemcachedClient();
            String[] servers = new String[]{"localhost:11211"};
            client.connect(servers, false, null, 3600, 5000L);
            try {
                int reps = 100;
                long start = System.currentTimeMillis();
                this.testInteger(client, reps);
                this.testString(client, "Str 10", 10, reps);
                this.testString(client, "Str 1K", 1024, reps);
                this.testString(client, "Str 50K", 51200, reps);
                this.testString(client, "Str 100K", 102400, reps);
                this.testString(client, "Str 500K", 512000, reps);
                this.testBBA(client, "BBA 10", 10, reps);
                this.testBBA(client, "BBA 1K", 1024, reps);
                this.testBBA(client, "BBA 5K", 5120, reps);
                this.testBBA(client, "BBA 10K", 10240, reps);
                this.testBBA(client, "BBA 50K", 51200, reps);
                this.testBBA(client, "BBA 100K", 102400, reps);
                this.testBBA(client, "BBA 500K", 512000, reps);
                this.testBBA(client, "BBA 900K", 921600, reps);
                this.testBBA(client, "BBA 1M--", 1047542, reps);
                this.testBBA(client, "BBA 1M", 0x100000, reps);
                this.testBBA(client, "BBA 5M", 0x500000, reps);
                this.testBBA(client, "BBA 10M", 0xA00000, reps);
                this.testBBA(client, "BBA 20M", 0x1400000, reps);
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("Took " + elapsed + "ms");
            }
            finally {
                client.disconnect(1000L);
            }
        }

        private void pause() throws Exception {
            System.gc();
            Thread.sleep(10L);
        }

        private void printReport(String testName, long elapsed, int bytes, boolean success) {
            double kbPerSec = (double)bytes / 1024.0 / (double)elapsed * 1000.0;
            System.out.printf("%-9s: %5dms, %7.2fkb/s, %s\n", testName, elapsed, kbPerSec, success ? "PASS" : "FAIL");
        }

        private boolean testInteger(ZimbraMemcachedClient client, int reps) throws Exception {
            MemcachedMap<TestKey, Integer> map = new MemcachedMap<TestKey, Integer>(client, new IntegerSerializer());
            TestKey foo = new TestKey("fooInt");
            int val1 = 1234567890;
            boolean success = true;
            map.put(foo, val1);
            this.pause();
            long start = System.currentTimeMillis();
            for (int i = 0; i < reps; ++i) {
                boolean same;
                Integer val2 = map.get(foo);
                boolean bl = same = val2 != null && val2 == val1;
                if (same) continue;
                success = false;
                System.out.println("failed on rep " + i);
            }
            long elapsed = System.currentTimeMillis() - start;
            this.printReport("Integer", elapsed, 10, success);
            return success;
        }

        private boolean testString(ZimbraMemcachedClient client, String testName, int dataLen, int reps) throws Exception {
            MemcachedMap<TestKey, String> map = new MemcachedMap<TestKey, String>(client, new StringSerializer());
            TestKey foo = new TestKey("fooStr");
            StringBuilder sb = new StringBuilder(dataLen + 20);
            while (sb.length() < dataLen) {
                sb.append("Hello, STR!  ");
            }
            String val1 = sb.substring(0, dataLen);
            boolean success = true;
            map.put(foo, val1);
            this.pause();
            long start = System.currentTimeMillis();
            for (int i = 0; i < reps; ++i) {
                String val2 = map.get(foo);
                boolean same = val1.equals(val2);
                if (same) continue;
                success = false;
                System.out.println("failed on rep " + i);
            }
            long elapsed = System.currentTimeMillis() - start;
            this.printReport(testName, elapsed, dataLen, success);
            return success;
        }

        private boolean testBBA(ZimbraMemcachedClient client, String testName, int dataLen, int reps) throws Exception {
            BigByteArrayMemcachedMap<TestKey, ByteArray> map = new BigByteArrayMemcachedMap<TestKey, ByteArray>(client, new BBASerializer());
            TestKey foo = new TestKey("fooBBA");
            StringBuilder sb = new StringBuilder(dataLen + 20);
            while (sb.length() < dataLen) {
                sb.append("Hello, BBA!  ");
            }
            byte[] sbBytes = sb.toString().getBytes("utf-8");
            byte[] data = new byte[dataLen];
            System.arraycopy(sbBytes, 0, data, 0, dataLen);
            ByteArray bytes1 = new ByteArray(data);
            ByteArray bytes2 = null;
            boolean success = true;
            map.put(foo, bytes1);
            this.pause();
            long start = System.currentTimeMillis();
            for (int i = 0; i < reps; ++i) {
                boolean same;
                bytes2 = map.get(foo);
                boolean bl = same = bytes2 != null && bytes1.getBytes().length == bytes2.getBytes().length;
                if (same) continue;
                success = false;
                System.out.println("failed on rep " + i);
            }
            long elapsed = System.currentTimeMillis() - start;
            byte[] b1 = bytes1 != null ? bytes1.getBytes() : null;
            byte[] b2 = bytes2 != null ? bytes2.getBytes() : null;
            success = success && Arrays.equals(b1, b2);
            this.printReport(testName, elapsed, dataLen, success);
            return success;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class BBASerializer
        implements ByteArraySerializer<ByteArray> {
            private BBASerializer() {
            }

            @Override
            public byte[] serialize(ByteArray value) throws ServiceException {
                return value.getBytes();
            }

            @Override
            public ByteArray deserialize(byte[] bytes) throws ServiceException {
                return new ByteArray(bytes);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class StringSerializer
        implements MemcachedSerializer<String> {
            private StringSerializer() {
            }

            @Override
            public Object serialize(String value) throws ServiceException {
                return value;
            }

            @Override
            public String deserialize(Object obj) throws ServiceException {
                return (String)obj;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class IntegerSerializer
        implements MemcachedSerializer<Integer> {
            private IntegerSerializer() {
            }

            @Override
            public Object serialize(Integer value) throws ServiceException {
                return value;
            }

            @Override
            public Integer deserialize(Object obj) throws ServiceException {
                return (Integer)obj;
            }
        }

        private static class TestKey
        implements MemcachedKey {
            private String mKey;

            public TestKey(String k) {
                this.mKey = k;
            }

            public String getKeyPrefix() {
                return null;
            }

            public String getKeyValue() {
                return this.mKey;
            }
        }
    }

    private static class ByteArrayChunks {
        private int mTotalLen;
        private int mNumChunks;
        private ByteArray[] mChunks;
        private long mFingerprint;
        private long[] mChecksum;

        public ByteArrayChunks(byte[] data) throws ServiceException {
            if (data.length > 0x6400000) {
                throw ServiceException.FAILURE("Byte array is bigger than max 104857600 bytes; requested " + data.length + " bytes", null);
            }
            this.mTotalLen = data.length;
            this.mNumChunks = (data.length + 1047552 - 1) / 1047552;
            this.mChunks = new ByteArray[this.mNumChunks];
            this.mChecksum = new long[this.mNumChunks];
            CRC32 ff = new CRC32();
            CRC32 cksumChunk = new CRC32();
            for (int i = 0; i < this.mNumChunks; ++i) {
                int offset = 1047552 * i;
                int len = i < this.mNumChunks - 1 ? 1047552 : data.length - offset;
                byte[] bytes = new byte[len];
                System.arraycopy(data, offset, bytes, 0, len);
                this.mChunks[i] = new ByteArray(bytes);
                cksumChunk.reset();
                int csLen = Math.min(32768, bytes.length);
                ff.update(bytes, 0, csLen);
                cksumChunk.update(bytes, 0, csLen);
                this.mChecksum[i] = cksumChunk.getValue();
            }
            this.mFingerprint = ff.getValue();
        }

        public int getTotalLen() {
            return this.mTotalLen;
        }

        public int getNumChunks() {
            return this.mNumChunks;
        }

        public ByteArray getChunk(int chunkIndex) {
            return this.mChunks[chunkIndex];
        }

        public ByteArrayChunksTOC makeTOC() {
            int[] lengths = new int[this.mNumChunks];
            for (int i = 0; i < this.mNumChunks; ++i) {
                lengths[i] = this.mChunks[i].getBytes().length;
            }
            return new ByteArrayChunksTOC(this.mNumChunks, this.mFingerprint, lengths, this.mChecksum);
        }

        public static byte[] combine(ByteArray[] arrays, ByteArrayChunksTOC toc) throws ServiceException {
            if (arrays.length != toc.getNumChunks()) {
                return null;
            }
            int len = 0;
            CRC32 cksumChunk = new CRC32();
            for (int i = 0; i < arrays.length; ++i) {
                ByteArray ba = arrays[i];
                if (ba == null) {
                    return null;
                }
                byte[] chunk = ba.getBytes();
                if (chunk == null) {
                    return null;
                }
                if (chunk.length != toc.getLength(i)) {
                    return null;
                }
                cksumChunk.reset();
                int csLen = Math.min(32768, chunk.length);
                cksumChunk.update(chunk, 0, csLen);
                if (cksumChunk.getValue() != toc.getChecksum(i)) {
                    return null;
                }
                len += chunk.length;
            }
            if (len > 0x6400000) {
                throw ServiceException.FAILURE("Byte array is bigger than max 104857600 bytes; requested " + len + " bytes", null);
            }
            byte[] data = new byte[len];
            int offset = 0;
            for (int i = 0; i < arrays.length; ++i) {
                byte[] chunk = arrays[i].getBytes();
                System.arraycopy(chunk, 0, data, offset, chunk.length);
                offset += chunk.length;
            }
            return data;
        }
    }

    private static class ByteArrayChunksTOC {
        private int mNumChunks;
        private int[] mLength;
        private long[] mChecksum;
        private long mFingerprint;
        private static final String FN_NUM_CHUNKS = "n";
        private static final String FN_FINGERPRINT = "f";
        private static final String FN_LENGTH = "l";
        private static final String FN_CHECKSUM = "cs";

        public int getNumChunks() {
            return this.mNumChunks;
        }

        public int getLength(int chunkIndex) {
            return this.mLength[chunkIndex];
        }

        public long getChecksum(int chunkIndex) {
            return this.mChecksum[chunkIndex];
        }

        public long getFingerprint() {
            return this.mFingerprint;
        }

        public String encode() {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put(FN_NUM_CHUNKS, Long.valueOf(this.mNumChunks));
            map.put(FN_FINGERPRINT, this.mFingerprint);
            for (int i = 0; i < this.mNumChunks; ++i) {
                map.put(FN_LENGTH + i, Long.valueOf(this.mLength[i]));
                map.put(FN_CHECKSUM + i, this.mChecksum[i]);
            }
            return BEncoding.encode(map);
        }

        private static long getFieldLong(Map map, String field) throws ServiceException {
            Object val = map.get(field);
            if (val == null) {
                throw ServiceException.FAILURE("Field " + field + " not found", null);
            }
            if (val instanceof Long) {
                return (Long)val;
            }
            if (val instanceof Integer) {
                return ((Integer)val).longValue();
            }
            if (val instanceof String) {
                try {
                    return Long.parseLong((String)val);
                }
                catch (NumberFormatException e) {
                    throw ServiceException.FAILURE("Invalid number " + val.toString(), null);
                }
            }
            throw ServiceException.FAILURE("Invalid number " + val.toString(), null);
        }

        public ByteArrayChunksTOC(String encoded) throws ServiceException {
            Map map;
            try {
                map = (Map)BEncoding.decode(encoded);
            }
            catch (BEncoding.BEncodingException e) {
                throw ServiceException.FAILURE("Invalid ByteArrayChunksTOC value: " + encoded, null);
            }
            this.mNumChunks = (int)ByteArrayChunksTOC.getFieldLong(map, FN_NUM_CHUNKS);
            this.mFingerprint = ByteArrayChunksTOC.getFieldLong(map, FN_FINGERPRINT);
            this.mLength = new int[this.mNumChunks];
            this.mChecksum = new long[this.mNumChunks];
            for (int i = 0; i < this.mNumChunks; ++i) {
                this.mLength[i] = (int)ByteArrayChunksTOC.getFieldLong(map, FN_LENGTH + i);
                this.mChecksum[i] = ByteArrayChunksTOC.getFieldLong(map, FN_CHECKSUM + i);
            }
        }

        public ByteArrayChunksTOC(int numChunks, long fingerprint, int[] length, long[] checksum) {
            this.mNumChunks = numChunks;
            this.mFingerprint = fingerprint;
            this.mLength = length;
            this.mChecksum = checksum;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteArrayTranscoder
    implements Transcoder<ByteArray> {
        private ByteArrayTranscoder() {
        }

        public ByteArray decode(CachedData cachedData) {
            return new ByteArray(cachedData.getData());
        }

        public CachedData encode(ByteArray byteArray) {
            return new CachedData(0, byteArray.getBytes(), 0x100000);
        }

        public int getMaxSize() {
            return 0x100000;
        }
    }

    private static class ByteArray {
        private byte[] mBytes;

        ByteArray(byte[] bytes) {
            this.mBytes = bytes;
        }

        public byte[] getBytes() {
            return this.mBytes;
        }
    }

    private static class ConnObserver
    implements ConnectionObserver {
        private ConnObserver() {
        }

        public void connectionEstablished(SocketAddress sa, int reconnectCount) {
            if (sa instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)sa;
                String hostPort = isa.getHostName() + ":" + isa.getPort();
                ZimbraLog.misc.info("Reconnected to memcached at " + hostPort);
            } else {
                ZimbraLog.misc.info("Reconnected to memcached at " + sa.toString());
            }
        }

        public void connectionLost(SocketAddress sa) {
            if (sa instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)sa;
                String hostPort = isa.getHostName() + ":" + isa.getPort();
                ZimbraLog.misc.warn("Lost connection to memcached at " + hostPort);
            } else {
                ZimbraLog.misc.warn("Lost connection to memcached at " + sa.toString());
            }
        }
    }
}

