/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util.memcached;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.memcached.MemcachedKey;
import com.zimbra.common.util.memcached.MemcachedSerializer;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedMap<K extends MemcachedKey, V> {
    private ZimbraMemcachedClient mClient;
    private MemcachedSerializer<V> mSerializer;
    private boolean mAckWrites;

    public MemcachedMap(ZimbraMemcachedClient client, MemcachedSerializer<V> serializer, boolean ackWrites) {
        this.mClient = client;
        this.mSerializer = serializer;
        this.mAckWrites = ackWrites;
    }

    public MemcachedMap(ZimbraMemcachedClient client, MemcachedSerializer<V> serializer) {
        this(client, serializer, true);
    }

    public V get(K key) throws ServiceException {
        String prefix = key.getKeyPrefix();
        String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
        Object valobj = this.mClient.get(kval);
        V value = null;
        if (valobj != null) {
            value = this.mSerializer.deserialize(valobj);
        }
        return value;
    }

    public Map<K, V> getMulti(Collection<K> keys) throws ServiceException {
        HashMap<String, MemcachedKey> keyMap = new HashMap<String, MemcachedKey>(keys.size());
        for (MemcachedKey key : keys) {
            String prefix = key.getKeyPrefix();
            String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
            keyMap.put(kval, key);
        }
        Map<String, Object> valueMap = this.mClient.getMulti(keyMap.keySet());
        HashMap<MemcachedKey, Object> result = new HashMap<MemcachedKey, Object>(keys.size());
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            MemcachedKey key = (MemcachedKey)keyMap.get(entry.getKey());
            if (key == null) continue;
            Object valobj = entry.getValue();
            Object value = null;
            if (valobj != null) {
                value = this.mSerializer.deserialize(valobj);
            }
            result.put(key, value);
        }
        return result;
    }

    public void put(K key, V value) throws ServiceException {
        String prefix = key.getKeyPrefix();
        String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
        Object valobj = this.mSerializer.serialize(value);
        this.mClient.put(kval, valobj, this.mAckWrites);
    }

    public void putMulti(Map<K, V> map) throws ServiceException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((MemcachedKey)entry.getKey(), entry.getValue());
        }
    }

    public void remove(K key) throws ServiceException {
        String prefix = key.getKeyPrefix();
        String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
        this.mClient.remove(kval, this.mAckWrites);
    }

    public void removeMulti(Collection<K> keys) throws ServiceException {
        for (MemcachedKey key : keys) {
            String prefix = key.getKeyPrefix();
            String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
            this.mClient.remove(kval, this.mAckWrites);
        }
    }
}

