/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util.memcached;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.memcached.ByteArraySerializer;
import com.zimbra.common.util.memcached.MemcachedKey;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigByteArrayMemcachedMap<K extends MemcachedKey, V> {
    private ZimbraMemcachedClient mClient;
    private ByteArraySerializer<V> mSerializer;
    private boolean mAckWrites;

    public BigByteArrayMemcachedMap(ZimbraMemcachedClient client, ByteArraySerializer<V> serializer, boolean ackWrites) {
        this.mClient = client;
        this.mSerializer = serializer;
        this.mAckWrites = ackWrites;
    }

    public BigByteArrayMemcachedMap(ZimbraMemcachedClient client, ByteArraySerializer<V> serializer) {
        this(client, serializer, true);
    }

    public V get(K key) throws ServiceException {
        String prefix = key.getKeyPrefix();
        String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
        byte[] data = this.mClient.getBigByteArray(kval);
        V value = null;
        if (data != null) {
            value = this.mSerializer.deserialize(data);
        }
        return value;
    }

    public void put(K key, V value) throws ServiceException {
        String prefix = key.getKeyPrefix();
        String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
        byte[] data = this.mSerializer.serialize(value);
        this.mClient.putBigByteArray(kval, data, this.mAckWrites);
    }

    public void remove(K key) throws ServiceException {
        String prefix = key.getKeyPrefix();
        String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
        this.mClient.remove(kval, this.mAckWrites);
    }

    public void removeMulti(Collection<K> keys) throws ServiceException {
        for (MemcachedKey key : keys) {
            String prefix = key.getKeyPrefix();
            String kval = prefix != null ? prefix + key.getKeyValue() : key.getKeyValue();
            this.mClient.remove(kval, this.mAckWrites);
        }
    }
}

