/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import java.io.IOException;
import javax.servlet.ServletOutputStream;

public class ZimbraServletOutputStream
implements Appendable {
    private static final int BUFFER_SIZE = LC.zimbra_servlet_output_stream_buffer_size.intValueWithinRange(512, 20480);
    ServletOutputStream mOut;
    StringBuilder mBuffer = new StringBuilder(BUFFER_SIZE);

    public ZimbraServletOutputStream(ServletOutputStream out) {
        this.mOut = out;
    }

    public Appendable append(CharSequence csq) throws IOException {
        this.append(csq, 0, csq.length());
        return this;
    }

    public Appendable append(char c) throws IOException {
        if (this.mBuffer.length() + 1 > BUFFER_SIZE) {
            this.flush();
        }
        this.mBuffer.append(c);
        return this;
    }

    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        int lenToAppend = end - start;
        if (lenToAppend >= BUFFER_SIZE) {
            this.flush();
            this.write(((Object)csq.subSequence(start, end)).toString());
        } else {
            if (this.mBuffer.length() + lenToAppend > BUFFER_SIZE) {
                this.flush();
            }
            this.mBuffer.append(csq, start, end);
        }
        return this;
    }

    private void write(String str) throws IOException {
        this.mOut.write(str.getBytes("utf-8"));
    }

    public void flush() throws IOException {
        if (this.mBuffer.length() > 0) {
            this.write(this.mBuffer.toString());
            this.mBuffer.setLength(0);
        }
    }
}

