/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraLog {
    private static final String C_IP = "ip";
    private static final String C_OIP = "oip";
    public static final String C_ID = "id";
    public static final String C_NAME = "name";
    public static final String C_AID = "aid";
    public static final String C_ANAME = "aname";
    public static final String C_CONNECTIONID = "cid";
    public static final String C_MID = "mid";
    private static final String C_USER_AGENT = "ua";
    private static final String C_MSG_ID = "msgid";
    private static final String C_ITEM = "item";
    private static final String C_DATA_SOURCE_NAME = "ds";
    private static final String C_PORT = "port";
    public static final Log misc = LogFactory.getLog("zimbra.misc");
    public static final Log index = LogFactory.getLog("zimbra.index");
    public static final Log index_lucene = LogFactory.getLog("zimbra.index.lucene");
    public static final Log index_search = LogFactory.getLog("zimbra.index.search");
    public static final Log index_add = LogFactory.getLog("zimbra.index.indexadd");
    public static final Log searchstats = LogFactory.getLog("zimbra.searchstats");
    public static final Log redolog = LogFactory.getLog("zimbra.redolog");
    public static final Log lmtp = LogFactory.getLog("zimbra.lmtp");
    public static final Log smtp = LogFactory.getLog("zimbra.smtp");
    public static final Log nio = LogFactory.getLog("zimbra.nio");
    public static final Log imap = LogFactory.getLog("zimbra.imap");
    public static final Log pop = LogFactory.getLog("zimbra.pop");
    public static final Log mailbox = LogFactory.getLog("zimbra.mailbox");
    public static final Log calendar = LogFactory.getLog("zimbra.calendar");
    public static final Log im = LogFactory.getLog("zimbra.im");
    public static final Log im_intercept = LogFactory.getLog("zimbra.im.intercept");
    public static final Log account = LogFactory.getLog("zimbra.account");
    public static final Log gal = LogFactory.getLog("zimbra.gal");
    public static final Log ldap = LogFactory.getLog("zimbra.ldap");
    public static final Log acl = LogFactory.getLog("zimbra.acl");
    public static final Log security = LogFactory.getLog("zimbra.security");
    public static final Log soap = LogFactory.getLog("zimbra.soap");
    public static final Log test = LogFactory.getLog("zimbra.test");
    public static final Log sqltrace = LogFactory.getLog("zimbra.sqltrace");
    public static final Log dbconn = LogFactory.getLog("zimbra.dbconn");
    public static final Log perf = LogFactory.getLog("zimbra.perf");
    public static final Log cache = LogFactory.getLog("zimbra.cache");
    public static final Log filter = LogFactory.getLog("zimbra.filter");
    public static final Log session = LogFactory.getLog("zimbra.session");
    public static final Log backup = LogFactory.getLog("zimbra.backup");
    public static final Log system = LogFactory.getLog("zimbra.system");
    public static final Log sync = LogFactory.getLog("zimbra.sync");
    public static final Log synctrace = LogFactory.getLog("zimbra.synctrace");
    public static final Log syncstate = LogFactory.getLog("zimbra.syncstate");
    public static final Log wbxml = LogFactory.getLog("zimbra.wbxml");
    public static final Log xsync = LogFactory.getLog("zimbra.xsync");
    public static final Log extensions = LogFactory.getLog("zimbra.extensions");
    public static final Log zimlet = LogFactory.getLog("zimbra.zimlet");
    public static final Log wiki = LogFactory.getLog("zimbra.wiki");
    public static final Log op = LogFactory.getLog("zimbra.op");
    public static final Log dav = LogFactory.getLog("zimbra.dav");
    public static final Log io = LogFactory.getLog("zimbra.io");
    public static final Log datasource = LogFactory.getLog("zimbra.datasource");
    public static final Log rmgmt = LogFactory.getLog("zimbra.rmgmt");
    public static final Log webclient = LogFactory.getLog("zimbra.webclient");
    public static final Log scheduler = LogFactory.getLog("zimbra.scheduler");
    public static final Log store = LogFactory.getLog("zimbra.store");
    public static final Log fb = LogFactory.getLog("zimbra.fb");
    public static final Log purge = LogFactory.getLog("zimbra.purge");
    public static final Log mailop = LogFactory.getLog("zimbra.mailop");
    public static final Log slogger = LogFactory.getLog("zimbra.slogger");
    public static final Log mbxmgr = LogFactory.getLog("zimbra.mbxmgr");
    public static final Map<String, String> CATEGORY_DESCRIPTIONS;
    private static final ThreadLocal<Map<String, String>> sContextMap;
    private static final ThreadLocal<String> sContextString;
    private static final Set<String> CONTEXT_KEY_ORDER;
    private static final Set<String> CONTEXT_FILTER;

    public static Set<String> getAccountNamesFromContext() {
        Map<String, String> contextMap = sContextMap.get();
        if (contextMap == null) {
            return Collections.emptySet();
        }
        String name = contextMap.get(C_NAME);
        String aname = contextMap.get(C_ANAME);
        if (name == null && aname == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        if (name != null) {
            names.add(name);
        }
        if (aname != null) {
            names.add(aname);
        }
        return names;
    }

    static String getContextString() {
        return sContextString.get();
    }

    public static void addContextFilters(String filters) {
        for (String item : filters.split(",")) {
            CONTEXT_FILTER.add(item);
        }
    }

    public static void addToContext(String key, String value) {
        if (key == null || CONTEXT_FILTER.contains(key)) {
            return;
        }
        Map<String, String> contextMap = sContextMap.get();
        boolean contextChanged = false;
        if (StringUtil.isNullOrEmpty(value)) {
            String oldValue;
            if (contextMap != null && (oldValue = contextMap.remove(key)) != null) {
                contextChanged = true;
            }
        } else {
            String oldValue;
            if (contextMap == null) {
                contextMap = new LinkedHashMap<String, String>();
                sContextMap.set(contextMap);
            }
            if (!StringUtil.equal(oldValue = contextMap.put(key, value), value)) {
                contextChanged = true;
            }
        }
        if (contextChanged) {
            ZimbraLog.updateContextString();
        }
    }

    private static void updateContextString() {
        String value;
        Map<String, String> contextMap = sContextMap.get();
        if (contextMap == null || contextMap.size() == 0) {
            sContextString.set(null);
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (String key : CONTEXT_KEY_ORDER) {
            value = contextMap.get(key);
            if (value == null) continue;
            ZimbraLog.encodeArg(sb, key, value);
        }
        for (String key : contextMap.keySet()) {
            if (CONTEXT_KEY_ORDER.contains(key)) continue;
            value = contextMap.get(key);
            if (key == null || value == null) continue;
            ZimbraLog.encodeArg(sb, key, value);
        }
        sContextString.set(sb.toString());
    }

    public static void addItemToContext(int itemId) {
        ZimbraLog.addToContext(C_ITEM, Integer.toString(itemId));
    }

    public static void removeFromContext(String key) {
        if (key != null) {
            ZimbraLog.addToContext(key, null);
        }
    }

    public static void removeItemFromContext(int itemId) {
        ZimbraLog.removeFromContext(C_ITEM);
    }

    public static void addAccountNameToContext(String accountName) {
        ZimbraLog.addToContext(C_NAME, accountName);
    }

    public static void removeAccountFromContext() {
        ZimbraLog.removeFromContext(C_ID);
        ZimbraLog.removeFromContext(C_MID);
        ZimbraLog.removeFromContext(C_NAME);
        ZimbraLog.removeFromContext(C_ANAME);
        ZimbraLog.removeFromContext(C_ITEM);
        ZimbraLog.removeFromContext(C_MSG_ID);
    }

    public static void addIpToContext(String ipAddress) {
        ZimbraLog.addToContext(C_IP, ipAddress);
    }

    public static void addOrigIpToContext(String ipAddress) {
        ZimbraLog.addToContext(C_OIP, ipAddress);
    }

    public static void addConnectionIdToContext(String connectionId) {
        ZimbraLog.addToContext(C_CONNECTIONID, connectionId);
    }

    public static void addMboxToContext(long mboxId) {
        ZimbraLog.addToContext(C_MID, Long.toString(mboxId));
    }

    public static void removeMboxFromContext() {
        ZimbraLog.removeFromContext(C_MID);
    }

    public static void addMsgIdToContext(String messageId) {
        ZimbraLog.addToContext(C_MSG_ID, messageId);
    }

    public static void addDataSourceNameToContext(String dataSourceName) {
        ZimbraLog.addToContext(C_DATA_SOURCE_NAME, dataSourceName);
    }

    public static void removeDataSourceNameFromContext() {
        ZimbraLog.removeFromContext(C_DATA_SOURCE_NAME);
    }

    public static void addPortToContext(int port) {
        ZimbraLog.addToContext(C_PORT, Integer.toString(port));
    }

    public static void addUserAgentToContext(String ua) {
        ZimbraLog.addToContext(C_USER_AGENT, ua);
    }

    public static void clearContext() {
        Map<String, String> contextMap = sContextMap.get();
        if (contextMap != null) {
            contextMap.clear();
        }
        sContextString.remove();
    }

    public static void toolSetupLog4j(String defaultLevel, String logFile, boolean showThreads) {
        String level = System.getProperty("zimbra.log4j.level");
        if (level == null) {
            level = defaultLevel;
        }
        Properties p = new Properties();
        p.put("log4j.rootLogger", level + ",A1");
        if (logFile != null) {
            p.put("log4j.appender.A1", "org.apache.log4j.FileAppender");
            p.put("log4j.appender.A1.File", logFile);
            p.put("log4j.appender.A1.Append", "false");
        } else {
            p.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        }
        p.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        if (showThreads) {
            p.put("log4j.appender.A1.layout.ConversionPattern", "[%t] [%x] %p: %m%n");
        } else {
            p.put("log4j.appender.A1.layout.ConversionPattern", "[%x] %p: %m%n");
        }
        PropertyConfigurator.configure((Properties)p);
    }

    public static void toolSetupLog4j(String defaultLevel, String propsFile) {
        if (propsFile != null && new File(propsFile).exists()) {
            PropertyConfigurator.configure((String)propsFile);
        } else {
            ZimbraLog.toolSetupLog4j(defaultLevel, null, false);
        }
    }

    private static void encodeArg(StringBuffer sb, String name, String value) {
        if (value == null) {
            value = "";
        }
        if (value.indexOf(59) != -1) {
            value = value.replaceAll(";", ";;");
        }
        value = value.replace('\r', ' ');
        value = value.replace('\n', ' ');
        sb.append(name);
        sb.append("=");
        sb.append(value);
        sb.append(';');
    }

    public static String encodeAttrs(String[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; i += 2) {
            if (i > 0) {
                sb.append(' ');
            }
            ZimbraLog.encodeArg(sb, args[i], args[i + 1]);
        }
        return sb.toString();
    }

    public static String encodeAttrs(String[] args, Map extraArgs) {
        StringBuffer sb = new StringBuffer();
        boolean needSpace = false;
        for (int i = 0; i < args.length; i += 2) {
            if (needSpace) {
                sb.append(' ');
            } else {
                needSpace = true;
            }
            ZimbraLog.encodeArg(sb, args[i], args[i + 1]);
        }
        if (extraArgs != null) {
            Iterator it = extraArgs.entrySet().iterator();
            while (it.hasNext()) {
                if (needSpace) {
                    sb.append(' ');
                } else {
                    needSpace = true;
                }
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    ZimbraLog.encodeArg(sb, name, "");
                    continue;
                }
                if (v instanceof String) {
                    ZimbraLog.encodeArg(sb, name, (String)v);
                    continue;
                }
                if (!(v instanceof String[])) continue;
                String[] values = (String[])v;
                for (int i = 0; i < values.length; ++i) {
                    ZimbraLog.encodeArg(sb, name, values[i]);
                }
            }
        }
        return sb.toString();
    }

    static {
        sContextMap = new ThreadLocal();
        sContextString = new ThreadLocal();
        CONTEXT_KEY_ORDER = new LinkedHashSet<String>();
        CONTEXT_KEY_ORDER.add(C_NAME);
        CONTEXT_KEY_ORDER.add(C_ANAME);
        CONTEXT_KEY_ORDER.add(C_MID);
        CONTEXT_KEY_ORDER.add(C_IP);
        TreeMap<String, String> descriptions = new TreeMap<String, String>();
        descriptions.put(misc.getCategory(), "Miscellaneous");
        descriptions.put(index.getCategory(), "Index operations");
        descriptions.put(redolog.getCategory(), "Redo log operations");
        descriptions.put(lmtp.getCategory(), "LMTP operations (incoming mail)");
        descriptions.put(smtp.getCategory(), "SMTP operations (outgoing mail)");
        descriptions.put(imap.getCategory(), "IMAP protocol operations");
        descriptions.put(pop.getCategory(), "POP protocol operations");
        descriptions.put(mailbox.getCategory(), "General mailbox operations");
        descriptions.put(calendar.getCategory(), "Calendar operations");
        descriptions.put(im.getCategory(), "Instant messaging operations");
        descriptions.put(account.getCategory(), "Account operations");
        descriptions.put(gal.getCategory(), "GAL operations");
        descriptions.put(ldap.getCategory(), "LDAP operations");
        descriptions.put(acl.getCategory(), "ACL operations");
        descriptions.put(security.getCategory(), "Security events");
        descriptions.put(soap.getCategory(), "SOAP protocol");
        descriptions.put(sqltrace.getCategory(), "SQL tracing");
        descriptions.put(dbconn.getCategory(), "Database connection tracing");
        descriptions.put(cache.getCategory(), "In-memory cache operations");
        descriptions.put(filter.getCategory(), "Mail filtering");
        descriptions.put(session.getCategory(), "User session tracking");
        descriptions.put(backup.getCategory(), "Backup and restore");
        descriptions.put(system.getCategory(), "Startup/shutdown and other system messages");
        descriptions.put(sync.getCategory(), "Sync client operations");
        descriptions.put(extensions.getCategory(), "Server extension loading");
        descriptions.put(zimlet.getCategory(), "Zimlet operations");
        descriptions.put(wiki.getCategory(), "Wiki operations");
        descriptions.put(op.getCategory(), "Changes to mailbox state");
        descriptions.put(dav.getCategory(), "DAV operations");
        descriptions.put(io.getCategory(), "Filesystem operations");
        descriptions.put(store.getCategory(), "Mail store disk operations");
        CATEGORY_DESCRIPTIONS = Collections.unmodifiableMap(descriptions);
        CONTEXT_FILTER = new HashSet<String>();
    }
}

