/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;

public class ZimbraHttpConnectionManager {
    private static HttpConnectionManagerParams sConnMgrParams;
    private static HttpClientParams sClientParams;
    private static IdleConnectionTimeoutThread sReaperThread;
    private static ZimbraHttpConnectionManager sInternalConnMgr;
    private static ZimbraHttpConnectionManager sExternalConnMgr;
    private static final Log sLog;
    private HttpConnectionManager mHttpConnMgr = new MultiThreadedHttpConnectionManager();
    private HttpClient mDefaultHttpClient;

    public static ZimbraHttpConnectionManager getInternalHttpConnMgr() {
        return sInternalConnMgr;
    }

    public static ZimbraHttpConnectionManager getExternalHttpConnMgr() {
        return sExternalConnMgr;
    }

    private ZimbraHttpConnectionManager() {
        this.mHttpConnMgr.setParams(sConnMgrParams);
        this.mDefaultHttpClient = this.createHttpClient();
    }

    private HttpClient createHttpClient() {
        return new HttpClient(sClientParams, this.mHttpConnMgr);
    }

    private HttpConnectionManager getConnMgr() {
        return this.mHttpConnMgr;
    }

    public boolean getKeepAlive() {
        return LC.httpclient_connmgr_keepalive_connections.booleanValue();
    }

    public HttpClient getDefaultHttpClient() {
        return this.mDefaultHttpClient;
    }

    public HttpClient newHttpClient() {
        return this.createHttpClient();
    }

    public static synchronized void startReaperThread() {
        Reaper.start();
    }

    public static synchronized void shutdownReaperThread() {
        Reaper.shutdown();
    }

    private static String dumpParams(HttpConnectionManagerParams connMgrParams, HttpClientParams clientParams) {
        if (connMgrParams == null) {
            connMgrParams = new HttpConnectionManagerParams();
        }
        if (clientParams == null) {
            clientParams = new HttpClientParams();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("HttpConnectionManagerParams DefaultMaxConnectionsPerHost  : " + connMgrParams.getDefaultMaxConnectionsPerHost() + "\n");
        sb.append("HttpConnectionManagerParams MaxTotalConnections           : " + connMgrParams.getMaxTotalConnections() + "\n");
        sb.append("HttpConnectionParams ConnectionTimeout                    : " + connMgrParams.getConnectionTimeout() + "\n");
        sb.append("HttpConnectionParams Linger                               : " + connMgrParams.getLinger() + "\n");
        sb.append("HttpConnectionParams ReceiveBufferSize                    : " + connMgrParams.getReceiveBufferSize() + "\n");
        sb.append("HttpConnectionParams SendBufferSize                       : " + connMgrParams.getSendBufferSize() + "\n");
        sb.append("HttpConnectionParams SoTimeout                            : " + connMgrParams.getSoTimeout() + "\n");
        sb.append("HttpConnectionParams TcpNoDelay                           : " + connMgrParams.getTcpNoDelay() + "\n");
        sb.append("HttpConnectionParams isStaleCheckingEnabled               : " + connMgrParams.isStaleCheckingEnabled() + "\n");
        sb.append("HttpClientParams ConnectionManagerClass               : " + clientParams.getConnectionManagerClass().getName() + "\n");
        sb.append("HttpClientParams ConnectionManagerTimeout             : " + clientParams.getConnectionManagerTimeout() + "\n");
        sb.append("HttpClientParams isAuthenticationPreemptive()         : " + clientParams.isAuthenticationPreemptive() + "\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(ZimbraHttpConnectionManager.dumpParams(new HttpConnectionManagerParams(), new HttpClientParams()));
        System.out.println(ZimbraHttpConnectionManager.dumpParams(sConnMgrParams, sClientParams));
        HttpClient httpClient = ZimbraHttpConnectionManager.getInternalHttpConnMgr().getDefaultHttpClient();
        String connMgrName = httpClient.getHttpConnectionManager().getClass().getSimpleName();
        long connMgrTimeout = httpClient.getParams().getConnectionManagerTimeout();
        System.out.println("HttpConnectionManager for the HttpClient instance is: " + connMgrName);
        System.out.println("connection manager timeout for the HttpClient instance is: " + connMgrTimeout);
    }

    static {
        sLog = LogFactory.getLog(ZimbraHttpConnectionManager.class);
        sConnMgrParams = new HttpConnectionManagerParams();
        sConnMgrParams.setDefaultMaxConnectionsPerHost(LC.httpclient_connmgr_max_host_connections.intValue());
        sConnMgrParams.setMaxTotalConnections(LC.httpclient_connmgr_max_total_connections.intValue());
        sConnMgrParams.setConnectionTimeout(LC.httpclient_connmgr_connection_timeout.intValue());
        sConnMgrParams.setSoTimeout(LC.httpclient_connmgr_so_timeout.intValue());
        sConnMgrParams.setStaleCheckingEnabled(LC.httpclient_connmgr_keepalive_connections.booleanValue());
        sConnMgrParams.setTcpNoDelay(LC.httpclient_connmgr_tcp_nodelay.booleanValue());
        sClientParams = new HttpClientParams();
        sClientParams.setConnectionManagerTimeout(LC.httpclient_client_connection_timeout.longValue());
        sInternalConnMgr = new ZimbraHttpConnectionManager();
        sExternalConnMgr = new ZimbraHttpConnectionManager();
    }

    private static class Reaper {
        private Reaper() {
        }

        private static synchronized void start() {
            if (Reaper.isReaperThreadRunning()) {
                sLog.warn("Cannot start a second http client idle connection reaper thread while another one is running.");
                return;
            }
            if (!Reaper.reaperEnabled()) {
                sLog.info("Not starting http client idle connection reaper thread because it is disabled");
                return;
            }
            sLog.info("Starting http client idle connection reaper thread with sleep interval %s.", Reaper.getReaperSleepInterval());
            sReaperThread = new IdleConnectionTimeoutThread();
            sReaperThread.addConnectionManager(sInternalConnMgr.getConnMgr());
            sReaperThread.addConnectionManager(sExternalConnMgr.getConnMgr());
            sReaperThread.setConnectionTimeout(Reaper.getReaperConnectionTimeout());
            sReaperThread.setTimeoutInterval(Reaper.getReaperSleepInterval());
            sReaperThread.start();
        }

        private static synchronized void shutdown() {
            if (!Reaper.isReaperThreadRunning()) {
                sLog.warn("shutting down http client idle connection reaper thread requested but the reaper thread is not running");
                return;
            }
            sLog.warn("shutting down http client idle connection reaper thread");
            sReaperThread.shutdown();
            sReaperThread = null;
        }

        private static synchronized boolean isReaperThreadRunning() {
            return sReaperThread != null;
        }

        private static long getReaperSleepInterval() {
            return LC.httpclient_connmgr_idle_reaper_sleep_interval.longValue();
        }

        private static boolean reaperEnabled() {
            return Reaper.getReaperSleepInterval() != 0L;
        }

        private static long getReaperConnectionTimeout() {
            return LC.httpclient_connmgr_idle_reaper_connection_timeout.longValue();
        }
    }
}

