/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCounter<E> {
    private Map<E, Integer> mValues = new HashMap<E, Integer>();

    public void increment(E value) {
        this.increment(value, 1);
    }

    public void decrement(E value) {
        this.increment(value, -1);
    }

    public void increment(E value, int delta) {
        Integer count = this.mValues.get(value);
        count = count == null ? new Integer(delta) : new Integer(count + delta);
        this.mValues.put(value, count);
    }

    public int getCount(Object value) {
        Integer count = this.mValues.get(value);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public Iterator<E> iterator() {
        return this.mValues.keySet().iterator();
    }

    public int size() {
        return this.mValues.size();
    }

    public int getTotal() {
        int total = 0;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            total += this.getCount(i.next());
        }
        return total;
    }

    public void clear() {
        this.mValues.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            E value = i.next();
            buf.append(value + ": " + this.getCount(value));
        }
        return buf.toString();
    }
}

