/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.IOException;
import java.io.Writer;

public class TruncatingWriter
extends Writer {
    private final Writer mWriter;
    private final int mMaxChars;
    private int mCharsWritten;
    private boolean mWasTruncated = false;

    public TruncatingWriter(Writer writer, int maxChars) {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        if (maxChars < 0) {
            throw new IllegalArgumentException("maxChars cannot be less than 0");
        }
        this.mWriter = writer;
        this.mMaxChars = maxChars;
    }

    public boolean wasTruncated() {
        return this.mWasTruncated;
    }

    public void close() throws IOException {
        this.mWriter.close();
    }

    public void flush() throws IOException {
        this.mWriter.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.mWasTruncated) {
            return;
        }
        if (cbuf != null && this.mCharsWritten + len >= this.mMaxChars) {
            int actualLen = Math.min(len, this.mMaxChars - this.mCharsWritten);
            if (actualLen > 0) {
                this.mWriter.write(cbuf, off, actualLen);
                this.mCharsWritten += actualLen;
            }
            this.mWasTruncated = true;
        } else {
            this.mWriter.write(cbuf, off, len);
            this.mCharsWritten += len;
        }
    }
}

