/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutMap<K, V>
implements Map<K, V> {
    private long mTimeoutMillis;
    private Map<K, V> mMap = new HashMap();
    private Map<Long, K> mTimestamps = new TreeMap<Long, K>();
    private long mLastTimestamp = 0L;

    public TimeoutMap(long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeoutMillis);
        }
        this.mTimeoutMillis = timeoutMillis;
    }

    @Override
    public int size() {
        this.prune();
        return this.mMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.prune();
        return this.mMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.prune();
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.prune();
        return this.mMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.prune();
        return this.mMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.prune();
        this.mTimestamps.put(this.getTimestamp(), (Long)key);
        return this.mMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.prune();
        return this.mMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.prune();
        for (K key : t.keySet()) {
            this.mTimestamps.put(this.getTimestamp(), (Long)key);
        }
        this.mMap.putAll(t);
    }

    @Override
    public void clear() {
        this.mTimestamps.clear();
        this.mMap.clear();
    }

    @Override
    public Set<K> keySet() {
        this.prune();
        return this.mMap.keySet();
    }

    @Override
    public Collection<V> values() {
        this.prune();
        return this.mMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.prune();
        return this.mMap.entrySet();
    }

    private void prune() {
        long now = System.currentTimeMillis();
        Iterator<Long> i = this.mTimestamps.keySet().iterator();
        while (i.hasNext()) {
            Long timestamp = i.next();
            if (now - timestamp > this.mTimeoutMillis) {
                K key = this.mTimestamps.get(timestamp);
                this.mMap.remove(key);
                i.remove();
                continue;
            }
            return;
        }
    }

    private Long getTimestamp() {
        long now = System.currentTimeMillis();
        if (now <= this.mLastTimestamp) {
            now = this.mLastTimestamp + 1L;
        }
        this.mLastTimestamp = now;
        return new Long(this.mLastTimestamp);
    }
}

