/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool
implements Executor {
    private static Log mLog = LogFactory.getLog(ThreadPool.class);
    private static long TIMEOUT = 30000L;
    private ThreadCounter mActiveThreadsCounter;
    private String mName;
    private ThreadPoolExecutor mPool;
    private long mTimeout;

    public ThreadPool(String name, int poolSize) {
        this(name, poolSize, TIMEOUT);
    }

    public ThreadPool(String name, int poolSize, long timeout) {
        this.mName = name;
        this.mTimeout = timeout;
        NamedThreadFactory tfac = new NamedThreadFactory(name, 5);
        this.mPool = new ThreadPoolExecutor(1, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.mPool.setThreadFactory(tfac);
        this.mActiveThreadsCounter = new ThreadCounter();
    }

    public String getName() {
        return this.mName;
    }

    public int getNumActiveThreads() {
        return this.mActiveThreadsCounter.getValue();
    }

    public void execute(Runnable task) throws RejectedExecutionException {
        this.mPool.execute(new CountedTask(task, this.mActiveThreadsCounter));
    }

    public void shutdown() {
        this.mPool.shutdown();
        this.awaitTermination();
    }

    public void shutdownNow() {
        this.mPool.shutdownNow();
        this.awaitTermination();
    }

    private void awaitTermination() {
        try {
            if (!this.mPool.awaitTermination(this.mTimeout, TimeUnit.MILLISECONDS)) {
                mLog.warn("Thread pool did not terminate within " + this.mTimeout + " milliseconds");
            }
        }
        catch (InterruptedException e) {
            mLog.warn((Object)"InterruptedException waiting for thread pool shutdown", e);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private String mName;
        private int mPriority;
        private int mThreadNumber;

        public NamedThreadFactory(String name, int priority) {
            this.mName = name;
            this.mThreadNumber = 0;
            this.mPriority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Thread newThread(Runnable command) {
            int n;
            NamedThreadFactory namedThreadFactory = this;
            synchronized (namedThreadFactory) {
                n = ++this.mThreadNumber;
            }
            StringBuffer sb = new StringBuffer(this.mName);
            sb.append('-').append(n);
            Thread t = new Thread(command, sb.toString());
            t.setPriority(this.mPriority);
            return t;
        }
    }

    public class CountedTask
    implements Runnable {
        ThreadCounter mCounter;
        Runnable mTask;

        public CountedTask(Runnable task, ThreadCounter counter) {
            this.mTask = task;
            this.mCounter = counter;
        }

        public Runnable getTask() {
            return this.mTask;
        }

        public void run() {
            this.mCounter.inc();
            this.mTask.run();
            this.mCounter.dec();
        }
    }

    private class ThreadCounter {
        private int mCount = 0;

        public synchronized int getValue() {
            return this.mCount;
        }

        public synchronized void inc() {
            ++this.mCount;
        }

        public synchronized void dec() {
            --this.mCount;
            if (this.mCount <= 0) {
                this.notifyAll();
            }
        }
    }
}

