/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompiler {
    private static final String S_PARAM = "\\$\\{(.+?)\\}";
    private static final String S_INLINE = "<\\$=(.+?)\\$>";
    private static final String S_CODE = "<\\$(.+?)\\$>";
    private static final String S_ALL = "\\$\\{(.+?)\\}|<\\$=(.+?)\\$>|<\\$(.+?)\\$>";
    private static final String S_TEMPLATE = "<template(.*?)>(.*?)</template>";
    private static final String S_ATTR = "\\s*(\\S+)\\s*=\\s*('[^']*'|\"[^\"]*\")";
    private static final String S_WS_LINESEP = "\\s*\\n+\\s*";
    private static final String S_GT_LINESEP_LT = ">\\s*\\n+\\s*<";
    private static final Pattern RE_REPLACE = Pattern.compile("\\$\\{(.+?)\\}|<\\$=(.+?)\\$>|<\\$(.+?)\\$>", 32);
    private static final Pattern RE_TEMPLATE = Pattern.compile("<template(.*?)>(.*?)</template>", 32);
    private static final Pattern RE_ATTR = Pattern.compile("\\s*(\\S+)\\s*=\\s*('[^']*'|\"[^\"]*\")", 32);
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_XML_SPACE_PRESERVE = "preserve";
    private static final String S_PARAM_PART = "([^\\(\\.]+)(\\(.*?\\))?\\.?";
    private static final Pattern RE_PARAM_PART = Pattern.compile("([^\\(\\.]+)(\\(.*?\\))?\\.?");
    private static Options _mOptions = new Options();
    private String _prefix = "";
    private String _idir = ".";
    private String _odir = ".";
    private boolean _authoritative = false;
    private boolean _define = false;
    private String[] _filenames = null;
    private String _format = "js";

    public static void main(String[] args) throws Exception {
        try {
            TemplateCompiler compiler = new TemplateCompiler();
            compiler.compile(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void compile(File idir, File odir, String prefix, String[] filenames, boolean authoritative, boolean define) throws IOException {
        TemplateCompiler.compile(idir, odir, prefix, filenames, "js", authoritative, define);
    }

    public static void compile(File idir, File odir, String prefix, String[] filenames, String format, boolean authoritative, boolean define) throws IOException {
        for (String filename : filenames) {
            String path = TemplateCompiler.stripExt(filename);
            String pkg = prefix + TemplateCompiler.path2package(path);
            File ifile = new File(idir, filename);
            File ofile = new File(odir, filename + "." + format);
            if (TemplateCompiler.upToDate(ifile, ofile)) {
                System.out.println(ifile + " is up to date");
                continue;
            }
            System.out.println("Compiling " + ifile);
            if (odir != idir) {
                File pdir = ofile.getParentFile();
                pdir.mkdirs();
            }
            try {
                TemplateCompiler.compile(ifile, ofile, format, pkg, authoritative, define);
            }
            catch (IOException e) {
                System.err.println("error: " + e.getMessage());
            }
        }
    }

    public static void compile(File ifile, File ofile, String pkg, boolean authoritative, boolean define) throws IOException {
        TemplateCompiler.compile(ifile, ofile, "js", pkg, authoritative, define);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compile(File ifile, File ofile, String format, String pkg, boolean authoritative, boolean define) throws IOException {
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            boolean isProperties = format.equals("properties");
            in = new BufferedReader(new FileReader(ifile));
            out = new PrintWriter(new FileWriter(ofile));
            String lines = TemplateCompiler.readLines(in);
            Matcher matcher = RE_TEMPLATE.matcher(lines);
            if (matcher.find()) {
                boolean first = true;
                do {
                    String id;
                    Map<String, String> attrs = TemplateCompiler.parseAttrs(matcher.group(1));
                    String body = matcher.group(2);
                    String stripWsAttr = attrs.get(A_XML_SPACE);
                    String packageId = pkg;
                    String templateId = attrs.get("id");
                    if (templateId != null && (templateId.indexOf(35) != -1 || templateId.startsWith("/"))) {
                        if (templateId.indexOf(35) == -1) {
                            templateId = templateId + "#";
                        }
                        packageId = templateId.replaceAll("#.*$", "").replaceAll("^/", "").replace('/', '.');
                        templateId = templateId.replaceAll("^.*#", "");
                    }
                    String string = id = templateId != null && !templateId.equals("") ? packageId + "#" + templateId : packageId;
                    if (isProperties) {
                        TemplateCompiler.printEscaped(out, id);
                        if (body.indexOf(10) == -1) {
                            out.print(" = ");
                            TemplateCompiler.printEscaped(out, body);
                        } else {
                            String[] bodylines;
                            out.print(" =");
                            for (String bodyline : bodylines = body.split("\n")) {
                                out.print("\\\n\t");
                                TemplateCompiler.printEscaped(out, bodyline);
                            }
                        }
                        out.println();
                        continue;
                    }
                    if (stripWsAttr == null || !stripWsAttr.equals(V_XML_SPACE_PRESERVE)) {
                        body = body.replaceAll(S_GT_LINESEP_LT, "><").trim();
                    }
                    TemplateCompiler.convertLines(out, id, body, attrs, authoritative);
                    if (first && define) {
                        out.print("AjxPackage.define(\"");
                        out.print(packageId);
                        out.println("\");");
                    }
                    if (first) {
                        first = false;
                        out.print("AjxTemplate.register(\"");
                        out.print(packageId);
                        out.print("\", ");
                        out.print("AjxTemplate.getTemplate(\"");
                        out.print(id);
                        out.print("\"), ");
                        out.print("AjxTemplate.getParams(\"");
                        out.print(id);
                        out.println("\"));");
                    }
                    out.println();
                } while (matcher.find());
            } else {
                TemplateCompiler.convertLines(out, pkg, lines, null, authoritative);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private void compile(String[] args) throws IOException {
        this.parseArgs(args);
        File idir = new File(this._idir);
        File odir = new File(this._odir);
        TemplateCompiler.compile(idir, odir, this._prefix, this._filenames, this._format, this._authoritative, this._define);
    }

    private void parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(_mOptions, args);
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(10);
        }
        if (cl == null) {
            System.out.println("Nothing to do!");
            System.exit(1);
        }
        if (cl.hasOption("p")) {
            this._prefix = cl.getOptionValue("p");
        }
        if (cl.hasOption("d")) {
            this._define = true;
        }
        if (cl.hasOption("a")) {
            this._authoritative = true;
        }
        if (cl.hasOption("i")) {
            this._odir = cl.getOptionValue("i");
        }
        if (cl.hasOption("o")) {
            this._odir = cl.getOptionValue("o");
        }
        if (cl.hasOption("f")) {
            this._format = cl.getOptionValue("f");
        }
        this._filenames = cl.getArgs();
        if (this._filenames.length == 0) {
            System.out.println("No files to convert!");
            System.exit(1);
        }
    }

    private static void convertLines(PrintWriter out, String pkg, String lines, Map<String, String> attrs, boolean authoritative) {
        out.print("AjxTemplate.register(\"");
        out.print(pkg);
        out.println("\", ");
        out.println("function(name, params, data, buffer) {");
        out.println("\tvar _hasBuffer = Boolean(buffer);");
        out.println("\tdata = (typeof data == \"string\" ? { id: data } : data) || {};");
        out.println("\tbuffer = buffer || [];");
        out.println("\tvar _i = buffer.length;");
        out.println();
        Matcher matcher = RE_REPLACE.matcher(lines);
        if (matcher.find()) {
            int offset = 0;
            do {
                int index;
                if (offset < (index = matcher.start())) {
                    TemplateCompiler.printStringLines(out, lines.substring(offset, index));
                }
                String param = matcher.group(1);
                String inline = matcher.group(2);
                if (param != null) {
                    TemplateCompiler.printDataLine(out, param);
                } else if (inline != null) {
                    TemplateCompiler.printBufferLine(out, inline);
                } else {
                    TemplateCompiler.printLine(out, "\t", matcher.group(3).replaceAll("\n", "\n\t"), "\n");
                }
                offset = matcher.end();
            } while (matcher.find());
            if (offset < lines.length()) {
                TemplateCompiler.printStringLines(out, lines.substring(offset));
            }
        } else {
            TemplateCompiler.printStringLines(out, lines);
        }
        out.println();
        out.println("\treturn _hasBuffer ? buffer.length : buffer.join(\"\");");
        out.println("},");
        if (attrs != null && attrs.size() > 0) {
            out.println("{");
            Iterator<String> iter = attrs.keySet().iterator();
            while (iter.hasNext()) {
                String aname = iter.next();
                String avalue = attrs.get(aname);
                out.print("\t\"");
                TemplateCompiler.printEscaped(out, aname);
                out.print("\": \"");
                TemplateCompiler.printEscaped(out, avalue);
                out.print("\"");
                if (iter.hasNext()) {
                    out.print(",");
                }
                out.println();
            }
            out.print("}");
        } else {
            out.print("null");
        }
        out.print(", ");
        out.print(authoritative);
        out.println(");");
    }

    private static Map<String, String> parseAttrs(String s) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Matcher matcher = RE_ATTR.matcher(s);
        while (matcher.find()) {
            String aname = matcher.group(1);
            String avalue = matcher.group(2).replaceAll("^['\"]|['\"]$", "");
            attrs.put(aname, avalue);
        }
        return attrs;
    }

    private static String readLines(BufferedReader in) throws IOException {
        String line;
        StringBuilder str = new StringBuilder();
        while ((line = in.readLine()) != null) {
            str.append(line);
            str.append('\n');
        }
        return str.toString();
    }

    private static void printLine(PrintWriter out, String ... ss) {
        for (String s : ss) {
            out.print(s);
        }
    }

    private static void printStringLines(PrintWriter out, String ... ss) {
        for (String s : ss) {
            String[] lines = s.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                TemplateCompiler.printStringLine(out, line, i < lines.length - 1 ? "\n" : "");
            }
        }
    }

    private static void printStringLine(PrintWriter out, String ... ss) {
        out.print("\tbuffer[_i++] = \"");
        for (String s : ss) {
            TemplateCompiler.printEscaped(out, s);
        }
        out.println("\";");
    }

    private static void printDataLine(PrintWriter out, String s) {
        out.print("\tbuffer[_i++] = data");
        Matcher part = RE_PARAM_PART.matcher(s);
        while (part.find()) {
            String name = part.group(1);
            String args = part.group(2);
            out.print("[\"");
            out.print(name);
            out.print("\"]");
            if (args == null) continue;
            out.print(args);
        }
        out.println(";");
    }

    private static void printBufferLine(PrintWriter out, String ... ss) {
        out.print("\tbuffer[_i++] = ");
        for (String s : ss) {
            out.print(s);
        }
        out.println(";");
    }

    private static String stripExt(String s) {
        return s.replaceAll("\\.[^\\.]+$", "");
    }

    private static String path2package(String s) {
        return s.replace(File.separatorChar, '.');
    }

    private static void printEscaped(PrintWriter out, String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                out.print('\\');
            } else {
                if (c == '\n') {
                    out.print("\\n");
                    continue;
                }
                if (c == '\r') {
                    out.print("\\r");
                    continue;
                }
                if (c == '\t') {
                    out.print("\\t");
                    continue;
                }
                if (c == '\\') {
                    out.print("\\\\");
                    continue;
                }
            }
            out.print(c);
        }
    }

    private static boolean upToDate(File ifile, File ofile) {
        if (ifile.exists() && ofile.exists()) {
            return ifile.lastModified() < ofile.lastModified();
        }
        return false;
    }

    static {
        Option option = new Option("p", "prefix", true, "");
        option.setRequired(false);
        _mOptions.addOption(option);
        option = new Option("d", "define", false, "prevent ");
        option.setRequired(false);
        _mOptions.addOption(option);
        option = new Option("a", "authoritative", false, "declare template as authoritative");
        option.setRequired(false);
        _mOptions.addOption(option);
        option = new Option("i", "inputdir", true, "source directory base");
        option.setRequired(false);
        _mOptions.addOption(option);
        option = new Option("o", "outputdir", true, "name of directory for resultant files");
        option.setRequired(false);
        _mOptions.addOption(option);
        option = new Option("f", "format", true, "output format, \"js\" or \"properties\" (default: \"js\"");
        option.setRequired(false);
        _mOptions.addOption(option);
    }
}

