/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskUtil {
    private static Timer timer;

    private TaskUtil() {
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("task timeout timer", true);
        }
        return timer;
    }

    public static <V> V call(Callable<V> c, long timeout) throws Exception {
        TimeoutTask task = new TimeoutTask(Thread.currentThread());
        TaskUtil.getTimer().schedule((TimerTask)task, timeout);
        try {
            V v = c.call();
            return v;
        }
        catch (InterruptedException e) {
            throw new TimeoutException();
        }
        finally {
            task.stop();
            Thread.interrupted();
        }
    }

    private static class TimeoutTask
    extends TimerTask {
        final Thread thread;
        final Object lock = new Object();
        boolean stopped;

        TimeoutTask(Thread t) {
            this.thread = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.lock;
            synchronized (object) {
                if (this.stopped) {
                    return;
                }
                this.cancel();
                this.stopped = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                if (this.stopped) {
                    return;
                }
                this.thread.interrupt();
                this.stopped = true;
            }
        }
    }
}

