/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.ScheduledTaskCallback;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScheduler<V> {
    private final Map<Object, TaskRunner<V>> mRunnerMap = Collections.synchronizedMap(new HashMap());
    private final ScheduledThreadPoolExecutor mThreadPool;
    private final List<ScheduledTaskCallback<V>> mCallbacks = Collections.synchronizedList(new ArrayList());

    public TaskScheduler(String name, int corePoolSize, int maximumPoolSize) {
        this.mThreadPool = new ScheduledThreadPoolExecutor(corePoolSize, new TaskSchedulerThreadFactory(name));
        this.mThreadPool.setMaximumPoolSize(maximumPoolSize);
    }

    public void schedule(Object taskId, Callable<V> task, long delayMillis) {
        this.schedule(taskId, task, false, 0L, delayMillis);
    }

    public void schedule(Object taskId, Callable<V> task, boolean recurs, long intervalMillis, long delayMillis) {
        ZimbraLog.scheduler.debug("Scheduling task %s", taskId);
        TaskRunner<V> runner = new TaskRunner<V>(taskId, task, recurs, intervalMillis, this.mCallbacks);
        runner.mSchedule = this.mThreadPool.schedule(runner, delayMillis, TimeUnit.MILLISECONDS);
        this.mRunnerMap.put(taskId, runner);
    }

    public V getLastResult(Object taskId) {
        TaskRunner<V> runner = this.mRunnerMap.get(taskId);
        if (runner == null) {
            return null;
        }
        return (V)runner.mLastResult;
    }

    public Callable<V> cancel(Object taskId, boolean mayInterruptIfRunning) {
        TaskRunner<V> runner = this.mRunnerMap.get(taskId);
        if (runner == null) {
            return null;
        }
        ZimbraLog.scheduler.debug("Cancelling task %s", taskId);
        runner.mSchedule.cancel(mayInterruptIfRunning);
        return runner.getTask();
    }

    public void shutdown() {
        this.mThreadPool.shutdown();
    }

    public void addCallback(ScheduledTaskCallback<V> callback) {
        this.mCallbacks.add(callback);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskRunner<V2>
    implements Callable<V2> {
        Object mId;
        boolean mRecurs;
        long mIntervalMillis;
        Callable<V2> mTask;
        V2 mLastResult;
        ScheduledFuture<V2> mSchedule;
        List<ScheduledTaskCallback<V2>> mCallbacks;

        TaskRunner(Object id, Callable<V2> task, boolean recurs, long intervalMillis, List<ScheduledTaskCallback<V2>> callbacks) {
            this.mTask = task;
            this.mId = id;
            this.mRecurs = recurs;
            this.mIntervalMillis = intervalMillis;
            this.mCallbacks = callbacks;
        }

        Callable<V2> getTask() {
            return this.mTask;
        }

        @Override
        public V2 call() throws Exception {
            try {
                ZimbraLog.scheduler.debug("Executing task %s", this.mId);
                this.mLastResult = this.mTask.call();
                ZimbraLog.scheduler.debug("Task returned result %s", this.mLastResult);
                if (this.mCallbacks != null) {
                    for (ScheduledTaskCallback<V2> callback : this.mCallbacks) {
                        callback.afterTaskRun(this.mTask);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    ZimbraLog.scheduler.fatal((Object)"Shutting down", t);
                    System.exit(1);
                }
                ZimbraLog.scheduler.warn("Exception during execution of task %s", this.mId, t);
                this.mLastResult = null;
            }
            boolean cancelled = false;
            if (this.mSchedule != null) {
                cancelled = this.mSchedule.isCancelled();
            }
            if (this.mRecurs && !cancelled) {
                ZimbraLog.scheduler.debug("Rescheduling task %s", this.mId);
                this.mSchedule = TaskScheduler.this.mThreadPool.schedule(this, this.mIntervalMillis, TimeUnit.MILLISECONDS);
            } else {
                ZimbraLog.scheduler.debug("Not rescheduling task %s.  mRecurs=%b", this.mId, this.mRecurs);
            }
            return this.mLastResult;
        }
    }

    static class TaskSchedulerThreadFactory
    implements ThreadFactory {
        final ThreadGroup mGroup;
        final AtomicInteger mThreadNumber = new AtomicInteger(1);
        String mNamePrefix;

        TaskSchedulerThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.mGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.mNamePrefix = "ScheduledTask-";
            if (!StringUtil.isNullOrEmpty(name)) {
                this.mNamePrefix = this.mNamePrefix + name + "-";
            }
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.mGroup, r, this.mNamePrefix + this.mThreadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

