/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final int TERM_WHITESPACE = 1;
    private static final int TERM_SINGLEQUOTE = 2;
    private static final int TERM_DBLQUOTE = 3;
    public static Pattern atPattern = Pattern.compile("(.*)\\@([^\\@]+)\\@(.*)", 32);
    public static Pattern varPattern = Pattern.compile("(.*)\\$\\{([^\\}]+)\\}(.*)", 32);
    private static final String[] JS_CHAR_ENCODINGS = new String[]{"\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\b", "\\t", "\\n", "\\u000B", "\\f", "\\r", "\\u000E", "\\u000F", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001A", "\\u001B", "\\u001C", "\\u001D", "\\u001E", "\\u001F"};
    private static Set<String> sJavaReservedWords = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    public static boolean equal(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public static int compareTo(String s1, String s2) {
        if (s1 != null) {
            if (s2 != null) {
                return s1.compareTo(s2);
            }
            return 1;
        }
        if (s2 != null) {
            return -1;
        }
        return 0;
    }

    public static int countOccurrences(String str, char c) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String stripControlCharacters(String raw) {
        char c;
        int i;
        if (raw == null) {
            return null;
        }
        for (i = 0; !(i >= raw.length() || (c = raw.charAt(i)) < ' ' && c != '\t' && c != '\n' && c != '\r' || c == '\ufffe' || c == '\uffff' || c > '\ud7ff' && c < '\ue000'); ++i) {
        }
        if (i >= raw.length()) {
            return raw;
        }
        StringBuilder sb = new StringBuilder(raw.substring(0, i));
        while (i < raw.length()) {
            char c2 = raw.charAt(i);
            if (!(c2 < ' ' && c2 != '\t' && c2 != '\n' && c2 != '\r' || c2 == '\ufffe' || c2 == '\uffff' || c2 > '\ud7ff' && c2 < '\ue000')) {
                sb.append(c2);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isAsciiString(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= ' ' && c < '\u007f' || c == '\r' || c == '\n' || c == '\t') continue;
            return false;
        }
        return true;
    }

    public static String trimTrailingSpaces(String raw) {
        int length;
        if (raw == null) {
            return null;
        }
        for (length = raw.length(); length > 0 && raw.charAt(length - 1) <= ' '; --length) {
        }
        return length == raw.length() ? raw : raw.substring(0, length);
    }

    public static void addToMultiMap(Map<String, Object> result, String name, String value) {
        Object currentValue = result.get(name);
        if (currentValue == null) {
            result.put(name, value);
        } else if (currentValue instanceof String) {
            result.put(name, new String[]{(String)currentValue, value});
        } else if (currentValue instanceof String[]) {
            String[] ov = (String[])currentValue;
            String[] nv = new String[ov.length + 1];
            System.arraycopy(ov, 0, nv, 0, ov.length);
            nv[ov.length] = value;
            result.put(name, nv);
        }
    }

    public static Map<String, Object> keyValueArrayToMultiMap(String[] args, int offset) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (int i = offset; i < args.length; i += 2) {
            String n = args[i];
            if (i + 1 >= args.length) {
                throw new IllegalArgumentException("not enough arguments");
            }
            String v = args[i + 1];
            StringUtil.addToMultiMap(attrs, n, v);
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSingleLineFromFile(String file) throws IOException {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            string = in.readLine();
        }
        catch (Throwable throwable) {
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        return string;
    }

    public static String readLine(BufferedReader in) throws IOException {
        String line;
        StringBuilder sb = null;
        while ((line = in.readLine()) != null && line.length() != 0 && line.charAt(line.length() - 1) == '\\') {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(line.substring(0, line.length() - 1));
        }
        if (line == null) {
            if (sb == null) {
                return null;
            }
            return sb.toString();
        }
        if (sb == null) {
            return line;
        }
        sb.append(line);
        return sb.toString();
    }

    public static List<String> parseSieveStringList(String value) throws ServiceException {
        ArrayList<String> result = new ArrayList<String>();
        if (value == null) {
            return result;
        }
        if ((value = value.trim()).length() == 0) {
            return result;
        }
        int i = 0;
        boolean inStr = false;
        boolean inList = false;
        StringBuilder sb = null;
        while (i < value.length()) {
            char ch = value.charAt(i++);
            if (inStr) {
                if (ch == '\"') {
                    result.add(sb.toString());
                    inStr = false;
                    continue;
                }
                if (ch == '\\' && i < value.length()) {
                    ch = value.charAt(i++);
                }
                sb.append(ch);
                continue;
            }
            if (ch == '\"') {
                inStr = true;
                sb = new StringBuilder();
                continue;
            }
            if (ch == '[' && !inList) {
                inList = true;
                continue;
            }
            if (ch == ']' && inList) {
                inList = false;
                continue;
            }
            if (Character.isWhitespace(ch)) continue;
            throw ServiceException.INVALID_REQUEST("unable to parse string list: " + value, null);
        }
        if (inStr || inList) {
            throw ServiceException.INVALID_REQUEST("unable to parse string list2: " + value, null);
        }
        return result;
    }

    public static String[] parseLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        StringBuilder sb = new StringBuilder(32);
        int term = 1;
        boolean inStr = false;
        block12: while (i < line.length()) {
            char ch = line.charAt(i++);
            boolean escapedTerm = false;
            if (ch == '\\' && i < line.length()) {
                ch = line.charAt(i++);
                switch (ch) {
                    case '\\': {
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        escapedTerm = true;
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        escapedTerm = true;
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        escapedTerm = true;
                        break;
                    }
                    case '\'': {
                        ch = '\'';
                        escapedTerm = true;
                        break;
                    }
                    case '\"': {
                        ch = '\"';
                        escapedTerm = true;
                        break;
                    }
                    default: {
                        escapedTerm = Character.isWhitespace(ch);
                    }
                }
            }
            if (inStr) {
                if (!escapedTerm && (term == 1 && Character.isWhitespace(ch) || term == 2 && ch == '\'' || term == 3 && ch == '\"')) {
                    inStr = false;
                    result.add(sb.toString());
                    sb = new StringBuilder(32);
                    term = 1;
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (!escapedTerm) {
                switch (ch) {
                    case '\'': {
                        term = 2;
                        inStr = true;
                        continue block12;
                    }
                    case '\"': {
                        term = 3;
                        inStr = true;
                        continue block12;
                    }
                }
                if (Character.isWhitespace(ch)) continue;
                inStr = true;
                sb.append(ch);
                continue;
            }
            inStr = true;
            sb.append(ch);
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private static void dump(String line) {
        String[] result = StringUtil.parseLine(line);
        System.out.println("line: " + line);
        for (int i = 0; i < result.length; ++i) {
            System.out.println(i + ": (" + result[i] + ")");
        }
        System.out.println();
    }

    public static void main(String[] args) {
        StringUtil.dump("this is a test");
        StringUtil.dump("this is 'a nother' test");
        StringUtil.dump("this is\\ test");
        StringUtil.dump("first Roland last 'Schemers' full 'Roland Schemers'");
        StringUtil.dump("multi 'Roland\\nSchemers'");
        StringUtil.dump("a");
        StringUtil.dump("");
        StringUtil.dump("\\  \\ ");
        StringUtil.dump("backslash \\\\");
        StringUtil.dump("backslash \\f");
        StringUtil.dump("a           b");
    }

    public static String fillTemplate(String template, Map<String, ? extends Object> vars) {
        return StringUtil.fillTemplate(template, vars, varPattern);
    }

    public static String fillTemplate(String template, Map<String, ? extends Object> vars, Pattern pattern) {
        if (template == null) {
            return null;
        }
        String line = template;
        Matcher matcher = pattern.matcher(line);
        while (matcher.matches()) {
            String key = matcher.group(2);
            Object value = vars.get(key);
            if (value == null) {
                ZimbraLog.misc.info("fillTemplate(): could not find key '" + key + "'");
                value = "";
            }
            line = matcher.group(1) + value + matcher.group(3);
            matcher.reset(line);
        }
        return line;
    }

    public static String join(String delimiter, short[] array) {
        if (array == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]);
            if (i + 1 >= array.length) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static String join(String delimiter, Object[] array) {
        return array == null ? null : StringUtil.join(delimiter, array, 0, array.length);
    }

    public static String join(String delimiter, Object[] array, int start, int count) {
        if (array == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int end = start + count;
        for (int i = start; i < end; ++i) {
            buf.append(array[i]);
            if (i + 1 >= end) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static String join(String delimiter, Iterable<? extends Object> array) {
        if (array == null) {
            return null;
        }
        boolean firstTime = true;
        StringBuilder buf = new StringBuilder();
        for (Object object : array) {
            if (firstTime) {
                firstTime = false;
            } else {
                buf.append(delimiter);
            }
            buf.append(object);
        }
        return buf.toString();
    }

    public static String getSimpleClassName(String className) {
        return FileUtil.getExtension(className);
    }

    public static String getSimpleClassName(Object o) {
        if (o == null) {
            return null;
        }
        return FileUtil.getExtension(o.getClass().getName());
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String jsEncode(Object obj) {
        int i;
        if (obj == null) {
            return "";
        }
        String str = obj.toString();
        StringBuilder sb = null;
        int length = str.length();
        int last = -1;
        block8: for (i = 0; i < length; ++i) {
            String replacement;
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    replacement = "\\x3C";
                    break;
                }
                case '>': {
                    replacement = "\\x3E";
                    break;
                }
                case '\\': {
                    replacement = "\\\\";
                    break;
                }
                case '\"': {
                    replacement = "\\\"";
                    break;
                }
                case '\u2028': {
                    replacement = "\\u2028";
                    break;
                }
                case '\u2029': {
                    replacement = "\\u2029";
                    break;
                }
                default: {
                    if (c >= ' ') continue block8;
                    replacement = JS_CHAR_ENCODINGS[c];
                }
            }
            if (sb == null) {
                sb = new StringBuilder(str.substring(0, i));
            } else {
                sb.append(str.substring(last, i));
            }
            sb.append(replacement);
            last = i + 1;
        }
        return sb == null ? str : sb.append(str.substring(last, i)).toString();
    }

    public static String jsEncodeKey(String key) {
        return '\"' + key + '\"';
    }

    public static String escapeHtml(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(text.length());
        block8: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    result.append("&#039;");
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    result.append(" ");
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String checkCharset(String data, String requestedCharset) {
        if (data == null) {
            return "us-ascii";
        }
        if (requestedCharset != null && !requestedCharset.equalsIgnoreCase("utf-8")) {
            try {
                Charset cset = Charset.forName(requestedCharset);
                if (cset.canEncode() && cset.newEncoder().canEncode(data)) {
                    return requestedCharset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "utf-8";
    }

    public static boolean isJavaReservedWord(String s) {
        return sJavaReservedWords.contains(s);
    }

    public static String escapeJavaIdentifier(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        if (StringUtil.isJavaReservedWord(s)) {
            return s + "_";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (i == 0) {
                result.append(Character.isJavaIdentifierStart(ch) ? Character.valueOf(ch) : "_");
                continue;
            }
            result.append(Character.isJavaIdentifierPart(ch) ? Character.valueOf(ch) : "_");
        }
        return result.toString();
    }

    public static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

