/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.BufferStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class StringBufferStream
extends BufferStream
implements Appendable {
    String cset;
    StringBuilder sbuf;
    static final int DEFAULT_SIZE_HINT = 512;

    public StringBufferStream() {
        this(null);
    }

    public StringBufferStream(long sizeHint) {
        this(null, sizeHint);
    }

    public StringBufferStream(long sizeHint, int maxBuffer) {
        this(null, sizeHint, maxBuffer);
    }

    public StringBufferStream(long sizeHint, int maxBuffer, long maxSize) {
        this(null, sizeHint, maxBuffer, maxSize);
    }

    public StringBufferStream(String cset) {
        this(cset, 0L);
    }

    public StringBufferStream(String cset, long sizeHint) {
        this(cset, sizeHint, Integer.MAX_VALUE);
    }

    public StringBufferStream(String cset, long sizeHint, int maxBuffer) {
        this(cset, sizeHint, maxBuffer, Long.MAX_VALUE);
    }

    public StringBufferStream(String cset, long sizeHint, int maxBuffer, long maxSize) {
        super(sizeHint, maxBuffer, maxSize);
        this.cset = cset == null ? Charset.defaultCharset().toString() : cset;
        this.sbuf = new StringBuilder((int)Math.min(sizeHint == 0L ? 512L : sizeHint, 2048L));
    }

    public Appendable append(char c) throws IOException {
        this.flush(1);
        this.sbuf.append(c);
        return this;
    }

    public Appendable append(CharSequence cs) throws IOException {
        this.flush(cs.length());
        if (cs.length() > this.sbuf.capacity() - this.sbuf.length()) {
            this.write(((Object)cs).toString().getBytes(this.cset));
        } else {
            this.sbuf.append(cs);
        }
        return this;
    }

    public Appendable append(CharSequence cs, int start, int end) throws IOException {
        int len = end - start;
        this.flush(len);
        if (len > this.sbuf.capacity() - this.sbuf.length()) {
            this.write(((Object)cs.subSequence(start, end)).toString().getBytes(this.cset));
        } else {
            this.sbuf.append(cs, start, end);
        }
        return this;
    }

    private void flush(int len) throws IOException {
        if (this.sbuf.capacity() - this.sbuf.length() < len && this.sbuf.length() > 0) {
            this.write(this.sbuf.toString().getBytes(this.cset));
            this.sbuf.setLength(0);
        }
    }

    public void sync() throws IOException {
        this.flush(Integer.MAX_VALUE);
        super.sync();
    }

    public String toString() {
        try {
            return super.toString(this.cset);
        }
        catch (Exception e) {
            return new String(this.getBuffer());
        }
    }

    public static void main(String[] args) throws IOException {
        StringBufferStream sbs = new StringBufferStream(12L);
        sbs.append("start ");
        sbs.append(new StringBuilder("-middle-"), 1, 7);
        sbs.append(" end");
        System.out.println(sbs.toString());
    }
}

