/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.CustomSSLSocketFactory;
import com.zimbra.common.util.DummySSLSocketFactory;
import com.zimbra.common.util.EasySSLProtocolSocketFactory;
import com.zimbra.common.util.ZimbraLog;
import java.security.GeneralSecurityException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class SSLSocketFactoryManager {
    private static boolean isInitialzied = false;

    public static synchronized void init() {
        if (isInitialzied) {
            return;
        }
        ProtocolSocketFactory psFactory = null;
        String className = LC.zimbra_class_sslprotocolsocketfactory.value();
        if (className != null && !className.equals("")) {
            try {
                psFactory = (ProtocolSocketFactory)Class.forName(className).newInstance();
            }
            catch (Exception x) {
                ZimbraLog.security.error("could not instantiate ProtocolSocketFactory interface of class '%s'", (Object)className, x);
            }
        }
        if (psFactory == null && LC.ssl_allow_untrusted_certs.booleanValue()) {
            psFactory = new EasySSLProtocolSocketFactory();
        }
        if (psFactory != null) {
            Protocol https = new Protocol("https", psFactory, 443);
            Protocol.registerProtocol("https", https);
        }
        try {
            SSLSocketFactory sockFactory = LC.data_source_trust_self_signed_certs.booleanValue() ? new DummySSLSocketFactory() : new CustomSSLSocketFactory(false);
            HttpsURLConnection.setDefaultSSLSocketFactory(sockFactory);
        }
        catch (GeneralSecurityException x) {
            ZimbraLog.security.error((Object)"could not init HttpsURLConnection with SSLSocketFactory", x);
        }
    }

    public static String getDefaultSSLSocketFactoryClassName() {
        return LC.data_source_trust_self_signed_certs.booleanValue() ? DummySSLSocketFactory.class.getName() : CustomSSLSocketFactory.class.getName();
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        try {
            return LC.data_source_trust_self_signed_certs.booleanValue() ? new DummySSLSocketFactory() : new CustomSSLSocketFactory(true);
        }
        catch (GeneralSecurityException x) {
            throw new RuntimeException(x);
        }
    }
}

