/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.BEncoding;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SSLCertInfo {
    private static final String ACCEPTABLE = "accept";
    private static final String MISMATCH = "mismatch";
    private static final String ALIAS = "alias";
    private static final String HOSTNAME = "host";
    private static final String COMMON_NAME = "CN";
    private static final String ORGANIZATION_UNIT = "OU";
    private static final String ORGANIZATION = "O";
    private static final String SERIAL_NUMBER = "s";
    private static final String ISSUER_COMMON_NAME = "icn";
    private static final String ISSUER_ORGANIZATION_UNIT = "iou";
    private static final String ISSUER_ORGANIZATION = "io";
    private static final String ISSUED_ON = "from";
    private static final String EXPIRES_ON = "to";
    private static final String SHA1 = "sha1";
    private static final String MD5 = "md5";
    private boolean isAcceptable;
    private boolean isMismatch;
    private String alias;
    private String hostname;
    private String commonName;
    private String organizationUnit;
    private String organization;
    private String serialNumber;
    private String issuerCommonName;
    private String issuerOrganizationUnit;
    private String issuerOrganization;
    private Date issuedOn;
    private Date expiresOn;
    private String sha1;
    private String md5;

    private SSLCertInfo() {
    }

    public SSLCertInfo(String alias, String hostname, X509Certificate cert, boolean isAcceptable, boolean isMismatch) throws GeneralSecurityException {
        this.isAcceptable = isAcceptable;
        this.isMismatch = isMismatch;
        this.alias = alias;
        this.hostname = hostname;
        String subjectDn = cert.getSubjectX500Principal().getName();
        this.commonName = SSLCertInfo.getComponent(subjectDn, COMMON_NAME);
        this.organizationUnit = SSLCertInfo.getComponent(subjectDn, ORGANIZATION_UNIT);
        this.organization = SSLCertInfo.getComponent(subjectDn, ORGANIZATION);
        this.serialNumber = cert.getSerialNumber().toString(16).toUpperCase();
        String issuerDn = cert.getIssuerDN().getName();
        this.issuerCommonName = SSLCertInfo.getComponent(issuerDn, COMMON_NAME);
        this.issuerOrganizationUnit = SSLCertInfo.getComponent(issuerDn, ORGANIZATION_UNIT);
        this.issuerOrganization = SSLCertInfo.getComponent(issuerDn, ORGANIZATION);
        this.issuedOn = cert.getNotBefore();
        this.expiresOn = cert.getNotAfter();
        byte[] encoded = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(encoded);
        this.sha1 = SSLCertInfo.getHexString(md.digest());
        md = MessageDigest.getInstance("MD5");
        md.update(encoded);
        this.md5 = SSLCertInfo.getHexString(md.digest());
    }

    public static String getHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1).toUpperCase());
        }
        return sb.toString();
    }

    public String serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ALIAS, this.alias);
        map.put(HOSTNAME, this.hostname);
        map.put(COMMON_NAME, this.commonName);
        map.put(ORGANIZATION_UNIT, this.organizationUnit);
        map.put(ORGANIZATION, this.organization);
        map.put(SERIAL_NUMBER, this.serialNumber);
        map.put(ISSUER_COMMON_NAME, this.issuerCommonName);
        map.put(ISSUER_ORGANIZATION_UNIT, this.issuerOrganizationUnit);
        map.put(ISSUER_ORGANIZATION, this.issuerOrganization);
        map.put(ISSUED_ON, this.issuedOn.getTime());
        map.put(EXPIRES_ON, this.expiresOn.getTime());
        map.put(SHA1, this.sha1);
        map.put(MD5, this.md5);
        map.put(ACCEPTABLE, Boolean.valueOf(this.isAcceptable).toString());
        map.put(MISMATCH, Boolean.valueOf(this.isMismatch).toString());
        return BEncoding.encode(map);
    }

    public static SSLCertInfo deserialize(String s) {
        SSLCertInfo certInfo = new SSLCertInfo();
        try {
            Map map = (Map)BEncoding.decode(s);
            certInfo.alias = (String)map.get(ALIAS);
            certInfo.hostname = (String)map.get(HOSTNAME);
            certInfo.commonName = (String)map.get(COMMON_NAME);
            certInfo.organizationUnit = (String)map.get(ORGANIZATION_UNIT);
            certInfo.organization = (String)map.get(ORGANIZATION);
            certInfo.serialNumber = (String)map.get(SERIAL_NUMBER);
            certInfo.issuerCommonName = (String)map.get(ISSUER_COMMON_NAME);
            certInfo.issuerOrganizationUnit = (String)map.get(ISSUER_ORGANIZATION_UNIT);
            certInfo.issuerOrganization = (String)map.get(ISSUER_ORGANIZATION);
            certInfo.issuedOn = new Date((Long)map.get(ISSUED_ON));
            certInfo.expiresOn = new Date((Long)map.get(EXPIRES_ON));
            certInfo.sha1 = (String)map.get(SHA1);
            certInfo.md5 = (String)map.get(MD5);
            certInfo.isAcceptable = Boolean.parseBoolean((String)map.get(ACCEPTABLE));
            certInfo.isMismatch = Boolean.parseBoolean((String)map.get(MISMATCH));
            return certInfo;
        }
        catch (BEncoding.BEncodingException bEncodingException) {
            return null;
        }
    }

    public static String getCertificateCN(X509Certificate cert) {
        return SSLCertInfo.getComponent(cert.getSubjectX500Principal().getName(), COMMON_NAME);
    }

    private static String getComponent(String dn, String component) {
        int i;
        int start = dn.indexOf(component + "=");
        if (start == -1) {
            return "";
        }
        for (i = start += new StringBuilder().append(component).append("=").toString().length(); i < dn.length() && (dn.charAt(i) != ',' || dn.charAt(i - 1) == '\\'); ++i) {
        }
        return dn.substring(start, i);
    }

    public boolean isAcceptable() {
        return this.isAcceptable;
    }

    public boolean isMismatch() {
        return this.isMismatch;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getIssuerCommonName() {
        return this.issuerCommonName;
    }

    public String getIssuerOrganizationUnit() {
        return this.issuerOrganizationUnit;
    }

    public String getIssuerOrganization() {
        return this.issuerOrganization;
    }

    public Date getIssuedOn() {
        return this.issuedOn;
    }

    public Date getExpiresOn() {
        return this.expiresOn;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getMd5() {
        return this.md5;
    }

    public static void main(String[] args) {
        String dn = "CN=abc, O=foo=bar\\,asdf,OU=123";
        String cn = SSLCertInfo.getComponent(dn, COMMON_NAME);
        String ou = SSLCertInfo.getComponent(dn, ORGANIZATION_UNIT);
        String o = SSLCertInfo.getComponent(dn, ORGANIZATION);
        System.out.println(cn);
        System.out.println(ou);
        System.out.println(o);
    }
}

