/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RemoteIP {
    public static final String X_ORIGINATING_IP_HEADER = LC.zimbra_http_originating_ip_header.value();
    private String mClientIP;
    private String mOrigIP;
    private String mRequestIP;

    public RemoteIP(HttpServletRequest req, TrustedIPs trustedIPs) {
        this.mClientIP = req.getRemoteAddr();
        Object origIp = null;
        if (trustedIPs.isIpTrusted(this.mClientIP)) {
            this.mOrigIP = req.getHeader(X_ORIGINATING_IP_HEADER);
        }
        this.mRequestIP = this.mOrigIP != null ? this.mOrigIP : this.mClientIP;
    }

    public String getClientIP() {
        return this.mClientIP;
    }

    public String getOrigIP() {
        return this.mOrigIP;
    }

    public String getRequestIP() {
        return this.mRequestIP;
    }

    public void addToLoggingContext() {
        if (this.mOrigIP != null) {
            ZimbraLog.addOrigIpToContext(this.mOrigIP);
        }
        if (!TrustedIPs.isLocalhost(this.mClientIP) || this.mOrigIP == null) {
            ZimbraLog.addIpToContext(this.mClientIP);
        }
    }

    public static class TrustedIPs {
        private static final String IP_LOCALHOST = "127.0.0.1";
        private Set<String> mTrustedIPs = new HashSet<String>();

        public TrustedIPs(String[] ips) {
            if (ips != null) {
                for (String ip : ips) {
                    if (StringUtil.isNullOrEmpty(ip)) continue;
                    this.mTrustedIPs.add(ip);
                }
            }
        }

        public boolean isIpTrusted(String ip) {
            return TrustedIPs.isLocalhost(ip) || this.mTrustedIPs.contains(ip);
        }

        private static boolean isLocalhost(String ip) {
            return IP_LOCALHOST.equals(ip);
        }
    }
}

