/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.security.SecureRandom;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RandomPassword {
    private static final String ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.";
    private static final String ALPHABET_NO_DOT = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
    private static final int DEFAULT_MIN_LENGTH = 24;
    private static final int DEFAULT_MAX_LENGTH = 32;

    private static int byteLimit(int alphabetLength) {
        if (alphabetLength > 256) {
            throw new IllegalStateException("alphabet length " + alphabetLength + " has risk of bias");
        }
        return 256 - 256 % alphabetLength;
    }

    private static String generate(int minLength, int maxLength, boolean localpart) {
        SecureRandom random = new SecureRandom();
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength=" + minLength + " > maxLength=" + maxLength);
        }
        int length = minLength < maxLength ? minLength + random.nextInt(1 + maxLength - minLength) : maxLength;
        String alphabet = localpart ? ALPHABET_NO_DOT : ALPHABET;
        int alphabetLength = alphabet.length();
        int limit = RandomPassword.byteLimit(alphabetLength);
        StringBuffer password = new StringBuffer(length);
        byte[] randomByte = new byte[1];
        while (password.length() < length) {
            random.nextBytes(randomByte);
            int i = randomByte[0] + 128;
            if (i >= limit) continue;
            password.append(alphabet.charAt(i % alphabetLength));
        }
        return password.toString();
    }

    public static String generate() {
        return RandomPassword.generate(24, 32, false);
    }

    private static void usage() {
        System.out.println("");
        System.out.println("RandomPassword [-l] <minLength> <maxLength>");
        System.exit(1);
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("l", "localpart", false, "genarated string does not contain dot(.)");
        CommandLine cl = null;
        boolean err = false;
        try {
            cl = parser.parse(options, args, true);
        }
        catch (ParseException pe) {
            System.err.println("error: " + pe.getMessage());
            err = true;
        }
        if (err || cl.hasOption('h')) {
            RandomPassword.usage();
        }
        boolean localpart = false;
        int minLength = 24;
        int maxLength = 32;
        if (cl.hasOption('l')) {
            localpart = true;
        }
        if ((args = cl.getArgs()).length != 0) {
            if (args.length != 2) {
                RandomPassword.usage();
            }
            try {
                minLength = Integer.valueOf(args[0]);
                maxLength = Integer.valueOf(args[1]);
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
        System.out.println(RandomPassword.generate(minLength, maxLength, localpart));
    }
}

