/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<F, S> {
    private F mFirst;
    private S mSecond;

    public Pair(F first, S second) {
        this.mFirst = first;
        this.mSecond = second;
    }

    public F car() {
        return this.getFirst();
    }

    public S cdr() {
        return this.getSecond();
    }

    public F getFirst() {
        return this.mFirst;
    }

    public S getSecond() {
        return this.mSecond;
    }

    public void setFirst(F first) {
        this.mFirst = first;
    }

    public void setSecond(S second) {
        this.mSecond = second;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            Pair that = (Pair)obj;
            if (!(this.mFirst == that.mFirst || this.mFirst != null && this.mFirst.equals(that.mFirst))) {
                return false;
            }
            return this.mSecond == that.mSecond || this.mSecond != null && this.mSecond.equals(that.mSecond);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int code1 = this.mFirst == null ? 0 : this.mFirst.hashCode();
        int code2 = this.mSecond == null ? 0 : this.mSecond.hashCode();
        return code1 ^ code2;
    }

    public String toString() {
        return "(" + this.mFirst + "," + this.mSecond + ")";
    }

    public static void main(String[] args) {
        System.out.println(new Pair<String, String>("foo", "bar").equals(new Pair<String, String>("foo", "bar")));
        System.out.println(new Pair<String, Object>("foo", null).equals(new Pair<String, Object>("foo", null)));
        System.out.println(new Pair<Object, String>(null, "bar").equals(new Pair<Object, String>(null, "foo")));
        System.out.println(new Pair<String, String>("foo", "bar").equals(new Pair<String, Integer>("foo", 8)));
        System.out.println(new Pair<Object, String>(null, "bar").equals(new Pair<Integer, String>(0, "bar")));
    }
}

