/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.service.ServiceException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class NetUtil {
    private static Map<String, ServerSocket> mBoundSockets = new HashMap<String, ServerSocket>();

    public static ServerSocket getTcpServerSocket(String address, int port) throws ServiceException {
        return NetUtil.getServerSocket(address, port, false, false, null);
    }

    public static ServerSocket getSslTcpServerSocket(String address, int port, String[] excludeCiphers) throws ServiceException {
        return NetUtil.getServerSocket(address, port, true, false, excludeCiphers);
    }

    public static ServerSocket getNioServerSocket(String address, int port) throws ServiceException {
        return NetUtil.getServerSocket(address, port, false, true, null);
    }

    public static void bindTcpServerSocket(String address, int port) throws IOException {
        NetUtil.bindServerSocket(address, port, false, false, null);
    }

    public static void bindSslTcpServerSocket(String address, int port, String[] excludeCiphers) throws IOException {
        NetUtil.bindServerSocket(address, port, true, false, excludeCiphers);
    }

    public static void bindNioServerSocket(String address, int port) throws IOException {
        NetUtil.bindServerSocket(address, port, false, true, null);
    }

    public static synchronized ServerSocket getServerSocket(String address, int port, boolean ssl, boolean useChannels, String[] excludeCiphers) throws ServiceException {
        ServerSocket serverSocket = NetUtil.getAlreadyBoundServerSocket(address, port, ssl, useChannels);
        if (serverSocket != null) {
            return serverSocket;
        }
        try {
            serverSocket = NetUtil.newBoundServerSocket(address, port, ssl, useChannels, excludeCiphers);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("Could not bind to port=" + port + " bindaddr=" + address + " ssl=" + ssl + " useChannels=" + useChannels, ioe);
        }
        if (serverSocket == null) {
            throw ServiceException.FAILURE("Server socket null after bind to port=" + port + " bindaddr=" + address + " ssl=" + ssl + " useChannels=" + useChannels, null);
        }
        return serverSocket;
    }

    private static ServerSocket newBoundServerSocket(String address, int port, boolean ssl, boolean useChannels, String[] excludeCiphers) throws IOException {
        ServerSocket serverSocket = null;
        InetAddress bindAddress = null;
        if (address != null && address.length() > 0) {
            bindAddress = InetAddress.getByName(address);
        }
        if (useChannels) {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            serverSocket = serverSocketChannel.socket();
        } else if (ssl) {
            SSLServerSocketFactory fact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            serverSocket = fact.createServerSocket();
            NetUtil.setSSLEnabledCipherSuites((SSLServerSocket)serverSocket, excludeCiphers);
        } else {
            serverSocket = new ServerSocket();
        }
        serverSocket.setReuseAddress(true);
        InetSocketAddress isa = new InetSocketAddress(bindAddress, port);
        serverSocket.bind(isa, 1024);
        return serverSocket;
    }

    public static String[] computeEnabledCipherSuites(String[] enabledCiphers, String[] excludeCiphers) {
        if (enabledCiphers == null || enabledCiphers.length == 0 || excludeCiphers == null || excludeCiphers.length == 0) {
            return null;
        }
        ArrayList<String> excludedCSList = new ArrayList<String>(Arrays.asList(excludeCiphers));
        ArrayList<String> enabledCSList = new ArrayList<String>(Arrays.asList(enabledCiphers));
        for (String cipher : excludedCSList) {
            if (!enabledCSList.contains(cipher)) continue;
            enabledCSList.remove(cipher);
        }
        return enabledCSList.toArray(new String[enabledCSList.size()]);
    }

    private static void setSSLEnabledCipherSuites(SSLServerSocket socket, String[] excludeCiphers) {
        String[] enabledCiphers = NetUtil.computeEnabledCipherSuites(socket.getEnabledCipherSuites(), excludeCiphers);
        if (enabledCiphers != null) {
            socket.setEnabledCipherSuites(enabledCiphers);
        }
    }

    public static void setSSLEnabledCipherSuites(SSLSocket socket, String[] excludeCiphers) {
        String[] enabledCiphers = NetUtil.computeEnabledCipherSuites(socket.getEnabledCipherSuites(), excludeCiphers);
        if (enabledCiphers != null) {
            socket.setEnabledCipherSuites(enabledCiphers);
        }
    }

    private static String makeKey(String address, int port, boolean ssl, boolean useChannels) {
        return "[ssl=" + ssl + ";addr=" + address + ";port=" + port + ";useChannels=" + useChannels + "]";
    }

    public static void dumpMap() {
        for (Map.Entry<String, ServerSocket> entry : mBoundSockets.entrySet()) {
            System.err.println(entry.getKey() + " => " + entry.getValue());
        }
    }

    public static synchronized void bindServerSocket(String address, int port, boolean ssl, boolean useChannels, String[] excludeCiphers) throws IOException {
        System.err.println("Zimbra server reserving server socket port=" + port + " bindaddr=" + address + " ssl=" + ssl);
        String key = NetUtil.makeKey(address, port, ssl, useChannels);
        ServerSocket serverSocket = NetUtil.newBoundServerSocket(address, port, ssl, useChannels, excludeCiphers);
        mBoundSockets.put(key, serverSocket);
    }

    private static ServerSocket getAlreadyBoundServerSocket(String address, int port, boolean ssl, boolean useChannels) {
        String key = NetUtil.makeKey(address, port, ssl, useChannels);
        ServerSocket serverSocket = mBoundSockets.get(key);
        return serverSocket;
    }

    public static void main(String[] args) {
        SSLServerSocketFactory sf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        String[] supportedCipherSuites = sf.getSupportedCipherSuites();
        System.out.println("\nsupported cipher suites:\n");
        for (String c : supportedCipherSuites) {
            System.out.println(c);
        }
    }
}

