/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTreeMap<K, V>
extends TreeMap<K, Collection<V>> {
    public MultiTreeMap(Comparator<? super K> c) {
        super(c);
    }

    @Override
    public boolean containsValue(Object value) {
        if (super.containsValue(value)) {
            return true;
        }
        for (Collection v : this.values()) {
            if (!v.contains(value)) continue;
            return true;
        }
        return false;
    }

    public V add(K key, V value) {
        ArrayList<V> v = (ArrayList<V>)super.get(key);
        if (v == null) {
            v = new ArrayList<V>();
            super.put(key, v);
        }
        v.add(value);
        return value;
    }

    public V getFirst(K key) {
        Collection v = (Collection)this.get(key);
        if (v != null && v.size() > 0) {
            return (V)v.iterator().next();
        }
        return null;
    }

    public void remove(K key, V value) {
        Collection v = (Collection)super.get(key);
        if (v != null) {
            v.remove(value);
        }
    }
}

