/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.AccountLogger;
import com.zimbra.common.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFactory {
    private static Map<String, Log> sLogsByName = new HashMap<String, Log>();

    public static Log getLog(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return LogFactory.getLog(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(String name) {
        Log log = null;
        Map<String, Log> map = sLogsByName;
        synchronized (map) {
            log = sLogsByName.get(name);
            if (log == null) {
                Logger log4jLogger = Logger.getLogger((String)name);
                log = new Log(log4jLogger);
                sLogsByName.put(name, log);
            }
        }
        return log;
    }

    public static boolean logExists(String name) {
        return LogManager.exists((String)name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AccountLogger> getAllAccountLoggers() {
        ArrayList<AccountLogger> accountLoggers = new ArrayList<AccountLogger>();
        ArrayList<Log> allLogs = new ArrayList<Log>();
        Map<String, Log> map = sLogsByName;
        synchronized (map) {
            allLogs.addAll(sLogsByName.values());
        }
        for (Log log : allLogs) {
            List<AccountLogger> alForCategory = log.getAccountLoggers();
            if (alForCategory == null) continue;
            accountLoggers.addAll(alForCategory);
        }
        return accountLoggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Log> getAllLoggers() {
        Map<String, Log> map = sLogsByName;
        synchronized (map) {
            ArrayList<Log> allLogs = new ArrayList<Log>();
            allLogs.addAll(sLogsByName.values());
            return allLogs;
        }
    }
}

